IP(1)                   XROUTER REFERENCE MANUAL             17/12/02

COMMAND
        IP -- Display / Change IP parameters and routing.

SYNOPSIS
        IP QUIET [0-255]
        IP ROUTES
        IP ROUTE ADD <host>[/len] <gateway> <port> [d|v|n|e|u|r|s]
        IP ROUTE DROP <host> <len>
        IP ROUTE DEFAULT <port> [gateway [d|v|n|e|u|r|s]]
        IP ROUTE LOAD
        IP ROUTE LOOKUP <host>
        IP TTL [0-255]

DESCRIPTION
        The IP commands are used to display and alter IP parameters 
        and the contents of the tables responsible for routing of IP 
        datagrams.

        The IP routing table contains a series of entries which are 
        checked whenever a datagram is routed.  The "best" match is 
        chosen, i.e. the one which matches the address and mask with 
        the highest <bits>.

        The IP ROUTE command arguments are as follows:

        <host>           Target host IP address in dotted quad form.
        <len>            No. of bits to be matched (from left) 0-32.
        <gateway>        Destination gateway IP address or hostname. 
        <port>           Port number on which to route the datagram.
        <d|v|n|e|u|r|s>  Mode: (d)atagram, (v)irtual circuit, (n)etrom,
                               (e)ncap, ip(u)dp, (r)eject, (s)ilent.

        The IP ROUTE DEFAULT command sets up a default route which is 
        used when no other route is found.  If no gateway is 
        specified, the target will be assumed to be a direct 
        neighbour.  If not specified, the mode defaults to datagram.

        The IP ROUTE ADD command adds an entry to the routing table.

        The first argument is the target host IP address, with 
        optional mask. e.g. 44.131.90.1/32 means "match all 32 bits", 
        whereas 44.131.90.0/24 means "match the most significant 24 
        bits", and would route all 256 addresses from 44.131.90.0 to 
        44.131.90.255.  If not specified, the mask defaults to 32.

        The second argument is the "gateway" address, i.e. the IP
        address or hostname of the system which can handle the datagram
        (hostname requires access to a Domain Name Server and may be
        slower). You may use "*" to signify a direct route (no gateway).

        The third argument is the port to route the datagram on, and 
        the last argument is the mode:

        - Datagram mode should be used on links with low loss rates.
        - Virtual Circuit mode gives better performance on lossy links.
        - Netrom mode "tunnels" datagrams through the NetRom network.
        - Encap mode tunnels datagrams through non-ham IP networks.
        - Ipudp mode tunnels datagrams within commercial UDP/IP.
        - Reject mode rejects unroutable datagrams.
        - Silent mode silently discards unroutable datagrams.

        The IP ROUTE DROP command removes an entry from the routing 
        table.  Both the target host and the mask must match.

        The IP ROUTE LOAD command deletes all routes and re-loads the 
        information from the IPROUTE.SYS file.

        The IP ROUTE LOOKUP command displays the route which Xrouter 
        will use to reach to a specified destination host.

        The IP TTL command displays or changes the IP "Time To Live" 
        on datagrams originating from Xrouter.

        The IP QUIET command is used to display or set the "stealth" 
        level.  The default value of 0 causes TCP/IP to operate 
        normally.  A non-zero value disables various ICMP and TCP 
        error responses, and should be used with caution.  Please 
        refer to the manual entry STEALTH for more information.

EXAMPLES
        IP ROUTE DEFAULT 3 44.131.90.6 v
        IP ROUTE ADD 44.131.95.0/24 44.131.95.240 9 d
        IP ROUTE DROP 44.131.97.1 32
        IP ROUTE LOOKUP 62.31.87.22
        IP TTL 127
        IP QUIET 2

AVAILABILITY
        The only command available to non-sysops is "IP ROUTES".

NOTE
        The IP routing table is necessary only for IP, and does not 
        take any part in normal ax25 and Netrom activities.  See the 
        full manual for details on how to set up the IP system.

SEE ALSO
        IPROUTE, ARP, STEALTH

IP(1)                        END OF DOCUMENT
