TXDELAY(1)              XROUTER REFERENCE MANUAL         10/6/00

COMMAND
        TXDELAY -- Display / Set the transmit keyup delay for a port.

SYNOPSIS
        TXD[ELAY] <port> [millisecs]

DESCRIPTION
        The TXDELAY command allows the value of the transmit keyup 
        delay for a port to be displayed or altered.

        If a single numeric argument is supplied, the current value 
        for that port number is displayed.

        If two numeric arguments are supplied, the first specifies the 
        port number, and the second specifies the new value for the 
        parameter in milliseconds.  The new setting remains in force 
        until changed, or until the router is restarted, in which case 
        the value specified in the CFG file is reapplied.

EXAMPLE
        TXDELAY 3       - Display current setting for port 3
        TXDELAY 3 300   - Set port 3 txdelay to 300 millisecs

AVAILABILITY
        This is a sysop-only command.

NOTES
        TXDELAY is the interval between the transmitter being keyed up 
        and the start of a transmitted packet.  It allows time for the 
        RF to reach its full value, and for the TX audio circuits to 
        stabilise.  Some synthesised rigs require a large txdelay (500 
        or more) to allow the synthesiser to swing between RX and TX 
        frequencies, and many rigs have audio stages which take 100 ms 
        to stabilise while oversized electrolytics charge up.

        One factor which is often overlooked is the other end's 
        receiver.  It takes a finite time for the squelch to open, and 
        if the rig has just been transmitting it may take a while to 
        stabilise back to receiving, especially with synthesised rigs.  
        If your txd is too short, you will be sending replies before 
        the other end is ready to hear you, and unnecessary retries 
        will result.

        On KISS TNC's, you should allow up to 5 minutes for any new 
        setting to take effect.

SEE ALSO
        TXTAIL

TXDELAY(1)                        END OF DOCUMENT
