ROUTES(1)               XROUTER REFERENCE MANUAL              17/12/02

COMMAND
	ROUTES -- Display / Edit NetRom routes.

SYNOPSIS
	R[outes] [Q | X | Y | Z | *] [port]
	R[outes] ADD <call> <port> <qual> [!] [V digis] [opts]
	R[outes] DROP <call> <port>

DESCRIPTION
	The ROUTES command, which may be abbreviated to "R", lists
	the immediately adjacent NetRom nodes, i.e. those who can be
	heard directly, providing those nodes are making NetRom nodes
	broadcasts.

	For each neighbour node the display shows the port number,
	the neighbour's callsign, the route quality, and the number
	of nodes accessible through that neighbour.

	A chevron (>) in the left-most column indicates a route which
	is in use, and an exclamation mark (!) in the right-most
	column indicates that the data has been "locked in" by the
	sysop. See example...

	If any argument is supplied, it will give additional
	information mainly of interest to sysops.  The additional
	fields are the current MAXFRAME, FRACK and PACLEN settings,
	the number of information frames sent, the number of
	information frames re-sent, the retry rate, which is the
	ratio of the two preceding figures (or * if both are zero),
	and the time a nodes broadcast was last heard from the
	neighbour.

        The "R X" form shows the long term average retry rate (Rty%),
        plus a "running average" (Now%).  It also records the peak
        value of the running average (Max%) and the date/time when it
        occurred.

	The "R Y" form shows the "Smoothed Trip Time" (STT) in
	seconds, the number of time-domain routes (TDR) learned via
	that neighbour, some flags, plus the MAXTT (milliseconds) and
	MAXHOPS figures for each route.  An stt of 0.00 indicates
	that the link isn't open or the value hasn't yet been
	measured.

	The flags field is mainly for my use and is subject to
	change.  The current flag values are:


               1    Locked route
               2    Neighbour is INP capable
               4    Neighbour is L3RTT capable
               8    Neighbour is Xrouter
               16   Dynamic route quality enabled.


	The "R Z" form is experimental and may be subject to change.
	It shows the perentage of time the neighbour has been
	connected (Con%), the data throughputs in bytes/sec and the
	date / time of last L3 activity.

	The "R Q" form shows the calculated Netrom quality for each
	route, plus the minimum, maximum and mean deviation of the
	value.  You may use this as a guide when deciding what
	quality to assign to a route.  A low mean deviation indicates
	a quality which doesn't vary much.

	If the first argument is a port number, or it is one of the
	above options and the second argument is a port number, e.g.
	"R 2" or "R R 2", it will display only the routes which use
	that port.

	ROUTE ADD adds a new route or modifies an existing one, and
	ROUTE DROP removes a route.

	<call> is the callsign of the neighbour node.

	<port> is the radio port via which the neighbour is reached.

	<qual> is the netrom "quality" to use for that route.  A
	quality between 256 and 511 will instruct Xrouter to use
	"automatic" quality, with a starting point of (qual-256).

	[!] locks the entry to prevent it being overridden by learned
	information.

	[V digis] specifies a digipeated route, where "digis" is a
	string of digipeater calls seperated by commas, i.e. in the
	form "DIGI,DIGI,DIGI".

	[opts] are optional maxframe, frack, paclen, maxtt and
	maxhops values to override the port defaults.  The format is:
	[maxframe [frack [paclen [maxtt [maxhops]]]]], i.e. in
	order to specify maxtt you must also specify maxframe, frack
	and paclen  Use zero in any field for which you don't wish to
	overwrite the port default.

EXAMPLES
        If no arguments are supplied, the output looks like this:

        G8PZT:KIDDER} Routes:
        Port Callsign  Qty Nod
        >  5 G4FPV     150  70!
        >  7 GB7PZT    250   1!
        >  8 GB7WV-12  100  32!
        >  9 GB7GH     150 104!
          10 GB7CL     150   1!
        > 11 GB7IPT-7  150   3!
          12 G1LOA-10  150   2!

        The R R form produces an output similar to this:

        G8PZT:KIDDER} Routes:
        Port Callsign Qty Nod Max Frack Pac  Sent Resent Rty%  Last Heard
        >  5 G4FPV    150  70! 5   7000 160 15550   1507   9% 09/06 13:46
        >  7 GB7PZT   250   1! 7   5000 240 25387      4   0% 09/06 13:47
	>  8 GB7WV-12 100  32! 1   4000 120 12170   3426  28% 09/06 13:35
	>  9 GB7GH    150 104! 4   7000 120  7442   1335  17% 09/06 13:47
	  10 GB7CL    150   1! 3   7000 240   330      1   0% 09/06 13:23
	> 11 GB7IPT-7 150   3! 2   7000 120 19401   2928  15% 09/06 13:47
	  12 G1LOA-10 150   2! 4   7000 120 10745   3379  31% 09/06 13:39

        The R X form produces an output like this:

        G8PZT:KIDDER} Routes:
        Port Callsign  Qty Nod    Sent  Resent  Rty%  Now%   Max% @dd/mm hh:mm
        >  7 GB7PZT    250   1!  10067       0    0%   0.0    0.0
        >  9 GB7GH     150  93!    333      17    5%   5.3    5.6  26/08 20:26
        > 12 G1WXA-1   150   2    1231      83    6%   1.6   24.4  26/08 12:37
        (End of list)

        route add g8pzt 5 100
	route add g6yak 2 100 ! V G8EPR,G8NTU 5 7000
	route add g8klm 3 150 ! 0 0 245 2000 3
	route drop mb7uyl 14

AVAILABILITY
	The ROUTES command is available to all users.
	The ADD and DROP subcommand is only available to sysops.


ROUTES(1)                         END OF DOCUMENT
