MPORT(1)                XROUTER REFERENCE MANUAL        17/12/02

COMMAND
        MPORT -- Select which port(s) to monitor (trace)

SYNOPSIS
	MP[ort] [#xxxx | n | n+n+n]

DESCRIPTION
	The MPORT command selects which ports will be monitored when
	traffic tracing is enabled.  The <F3> key duplicates this
	function.

	The optional argument can take one of three forms:

	a) A hex number, preceded by "#", representing a binary
	number of up to 32 bits.  A "set" bit (1) enables monitoring
	for the corresponding port, and an "unset" (0) bit disables
	monitoring on that port.  Bit 0, the rightmost (least
	significant) bit, represents port 1 and bit 31, the leftmost
	(most significant) bit represents port 32.  The number is
	calculated by adding together the desired values from this
	table:

	 Port  HEX    Port  HEX    Port    HEX    Port      HEX
           1     1      9   100     17   10000     25   1000000
           2     2     10   200     18   20000     26   2000000
           3     4     11   400     19   40000     26   4000000
           4     8     12   800     20   80000     28   8000000
           5    10     13  1000     21  100000     29  10000000
           6    20     14  2000     22  200000     30  20000000
           7    40     15  4000     23  400000     31  40000000
           8    80     16  8000     24  800000     32  80000000


	b) A decimal number representing a single port, or 0 to
	   disable monitoring.

	c) Several decimal numbers separated by "+" characters,
	representing a combination of port numbers.  There must be no
         spaces in the string of characters.

        If no argument is supplied, the current setting is reported.

        If used by a remote sysop, monitored frames are sent to him
        instead of the console window.  In order to avoid overloading
        the link, the MPORT setting is cleared every time monitoring
        is enabled, so the sysop must then issue the MPORT command to
        select which port(s) to monitor.

        The console can override a remote sysop's settings.

EXAMPLES
	MPORT #800  -  Trace port 12.
	MPORT #1803 -  Trace ports 13, 12, 2 and 1.
	MPORT 21    -  Trace port 21 only
	MPORT 1+5+7 -  Trace ports 1, 5 and 7

AVAILABILITY
        The MPORT command is available only to console and remote
        sysops.

LIMITATIONS
        Only one sysop may receive the trace display at any one time.

        Remote sysops cannot trace activity on the port on which they
	are uplinked

	Only ports 1 through 32 can be traced at present.

NOTE
        Remote sysops must ensure that their link with the router is
        capable of carrying the large volume of traffic resulting from
        tracing.  Attempting to trace too many ports / too much detail
        on a slow link may result in poor performance.  You have been
        warned!

SEE ALSO
        MONITOR  -  Enable / disable monitoring.
        MMASK    -  Select type of activity to monitor.

MPORT(1)                        END OF DOCUMENT
