MHEARD(1)               XROUTER REFERENCE MANUAL              22/7/02

COMMAND
        MHEARD -- List recently heard stations.

SYNOPSIS
        MH[eard] <portnum>

DESCRIPTION
        If the facility is enabled on the specified port, the MHEARD 
        command lists the most recently heard stations on that port, 
        along with the date / time of reception, and the number of 
        frames heard.

        This is useful for users to discover who else the router can 
        hear, to aid the search for suitable digipeaters, and to 
        diagnose problems.  Even on linking-only ports, where there is 
        only usually one partner, it provides a useful indication when 
        the frequency is being encroached, either by deliberate 
        squatting, unauthorised attempts to link, or lift conditions.

        If you have included an APRS-style position report in your ID 
        beacon, the router will know its own position and will display 
        position, distance and bearing for any stations which 
        broadcast APRS positions.

        The command may be abbreviated to "MH".

EXAMPLE
        MH 3 gives a heard list for port 3....

G8PZT:KIDDER} Heard list for port 3:
Callsign   Date  Time Frames   Via   Type  Position         Dist Dir
G1LOA-10   09/06 13:42   309         N
G3TQG-2    09/06 13:19   599 GB7WV
GB7PZT-15  09/06 13:18   708
G3KFD      21/07 23:58   332             5229.65N 00208.28W 13Km 36
(End of list)

        An entry in the "Via" column indicates a digipeated signal, 
        otherwise the station was heard direct.

        The "Type" column indicates the type of sender, i.e. whether 
        it is a (D)igipeater, or (N)etrom node, or has (I)P or (A)RP 
        capabilities.

        The "Position" field shows the latitude and longitude of the 
        heard stations (if known), in APRS-style.  5229.65N means 52 
        degrees, 29.65 minutes North of the Equator. 00208.28W means 2 
        degrees and 8.28 minutes West of the Greenwich meridian.

        The "Dir" field shows the direction of the heard station (if 
        known) in degrees clockwise from true North.

AVAILABILITY
        The MHEARD command is available to all users.

NOTE
        For each port, the MH facility can be enabled / disabled and 
        the maximum length of the list specified by appropriate 
        entries in the .CFG file.  

MHEARD(1)                        END OF DOCUMENT
