EDITOR(1)              XROUTER REFERENCE MANUAL            17/12/02

LINE EDITOR COMMANDS
====================

In the following, n1, n2 and n3 refer to line numbers, which must be 
greater than zero, and within the range of line numbers used in the 
file.  The space between the command and the first number may be 
omitted, and the numbers can be separated by spaces, commas, colons, 
tabs etc.   Parameters in square brackets [] are optional.  When 
copying, moving or inserting lines, the "source" text is inserted at 
the "destination" line, i.e. "in front of" the original text.


?              Displays a brief list of commands.


A <text>       Append line <text> to the file.

               The editor ignores exactly one space between the A and 
               the text to be inserted, so if you want to enter a line 
               with leading spaces, add one extra.


C n1 n2 [n3]   Copy line(s).

               If n3 is omitted, line n1 is copied into line n2, 
               otherwise the block n1 to n2 inclusive will be copied 
               into the position beginning at n3.
               Note: n3 must not be within the block being copied.


D n1 [n2]      Delete line(s).

               If both n1 and n2 are specified, the block of lines 
               between and including n1 and n2 will be deleted.  If n2 
               is omitted, or is the same as n1, only n1 will be 
               deleted.


H n1           Hash (comment-out) a line using the '#' symbol.
              
               This is useful for disabling configuration entries 
               without deleting them.  They can be easily re-activated 
               at a later date using the U)nhash command.  If the line 
               already begins with '#' another one is not prepended.


I n1 <text>    Insert <text> into line n1.


L n1 [n2]      List (display) line(s).

               If n2 is specified, lines n1 to n2 inclusive will be 
               displayed, otherwise it will display 10 lines beginning 
               at n1.  If n1 is omitted, it will re-display the same 
               page, or if this is the first time the command has been 
               used, the first 10 lines of the text will be displayed.


M n1 n2 [n3]   Move line(s).

               If n3 is specified, the block of lines n1 to n2 
               inclusive will be moved to the position beginning at 
               n3, otherwise the single line n1 will be moved to the 
               n2 position.


N              Next page.

               Displays the next page (10 lines) of text.


P              Previous page.

               Displays the previous page (10 lines) of text.


Q              Quit.

               The text is abandoned and the original file is
               left intact, providing you hadn't used the W command.


S              Save the text.
               Syntax and function identical to W)rite.


U n1           Unhash line n1.

               Removes a '#' symbol from start of line, if one is 
               present (opposite of H)ash).


W [<file>]     Write (save) file being edited to disk.

               If <file> is specified, the work is written there 
               instead of the original name, but will not overwrite an 
               existing file.


W! <file>      Write unconditionally.

               Writes the text being edited to <file>, overwriting any
               existing file of that name.


WQ             Write & Quit.

               Writes the modified text back to the original file and
               quits editor. (Same as ZZ)


ZZ             Same as WQ (see above)


EDITOR(1)                END OF DOCUMENT
