ARP(1)                    XROUTER REFERENCE MANUAL            21/7/02

COMMAND
        ARP -- Display / Edit the ARP table.

SYNOPSIS
        ARP [ADD <host> <hwtype> <addr>]
            [DROP <host> <hwtype>]
            [FLUSH]
            [LIST] 
            [PUBLISH <host> <hwtype> <addr>]

DESCRIPTION
        The ARP command is used to display and edit the Address 
        Resolution Table, responsible for mapping IP datagrams to 
        callsigns.

        If no arguments are supplied, or the argument is LIST, the 
        table is listed.

        The forms ARP ADD and ARP PUBLISH are used to add an entry to 
        the table.  PUBLISH is used when a host is "hidden" on a 
        network which is only accessible via Xrouter, and allows 
        Xrouter to respond to arp requests for the hidden system, by 
        returning its own hardware address.

        ARP DROP is used to delete an entry, and ARP FLUSH removes 
        temporary entries, i.e. those pending resolution.

        <host> is an IP address in dotted quad form.

        <hwtype> is the hardware type, i.e. "ax25" or "ether".

        <addr> is the hardware address, i.e. callsign or ethernet.

EXAMPLES
        ARP ADD 44.131.91.2 ax25 gb7pzt-5    Add ax25 entry
        ARP PUB 44.131.91.127 ax25 g8pzt     Publish 91.127
        ARP DROP 44.131.91.7 ax25            Delete ax25 entry
        ARP LIST                             List the table
        ARP                                  List the table

AVAILABILITY
        The LIST subcommand is available to everyone, but ADD, DROP, 
        PUBLISH and FLUSH are sysop-only.

NOTES
        In order for this command to have any meaning, the router must 
        have an IP address and be connected to an IP-capable network.

        You cannot add hardware address types for which there is no 
        compatible interface, e.g. an attempt to add an Ethernet 
        address on a system with no Ethernet interfaces will fail.


ARP(1)                         END OF DOCUMENT
