SCRIPT(1)               XROUTER REFERENCE MANUAL              23/7/02

Assuming you have a port configured for modem use, DUN requires at 
least one dialler script, to control the dial and login sequence.

Dialler scripts are ordinary text files containing script commands as 
detailed below, one per line.  Lines must not exceed 256 characters in 
length.  The script file can be named as you wish, for example you 
might like to name your AOL dial script "AOL.SCR".  You will need to 
use this name later to identify the script, so it makes sense to call 
it something meaningful, rather than "SCRIPT1.TXT".  Script files must 
reside in the same director as XROUTER.EXE.

Script Commands Overview
~~~~~~~~~~~~~~~~~~~~~~~~

        CONTROL         Raise / lower RS232 DTR signal.
        MODE            Sets protocol to use upon sucessful login.
        PPP             PPP configuration commands.
        SEND            Send text.
        SLEEP           Temporary pause.
        WAIT            Wait for text in received data.


Script Commands In Detail
~~~~~~~~~~~~~~~~~~~~~~~~~

CONTROL - Raise / Lower RS232 DTR signal.

        Syntax: C[ontrol] <up | down>

        Example: CONTROL UP

        The CONTROL command is used to raise or lower the RS232 DTR
        (Data Terminal Ready) line.  Most modems require the DTR
        signal to be "up", and will disconnect or reset when the
        DTR signal goes down.  Those modems which do not do this by
        default can usually be configured to do so by including
        "&D2" in the initialisation string.


MODE    - Set protocol to use upon sucessful login.

        Syntax: M[ode] <kiss | ppp | slip>

        Example: MODE PPP

        This command specifies which protocol should be used after
        your system has sucessfully logged into the remote host,
        i.e. when the script ends without error.  It must preceed
        the dialling and login sequence, and any protocol dependant
        commands, such as the PPP commands.


PPP     - PPP configuration commands.

        Syntax: P[pp] <idle | ipcp | lcp | log | pap> [arg]

        Example: PPP IDLE 300

        PPP commands are used to configure the PPP subsystem for
        the connection being established.  You may find that the
        default configuration is sufficient, or you may need to
        use the PPP PAP command to specify your PAP login details
        if your ISP requires the use of PAP.  See PPP documentation
        for details of PPP commands.


SEND    - Send a line of text.

        Syntax: S[end] <text>

        Example: SEND ATDT01674302153

        The SEND command sends one line of text to the modem or the
        remote host, for example modem initialisation and dial commands,
        or login commands.  The <text> argument may contain spaces,
        and the system will append a carriage return/line feed.


SLEEP   - Temporary pause.

        Syntax: SL[eep] <millisecs>

        Example: SLEEP 5000

        The SLEEP command causes the script to pause for the specified
        interval.  For example, you would need a short delay after
        issuing a modem reset command, before any more command would
        be accepted by the modem.  When the pause is complete, script
        execution continues on the next line.


WAIT    - Wait for received text.

        Syntax: W[ait] <millisecs> <string> [exiterr]

        Example: WAIT 5000 Password: exiterr

        The WAIT command causes Xrouter to wait for specific responses
        from the modem or remote host.  The <millisecs> argument
        specifies the maximum wait interval.  The <string> argument
        specifies the string of characters for which the system must
        wait. It must not contain spaces, and must not exceed 20
        characters in length.  When the string is seen in the received
        data stream, the next script command is executed.

        If the "exiterr" argument is present, the script will abort
        if the string is not seen before the interval expires. If the
        argument is not present, the next script command will be
        executed if timeout occurs.


SCRIPT(1)                         END OF DOCUMENT
