CHATCMDS(1)             XROUTER REFERENCE MANUAL              17/12/02

CHAT SERVER COMMANDS
====================

The following commands are available within the chat server only.

/?        /ANSI     /BELL     /BYE      /CHANNEL  /ECHO     /EXIT
/HEADERLN /HELP     /JOIN     /LEAVE    /LINKS    /MSG      /NAME
/PERSONAL /QUIT     /STAMP    /TOPIC    /USER     /WHO      /VERSION


CHAT SERVER COMMANDS IN DETAIL
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Note that the server is still experimental, and the syntax of these
commands may be changed in future versions.  Additional commands will
be added as required.

/?       Display commands / syntax help.

         Syntax: /? [cmd]

         When used without arguments, the /? command lists the 
         available commands.  The syntax for any of the commands thus 
         listed may be shown by specifying the command as an argument 
         to the /? command.

         Examples:  /?          List available commands.
                    /? /who     Display syntax for the /WHO command.


/ANSI   Enable / Disable ANSI colour

         Syntax:  /A[nsi] [on | off]

         The /ANSI command is used to enable or disable the use of
         ANSI colour.  In order to make use of this feature, callers 
         must be using an ansi-compatible terminal.  When enabled, 
         each user's messages are shown in a different colour making 
         it easier to follow threads of conversation. 

         Typing /ANSI by itself displays the current setting.


/BELL   Display / Set activity bell

         Syntax: /BE[ll] [0-3]

         The /BELL command controls which events are signalled by an 
         audible warning.  The warning consists of a bell character 
         (ascii 7) within the text.  In order to use this feature, 
         your terminal software must respond to bell characters.

         Arguments to the /BELL command are as follows:

               0     No bells (default setting)
               1     Informative messages from chat server only
               2     Text entered by other chatters only
               3     All events.


/BYE    Exit the chat server.

         Syntax: /B[ye]

         The /BYE command, which may be shortened to /B, disconnects 
         the user from the chat server, and informs everyone that he's 
         left.  There is no need for the user to /leave any logged 
         channels before issuing this command.

         If the user accessed the server via the router's CHAT 
         command, he will be returned to the router's main command 
         prompt, otherwise he will be completely disconnected.

         The /EXIT and /QUIT commands also perform this function.


/CHANNEL  Display / Change logged channel(s).

         Syntax: /C[hannel] [number]

         The /CHANNEL command displays / changes the channel(s) the 
         user is logged to.  When no argument is supplied, the logged 
         channel(s) is / are displayed.  If a valid numeric argument 
         is supplied, the user is logged to the specified channel.

         Examples: /C        Displays current logged channel(s)
                   /C 22     Change to channel 22

         When a new channel is selected, the user remains logged to 
         any previous channels, (so he can "monitor" several channels 
         at once) but any subsequent text he sends will go to the new 
         channel (unless targeted otherwise).

         Note: Channels 1 to 255 are "local" to each chat server, and 
         channels 256-32767 are "global", i.e. they are linked with 
         all other servers. 

         The /JOIN command has a similar function, and /LEAVE is used 
         to de-select unwanted channels.


/ECHO    Control host echo

         Syntax: /EC[ho]

         The /ECHO command toggles host echo on and off.  The default 
         setting is ON, i.e. the user receives a copy of any text he 
         sends to the channel.

         Although host echo slightly increases bandwidth usage, it 
         helps to put the user's text into temporal context amongst 
         the other channel texts, especially when there is latency on 
         the links.  The user can more easily spot mistakes such as an 
         incorrectly entered name or callsign.


/EXIT    Exit the chat server.

         Syntax: /E[xit]

         The /EXIT command, which may be shortened to /E, disconnects 
         the user from the chat server, and informs everyone that he's 
         left.  There is no need for the user to /leave any logged 
         channels before issuing this command.

         If the user accessed the server via the router's CHAT 
         command, he will be returned to the router's main command 
         prompt, otherwise he will be completely disconnected.

         The /BYE and /QUIT commands also perform this function.


/HEADERLN Controls display format

         Syntax: /HEA[derln] [on | off]

         The /HEADERLN command controls whether or not the "header"
         and text of messages are displayed on the same line.

         If the setting is OFF (default), the header and text are 
         displayed on the same line.  This leads to a more compact 
         display, especially when the texts are short.

         If the setting is ON, headers and text are displayed on 
         separate lines. 


/HELP    Obtain help.

         Syntax: /HELP [topic]

         When used without arguments, the /HELP command gives brief 
         instruction on how to access various levels of help.

         If a topic is specified, detailed help for that topic (if 
         available) is displayed.  The topic may be a command name, or 
         any other chat server related topic.  A list of the available 
         help topics can be obtained by specifying "*" as a topic.

         Examples:  /H          Display general instructions.
                    /H *        List available help topics.
                    /H /who     Display help for /WHO command.

         Note:  When using /H to display help for a command, the         
         leading slash for that command may be omitted.  Thus         
         "/H /who" and "/H who" are equally permissible.


/JOIN    Join (log onto) a channel.

         Syntax: /J[oin] <channel>

         The /JOIN command logs the user to a channel, and performs a 
         similar function to the /CHANNEL command.

         When a new channel is selected, the user remains logged to 
         any previous channels, (so he can "monitor" several channels 
         at once) but any subsequent text he sends will go to the new 
         channel (unless targeted otherwise).  (Unwanted channels may 
         be de-selected using the complementary /LEAVE command.)

         Example:  /J 22   Join channel 22

         Note: Channels 0 to 255 are "local" to each chat server, and 
         channels 256-32767 are "global", i.e. they are linked with 
         all other servers. 


/LEAVE   Leave (log off) a channel.

         Syntax: /L[eave] <channel>

         The /LEAVE command logs the user off the specified channel.  
         When a user joins a channel, he remains logged to any 
         previous channels, so this command allows him to de-select 
         unwanted channels.

         Example:  /L 22   - Leave channel 22


/LINKS   Display / Change peer links

         Syntax: /LI[nks] [add | drop <peercall>]
                 /LI[nks] ADD <peername> <ip_addr>:<tcp_port>
                 /LI[nks] DROP <peername>

         The /LINKS command shows the status of the links with other 
         chat servers, and allows sysops to add and drop links without 
         rebooting Xrouter.

         In the Netrom case, <peercall> is the netrom callsign (not 
         alias) of the peer server, and it must exist in Xrouter's 
         nodes table otherwise the link will not be opened.  If you 
         have trouble with peers dropping in and out of the nodes 
         table, create a "locked" node entry.

         In the TCP/IP case, <peername> is the server ID of a Tampa 
         Ping-Pong server, <ip_addr> is its IP address, and <tcp_port> 
         is the TCP port number of the server.

         Examples:  /LI ADD G1SSL-8
                    /LI DROP G8NTU-8
                    /LI ADD brmcht 80.195.22.37:3601


/MSG     Send a short message to a channel or a single user.

         Syntax: /M[sg] <channel | callsign> <text>

         The /Msg command is used to send a short message (70 chars 
         max.) to any specified channel or single user.  You may for 
         example use this command to direct a message to a channel you 
         are monitoring, but not actually logged to.

         If you direct a message to a specific user, he may be on this 
         or any other chat server.  The private nature of the message 
         will be indicated to the recipient by asterisks around the 
         sender's call, e.g. <*g8pzt@kdchat*> (Paula): Meet me on 
         channel 69.

         Examples: /M 32 Hello People
                   /M g6yak Meet me on channel 69

         The first form sends "Hello People" to all the users of 
         channel 32, and the second form sends a private msg to g6yak 
         only. Providing G6YAK is logged on to any chat server, the 
         message will find him.

         Note: As with all things Packet, the term "private" is 
         relative, as nothing is truly private when it is broadcast!


/NAME    Set name.

         Syntax:  /N[ame] <your name> [channel]

         The /NAME command sets the user's name, which will be 
         displayed on the user list and prefixed to everything he 
         sends to others.

         Users are not allowed to join any channels until they have 
         supplied a name (12 chars max), so it acts as a "log on" 
         command.  The name need be supplied only at the initial 
         logon, and may be changed as the user wishes.

         On the first use of this command, the user may optionally 
         specify a channel to join instead of the default (channel 0).

         TCP/IP users must first use the /USER command (see below) to 
         enter their callsign.

         Examples: /N Paula       Set name to "Paula"
                   /N Paula 23    Set name and join channel 23


/PERSONAL  Display / change personal description.

         Syntax: /P[ersonal] [text | @]

         The /PERSONAL command is used to display or change the user's 
         personal description.  This is a short text of up to 32 
         characters, which is displayed on the user list.  It may 
         typically contain the user's home town and "brag" 
         information.  If the user logs onto any "public" channels 
         (i.e. those above channel 255), this information will appear 
         on the user lists of all other chat servers.

         If used without arguments, the /PERSONAL command displays the 
         user's current text.  

         If the argument is "@", the existing text is removed.

         Examples: /P                        - Displays current text
                   /P Kidderminster, sysop   - Set new text.
                   /P @                      - Clear previous text.


/QUIT    Exit the chat server.

         Syntax: /Q[uit]

         The /QUIT command, which may be shortened to /Q, disconnects 
         the user from the chat server, and informs everyone that he's 
         left.  There is no need for the user to /leave any logged 
         channels before issuing this command.

         If the user accessed the server via the router's CHAT
         command, he will be returned to the router's main command 
         prompt, otherwise he will be completely disconnected.

         The /BYE and /EXIT commands also perform this function.


/STAMP   Controls timestamping of message texts.

         Syntax:  /S[TAMP] [on | off]

         With stamp ON (default) each mesage is timestamped in the 
         following style, designed to be readable both by humans and 
         by client software:

         [1234] 09:35 {21:33} <ZL2BAU@BAUCHT> (Peter): Hello folks

         The first field is the channel number.  This may seem
         pointless, but you will soon appreciate it if you are logged 
         to more than one channel!

         The second field is the chatserver's timestamp, i.e. the 
         local time the message was received at, and redistributed by, 
         the server.  This is useful if you are away from the screen 
         for a while, or are logging the activity to disk.

         The third field is the originating server's timestamp, i.e. 
         the local time at which the message was entered into the 
         system.  With servers linked across different timezones, the 
         two timestamps may differ by up to 12 hours.  Personally I 
         find it useful to know what the other user's local time is, 
         because it helps put their comments into perspective.  The 
         timestamps can also highlight propagation delays.

         The fourth field consists of the sender's callsign and the
         "alias" of the originating server.  Users may (and often do) 
         log onto more than one server, often at the same time.

         The fifth field is the user's name.

         Those who are used to chatting on the Ping-Pong system seem 
         to be unable to cope with anything which is different, so 
         with STAMP OFF the header information is abbreviated in the 
         Ping-Pong style as follows:

         <g8pzt:Paula>: Test


/TOPIC   Display / Change channel topic.

         Syntax: /T[opic] [channel] [text | @]

         Every channel has an optional topic, and the /TOPIC command 
         can be used to display the existing topic or change it.  The 
         topic can be up to 12 characters, and is displayed on the 
         /Who list.

         Examples: /T                        - Show current ch. topic
                   /T 32                     - Show channel 32 topic
                   /T 32 TCP/IP discussion   - Set topic for ch. 32
                   /T @                      - Clear topic.


/USER    TCP/IP logon.

         Syntax:  /U[ser] <callsign> [name]

         The /USER command is available only to TCP/IP users.  It sets 
         the user's callsign (and optionally his name), which will be
         displayed on the user list and prefixed to everything he 
         sends to others.

         The user will not be able to join the conference without 
         supplying both callsign (9 chars max) and name (12 chars 
         max), but if the name is omitted from this command he may 
         enter it in the normal way with the /Name command.

         Examples: /U g8pzt          - Set callsign to "g8pzt".
                   /U g8pzt Paula    - Set callsign and name.


/VERSION  Display chat server version.

         Syntax: /V[ersion]

         The /VERSION command displays the chat server version, author
         and compilation date.  Please quote it if reporting bugs.


/WHO     List channels and users.

         Syntax: /W[ho] [*]

         The /WHO command lists who is logged onto the chat server,
         and what channels they are on.

         If no arguments are supplied, the active channels are listed,
         along with the callsigns of their users.

         If an asterisk is supplied as the argument, each user is
         displayed in more detail.  The display would typically show
         the user's callsign, name, personal text and logon date/time.

         Examples:  /W     Lists channels & users in brief format
                    /W *   Lists users in detail


CHATCMDS(1)                    END OF DOCUMENT
