NAT(1)                  XROUTER REFERENCE MANUAL              23/7/02

COMMAND
        NAT -- Network Address Translation commands.

SYNOPSIS
        NAT ADD STATIC <local>[:port] <global>[:port] [tcp | udp]
        NAT ADD OVERLOAD <local> <global> <subnet_mask>
        NAT DROP <local>[:port] [tcp | udp]
        NAT LIST

DESCRIPTION
        The NAT commands controls Network Address Translation, i.e. 
        the process whereby the IP addresses contained in datagrams 
        are manipulated to allow hosts on one network to communicate 
        with hosts on a different network.

        For example, hosts on a private intranet using unregistered 
        192.168.0.x addresses cannot communicate with hosts on the 
        wider Internet because no-one would know where to route the 
        return datagrams.  NAT basically translates the unregistered 
        addresses into registered ones and vice versa.

        PAT (Port Address Translation) manipulates TCP and UDP service 
        port numbers, for example to allow several hosts to share one 
        IP address.  The NAT commands are also used to configure PAT.

        The arguments for NAT commands are as follows:

        <local>          Local private (unregistered) IP address.
        <global>         Globally recognised IP address.
        <port>           TCP or UDP service port number.
        <subnet_mask>    Bit pattern used for matching addresses.
                         e.g. 255.255.255.0

        NAT ADD adds an entry to the NAT table.  There are two forms: 
        STATIC and OVERLOAD.  STATIC is used to add static NAT and PAT 
        entries, i.e. those where there is a one-to-one mapping 
        between private and public IP addresses.  OVERLOAD is used 
        only for dynamic PAT, where several hosts share one public IP 
        address.

        NAT DROP removes an entry from the NAT table.

        NAT LIST lists the NAT table entries.

EXAMPLES
        NAT ADD STATIC 192.168.0.2:87 44.131.91.2:23 tcp
        NAT ADD OVERLOAD 192.168.0.0 44.131.91.3 255.255.255.240
        NAT DROP 192.168.0.5:23 tcp

AVAILABILITY
        The NAT commands are only available to sysops.

NOTE
        The NAT ADD command can also be used in IPROUTE.SYS or 
        BOOTCMDS.SYS.

SEE ALSO
        For more information about NAT please see the NAT section in 
        the full manual.

NAT(1)                         END OF DOCUMENT
