NODES(1)                XROUTER REFERENCE MANUAL             17/12/02

COMMAND
        NODES -- Display / Edit contents of the Nodes table.

SYNOPSIS
        N[odes] [* | + | F | H | I | N | O | P | Q | R | S | T]
	N[odes] [A | V] <call>
	N[odes] > | < <quality>
	N[odes] ADD <call>[:alias] <via> <port> <qual> [!]
	N[odes] DROP <call>

DESCRIPTION
        When used without arguments, this command lists all the NetRom
        nodes (but not KA nodes) known to the router, except those
        "hidden" nodes whose alias begins with the hash (#) character.

        If the argument is an asterisk (*), all nodes, including
        "hidden" nodes will be displayed.

	If the argument is a string containing wildcards, all the nodes
	with callsign or alias matching the string will be displayed.

        If the argument is a known node call or alias, the preferred
        route to the specified node, and up to two alternative routes
        will be displayed.  Example: N MLVN  The response looks like
        this:

        G8PZT:KIDDER} Routes to: MLVN:G4FPV  RTT=28  FR=3538  Q=0
        > 150  5  5 G4FPV     2.57  1  5
          110  5  9 GB7GH     3.52  2  5
            0  4  2 G1DKI-7   0.00  0  0

        RTT stands for Round Trip Time and is a running average of the
        time taken to get a response from that node.

        FR indicates the number of level 3 frames sent to that node.

        Q is the number of Level 3 frames currently queued for that
        destination.

        A chevron ">" in the left-most column indicates the currently
        active route.

        The first number shows the overall path quality to the target
        node, the second is the "obsolescence count", and the third
        number is the port designator.  The obsolescence count is a
        measure of how recently the route was heard about or used.  It
        is usually reset to 5 upon hearing a nodes broadcast from the
        neighbour node, and decrements by one every time this node
        makes a node broadcast (typically once per hour). If it drops
        below 4 the route is considered to be obsolete.

	The final 3 columns are the trip time, hop count, and an
	obsolescence count for those values.

        If the requested nodecall or alias is not in the table, an
        error message results.

	The "N A <call>" (advertised) command lists only the nodes to
	whom one of the primary or secondary routes is via the
	immediate neighbour specified by <call>.

	The "N F" (frames) variation lists only the nodes to whom one
	or more frames have been sent.

	The "N H" (hops) command lists only the nodes for whom a "hop
	count" is known, i.e. the number of nodes a frame must pass
	through to reach that destination.  It is not always possible
	to measure the hops via old netrom systems.

	The "N I" (IP address) form displays only the nodes whose IP
	address is known.

	The "N N" command displays the "Netrom-only" nodes, i.e.
	those for whom a trip time is not known.

	The "N O" (obsolete) form displays the "Obsolete" nodes, i.e.
	those which haven't been heard of for a while.

	The "N P" (position) command lists only the nodes whose APRS
	position is known.  This will include immediate neighbours of
	any software type, and distant Xrouters, providing in each
	case that their sysops have included their APRS position
	details in a beacon.

	The "N Q" (queue) command lists only the nodes for whom
	frames are currently queued.  Since it is a "snapshot" of the
	state at the time the command was issued, it is likely to
	produce different results each time, but it allows problems
	to be identified.

	The "N R" (rtt) command lists only the nodes for whom a Round
	Trip Time is known.  The RTT is only available for those
	nodes with whom traffic has been exchanged.

	The "N S" command lists all the nodes with non-zero stats
	(i.e. round-trip times and frame counts).

	The "N T" command lists the nodes which have only time-domain
	information, i.e. trip time but no netrom quality.

	The "N V <call>" (via) command lists only the nodes to whom
	the preferred route is via the immediate neighbour whose
	callsign or alias is specified by <call>.

	The "N +" command shows the nodes which have *both* netrom
	and time-domain information.

	The "N > <quality>" form displays the nodes whose primary
	route quality is greater than the specified value.

	The "N < <quality>" form displays the nodes whose primary
	route quality is less than the specified value.

	The NODE ADD command allows nodes to be manually added to the
	Netrom nodes table, and optionally "locked in".  This can be
	useful in cases where the node is reachable, but not in the
	table.

	<call>      Callsign of the node you are adding.
	[alias]     Optional alias for that node.
	<via>       Callsign of neighbour the node is reached via
	<port>      Radio port the neighbour is on.
	<quality>   Netrom quality for the node.
	[!]         Lock flag.

	NODE DROP removes a node from the table.

EXAMPLES
         N           - List nodes except those beginning with #
         N *         - List nodes including those beginning with #
         N > 100     - List nodes whose quality is greater than 100
         N < 20      - List nodes whose quality is less than 20
         N +         - List nodes with both quality and trip time
         N MLVN      - Display routes to MLVN node
         N A MLVN    - List nodes advertised by MLVN
         N F         - List nodes to whom frames have been sent
         N H         - List the nodes for whom a hop count is known
         N I         - List the nodes whose IP address is known.
         N N         - List the Netrom-only nodes
         N P         - List all nodes whose APRS position is known
         N Q         - List the nodes for whom data is queued
         N R         - List the nodes for whom an RTT is known
         N S         - List the nodes with non-zero stats
         N T         - List the time-domain-only nodes
	 N V MLVN    - List nodes routed via MLVN node.
         NODE ADD GB7BM-7:BRMCHT GB7BM 23 10 !

AVAILABILITY
        The NODES command is available to all users.
	The ADD and DROP cubcommands are only available to sysops.
	The ADD subcommand may also be used in BOOTCMDS.SYS by preceding
	it with "netrom", i.e. "netrom node add ...".

NODES(1)                         END OF DOCUMENT
