ARP(1)                    XROUTER REFERENCE MANUAL            25/04/04

COMMAND
        ARP -- Display / Edit / Control of the ARP table.

SYNOPSIS
        ARP [ADD <host> <hwtype> <addr>]
            [DROP <host> <hwtype>]
            [FLUSH]
            [LIST] 
            [PUBLISH <host> <hwtype> <addr>]
            
            [LEARN DEFAULT [on/off]]
            [LEARN <port> [on/off]]
            [TIMEOUT [0-32767]]
            [WAIT [0-32767]]
            [MAXQ [0-32767]]
            [CMD [0-255]]

DESCRIPTION
        The ARP command is used to display, edit and control the 
        Address Resolution Table, responsible for mapping IP 
        datagrams to callsigns.

        If no arguments are supplied, or the argument is LIST, the 
        table is listed.

        The forms ARP ADD and ARP PUBLISH are used to add an entry to 
        the table.  PUBLISH is used when a host is "hidden" on a 
        network which is only accessible via Xrouter, and allows 
        Xrouter to respond to arp requests for the hidden system, by 
        returning its own hardware address.

        ARP DROP is used to delete an entry, and ARP FLUSH removes 
        temporary entries, i.e. those pending resolution.

        <host> is an IP address in dotted quad form.

        <hwtype> is the hardware type, i.e. "ax25" or "ether".

        <addr> is the hardware address, i.e. callsign or ethernet.
        
        ARP LEARN controls the ability to learn hardware
        addresses from heard traffic, the ability can be 
        switched on/off on individual ports.

        ARP TIMEOUT controls the lifetime of these dynamic entries
        (default 900 seconds)

        ARP WAIT sets the time XROUTER will wait for a reply to
        any ARP queries that it makes. (default 30 seconds)

        ARP MAXQ sets a limit to the number of outstanding datagrams
        which may be queued pending resolution (default 100)

        ARP CMD is used to control who can see the ARP table
        currently the flags are:

        1 = Command is available to secure sysops (e.g. wire links)
	2 = Command available to non-secure sysops (e.g. rf links)
	4 = Command is available to users
	8 = Private addr's visible to secure sysops
	16 = Private addr's visible to non-secure sysops
	32 = Private addresses visible to all users

	default is 255.
        command can be used in BOOTCMDS.SYS,IPROUTES.SYS or 
        command line  
EXAMPLES
        ARP ADD 44.131.91.2 ax25 gb7pzt-5    Add ax25 entry
        ARP PUB 44.131.91.127 ax25 g8pzt     Publish 91.127
        ARP DROP 44.131.91.7 ax25            Delete ax25 entry
        ARP LIST                             List the table
        ARP                                  List the table
        ARP LEARN DEFAULT ON                 Allows ARP learning
        ARP LEARN 4 ON                       ARP learn on port 4
        ARP TIMEOUT 900                      Dynamic entry timeout
        ARP WAIT 30                          Resolution timeout
        ARP MAXQ 100                         Limits queue to 100
        ARP CMD 255                          Sets ARP availability

AVAILABILITY
        The LIST subcommand availability is controlled by the ARP CMD, 
        but ADD, DROP, PUBLISH, FLUSH, LEARN, TIMEOUT, WAIT, MAXQ and 
        CMD are sysop-only.

NOTES
        In order for this command to have any meaning, the router must 
        have an IP address and be connected to an IP-capable network.

        You cannot add hardware address types for which there is no 
        compatible interface, e.g. an attempt to add an Ethernet 
        address on a system with no Ethernet interfaces will fail.
        
        The amount of memory taken by the ARP list can be limited
        in the configuration file with MAXARP which sets the
        maximum total number of static/dynamic entries

ARP(1)                         END OF DOCUMENT
