STEALTH(1)              XROUTER REFERENCE MANUAL              23/7/02


                          TCP/IP Stealth Mode
                          -------------------


The experimental command IP QUIET [n] controls whether or not ICMP 
error messages are generated.  The command may be used at the command 
prompt, in BOOTCMDS.SYS, or (without the "IP") in IROUTE.SYS.  I am 
not convinced it is a good idea, and I may remove the command or 
modify its action as experience is gained.

Hackers use automated software to "probe" the network, looking for 
unprotected TCP or UDP services and "back doors" such as NetBios. When 
they find such a service, they will usually exploit known bugs, such 
as buffer overflow problems, to crash the machine or gain access to 
sensitive areas.

Xrouter has only a handful of standard TCP / UDP services, none of 
which pose much of a security risk if configured correctly, so the 
probes are more of a bandwidth-wasting nuisance than a real threat.

Issuing the command "IP QUIET n", where n is a number between 1 and 
255 puts Xrouter into "stealth mode", the level of which depends on 
the number n, which is the sum of the following values:

        1       Suppress ICMP echo replies.
        2       Suppress ICMP "Unknown Protocol" messages
        4       Suppress TCP resets
        8       Suppress all other ICMP error messages.

A value of 0 disables stealth mode and lets TCP/IP operate normally.

Suppressing ICMP messages, may reduce the bandwidth wasted and slow up 
the rate of probing.  But it won't confer any extra security, and will 
certainly have a detrimental effect on normal TCP/IP operations.

ICMP error messages are an integral part of the TCP/IP protocol, and 
are used to inform a sender of network problems such as unroutable 
frames, unsupported protocols, processing errors etc.  They are also 
used for diagnostic purposes, by applications such as "Ping" and 
"TraceRoute".

Using stealth mode therefore prevents the use of diagnostics and the 
detection of network problems, and may under some conditions make 
everything run more slowly, or fail completely.

If you suppress ICMP echo replies, your system will not respond to 
"pings".  This may be temporarily useful if you are being attacked 
with echo requests, but you would also be denying others the use of
a valuable network diagnostic tool.  I feel it is anti-social to do 
so.  It will not *prevent* a pingstorm attack, but it will halve the 
traffic by suppressing the replies.

If you suppress ICMP "unknown protocol" messages, it will reduce the 
bandwidth wasted by protocol scans, i.e. those in which the protocol 
number is incremented with each probe.

"Suppressing TCP resets" prevents the TCP layer from sending a refusal 
for connect requests aimed at non-existent TCP services. The request 
is simply ignored instead.  This may be useful in slowing up the 
action of so-called "port scanners".

I do not recommend the "Suppress all ICMP error messages" option.  It 
is provided for experimentation only.


STEALTH(1)                         END OF DOCUMENT
