ROUTES(1)               XROUTER REFERENCE MANUAL              23/7/02

COMMAND
        ROUTES -- List neighbouring nodes which can be heard directly.  

SYNOPSIS
        R[outes] [R <port> | * | X]

DESCRIPTION
        The ROUTES command, which may be abbreviated to "R", lists the 
        immediately adjacent NetRom nodes, i.e. those who can be heard 
        directly, providing those nodes are making NetRom nodes 
        broadcasts.

        For each neighbour node the display shows the port number, the 
        neighbour's callsign, the route quality (Qty), and the number 
        of nodes accessible through that neighbour (Nod).  A chevron 
        (>) in the left-most column indicates a route which is in use, 
        and an exclamation mark (!) in the right-most column indicates 
        that the data has been "locked in" by the sysop. See 
        example...

        If a single argument (other than X) is supplied, it will give 
        additional information mainly of interest to sysops.  The 
        additional fields are the current MAXFRAME (Max), FRACK 
        (Frack) and PACLEN (Pac) settings, the number of information 
        frames sent (Sent), the number of information frames re-sent 
        (Resent), the retry rate (Rty%), which is the ratio of the two 
        preceeding figures (or * if both are zero), and the time a 
        nodes broadcast was last heard from the neighbour (Last 
        Heard).

        The "R X" form shows the long term average retry rate (Rty%), 
        plus a "running average" (Now%).  It also records the peak 
        value of the running average (Max%) and the date/time when it 
        occurred.

        If the first argument is "R" and the second is a port number, 
        e.g. "R R 2", it will display only the routes which use that 
        port.

EXAMPLES
        If no arguments are supplied, the output looks like this:

        G8PZT:KIDDER} Routes:
        Port Callsign  Qty Nod
        >  5 G4FPV     150  70!
        >  7 GB7PZT    250   1!
        >  8 GB7WV-12  100  32!
        >  9 GB7GH     150 104!
          10 GB7CL     150   1!
        > 11 GB7IPT-7  150   3!
          12 G1LOA-10  150   2!

        The R R form produces an output similar to this:

        G8PZT:KIDDER} Routes:
        Port Callsign Qty Nod Max Frack Pac  Sent Resent Rty%  Last Heard
        >  5 G4FPV    150  70! 5   7000 160 15550   1507   9% 09/06 13:46
        >  7 GB7PZT   250   1! 7   5000 240 25387      4   0% 09/06 13:47
        >  8 GB7WV-12 100  32! 1   4000 120 12170   3426  28%09/06 13:35
        >  9 GB7GH    150 104! 4   7000 120  7442   1335  17%09/06 13:47
          10 GB7CL    150   1! 3   7000 240   330      1   0%09/06 13:23
        > 11 GB7IPT-7 150   3! 2   7000 120 19401   2928  15%09/06 13:47
          12 G1LOA-10 150   2! 4   7000 120 10745   3379  31%09/06 13:39

        The R X form produces an output like this:

        G8PZT:KIDDER} Routes:
        Port Callsign  Qty Nod    Sent  Resent  Rty%  Now%   Max% @dd/mm hh:mm
        >  7 GB7PZT    250   1!  10067       0    0%   0.0    0.0  
        >  9 GB7GH     150  93!    333      17    5%   5.3    5.6  26/08 20:26
        > 12 G1WXA-1   150   2    1231      83    6%   1.6   24.4  26/08 12:37
        (End of list)

AVAILABILITY
        The ROUTES command is available to all users.


ROUTES(1)                         END OF DOCUMENT
