RESPTIME(1)             G8PZT ROUTER REFERENCE MANUAL         10/6/00

COMMAND
        RESPTIME -- Display / Set L2 delayed ack timer for port.

SYNOPSIS
        RESPTIME <port> [millisecs]

DESCRIPTION
        The RESPTIME command allows the value of the AX25 T2 (delayed 
        ack) timer for a port to be displayed or altered.

        If a single numeric argument is supplied, the current value 
        for that port number is displayed.

        If two numeric arguments are supplied, the first specifies the 
        port number, and the second specifies the new value for the 
        parameter.  The new setting remains in force until changed, or 
        until the router is restarted, in which case the value 
        specified in the CFG file is reapplied.

EXAMPLE
        RESPTIME 3       - Display current setting for port 3
        RESPTIME 3 150   - Set port 3 resptime to 1500 millisecs

AVAILABILITY
        THis is a sysop-only command.

NOTES
        The RESPTIME parameter specifies how long the router will 
        wait, after receiving a frame, before sending an ack for that 
        frame.  It helps to improve the efficiency by cutting out 
        unnecessary acks.  It allows a single ack to be sent when a 
        transmission contains several frames, instead of acking each 
        frame in turn.

        The value must therefore be at least the length of time it 
        takes to transmit a single packet.  At 1200 bauds (120 
        bytes/sec) a 120 byte packet lasts 1 second, a 180 byte packet 
        lasts 1500 millisecs and a 256 byte packet lasts just over 2 
        secs.  Therefore resptime should reflect the paclen used by 
        the sender.  1500 millisecs is a good compromise, but if the 
        other end regularly uses high paclens, 2000 or 2500 ms would 
        be more appropriate.

        At 9600 baud, 200 millsecs is probably adequate.

        Too high a value will cause the link to be too "relaxed", 
        whereas too low a value will cause too many acks.  Both 
        extremes reduce the link efficiency.

SEE ALSO
        FRACK, SLOTTIME

RESPTIME(1)                        END OF DOCUMENT
