MPORT(1)                G8PZT ROUTER REFERENCE MANUAL        15/10/00

COMMAND
        MPORT -- Select which port(s) to monitor (trace)

SYNOPSIS
        MP[ORT] [0 - FFFFh]

DESCRIPTION
        The MPORT command selects which ports will be monitored when 
        traffic tracing is enabled.

        The optional argument is a HEX number between 0000h and FFFFh, 
        which is calculated by adding together the desired values from 
        this table:

        Port  HEX    Port  HEX    Port  HEX     Port  HEX
         1     1      5    10       9   100      13   1000
         2     2      6    20      10   200      14   2000
         3     4      7    40      11   400      15   4000
         4     8      8    80      12   800      16   8000

        If no argument is supplied, the current setting is reported.

        This command duplicates the function of the <F3> key.

        If used by a remote sysop, monitored frames are sent to him 
        instead of the console window.  In order to avoid overloading 
        the link, the MPORT setting is cleared every time monitoring 
        is enabled, so the sysop must then issue the MPORT command to 
        select which port(s) to monitor.

        The console can override a remote sysop's settings.

EXAMPLES
        MPORT 800  -  Trace port 12.
        MPORT 1803 -  Trace ports 13, 12, 2 and 1.

AVAILABILITY
        The MPORT command is available only to console and remote 
        sysops.

LIMITATIONS
        Only one sysop may receive the trace display at any one time.
          
        Remote sysops cannot trace activity on the port on which they 
        are uplinked

NOTE
        Remote sysops must ensure that their link with the router is 
        capable of carrying the large volume of traffic resulting from 
        tracing.  Attempting to trace too many ports / too much detail 
        on a slow link may result in poor performance.  You have been 
        warned!

SEE ALSO
        MONITOR  -  Enable / disable monitoring.
        MMASK    -  Select type of activity to monitor.

MPORT(1)                        END OF DOCUMENT
