CHATCMDS(1)             XROUTER REFERENCE MANUAL              23/7/02

CHAT SERVER COMMANDS
====================

The following commands are available within the chat server only.

/?       /BYE      /CHANNEL  /EXIT   /HELP     /JOIN     /LEAVE
/LINKS   /MSG      /NAME     /PERSONAL /QUIT   /TOPIC    /USER
/WHO     /VERSION


CHAT SERVER COMMANDS IN DETAIL
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Note that the server is still experimental, and the syntax of these 
commands may be changed in future versions.  Additional commands will 
be added as required.


/?       Display commands / syntax help.

         Syntax: /? [cmd]

         When used without arguments, the /? command lists the 
         available commands.  The syntax for any of the commands thus 
         listed may be shown by specifying the command as an argument 
         to the /? command.

         Examples:  /?          List available commands.
                    /? /who     Display syntax for the /WHO command.



/BYE    Exit the chat server.

         Syntax: /B[ye]

         The /BYE command, which may be shortened to /B, disconnects 
         the user from the chat server, and informs everyone that he's 
         left.  There is no need for the user to /leave any logged 
         channels before issuing this command.

         If the user accessed the server via the router's CHAT 
         command, he will be returned to the router's main command 
         prompt, otherwise he will be completely disconnected.

         The /EXIT and /QUIT commands also perform this function.


/CHANNEL  Display / Change logged channel(s).

         Syntax: /C[hannel] [number]

         The /CHANNEL command displays / changes the channel(s) the 
         user is logged to.  When no argument is supplied, the logged 
         channel(s) is / are displayed.  If a valid numeric argument 
         is supplied, the user is logged to the specified channel.

         Examples: /C        Displays current logged channel(s)
                   /C 22     Change to channel 22

         When a new channel is selected, the user remains logged to 
         any previous channels, (so he can "monitor" several channels 
         at once) but any subsequent text he sends will go to the new 
         channel (unless targeted otherwise).

         Note: Channels 0 to 255 are "local" to each chat server, and 
         channels 256-32767 are "global", i.e. they are linked with 
         all other servers. 

         The /JOIN command has a similar function, and /LEAVE is used 
         to de-select unwanted channels.


/EXIT    Exit the chat server.

         Syntax: /E[xit]

         The /EXIT command, which may be shortened to /E, disconnects 
         the user from the chat server, and informs everyone that he's 
         left.  There is no need for the user to /leave any logged 
         channels before issuing this command.

         If the user accessed the server via the router's CHAT 
         command, he will be returned to the router's main command 
         prompt, otherwise he will be completely disconnected.

         The /BYE and /QUIT commands also perform this function.


/HELP    Obtain help.

         Syntax: /HELP [topic]

         When used without arguments, the /HELP command gives brief 
         instruction on how to access various levels of help.

         If a topic is specified, detailed help for that topic (if 
         available) is displayed.  The topic may be a command name, or 
         any other chat server related topic.  A list of the available 
         help topics can be obtained by specifying "*" as a topic.

         Examples:  /H          Display general instructions.
                    /H *        List available help topics.
                    /H /who     Display help for /WHO command.

         Note:  When using /H to display help for a command, the         
         leading slash for that command may be omitted.  Thus         
         "/H /who" and "/H who" are equally permissible.


/JOIN    Join (log onto) a channel.

         Syntax: /J[oin] <channel>

         The /JOIN command logs the user to a channel, and performs a 
         similar function to the /CHANNEL command.

         When a new channel is selected, the user remains logged to 
         any previous channels, (so he can "monitor" several channels 
         at once) but any subsequent text he sends will go to the new 
         channel (unless targeted otherwise).  (Unwanted channels may 
         be de-selected using the complementary /LEAVE command.)

         Example:  /J 22   Join channel 22

         Note: Channels 0 to 255 are "local" to each chat server, and 
         channels 256-32767 are "global", i.e. they are linked with 
         all other servers. 


/LEAVE   Leave (log off) a channel.

         Syntax: /L[eave] <channel>

         The /LEAVE command logs the user off the specified channel.  
         When a user joins a channel, he remains logged to any 
         previous channels, so this command allows him to de-select 
         unwanted channels.

         Example:  /L 22   - Leave channel 22


/MSG     Send a short message to a channel or a single user.

         Syntax: /M[sg] <channel | callsign> <text>

         The /Msg command is used to send a short message (70 chars 
         max.) to any specified channel or single user.  You may for 
         example use this command to direct a message to a channel you 
         are monitoring, but not actually logged to.

         If you direct a message to a specific user, he may be on this 
         or any other chat server.  The private nature of the message 
         will be indicated to the recipient by asterisks around the 
         sender's call, e.g. <*g8pzt@kdchat*> (Paula): Meet me on 
         channel 69.

         Examples: /M 32 Hello People
                   /M g6yak Meet me on channel 69

         The first form sends "Hello People" to all the users of 
         channel 32, and the second form sends a private msg to g6yak 
         only. Providing G6YAK is logged on to any chat server, the 
         message will find him.

         Note: As with all things Packet, the term "private" is 
         relative, as nothing is truly private when it is broadcast!


/NAME    Set name.

         Syntax:  /N[ame] <your name> [channel]

         The /NAME command sets the user's name, which will be 
         displayed on the user list and prefixed to everything he 
         sends to others.

         Users are not allowed to join any channels until they have 
         supplied a name (12 chars max), so it acts as a "log on" 
         command.  The name need be supplied only at the initial 
         logon, and may be changed as the user wishes.

         On the first use of this command, the user may optionally 
         specify a channel to join instead of the default (channel 0).

         TCP/IP users must first use the /USER command (see below) to 
         enter their callsign.

         Examples: /N Paula       Set name to "Paula"
                   /N Paula 23    Set name and join channel 23


/PERSONAL  Display / change personal description.

         Syntax: /P[ersonal] [text | @]

         The /PERSONAL command is used to display or change the user's 
         personal description.  This is a short text of up to 32 
         characters, which is displayed on the user list.  It may 
         typically contain the user's home town and "brag" 
         information.  If the user logs onto any "public" channels 
         (i.e. those above channel 255), this information will appear 
         on the user lists of all other chat servers.

         If used without arguments, the /PERSONAL command displays the 
         user's current text.  

         If the argument is "@", the existing text is removed.

         Examples: /P                        - Displays current text
                   /P Kidderminster, sysop   - Set new text.
                   /P @                      - Clear previous text.


/QUIT    Exit the chat server.

         Syntax: /Q[uit]

         The /QUIT command, which may be shortened to /Q, disconnects 
         the user from the chat server, and informs everyone that he's 
         left.  There is no need for the user to /leave any logged 
         channels before issuing this command.

         If the user accessed the server via the router's CHAT 
         command, he will be returned to the router's main command 
         prompt, otherwise he will be completely disconnected.

         The /BYE and /EXIT commands also perform this function.


/TOPIC   Display / Change channel topic.

         Syntax: /T[opic] [channel] [text | @]

         Every channel has an optional topic, and the /TOPIC command 
         can be used to display the existing topic or change it.  The 
         topic can be up to 12 characters, and is displayed on the 
         /Who list.

         Examples: /T                        - Show current ch. topic
                   /T 32                     - Show channel 32 topic
                   /T 32 TCP/IP discussion   - Set topic for ch. 32
                   /T @                      - Clear topic.


/USER    TCP/IP logon.

         Syntax:  /U[ser] <callsign> [name]

         The /USER command is available only to TCP/IP users.  It sets 
         the user's callsign (and optionally his name), which will be 
         displayed on the user list and prefixed to everything he 
         sends to others.

         The user will not be able to join the conference without 
         supplying both callsign (9 chars max) and name (12 chars 
         max), but if the name is omitted from this command he may 
         enter it in the normal way with the /Name command.

         Examples: /U g8pzt          - Set callsign to "g8pzt".
                   /U g8pzt Paula    - Set callsign and name.


/VERSION  Display chat server version.

         Syntax: /V[ersion]

         The /VERSION command displays the chat server version, author 
         and compilation date.  Please quote it if reporting bugs.


/WHO     List channels and users.

         Syntax: /W[ho] [*]

         The /WHO command lists who is logged onto the chat server, 
         and what channels they are on.

         If no arguments are supplied, the active channels are listed, 
         along with the callsigns of their users.

         If an asterisk is supplied as the argument, each user is 
         displayed in more detail.  The display would typically show 
         the user's callsign, name, personal text and logon date/time.

         Examples:  /W     Lists channels & users in brief format
                    /W *   Lists users in detail

CHATCMDS(1)                    END OF DOCUMENT
