; HELP/FTP/FTP.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified: 26/1/99

This FTP server accepts the following commands:


        ABOR    CDUP    CWD     DELE    HELP    LIST    MKD     MODE
        NLST    NOOP    PASS    PORT    PWD     QUIT    RETR    RMD
        RNFR    RNTO    STOR    STRU    SYST    TYPE    USER


All commands and arguments are case-insensitive, thus "cwd", "CWD" and
"cWd" are equally valid.

Both UNIX style (e.g. /pub/fred) and DOS style (e.g. \pub\fred) pathname
conventions are accepted.

To get more help on any of these commands type "HELP <command>", where
<command> is the command for which you want help, e.g.	HELP RETR

; HELP/FTP/ABOR.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified: 26/1/99

COMMAND
	ABOR

SYNOPSIS
        Abort data connection.

SYNTAX
	ABOR

DESCRIPTION
        The ABOR command tells the server to abort any data transfer
        currently in progress and close the data connection.  The control
        connection is not closed.

        If the data connection is not open, this command has no effect.

; HELP/FTP/CDUP.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified: 26/1/99
;
The CDUP command changes the current working directory up one level to
the parent directory, i.e. it performs the function of "CWD .."

This command has no arguments, and if already at the root it has no effect.

See also:
   CWD   Change Working Directory

; HELP/FTP/CWD.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;
CWD changes the current working directory on the FTP server.

SYNTAX: CWD <pathname>

The server accepts both UNIX (e.g. pub/files) and DOS (e.g. pub\files)
pathname conventions, and is not case sensitive.

EXAMPLES:
        CWD FRED        Change to subdirectory FRED of current directory
        CWD ..          Change up one level to parent directory
        CWD /           Change to root directory
        CWD /FRED/JIM   Change to JIM subdirectory of FRED directory.

See also:
   CDUP   Change up one directory; HELP/FTP/SYST.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Command:
   SYST  (System)

Synopsis:
   FTP server command - Operating system enquiry.

Syntax:
   SYST

Description:
   The SYST command is used to find out what type of operating system
   is being used on the server.

   The first word of the reply is one of the agreed system names, in
   this case MSDOS.  The rest of the reply gives the BBS version number
   and byte size.

; HELP/FTP/DELE.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Synopsis:
   The DELE (delete) command deletes file(s) on the FTP server.

Syntax:
   DELE <filename>

Examples:
   DELE JIM.TXT         Delete file JIM.TXT from current directory.
   DELE /FRED/DOG.EXE   Delete DOG.EXE from directory /FRED
   DELE *.BAT           Delete all files with .BAT extension.

Notes:
   Wildcards '*' and '?' are accepted.
   You can only delete files if you have permission to do so.

; HELP/FTP/HELP.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Synopsis:
   The HELP command gives help on FTP server commands.

Syntax:
   HELP [<command>]

Examples:
   HELP        Displays basic info and a list of commands
   HELP CWD    Gives information about the CWD command

Notes:
   Some FTP clients may intercept the HELP command to give help on client
   commands.  In this case, the REMOTEHELP command, if it is implemented
   should translate to a server HELP command.  If not, the client may have
   a command which passes commands "RAW" to the server.
   If all else fails, TELNET to port 21 and the HELP command will work.


; HELP/FTP/LIST.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Synopsis:
   The LIST command lists FTP server directory contents.

Syntax:
   LIST [<filespec>]

Description:
   The LIST command causes a directory listing to be sent from the FTP
   server to the client over the data connection.  If the data connection
   cannot be established, the command will fail.

   The optional argument consists of a directory path and filename mask.
   If no path is specified, the current directory is assumed.  If no
   mask is specified, "*" (all files) is assumed.  Wildcards '*' and '?'
   are accepted. 

Examples:
   LIST              Displays all files in current directory
   LIST PUB          Lists all files in PUB subdirectory
   LIST /USR/*.EXE   Lists all executable files in /USR directory

;Notes:
See also:
   NLST  List names only
; HELP/FTP/MKD.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Synopsis:
   MKD (Make Directory) creates a new directory on the FTP server. 

Syntax:
   MKD <pathname>

Description:
   The MKD command creates a new directory on the FTP server and makes
   you the owner.

Examples:
   MKD FRED           Create directory FRED in current directory
   MKD /JIM/BILL      Create directory BILL in the /JIM directory

Notes:
   You can only create directories if you have write permission, and
   only in directories for which you are granted write access.

See also:
   RMD  Remove directory

; HELP/FTP/MODE.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Synopsis:
   The MODE command specifies the data transfer mode.

Syntax:
   MODE <mode_code>

Description:
   MODE specifies how the data is to be formatted and transferred via
   the data connection.  Mode codes are as follows:

       B - Block         Data is sent in blocks
       C - Compressed    Data is compressed
       S - Stream        Data sent as continuous stream of characters

   The default transfer mode, which is the only one currently implemented,
   is Stream.  The command is included to prevent unnecessary error
   replies.

Examples:
   MODE S   Sets (S)tream transfer mode.

;Notes:
; HELP/FTP/NLST.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Synopsis:
   NLST (Name List) lists FTP server directory contents in short form.

Syntax:
   NLST [<filespec>]

Description:
   The NLST command causes a directory listing to be sent from the FTP
   server to the client over the data connection.  If the data connection
   cannot be established, the command will fail.

   The optional argument consists of a directory path and filename mask.
   If no path is specified, the current directory is assumed.  If no
   mask is specified, "*" (all files) is assumed.  Wildcards '*' and '?'
   are accepted. 
   
   The listing consists of filenames only, without size, date and other
   supplementary information.

Examples:
   NLST              Displays all files in current directory
   NLST PUB          Lists all files in PUB subdirectory
   NLST /USR/*.EXE   Lists all executable files in /USR directory

;Notes:
See also:
   LIST  List directory contents
; HELP/FTP/NOOP.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Synopsis:
   The NOOP (NO OPeration) command does nothing. 

Syntax:
   NOOP

Description:
   The NOOP does not affect anything, and its only action is to cause
   the server to send an "OK" reply.  It is perhaps useful for testing
   that the control connection is still functioning.

; HELP/FTP/PASS.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Synopsis:
   The PASS (PASSword) command specifies user password at login.

Syntax:
   PASS <password>

Description:
   The argument to the PASS command is a string of up to 8 characters
   specifying the user's password.  The string may not contain spaces.

   The command must be immediately preceeded by the USER command.

Examples:
   PASS WATER   Enters your password as "WATER"

Notes:
   Some usernames, e.g. ANON and GUEST may accept any password if the
   sysop has set up the system to do so.  In this case it is customary
   to give your callsign as the password.

See also:
   USER   Specify your username.
; HELP/FTP/PORT.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Synopsis:
   PORT specifies the IP address and port for the data connection.

Syntax:
   PORT h1,h2,h3,h4,p1,p2

Description:
   The PORT command specifies the IP address and TCP port number to be
   used by the data connection.  The argument is the concatenation of
   a 32 bit IP address and a 16 bit TCP port number, broken into 8 bit
   fields, each field being transmitted as a decimal number.  The
   fields are seperated by commas, and the high order fields are
   transmitted first.

Example:
   PORT 44,131,91,2,4,1   Specifies IP address 44.131.91.2 and TCP
                          port number 0401 (1001 decimal)

Notes:
   Under normal circumstances this command is not needed.  The data
   connection defaults to TCP port 20 at the client's IP address of
   the control connection.  However, it allows data to be sent to
   a completely diffent host if required.

;See also:
; HELP/FTP/PWD.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;
Command:
   PWD (Print Working Directory)

Synopsis:
   Displays directory name currently logged at the FTP server.

Syntax:
   PWD

Description:
   The PWD command causes the full path of the FTP server's current
   working directory to be displayed via the control connection.

See also:
   CWD  (Change Working Directory)

; HELP/FTP/QUIT.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Synopsis:
   The QUIT command terminates an FTP session.  

Syntax:
   QUIT

Description:
   If a file transfer is not in progress, the QUIT command terminates
   the FTP session and closes the control connection.

   If file transfer is in progress, the control connection will remain
   open until transfer is complete, allowing the result code to be
   transmitted.  The control and data connections will then close.

   An unexpected close on the control connection will abort any data
   transfer currently in progress.

;Notes:
See also:
   ABOR  (Abort current command)

; HELP/FTP/RETR.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Command:
   RETR (Retrieve File)

Synopsis:
   Downloads a file from the FTP server to the client.

Syntax:
   RETR <filename>

Description:
   The RETR command causes the named file to be sent from the FTP
   server to the client over the data connection.  If the file can't
   be found, access is denied or the data connection can't be opened
   an appropriate error message is returned.

Examples:
   RETR JIM.TXT         Download file JIM.TXT from current directory.
   RETR /FRED/DOG.EXE   Download file DOG.EXE from directory /FRED

Notes:
   You can only RETR files if you have read permission, and the
   directory owner allows you read access.
   Single files only, wildcards not accepted.

See also:
   PORT   (Specify alternate host/port for data connection)
   STOR   (Send a file to the server)
; HELP/FTP/STOR.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Command:
   STOR (Store File)

Synopsis:
   Uploads a file from the FTP client to the server.

Syntax:
   STOR <filename>

Description:
   The STOR command requests the FTP server to accept data via the data
   connection and store it as a file with the specified name.

   If the file specified in the pathname already exists at the server,
   it is overwritten by the new data.  If the user does not have the
   appropriate write access the request is denied.

Examples:
   STOR JIM.TXT         Upload file JIM.TXT to current directory.
   STOR /FRED/DOG.EXE   Upload file DOG.EXE to directory /FRED

Notes:
   You can only RETR files if you have read permission, and the
   directory owner allows you read access.

See also:
   RETR   (Retrieve a file from the server)
; HELP/FTP/RMD.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Synopsis:
   RMD (Remove Directory) deletes a directory from the FTP server. 

Syntax:
   RMD <pathname>

Description:
   The RMD command deletes the directory specified by <pathname>
   from the FTP server, providing you are the owner of that directory
   and have write access.

Examples:
   RMD FRED           Delete subdirectory FRED from current directory
   RMD /JIM/BILL      Delete subdirectory BILL from /JIM directory

;Notes:
See also:
   MKD  (Make directory)

; HELP/FTP/RNFR.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Command:
   RNFR (Rename From)

Synopsis:
   Specifies a file to rename on the FTP server.

Syntax:
   RNFR <filename>

Description:
   The RNFR command specifies the old pathname of a file which is to be
   renamed, and must be immediately followed by an RNTO command.  The two
   commands together cause a file to be renamed.

   If the file isn't found, or the user doesn't have sufficient access
   the request will be refused.

Examples:
   RNFR JIM.TXT         Rename file JIM.TXT in current directory.
   RNFR /FRED/DOG.EXE   Rename file DOG.EXE in directory /FRED

See also:
   RNTO   (Rename To)
; HELP/FTP/RNTO.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Command:
   RNTO (Rename To)

Synopsis:
   FTP server command - Specifies new name for renamed file.

Syntax:
   RNTO <filename>

Description:
   The RNTO command specifies the new pathname of a file which is being
   renamed, and must immediately follow an RNFR command.  The two
   commands together cause a file to be renamed.

   If the new pathname isn't vaild, or the user doesn't have sufficient
   access the request will be refused.

Examples:
   RNTO DOG.TXT         Rename file to JIM.TXT in current directory.
   RNTO /FRED/CAT.EXE   Rename file to DOG.EXE in directory /FRED

See also:
   RNFR   (Rename From)
; HELP/FTP/STRU.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Command:
   STRU (File Structure)

Synopsis:
   The STRU command specifies the structure of files.

Syntax:
   STRU <structure_code>

Description:
   STRU specifies the internal structure of the files being transferred,
   i.e.  how the data is organised within them.
   Structure codes are as follows:

       F - File       No record structure (contiguous bytes)
       R - Record     File is collection of sequential records
       P - Page       File is composed of independant pages

   The default structure, which is the only one currently implemented,
   is (F)ile.  The command is included to prevent unnecessary error
   replies.

Examples:
   STRU F   Sets (F)ile structure.
; HELP/FTP/USER.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Command:
   USER  (User name)        { FTP server command }

Synopsis:
   Specifies user's name for login purposes.

Syntax:
   USER <username>

Description:
   The argument to the USER command is a string of up to 8 characters
   specifying the user's login name.  The string may not contain spaces.

   Users are not allowed access to the system without logging in.

   The command must be immediately followed by the PASS command.

Examples:
   USER GUEST   Enters your login name as "GUEST"

See also:
   PASS   Specify your password.
; HELP/FTP/TYPE.HLP
; G8PZT BBS FTP SERVER HELP FILE
; Last Modified 26/1/99
;

Command:
   TYPE  (Data Type)   {FTP server command}

Synopsis:
   The TYPE command specifies the data representation type.

Syntax:
   TYPE <type_code>

Description:
   The argument to the TYPE command specifies how the data is to be
   translated between storage and transfer.
   Type codes are as follows:

       A - ASCII      Text.  End of line indicated by <CR><LF>   
       I - Image      No translation.  Bytes stored as received.
       L <bytesize>   Size of local storage bytes


Examples:
   TYPE A    Specifies Ascii type.
   TYPE L 8  Specifies local byte size of 8 bits
