NODES(1)                XROUTER REFERENCE MANUAL              22/7/02

COMMAND
        NODES -- Display contents of the Nodes table.

SYNOPSIS
        N[odes] [<call> | * | F | H | P | Q | R | T | V <call>]

DESCRIPTION
        When used without arguments, this command lists all the NetRom 
        nodes (but not KA nodes) known to the router, except those 
        "hidden" nodes whose alias begins with the hash (#) character.

        If the argument is an asterisk (*), all nodes, including 
        "hidden" nodes will be displayed.

        If the argument is a known node call or alias, the preferred 
        route to the specified node, and up to two alternative routes 
        will be displayed.  Example: N MLVN  The response looks like 
        this:

        G8PZT:KIDDER} Routes to: MLVN:G4FPV  RTT=28  FR=3538  Q=0
        > 150  5  5 G4FPV
          110  5  9 GB7GH
            0  4  2 G1DKI-7

        RTT stands for Round Trip Time and is a running average of the 
        time taken to get a response from that node.

        FR indicates the number of level 3 frames sent to that node.

        Q is the number of Level 3 frames currently queued for that 
        destination.

        A chevron ">" in the left-most column indicates the currently 
        active route.

        The first number shows the overall path quality to the target 
        node, the second is the "obsolescence count", and the third 
        number is the port designator.  The obsolescence count is a 
        measure of how recently the route was heard about or used.  It 
        is usually reset to 5 upon hearing a nodes broadcast from the 
        neighbour node, and decrements by one every time this node 
        makes a node broadcast (typically once per hour). If it drops 
        below 4 the route is considered to be obsolete.

        If the requested nodecall or alias is not in the table, an 
        error message results.

        The "N T" command will list the round trip times and frame 
        counts for all nodes which have non-zero figures, producing a 
        display like this:

        G8PZT:KIDDER} Nodes:
         WV12:GB7WV-12     RTT=20  FR=255  Q=0
         WV13:GB7WV-13     RTT=14  FR=26  Q=0
         WV22:GB7WV-2      RTT=14  FR=31  Q=0

        The "N F" (frames) variation lists only the nodes to whom one 
        or more frames have been sent.

        The "N H" (hops) command lists only the nodes for whom a "hop 
        count" is known, i.e. the number of nodes a frame must pass 
        through to reach that destination.  It is not always possible 
        to measure the hops via old netrom systems.

        The "N P" (position) command lists only the nodes whose APRS 
        position is known.  This will include immediate neighbours of 
        any software type, and distant Xrouters, providing in each 
        case that their sysops have included their APRS position 
        details in a beacon.

        The "N Q" (queue) command lists only the nodes for whom frames 
        are currently queued.  Since it is a "snapshot" of the state 
        at the time the command was issued, it is likely to produce 
        different results each time, but it allows problems to be 
        identified.

        The "N R" (rtt) command lists only the nodes for whom a Round 
        Trip Time is known.  The RTT is only available for those nodes 
        with whom traffic hasbeen exchanged.

        The "N V <call>" (via) command lists only the nodes head via 
        the immediate neighbour whose callsign or alias is specified 
        by <call>.


EXAMPLES
        N           - List nodes except those beginning with #
        N *         - List nodes including those beginning with #
        N MLVN      - Display routes to MLVN node
        N F         - List nodes to whom frames have been sent
        N H         - List the nodes for whom a hop count is known
        N P         - List all nodes whose APRS position is known
        N Q         - List the nodes for whom data is queued
        N R         - List the nodes for whom an RTT is known
        N T         - List all nodes with any non-zero counts
        N V MLVN    - List nodes routed via MLVN node.

AVAILABILITY
        The NODES command is available to all users.

NODES(1)                         END OF DOCUMENT
