PACLEN(1)               G8PZT ROUTER REFERENCE MANUAL         10/6/00

COMMAND
        PACLEN -- Display / Set global or port paclen values.

SYNOPSIS
        PACLEN [port [value]]

DESCRIPTION
        The PACLEN command allows the global and port-specific PACLEN 
        settings to be displayed and changed.  Paclen is the maximum 
        data field length within a packet.

        The global PACLEN is specified in the L2 global parameters 
        section of the config file, and is the default value, used 
        where not overriden by a port-specific paclen.  

        All frames originating at the router use the global or port 
        paclens specified, but Netrom frames originating at other 
        systems can not be fragmented, so we have no control over 
        them, and they may be larger than our paclen.

        Used with no arguments, the PACLEN command displays the 
        current global paclen.

        If a single numeric argument is supplied, and its value is 
        less than 30, the current paclen for that port number is 
        displayed.  If the argument is between 30 and 256 the global 
        paclen is set to that value.

        If two numeric arguments are supplied, the first specifies a 
        port number and the second specifies a new paclen value for 
        that port.

EXAMPLES
        PACLEN           - Display global default paclen
        PACLEN 120       - Set default paclen to 120
        PACLEN 10        - Display current paclen for port 10
        PACLEN 10 160    - Set port 10 paclen to 160

LIMITATIONS
        The global paclen cannot be set below 30 using this command, 
        and the port paclen for port numbers > 30 cannot be displayed, 
        but this shouldn't present too much of a problem!  If you have 
        a router with over 30 ports let me know....

AVAILABILITY
        This command is not available to non-sysops.


PACLEN(1)                       END OF DOCUMENT
