IP(1)                   G8PZT ROUTER REFERENCE MANUAL         15/6/00

COMMAND
        IP -- Display / Change contents of IP routing table.

SYNOPSIS
        IP ROUTES
        IP ROUTE ADD <host>[/len] <gateway> <port>
        IP ROUTE DROP <host> <len>
        IP ROUTE DEFAULT <port> [gateway [d|v|n]]

DESCRIPTION
        The IP commands are used to display and alter the contents of 
        the table responsible for routing of IP datagrams.

        This table contains a series of entries which are checked 
        whenever a datagram is routed.  The search stops at the first 
        entry which matches the address and mask.

        The command arguments are as follows:

        <host>      Target host IP address in dotted quad form.
        <len>       No. of bits to be matched (from left) 0-32
        <gateway>   Destination gateway IP address in dotted quad. 
        <port>      Port number on which to route the datagram.
        <d|v|n>     Mode: (d)atagram, (v)irtual circuit or (n)etrom.

        The DEFAULT subcommand sets up a default route which is used 
        when no other route is found.  If no gateway is specified, the 
        target will be assumed to be a direct neighbour.  If not 
        specified, the mode defaults to datagram.

        The ADD subcommand adds an entry to the routing table.  The 
        first argument is the target host IP address, with optional 
        mask. e.g. 44.131.90.1/32 means "match all 32 bits", whereas 
        44.131.90.0/24 means "match the most significant 24 bits", and 
        would route all 256 addresses from 44.131.90.0 to 
        44.131.90.255.  The second argument is the "gateway" address, 
        i.e. the address of the system which can handle the datagram.  
        The third argument is the port to route the datagram on, and 
        the last argument is the mode.  Datagram mode should be used 
        on links with low loss rates.  Better performance can be 
        obtained on lossy links by using Virtual Circuit mode.  Netrom 
        mode is inefficient, but can "tunnel" datagrams across non-ip 
        parts of the network.

        The DROP subcommand removes an entry from the table.  Both the 
        target host and the mask must match.

EXAMPLES
        IP ROUTE DEFAULT 3 44.131.90.6 v
        IP ROUTE ADD 44.131.95.0/24 44.131.95.240 9 d
        IP ROUTE DROP 44.131.97.1 32

AVAILABILITY
        The ADD DROP and DEFAULT subcommands are not available to non-
        sysops.

NOTE
        The IP routing table is necessary only for IP, and does not 
        take any part in normal ax25 and Netrom activities.  See the 
        full manual for details on how to set up the IP system.

SEE ALSO
        IPROUTE, ARP.

IP(1)                        END OF DOCUMENT
