/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2001 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#ifndef YAPP_H
#define YAPP_H
//---------------------------------------------------------------------------
#include <qwidget.h>
#include <qtimer.h>
#include <qobject.h>

#include "filetransfer.h"
#include "senddata.h"
//---------------------------------------------------------------------------
class Channel;
//---------------------------------------------------------------------------
class YAPPBase
{
public:
	YAPPBase();

	void SendRR();
	void SendRF();
	void SendRT();
	void SendAF();
	void SendAT();
	void SendSI();
	void SendHD( const char *shortname, long filelen );
	void SendHD();
	void SendDT( int length );
	void SendEF();
	void SendET();
	void SendNR( const char *reason );
	void SendRE( int length );
	void SendCN( const char *reason );
	void SendRS( int length );
	unsigned char checksum( const char *data, int len );

private:
   virtual void sendData( const char *data, int len, bool show=false ) = 0;
};
//---------------------------------------------------------------------------
class YAPP_TX : public FileTransfer, public YAPPBase
{
	Q_OBJECT;
public:
   YAPP_TX( Channel *chan, const QString & filename );
   ~YAPP_TX();

	void getFileData();
   void startSending();
   int sentReady();
   void abortTransmission();

public slots:
	void slotReceivedString( const char *data, int len );
   void sendBlock();

private:
	void sendData( const char *data, int len, bool show=false );
	bool lookForAbort( const char *data );
	void unknownCode();
	void sendTransferInfo();

	QTimer *timer;
   long filelen;
   int state;
   int txready;
   int fd;
   time_t starttime;
   bool yappc;
   long totalsent;
   char *savedata;
   int savelen;
};
//---------------------------------------------------------------------------
// YAPP-RX
class YAPP : public QObject, public YAPPBase, public SendData
{
	Q_OBJECT;

public:
   YAPP( Channel *chan, const QString & filename );
   ~YAPP();

	bool proceed( const char *data, int len );

public slots:
   void sendBlock();

private:
	void sendData( const char *data, int len, bool show=false );
	bool lookForAbort( const char *data );
	bool lookForStart();
	bool readHeader();
	bool readData();
	void unknownCode();
	void sendTransferInfo();

   int state;
   char *savedata;
   int savedatalen;
   int file_time;
   bool yappc;
   QString filename, shortname;
   TransferInfo *transInfo;
   Channel *chan;
   QTimer *timer;
   int fd;
   time_t starttime;

   long filelen, offset, totalrxlen;
};
//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------

