/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  As a special exception, you have permission to link this program
 *  with the Qt library and distribute executables, as long as you
 *  follow the requirements of the GNU GPL in regard to all of the
 *  software in the executable aside from Qt.
 */
//---------------------------------------------------------------------------
#include "userdata.h"
#include "global.h"
#include "flags.h"

#include <qdir.h>
#include <qfile.h>
#include <qtextstream.h>
//---------------------------------------------------------------------------
UserData *userdata;
//---------------------------------------------------------------------------
UserData::UserData()
{
	udataDir = conf->localDir() + "/userdb/";
   userDataList = new QList<UDataUser> ();

   readUserList();
}
//---------------------------------------------------------------------------
UserData::~UserData()
{
}
//---------------------------------------------------------------------------
void UserData::addUserGroup( const QString & directory )
{
	if (directory[0] == '.') return;

   QDir d( directory );
   if (!d.isReadable()) return;
   d.setFilter( QDir::Files );

   const QFileInfoList *list=d.entryInfoList();
   QFileInfoListIterator it( *list );
   QFileInfo *fi;

   while ((fi=it.current()))
   {
      users.append( fi->fileName() );
   	++it;
   }
}
//---------------------------------------------------------------------------
void UserData::readUserList()
{
   QDir d(udataDir);
   if (!d.isReadable()) return;
   d.setFilter( QDir::Dirs );

   const QFileInfoList *list=d.entryInfoList();
   QFileInfoListIterator it( *list );
   QFileInfo *fi;

   while ((fi=it.current()))
   {
   	addUserGroup( udataDir+fi->fileName()+"/" );
   	++it;
   }

   users.sort();
}
//---------------------------------------------------------------------------
const QStringList & UserData::getUserList()
{
	return users;
}
//---------------------------------------------------------------------------
UDataUser * UserData::getUserData( const QString & call )
{
	UDataUser *user;


	// Erstmal gucken, ob dieses Rufzeichen schon in unserem Cache ist.
   for (user=userDataList->first(); user; user=userDataList->next())
   	if (user->getCall() == call)
      	return user;

	// Das Call ist nicht im Cache: Neu erzeugen und in die Liste eintragen
   user = new UDataUser( call, udataDir + call.left(3) + ".../" + call, true );

   return user;
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
UDataUser::UDataUser( const QString & callsign, const QString & filename, int temp )
{
	call = callsign;
   fname = filename;
   temporary = temp;

   readData();
   changed = false;		// Die Werte in den Variablen stimmen mit den in der
   							// Datei ueberein.
}
//---------------------------------------------------------------------------
UDataUser::~UDataUser()
{
}
//---------------------------------------------------------------------------
void UDataUser::readData()
{
   QFile file(fname);
   QString s, parm;
   int i;


   // Standard-Werte
	name = "";
   flags = CH_UI_STDFLAGS;
   remotes = REMOTE_STD_TERMINAL;
   software = CH_UI_STDFLAGS;
   type = TYPE_TERMINAL;

   if (!file.open(IO_ReadOnly)) return;

   QTextStream t( &file );

	while (!t.eof())
   {
      s = t.readLine();
      if ((i = s.find(' ')) == -1) continue;
      parm = s.mid(i+1);
		s.truncate(i);

      saveSetting( s, parm );
   }

   file.close();
}
//---------------------------------------------------------------------------
bool UDataUser::isTemporary()
{
	return temporary;
}
//---------------------------------------------------------------------------
// Speichert die uebergebene Einstellung lokal ab.
void UDataUser::saveSetting( const QString & id, QString & value )
{
	bool ok;
   long l;
   int i;


   if (id == "name")
   {
      name = value;
      return;
	}

	if (id == "flags")
   {
      l = value.toLong( &ok );
		if (ok) flags = l;
   	return;
   }

   if (id == "remotes")
   {
   	l = value.toLong( &ok );
      if (ok) remotes = l;
	}

   if (id == "software")
   {
   	i = value.toInt( &ok );
      if (ok) software = i;
   }

   if (id == "type")
   {
   	i = value.toInt( &ok );
      if (ok) type = i;
   }


   // Abwaerts-Kompatibilitaet - wird nicht mehr abgespeichert
   if (id == "swtype")
   {
   	i = value.toInt( &ok );
      if (ok) software = i;
   }
}
//---------------------------------------------------------------------------
const QString & UDataUser::getCall()
{
	return call;
}
//---------------------------------------------------------------------------
const QString & UDataUser::getName()
{
	return name;
}
//---------------------------------------------------------------------------
long UDataUser::getFlags()
{
	return flags;
}
//---------------------------------------------------------------------------
long UDataUser::getRemotes()
{
	return remotes;
}
//---------------------------------------------------------------------------
int UDataUser::getSoftware()
{
	return software;
}
//---------------------------------------------------------------------------
int UDataUser::getType()
{
	return type;
}
//---------------------------------------------------------------------------
void UDataUser::setName( const QString & name )
{
}
//---------------------------------------------------------------------------
void UDataUser::setFlag( long flag, bool state )
{
}
//---------------------------------------------------------------------------
void UDataUser::setRemotes( long rem )
{
}
//---------------------------------------------------------------------------
void UDataUser::setSoftware( int soft )
{
}
//---------------------------------------------------------------------------
void UDataUser::setType( int type )
{
}
//---------------------------------------------------------------------------

