/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#include "infobar.h"
#include "infobar.moc"

#include <qlayout.h>
//---------------------------------------------------------------------------
char TNC_Status[15][4] = {"DIS","SET","FMR","DRQ","IXF","REJ","WAK","DBS","RBS","BBS","WDB","WRB",
                          "RDB","RRB","RBB"};
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
InfoBar::InfoBar( QWidget *parent ) : QWidget( parent )
{
   QHBoxLayout *hbox = new QHBoxLayout( this );


   hbox->setMargin( 5 );
   hbox->setSpacing( 15 );
   hbox->setAlignment( Qt::AlignVCenter );


	lUnSent = new QLabel( this );
   lUnSent->setText( "UnSent: 0" );
   lUnSent->setFixedSize( lUnSent->sizeHint() );
	hbox->addWidget( lUnSent );

	lUnAck = new QLabel( this );
   lUnAck->setText( "UnAck: 0" );
   lUnAck->setFixedSize( lUnAck->sizeHint() );
	hbox->addWidget( lUnAck );

	lRetry = new QLabel( this );
   lRetry->setText( "Retry: 0" );
   lRetry->setFixedSize( lRetry->sizeHint() );
	hbox->addWidget( lRetry );

	lStat = new QLabel( this );
   lStat->setText( "IXF " );
   lStat->setFixedSize( lStat->sizeHint() );
	hbox->addWidget( lStat );

	lName = new QLabel( this );
   lName->setText( "" );
   lName->setFixedSize( lName->sizeHint() );
	hbox->addWidget( lName );


/*	lStat = new QLabel( this );
   lStat->setText( "XXXXXXX" );
   lStat->setFixedSize( lStat->sizeHint() );
   hbox->addWidget( lStat );*/


/*   lUnSent->setText( "UnSent: 0" );
   lUnAck->setText( "UnAck: 0" );
   lRetry->setText( "Retry: 0" );
   lName->setText( "" );*/
   hbox->addStretch( 1 );
}
//---------------------------------------------------------------------------
InfoBar::~InfoBar()
{
}
//---------------------------------------------------------------------------
void InfoBar::setUnSent( int i )
{
   QString str;

   str.sprintf( "UnSent: %i", i );
	lUnSent->setText( str );
   lUnSent->setFixedSize( lUnSent->sizeHint() );
}
//---------------------------------------------------------------------------
void InfoBar::setUnAck( int i )
{
   QString str;

   str.sprintf( "UnAck: %i", i );
	lUnAck->setText( str );
   lUnAck->setFixedSize( lUnAck->sizeHint() );
}
//---------------------------------------------------------------------------
void InfoBar::setRetry( int i )
{
   QString str;

   str.sprintf( "Retry: %i", i );
	lRetry->setText( str );
   lRetry->setFixedSize( lRetry->sizeHint() );
}
//---------------------------------------------------------------------------
void InfoBar::setStat( int i )
{
	lStat->setText( TNC_Status[i] );
   lStat->setFixedSize( lStat->sizeHint() );
}
//---------------------------------------------------------------------------
void InfoBar::setName( const QString & name )
{
   if (name.isEmpty())
		lName->setText( "" );
	else
		lName->setText( name );
   lName->setFixedSize( lName->sizeHint() );
}
//---------------------------------------------------------------------------

