/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
//---------------------------------------------------------------------------
#ifndef AX25K_H
#define AX25K_H
//---------------------------------------------------------------------------
#include <qsocketnotifier.h>
//---------------------------------------------------------------------------
// Maximal 15 Ports sind moeglich. Dieser Wert wird fuer verschiedene
// Arrays gebraucht. Es kommt (noch) keine Fehlermeldung, wenn die Zahl
// ueberschritten wird.
#define AX25_MAXPORTS 15
//---------------------------------------------------------------------------
// In dieser Struktur merken wir uns die Rufzeichen (mit file-descriptoren
// etc), auf die gelauscht werden.
typedef struct _s_listento
{
   struct _s_listento *next;
   char call[10];
   QSocketNotifier *sockrx;
   int txfd;
} s_listento;
//---------------------------------------------------------------------------
typedef struct
{
   int window;
   int polltime;
   int acktime;
   int timeout;
   int packetlength;
   int retries;
} s_protokollparameter;
//---------------------------------------------------------------------------
//  class AX25
// Ansteuerungs-Routinen fuer einen Port
class AX25 : QObject
{
   Q_OBJECT;
public:
   AX25(char *name, char *desc, char *dev, int baud, char *addr);
	~AX25();

   void listenToCall(const char *call);
   void deleteListenTo( const char *call );
   int makeConnect( char *call, char *digis, char *mycall, char *port, int *error );

   int getMaxframe();
   int getTxfd(char *mycall);

public slots:
   void rxFrame(int socket);

private:
   char *info_name;
   char *info_desc;
   char *info_dev;
   int info_baud;
   char *info_addr;
   s_listento *listento;

   bool disconnectCall(char *call);

   int maxframe;
};
//---------------------------------------------------------------------------
typedef struct _s_ports
{
   struct _s_ports *next;
   char *name;
   char *desc;
   char *dev;
   int baud;
   char *addr;
   AX25 *ax25;
   int maxframe;
   int umschalten;

   s_protokollparameter parameter;
} s_ports;
//---------------------------------------------------------------------------
extern s_ports *portlist;
//---------------------------------------------------------------------------
class ax25_polling : QObject
{
   Q_OBJECT;
public:
   ax25_polling();
   ~ax25_polling();
private:
   QTimer *timer;

   bool just_polling;
public slots:
   void poll();
};
//---------------------------------------------------------------------------
//   void init_ax25()
//
// Laed die Port-Informationen aus dem Kernel-AX25 in die Port-Liste.
void init_ax25();
//---------------------------------------------------------------------------
//   void add_ax25_port( s_ports *port );
//
// Ein AX.25-Port wird aktiviert
void activate_ax25_port( s_ports *port );
//---------------------------------------------------------------------------
//   void deactivate_ax25_port( s_ports *port )
//
// Deaktiviert den angegebenen AX25-Port
void deactivate_ax25_port( s_ports *port );
//---------------------------------------------------------------------------
#endif /* AX25K_H */
//---------------------------------------------------------------------------

