// Locator.hpp - Abbildung eines Locators als C++-Klasse
// Written by Stefan Pfeiffer, DL1ELY

#include <string>
#include <math.h>
#include <string.h>

#ifndef _LOCATOR_HPP

#define _LOCATOR_HPP

class Locator
{
  public:
	
	  enum { LOC_COMPLETE, LOC_PREFIXMISSING, LOC_SUFFIXMISSING, LOC_INVALID };
	
  private:

	  // "JO31IO", "JO31K" or "JO31"
	  string pv_locator;
	
	  /*
	     JO31IO -> LOC_COMPLETE
	     31IO -> LOC_PREFIXMISSING, can be calculated by country
	     JO31 or JO31I -> LOC_SUFFIXMISSING, will return 31LL/IL (Middle)
	     Empty or AA99ZZ -> LOC_INVALID
	  */
	  int pv_state;
	
	  // Geographical coordinates of the locator
	  double pv_north;
	  double pv_east;
	
	
	  void m_stringLocator2Coordinates();
	  static double m_degreeSin(const double degrees);
	  static double m_degreeCos(const double degrees);
	  static double m_degreeArcCos(const double degrees);
	  
  public:
	  // Defaultkonstruktur
	  Locator();
	  
	  // Konstruktor mit String Locator("JO31IO")
	  Locator(const string& a_loc);
	
	  // Konstruktor mit char* Locator
	  Locator(const char* a_loc);
	
	  // Kopierkonstruktor
	  Locator(const Locator& a_loc);

     // DG6VJ: Direktes setzen der Position (ohne Locator)
     Locator(const double north, const double east);


	  // Destruktor, obsolet
	  ~Locator();
	  	  
      // Setzen des Locators
	  void m_set(const string& a_loc);
	 		
	  // Abfragen des Locators	   
	  string m_getLocator() const;
	
	  // Abfragen der Nord-Koordinate	
	  double m_getNorth() const;
		
	  // Abfragen der Ost-Koordinate
	  double m_getEast() const;
	
	  // Abfrage des Locator-Status
	  int m_getState() const;
	
	  // Entfernung vom Locator zum gegebenen Locator
	  double m_getDistanceTo(const Locator& a_loc) const;
	  
	  // Richtung vom Locator zum gegebenen Locator
	  double m_getDirectionTo(const Locator& a_loc) const;
	  
	  // Liefert "JO31LL", wenn Locator "JO31" ist.
	  string m_getCompletedLocator() const;
	  
	  // Liefert TRUE, wenn der Locator komplett (6 Zeichen lang) ist.
	  bool m_isCompleteLocator() const;
	
	  // Liefert TRUE, wenn beim Locator nur das Ende fehlt.
	  bool m_isExpandableLocator() const;
};

#endif

