/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef INTERFACE_H
#define INTERFACE_H


#include <qobject.h>
#include <qsocketnotifier.h>
#include <qlist.h>


#define IBLOCK_CONNECT 1
#define IBLOCK_DATA 2
#define IBLOCK_DISC 3
#define IBLOCK_ERROR 4


// In dieser Struktur werden die Interface-Frames vom Sammler zur
// Auswerteroutine uebergeben
typedef struct
{
   unsigned char id;
   char *data;
   unsigned short len;
} s_ifaceframe;


// In dieser Struktur werden die Daten vom Clienten an LinKT uebergeben,
// die fuer einen Connect nach Aussen noetig sind.
typedef struct
{
   char call[10];          // Rufzeichen; *muss* im Router bekannt sein
} s_ifaceconnect;


class Interface : public QObject
{
   Q_OBJECT;
public:
   Interface(int _fd);
   ~Interface();

public slots:
   void rxData(int);

private:
   int fd;
   QSocketNotifier *sock;
   int rxlen;
   char *rxsave;

   void SendFrame(unsigned char frameid, char *data, unsigned short len);
   void FrameReady(s_ifaceframe *frame);
   void makeConnect(s_ifaceframe *frame);
};


class InterfaceVerwaltung : public QObject
{
   Q_OBJECT;
public:
   InterfaceVerwaltung();
   ~InterfaceVerwaltung();

public slots:
   void connectionGot(int);

private:
   int fd;
   QList<Interface> *connections;

   QSocketNotifier *sock;
};


#endif /* INTERFACE_H */
