/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-2000 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifndef CHANNEL_H
#define CHANNEL_H

//#include <drag.h>
#include "bin.h"

#include <qwidget.h>
#include <qobject.h>
#include <qdialog.h>
#include <qsocketnotifier.h>
#include <qevent.h>
#include <qpopupmenu.h>
#include <qtimer.h>
#include <qaccel.h>
#include <qlist.h>
#include <qsplitter.h>

#include "output.h"
#include "vorschreib.h"
#include "remote.h"
#include "flags.h"
#include "userinfo.h"
#include "passwords.h"
#include "didadit.h"
#include "interface.h"
#include "boxcheck.h"
#include "yapp.h"
#include "ahuf.h"
#include "buttonbar.h"

#include <ktmainwindow.h>
#include <ktopwidget.h>
#include <ktoolbar.h>

#include <time.h>



// KStatusBar-Felder
#define ID_STATUS_UNSENT 1
#define ID_STATUS_UNACK 2
#define ID_STATUS_RETRY 3
#define ID_STATUS_STATE 4
#define ID_STATUS_FLAGS 5
#define ID_GENERAL 6




#define SENDQ_TEXT 1            // Eine Textzeile
#define SENDQ_FILE 2            // Ein Binaer-File (1:1 senden)
#define SENDQ_TEXTFILE 3        // Ein Textfile (Zeilenenden wandeln)
#define SENDQ_DIDADIT 4         // Ein File mittels DIDADIT
#define SENDQ_YAPP 5            // Ein File mittels YAPP

#define COMP_FLAG 0
#define COMP_SP 1
#define COMP_HUF 2
#define COMP_NO 3

typedef struct _s_sendqueue
{
   struct _s_sendqueue *next;
   int len;
   char *data;
   bool show;
   bool abin;
   int comp;      // COMP_FLAG (0) = Siehe die entsprechenden Flags,
                  // COMP_SP   (1) = Soll komprimiert werden (//COMP),
                  // COMP_HUF  (2) = Soll komprimiert werden (#HUF#),
                  // COMP_NO   (3) = Soll nicht komprimiert werden
   int type;
   bool ready;

   // Infos fuer Dateien
   //   Der Dateiname steht in char *data drin.
   int fd;
} s_sendqueue;


typedef struct _s_conncalls
{
  struct _s_conncalls *next;
  char call[10];
} s_conncalls;


class Channel : public QDialog
{
   Q_OBJECT;
public:
   // Konstruktor fuer ankommende Connects von aussen
   Channel( QWidget *parent, char *port, char *mycall, char *call, char *digis, int fd, bool connected );
   ~Channel();

   void makeNewConnect( char *port, char *mycall, char *call, char *digis, int fd );

   void resizeEvent(QResizeEvent *event);

   // Funktionen, um private Variablen zurueckzugeben
   char * getCall();
   char * getMycall();
   char * getPort();
   void discStn();
   void discStnAuto();
   void closeQSOWindow();
   void reallyDisconnect();
   bool validCallsign(char */*call*/);
   int getFlags();
   int getTxfd();
   QWidget * getVorschreibPtr();
   QWidget *pannerHome;

   // Funktionen, ueber die das Kernel-AX.25-Interface die Verbindungs-
   // Daten setzt
   void setUnack(int value);
   void setSQueue(int value);
   void setTries(int value);
   void setStatus(int value);

   void sendStringComp(int len, const char *data, bool show, int comp);
   void sendString(int len, const char *data, bool show);
   void sendString( const char *data );
	void sendStringNow( int len, const char *data, bool show );
   void sendDidadit();
   void sendYAPP();
   void sendMacrofile( char *filename );
   void macroLine(char *dest, char *src);
   void sendFile( char *filename, bool show, bool abin);
   void sendTextFile( char *filename, bool show);
   void updateFont();
	void updateWindowPos();
	void updateButtonbar();
   void setIfaceConnection(Interface *i);
   void abortDIDADIT();
   void abortYAPP();
   void abortABinTX();
   void getCookie(char *str);
   void updateBoxcheckCfg();
   void updateStatusBar();
   void updateStatusBar( const char *str );
   void enableBoxcheckMenu();
   void statusConnectGot();
   bool isConnected();
	void updateBCSize();

   void withTransInfo( QWidget *win );
   void withoutTransInfo();

   void outText( char *text, int len, int color );

   UserInfo *userinfo;

   int flags;

private:
   QSplitter *panner;
   KStatusBar *statusbar;
   QPopupMenu *kontextmenu, *kontextvorschr, *tbFileSend;
   int mnu_textfile, mnu_sendabin, mnu_didadit, mnu_yapp, mnu_boxcheck;
   int mnu_sendabin_btn, mnu_didadit_btn, mnu_yapp_btn;
   KToolBar *toolbar;
   void setupToolbar();
   ButtonBar *buttonbar;

   myVorschreib *vorschreib;
   OutputWidget *output;
   Interface *iface;

   BoxCheck *boxcheck;
   RemoteCmds *remote;
   auto7plus *auto7;
   BinRX *binrx;
   BinTX *bintx;
   DIDADIT *didadit;
   YAPP *yapp;
   AHUF *ahuf;
   Passwords *password;
   int filerx_fd;
   bool closeWinDisc;
   QWidget *transferDlg;

   QTimer *timer;
   QList<QAccel> *accels;

   // Daten ueber die Verbindung
   char *data_firstcall;
   char *data_call;
   char *data_mycall;
   time_t data_logintime;
   char *data_port;
   char *data_digis;
   long bytesRX;
   long bytesTX;
   int maxframe;

   // Kommunikation
   QSocketNotifier *sockrx;
   int txfd;
   void sendFrame( char *str, int len, int comp );
   void sendqueueSendTextLine();
   void sendqueueSendFile( bool textfile );
   void sendqueueDidadit();
   void sendqueueYAPP();
	int getMaxframe( const char *port );

   // Sendqueue
   s_sendqueue *sendqueue;
   bool send_error;
   void deleteQueueEntry();

   s_conncalls *conncalls;

   // Kanal-Parameter
   int framesize;
   int old_status;
   int squeue;

   int typeCheckLine;

   // Wurde diese Verbindung von einem externen Programm aufgebaut?
   bool externalConnection;

   char *save_text;
   int save_text_len;
   int save_text_showed;
   int len_allready_showed;

   void showConnectMessage(char *port, char *call, char *digis);
   void showDisconnectMessage(char *port, char *call, char *digis);
   void showConnFailedMessage( char *port, char *call );
   void work_with_frame(char *neu_str, int neu_str_len);
   void sendCText();
   void send_a_frame();
   void logBookEntry();
   void checkForHUF(char *data, int len);
   void insertBINChatLine( char *text, bool out );
   void updateColors();
	void resizeChannelWin();

   void connCallAdd(char *call);
   bool connCallCheck(char *call);

   void checkConnectedTo(char *call);
   void checkReconnectedTo(char *call);
   void checkSwType(char *line);
   void checkSIDFlags( char *line );

   void checkPi1chlConnect(char *data);
   void checkTNNConnect(char *data);
   void checkTNNReconnect(char *data);

   int pollStatus();

public slots:
   void slotTimer();
   void rxFrame(int socket);
   void returnPressedGot();
   void settings();
   void slotSendFile();
   void slotSend7plus();
   void slotSendDIDADIT();
   void showKontextMenu();
   void showKontextVorschrMenu();
   void slotSendQuoted();
   void slotInsertQuoted();
   void slotSaveText();
   void slotSendAbinFile();
   void slotCTRLKeyUp();
   void slotCTRLKeyDown();
   void slotSendPW();
   void slotAway();
   void activateCheckWin();
   void slotHufComp();
   void slotYAPP();
   void slotBtnFileSend();

   void newConnect();
   void discStation();

//   void slotDropEvent( KDNDDropZone *zone );

protected:
   void closeEvent(QCloseEvent *e);
};


#endif /* CHANNEL_H */

