/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef BIN_H
#define BIN_H

#include <qwidget.h>
#include <qobject.h>
#include <time.h>
#include "dialog.h"


class auto7plus
{
public:
   auto7plus( QWidget *rxchan );
   ~auto7plus();

   void proceed( const char *data, int len );
   bool isRxfile();

   void saveLine( char *str, int len );
   void lookForLine( char *str, int len );
   void closeTransferwin();

   void abortRX();

private:
   QWidget *chan;
   int fd;
   char name[500];
   char shortname[100];
   int filelen;
   int bytes_got;
   time_t starttime;

   bool rxfile;         // true, wenn gerade ein File empfangen wird
   bool textfile;

   TransferWin *win;
   TransferInfo *transInfo;
   bool extraTransferWin;
};


class BinRX
{
public:
   BinRX( QWidget *rxchan );
   ~BinRX();

   int proceed( const char *data, int len );
   void closeTransferwin();
   void deleteDataFile();

   bool isRxfile();
   void abortRX();

private:
   void lookForLine( char *line, int len );
   int saveFrame(char *line, int len);

   QWidget *chan;
   bool rxfile;

   unsigned short crc;
   unsigned short our_crc;
   bool crc_rec;

   unsigned long rxtime;
   char *filename;
   char *shortname;
   int fd;
   time_t starttime;

   long size;               // Groesse des Files (aus dem #BIN# - Header)
   long size_written;       // Soviele Bytes wurden bislang schon geschrieben

   TransferWin *win;
   TransferInfo *transInfo;
   bool extraTransferWin;
   bool extraTransferWinSet;
};


class BinTX
{
public:
   BinTX( QWidget *txchan, char *fname );
   ~BinTX();

   int check_okno( const char *data, int len );
   void createTransferWin();
   void updateTransferWin( int received_bytes );
   void showEndText();
   char * getFilename();
   void closeTransferwin();

   int bin_state;

private:
   QWidget *chan;

   char *longname;
   char *shortname;

   long size;
   long size_tx;
   unsigned short crc;
   unsigned long fulldostime;
   time_t starttime;

   TransferWin *win;
   TransferInfo *transInfo;
   bool extraTransferWin;
   int wascomp;				// 0 = keine kompression, 1 = //COMP, 2 = #HUF#
};



#endif /* BIN_H */

