/*
 *  MonKT - a monitor for LinKT
 *  Copyright (C) 1998-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "preferences.h"
#include "global.h"
#include "toolbox.h"

#include <qlabel.h>
#include <qbuttongroup.h>

#include <kapp.h>



#define BTNLENGTH 80
#define BTNHEIGHT 25
#define ABSTAND_UNTEN 5



extern KApplication *mykapp;



//   DlgColor::DlgColor() : QDialog(0, "", true)
//
// Konstruktur - ein modaler Dialog
DlgColor::DlgColor() : QDialog(0, "", true)
{
   setCaption(klocale->translate("MonKT: Colors"));

   resize(330,350);

   setupWindow();

   setStandard();
}


DlgColor::~DlgColor()
{
   delete desc;
   delete colors;
   delete ok;
   delete abort;
}


void DlgColor::setupWindow()
{
   desc = new QListBox( this );
   desc->setGeometry( 5, 5, 150, 250 );
   connect(desc, SIGNAL(highlighted(int)), this, SLOT(slotChangeField(int)));

   colors = new QListBox( this );
   colors->setGeometry( 175, 5, 150, 250 );
   connect(colors, SIGNAL(highlighted(int)), this, SLOT(slotChangeColor(int)));


   // Eintraege in die Desc- und die Colors-Liste
   desc->insertItem( klocale->translate("Background Monitor") );
   desc->insertItem( klocale->translate("Error") );
   desc->insertItem( klocale->translate("Port") );
   desc->insertItem( klocale->translate("Kiss") );
   desc->insertItem( klocale->translate("BPQ") );
   desc->insertItem( klocale->translate("Data") );
   desc->insertItem( klocale->translate("Protocol") );
   desc->insertItem( klocale->translate("AX25-Header") );
   desc->insertItem( klocale->translate("Address") );
   desc->insertItem( klocale->translate("IP-Header") );
   desc->insertItem( klocale->translate("TCP-Header") );
   desc->insertItem( klocale->translate("Rose-Header") );
   desc->insertItem( klocale->translate("Timestamp") );
   desc->insertItem( klocale->translate("Flexnet") );
   desc->insertItem( klocale->translate("Zierrat") );
   desc->insertItem( klocale->translate("Call") );
   desc->insertItem( klocale->translate("FromCall") );
   desc->insertItem( klocale->translate("ToCall") );
   desc->insertItem( klocale->translate("ViaCall") );
   desc->insertItem( klocale->translate("Hdr-Val") );
   desc->insertItem( klocale->translate("Mark-Color") );
   desc->insertItem( klocale->translate("Mark-Background") );
   desc->insertItem( klocale->translate("QSO-Spy-Color 1") );
   desc->insertItem( klocale->translate("QSO-Spy-Color 2") );
   desc->insertItem( klocale->translate("QSO-Spy-Status-Color") );


   colors->insertItem( klocale->translate("black") );
   colors->insertItem( klocale->translate("white") );
   colors->insertItem( klocale->translate("dark-gray") );
   colors->insertItem( klocale->translate("gray") );
   colors->insertItem( klocale->translate("light-gray") );
   colors->insertItem( klocale->translate("red") );
   colors->insertItem( klocale->translate("green") );
   colors->insertItem( klocale->translate("blue") );
   colors->insertItem( klocale->translate("cyan") );
   colors->insertItem( klocale->translate("magenta") );
   colors->insertItem( klocale->translate("yellow") );
   colors->insertItem( klocale->translate("dark-red") );
   colors->insertItem( klocale->translate("dark-green") );
   colors->insertItem( klocale->translate("dark-blue") );
   colors->insertItem( klocale->translate("dark-cyan") );
   colors->insertItem( klocale->translate("dark-magenta") );
   colors->insertItem( klocale->translate("dark-yellow") );


   hdrbold = new QCheckBox( this );
   hdrbold->setGeometry(10, 265, 250, 20);
   hdrbold->setText( klocale->translate("AX.25-Header bold?") );

   markbold = new QCheckBox( this );
   markbold->setGeometry(10, 285, 250, 20);
   markbold->setText( klocale->translate("Marked text bold?") );


   // OK- und Abbruch-Knopf
   int abstand = (width()-(2*BTNLENGTH))/3;
   ok = new QPushButton( this );
   ok->setText( klocale->translate("&Ok") );
   ok->setGeometry(abstand, height()-BTNHEIGHT-ABSTAND_UNTEN, BTNLENGTH, BTNHEIGHT);
   ok->setDefault( true );
   connect(ok, SIGNAL(clicked()), this, SLOT(slotOkPressed()));
   ok->setDefault(true);

   abort = new QPushButton( this );
   abort->setText( klocale->translate ("&Abort") );
   abort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-ABSTAND_UNTEN, BTNLENGTH, BTNHEIGHT);
   connect(abort, SIGNAL(clicked()), this, SLOT(reject()));
}


void DlgColor::setStandard()
{
   changedColors[0] = config->colors->background;
   changedColors[1] = config->colors->colorError;
   changedColors[2] = config->colors->colorPort;
   changedColors[3] = config->colors->colorKiss;
   changedColors[4] = config->colors->colorBpq;
   changedColors[5] = config->colors->colorData;
   changedColors[6] = config->colors->colorProtocol;
   changedColors[7] = config->colors->colorAxhdr;
   changedColors[8] = config->colors->colorAddr;
   changedColors[9] = config->colors->colorIphdr;
   changedColors[10] = config->colors->colorTcphdr;
   changedColors[11] = config->colors->colorRosehdr;
   changedColors[12] = config->colors->colorTimestamp;
   changedColors[13] = config->colors->colorFlexnet,
   changedColors[14] = config->colors->colorZierrat;
   changedColors[15] = config->colors->colorCall;
   changedColors[16] = config->colors->colorFmCall;
   changedColors[17] = config->colors->colorToCall;
   changedColors[18] = config->colors->colorViaCall;
   changedColors[19] = config->colors->colorHdrVal;
   changedColors[20] = config->colors->qsoWinMarkColor;
   changedColors[21] = config->colors->qsoWinMarkBack;
   changedColors[22] = config->colors->spyColor1;
   changedColors[23] = config->colors->spyColor2;
   changedColors[24] = config->colors->spyColorStatus;

   if (config->colors->mark_bold) markbold->setChecked( true );
   if (config->colors->boldHeader) hdrbold->setChecked( true );
}


void DlgColor::slotChangeField(int index)
{
   colors->setCurrentItem(changedColors[index]);
}


void DlgColor::slotChangeColor(int index)
{
   changedColors[desc->currentItem()] = index;
}


void DlgColor::slotOkPressed()
{
   saveData();
   close();
}


void DlgColor::saveData()
{
   KConfig *kconfig;
   char tmp[100];


   kconfig = mykapp->getConfig();

   kconfig->setGroup( "Colors" );

   config->colors->background = changedColors[0];
   sprintf(tmp, "%i", config->colors->background);
   kconfig->writeEntry("background", tmp);

   config->colors->colorError = changedColors[1];
   sprintf(tmp, "%i", config->colors->colorError);
   kconfig->writeEntry("error", tmp);

   config->colors->colorPort = changedColors[2];
   sprintf(tmp, "%i", config->colors->colorPort);
   kconfig->writeEntry("port", tmp);

   config->colors->colorKiss = changedColors[3];
   sprintf(tmp, "%i", config->colors->colorKiss);
   kconfig->writeEntry("kiss", tmp);

   config->colors->colorBpq = changedColors[4];
   sprintf(tmp, "%i", config->colors->colorBpq);
   kconfig->writeEntry("bpq", tmp);

   config->colors->colorData = changedColors[5];
   sprintf(tmp, "%i", config->colors->colorData);
   kconfig->writeEntry("data", tmp);

   config->colors->colorProtocol = changedColors[6];
   sprintf(tmp, "%i", config->colors->colorProtocol);
   kconfig->writeEntry("protocol", tmp);

   config->colors->colorAxhdr = changedColors[7];
   sprintf(tmp, "%i", config->colors->colorAxhdr);
   kconfig->writeEntry("ax25-hdr", tmp);

   config->colors->colorAddr = changedColors[8];
   sprintf(tmp, "%i", config->colors->colorAddr);
   kconfig->writeEntry("address", tmp);

   config->colors->colorIphdr = changedColors[9];
   sprintf(tmp, "%i", config->colors->colorIphdr);
   kconfig->writeEntry("ip-hdr", tmp);

   config->colors->colorTcphdr = changedColors[10];
   sprintf(tmp, "%i", config->colors->colorTcphdr);
   kconfig->writeEntry("tcp-hdr", tmp);

   config->colors->colorRosehdr = changedColors[11];
   sprintf(tmp, "%i", config->colors->colorRosehdr);
   kconfig->writeEntry("rose-hdr", tmp);

   config->colors->colorTimestamp = changedColors[12];
   sprintf(tmp, "%i", config->colors->colorTimestamp);
   kconfig->writeEntry("timestamp", tmp);

   config->colors->colorFlexnet = changedColors[13];
   sprintf(tmp, "%i", config->colors->colorFlexnet);
   kconfig->writeEntry("flexnet", tmp);

   config->colors->colorZierrat = changedColors[14];
   sprintf(tmp, "%i", config->colors->colorZierrat);
   kconfig->writeEntry("zierrat", tmp);

   config->colors->colorCall = changedColors[15];
   sprintf(tmp, "%i", config->colors->colorCall);
   kconfig->writeEntry("call", tmp);

   config->colors->colorFmCall = changedColors[16];
   sprintf(tmp, "%i", config->colors->colorFmCall);
   kconfig->writeEntry("fm-call", tmp);

   config->colors->colorToCall = changedColors[17];
   sprintf(tmp, "%i", config->colors->colorToCall);
   kconfig->writeEntry("to-call", tmp);

   config->colors->colorViaCall = changedColors[18];
   sprintf(tmp, "%i", config->colors->colorViaCall);
   kconfig->writeEntry("via-call", tmp);

   config->colors->colorHdrVal = changedColors[19];
   sprintf(tmp, "%i", config->colors->colorHdrVal);
   kconfig->writeEntry("hdr-val", tmp);

   config->colors->qsoWinMarkColor = changedColors[20];
   sprintf(tmp, "%i", config->colors->qsoWinMarkColor);
   kconfig->writeEntry("winMarkColor", tmp);

   config->colors->qsoWinMarkBack = changedColors[21];
   sprintf(tmp, "%i", config->colors->qsoWinMarkBack);
   kconfig->writeEntry("winMarkBack", tmp);

   config->colors->spyColor1 = changedColors[22];
   sprintf(tmp, "%i", config->colors->spyColor1);
   kconfig->writeEntry("spyColor1", tmp);

   config->colors->spyColor2 = changedColors[23];
   sprintf(tmp, "%i", config->colors->spyColor2);
   kconfig->writeEntry("spyColor2", tmp);

   config->colors->spyColorStatus = changedColors[24];
   sprintf(tmp, "%i", config->colors->spyColorStatus);
   kconfig->writeEntry("spyColorStatus", tmp);

   if (markbold->isChecked())
   {
      kconfig->writeEntry("winMarkBold","1");
      config->colors->mark_bold = true;
   }
   else
   {
      kconfig->writeEntry("winMarkBold","0");
      config->colors->mark_bold = false;
   }

   if (hdrbold->isChecked())
   {
      kconfig->writeEntry("bold-header","1");
      config->colors->boldHeader = true;
   }
   else
   {
      kconfig->writeEntry("bold-header","0");
      config->colors->boldHeader = false;
   }


   kconfig->sync();
}


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


DlgDX::DlgDX() : QDialog(0, "", true)
{
   setCaption(klocale->translate("MonKT: Colors"));

   resize(330,350);

   setupWindow();
   setStandard();
}


DlgDX::~DlgDX()
{
   delete act;

   delete lGrad;
   delete lMin;
   delete lSec;
   delete bGrad;
   delete bMin;
   delete bSec;

   delete buttongroup;

   delete ok;
   delete abort;
}


void DlgDX::setupWindow()
{

   act = new QCheckBox( this );
   act->setText(klocale->translate("activate dx-cluster-spy?"));
   act->setGeometry( 10, 10, 300, 20 );
   connect( act, SIGNAL(toggled(bool)), SLOT(slotActToggled(bool)) );


   // Position
   buttongroup = new QButtonGroup( this );
   buttongroup->setGeometry( 10, 40, 140, 115 );
   buttongroup->setTitle( klocale->translate( "Position"));
   buttongroup->setFrameStyle( 49 );
   buttongroup->setAlignment( 1 );
   buttongroup->lower();


   QLabel* label;
   label = new QLabel( buttongroup );
   label->setGeometry( 10, 20, 100, 20 );
   label->setText( klocale->translate("latitude") );

   label = new QLabel( buttongroup );
   label->setGeometry( 10, 65, 100, 20 );
   label->setText( klocale->translate("longitude") );

   lGrad = new QLineEdit( buttongroup );
   lGrad->setGeometry( 10, 40, 30, 20 );
   lGrad->setMaxLength(3);
   label = new QLabel( buttongroup );
   label->setGeometry( 42, 38, 10, 20 );
   label->setText( "" );

   lMin = new QLineEdit( buttongroup );
   lMin->setGeometry( 50, 40, 25, 20 );
   lMin->setMaxLength(2);
   label = new QLabel( buttongroup );
   label->setGeometry( 77, 38, 10, 20 );
   label->setText( "'" );

   lSec = new QLineEdit( buttongroup );
   lSec->setGeometry( 85, 40, 25, 20 );
   lSec->setMaxLength(2);
   label = new QLabel( buttongroup );
   label->setGeometry( 112, 38, 10, 20 );
   label->setText( "''" );


   bGrad = new QLineEdit( buttongroup );
   bGrad->setGeometry( 10, 85, 30, 20 );
   bGrad->setMaxLength(3);
   label = new QLabel( buttongroup );
   label->setGeometry( 42, 83, 10, 20 );
   label->setText( "" );

   bMin = new QLineEdit( buttongroup );
   bMin->setGeometry( 50, 85, 25, 20 );
   bMin->setMaxLength(2);
   label = new QLabel( buttongroup );
   label->setGeometry( 77, 83, 10, 20 );
   label->setText( "'" );

   bSec = new QLineEdit( buttongroup );
   bSec->setGeometry( 85, 85, 25, 20 );
   bSec->setMaxLength(2);
   label = new QLabel( buttongroup );
   label->setGeometry( 112, 83, 10, 20 );
   label->setText( "''" );

   label = new QLabel( this );
   label->setGeometry( 10, 170, 250, 20 );
   label->setText( klocale->translate("Position DX-data-file") );
   dxdata = new QLineEdit( this );
   dxdata->setGeometry( 10, 190, 250, 20 );


   // OK- und Abbruch-Knopf
   int abstand = (width()-(2*BTNLENGTH))/3;
   ok = new QPushButton( this );
   ok->setText( klocale->translate("&Ok") );
   ok->setGeometry(abstand, height()-BTNHEIGHT-ABSTAND_UNTEN, BTNLENGTH, BTNHEIGHT);
   ok->setDefault( true );
   connect(ok, SIGNAL(clicked()), this, SLOT(slotOkPressed()));
   ok->setDefault(true);

   abort = new QPushButton( this );
   abort->setText( klocale->translate ("&Abort") );
   abort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-ABSTAND_UNTEN, BTNLENGTH, BTNHEIGHT);
   connect(abort, SIGNAL(clicked()), this, SLOT(reject()));
}


void DlgDX::setStandard()
{
   long lat, lon;
   char tmp[100];


   // Variablen besetzen
   act->setChecked( config->dxclusterspy );
   slotActToggled( config->dxclusterspy );


   lat = config->mylatitude;
   lon = config->mylongitude;

   if (lat < 0)
   {
      lat = abs(lat);
      sprintf(tmp, "-%li", lat/3600);
   }
   else
      sprintf(tmp, "%li", lat/3600);
   bGrad->setText(tmp);
   lat %= 3600;


   sprintf(tmp, "%li", lat/60);
   bMin->setText(tmp);
   lat %= 60;

   sprintf(tmp, "%li", lat);
   bSec->setText(tmp);


   if (lon < 0)
   {
      lon = abs(lon);
      sprintf(tmp, "-%li", lon/3600);
   }
   else
      sprintf(tmp, "%li", lon/3600);
   lGrad->setText(tmp);
   lon %= 3600;

   sprintf(tmp, "%li", lon/60);
   lMin->setText(tmp);
   lon %= 60;

   sprintf(tmp, "%li", lon);
   lSec->setText(tmp);


   dxdata->setText( config->dxdata_file );
}


void DlgDX::slotOkPressed()
{
   KConfig *kconfig;
   int grad, min, sec;
   char tmp[100];



   kconfig = mykapp->getConfig();

   kconfig->setGroup( "DX-Cluster-Spy" );
   if (act->isChecked())
   {
      config->dxclusterspy = true;
      kconfig->writeEntry("active", "1");
   }
   else
   {
      config->dxclusterspy = false;
      kconfig->writeEntry("active", "0");
   }


   // Position abspeichern
   grad = atoi( lGrad->text() );
   min = atoi( lMin->text() );
   sec = atoi( lSec->text() );
   if (grad < 0)
      config->mylongitude = -(abs(grad) * 3600L + min * 60L + sec);
   else
      config->mylongitude = grad * 3600L + min * 60L + sec;
   sprintf(tmp, "%li", config->mylongitude);
   kconfig->writeEntry("mylongitude", tmp);

   grad = atoi( bGrad->text() );
   min = atoi( bMin->text() );
   sec = atoi( bSec->text() );
   if (grad < 0)
      config->mylatitude = -(abs(grad) * 3600L + min * 60L + sec);
   else
      config->mylatitude = grad * 3600L + min * 60L + sec;
   sprintf(tmp, "%li", config->mylatitude);
   kconfig->writeEntry("mylatitude", tmp);


   // dxc.dat - File
   // Nur, wenn der Text geaendert wurde
   if (strcmp(dxdata->text(), config->dxdata_file))
   {
      if (config->dxdata_file != NULL)
         free(config->dxdata_file);
      config->dxdata_file = (char *) strdup(dxdata->text());
      kconfig->writeEntry("dxdata_file", config->dxdata_file);
   }


   kconfig->sync();

   accept();
}


void DlgDX::slotActToggled( bool active )
{
   lGrad->setEnabled( active );
   lMin->setEnabled( active );
   lSec->setEnabled( active );
   bGrad->setEnabled( active );
   bMin->setEnabled( active );
   bSec->setEnabled( active );

   dxdata->setEnabled( active );
}


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////


DlgQSOSpy::DlgQSOSpy() : QTabDialog( 0, "", true)
{
   setCaption(klocale->translate("MonKT: QSO-Spy"));

   setupWindowGeneral();
   addTab(winGeneral, klocale->translate("&General"));

   setupWindowSpy();
   addTab(winSpy, klocale->translate("&Spy"));

   setupWindowIgnore();
   addTab(winIgnore, klocale->translate("&Ignore"));

   setStandard();
   setFixedSize( 270, 280);

   setCancelButton();
   connect( this, SIGNAL(applyButtonPressed()), SLOT(slotOkPressed()));
}


DlgQSOSpy::~DlgQSOSpy()
{
   delete act;

   delete winGeneral;
   delete winSpy;
}


void DlgQSOSpy::setupWindowGeneral()
{
   winGeneral = new QWidget( this );

   act = new QCheckBox( winGeneral );
   act->setText(klocale->translate("activate qso-spy?"));
   act->setGeometry( 20, 50, 300, 20 );
   connect( act, SIGNAL(toggled(bool)), this, SLOT(slotEnabled(bool)) );
}


void DlgQSOSpy::setupWindowSpy()
{
   winSpy = new QWidget( this );


   QButtonGroup *buttongroup = new QButtonGroup( winSpy );
   buttongroup->setGeometry( 10, 10, 230, 160 );
   buttongroup->setFrameStyle( QButtonGroup::NoFrame );

   spyAll = new QRadioButton( buttongroup );
   spyAll->setText( klocale->translate("spy everything"));
   spyAll->setGeometry( 10, 10, 200, 20 );
   buttongroup->insert( spyAll );

   spyNothing = new QRadioButton( buttongroup );
   spyNothing->setText( klocale->translate("spy nothing"));
   spyNothing->setGeometry( 10, 30, 200, 20 );
   buttongroup->insert( spyNothing );

   spyFollow = new QRadioButton( buttongroup );
   spyFollow->setText( klocale->translate("spy the following calls:"));
   spyFollow->setGeometry( 10, 50, 200, 20 );
   buttongroup->insert( spyFollow );
   connect( spyFollow, SIGNAL(toggled(bool)), this, SLOT(slotSpyFollow(bool)) );

   spy = new QMultiLineEdit( buttongroup );
   spy->setGeometry( 30, 70, 190, 100 );
}


void DlgQSOSpy::setupWindowIgnore()
{
   winIgnore = new QWidget( this );


   QButtonGroup *buttongroup = new QButtonGroup( winIgnore );
   buttongroup->setGeometry( 10, 10, 230, 160 );
   buttongroup->setFrameStyle( QButtonGroup::NoFrame );

   ignAll = new QRadioButton( buttongroup );
   ignAll->setText( klocale->translate("ignore everything"));
   ignAll->setGeometry( 10, 10, 200, 20 );
   buttongroup->insert( ignAll );

   ignNothing = new QRadioButton( buttongroup );
   ignNothing->setText( klocale->translate("ignore nothing"));
   ignNothing->setGeometry( 10, 30, 200, 20 );
   buttongroup->insert( ignNothing );

   ignFollow = new QRadioButton( buttongroup );
   ignFollow->setText( klocale->translate("ignore the following calls:"));
   ignFollow->setGeometry( 10, 50, 200, 20 );
   buttongroup->insert( ignFollow );
   connect( ignFollow, SIGNAL(toggled(bool)), this, SLOT(slotIgnoreFollow(bool)) );

   ignore = new QMultiLineEdit( buttongroup );
   ignore->setGeometry( 30, 70, 190, 100 );
}


void DlgQSOSpy::setStandard()
{
   char *tmp;


   act->setChecked( config->qsospy );

   switch (config->spywhat)
   {
      case SPY_EVERYTHING:
           spyAll->setChecked( true );
           break;
      case SPY_NOTHING:
           spyNothing->setChecked( true );
           break;
      case SPY_FOLLOWING:
           spyFollow->setChecked( true );
           break;
   }

   switch (config->ignorewhat)
   {
      case SPY_EVERYTHING:
           ignAll->setChecked( true );
           break;
      case SPY_NOTHING:
           ignNothing->setChecked( true );
           break;
      case SPY_FOLLOWING:
           ignFollow->setChecked( true );
           break;
   }


   if ((tmp = config->spy->first()) == NULL) return;
   do
   {
      spy->insertLine( tmp );
   }
   while ((tmp = config->spy->next()) != NULL);


   if ((tmp = config->ignore->first()) == NULL) return;
   do
   {
      ignore->insertLine( tmp );
   }
   while ((tmp = config->ignore->next()) != NULL);
}


void DlgQSOSpy::slotOkPressed()
{
   KConfig *kconfig;
   char str[1000], *str2;
   int i;


   kconfig = mykapp->getConfig();

   kconfig->setGroup( "QSO-Spy" );

   if (act->isChecked())
   {
      config->qsospy = true;
      kconfig->writeEntry("active", "1");
   }
   else
   {
      config->qsospy = false;
      kconfig->writeEntry("active", "0");
   }

   if (spyAll->isChecked())
   {
      kconfig->writeEntry("spyWhat", "1");
      config->spywhat = SPY_EVERYTHING;
   }
   if (spyNothing->isChecked())
   {
      kconfig->writeEntry("spyWhat", "2");
      config->spywhat = SPY_NOTHING;
   }
   if (spyFollow->isChecked())
   {
      kconfig->writeEntry("spyWhat", "3");
      config->spywhat = SPY_FOLLOWING;
   }

   if (ignAll->isChecked())
   {
      kconfig->writeEntry("ignoreWhat", "1");
      config->ignorewhat = SPY_EVERYTHING;
   }
   if (ignNothing->isChecked())
   {
      kconfig->writeEntry("ignoreWhat", "2");
      config->ignorewhat = SPY_NOTHING;
   }
   if (ignFollow->isChecked())
   {
      kconfig->writeEntry("ignoreWhat", "3");
      config->ignorewhat = SPY_FOLLOWING;
   }


   config->spy->clear();
   str[0] = '\0';
   for (i=0; i<spy->numLines(); i++)
   {
      str2 = (char *) strdup(spy->textLine(i));
      Gross(str2);
      if (str2[0] != '\0')
      {
         if (str[0] == '\0')
            strcpy( str, str2 );
         else
            sprintf( str+strlen(str), ",%s", str2 );
         config->spy->append( str2 );
      }
      free(str2);
   }
   kconfig->writeEntry("spy", str);


   config->ignore->clear();
   str[0] = '\0';
   for (i=0; i<ignore->numLines(); i++)
   {
      str2 = (char *) strdup(ignore->textLine(i));
      Gross(str2);
      if (str2[0] != '\0')
      {
         if (str[0] == '\0')
            strcpy( str, str2 );
         else
            sprintf( str+strlen(str), ",%s", str2 );
         config->ignore->append( str2 );
      }
      free(str2);
   }
   kconfig->writeEntry("ignore", str);

   kconfig->sync();

   accept();
}


void DlgQSOSpy::slotSpyFollow( bool toggled )
{
   spy->setEnabled( toggled );
}


void DlgQSOSpy::slotEnabled( bool toggled )
{
   spyAll->setEnabled( toggled );
   spyNothing->setEnabled( toggled );
   spyFollow->setEnabled( toggled );
   if (spyFollow->isChecked())
      spy->setEnabled( toggled );
   else
      spy->setEnabled( false );

   ignAll->setEnabled( toggled );
   ignNothing->setEnabled( toggled );
   ignFollow->setEnabled( toggled );
   if (ignFollow->isChecked())
      ignore->setEnabled( toggled );
   else
      ignore->setEnabled( false );
}


void DlgQSOSpy::slotIgnoreFollow( bool toggled )
{
   ignore->setEnabled( toggled );
}


#include "preferences.moc"

