/*
 *  MonKT - a monitor for LinKT
 *  Copyright (C) 1998-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "main.h"
#include "global.h"
#include "mondefs.h"
#include "toolbox.h"
#include "preferences.h"
#include "version.h"

#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#include <kmsgbox.h>

#include <qkeycode.h>


QColor colors[17] = {black,white,darkGray,gray,lightGray,red,green,
                     blue,cyan,magenta,yellow,darkRed,darkGreen,darkBlue,
                     darkCyan,darkMagenta,darkYellow};

bool beenden=false;


KApplication *mykapp;
TopLevel *toplevel;
// Aus global.h
s_config *config;


/*
 *  TopLevel::TopLevel( QWidget *parent=0, const char *name=0 )
 * Konstruktor des Hauptfensters
 */
TopLevel::TopLevel( const char *name )
             : KTopLevelWidget(name)
{
   char tmp[500];
   QFont f("fixed", 12);


   moni = new Monitor();

   if (moni->result != 0)
   {
      switch (moni->result)
      {
         case 1: sprintf(tmp,klocale->translate("ax25spyd not found on port %i"), config->ax25spyd_port);
                 KMsgBox::message(0,klocale->translate("ax25spyd-Error"),tmp);
                 break;
      }

      beenden = true;
      return;
   }


   setMinimumSize (300, 200);
   resize(600,400);

   setCaption(klocale->translate("MonKT - the LinKT Monitor"));



   if (!config->dxclusterspy)
   {
      // Fenster fuer die eigentlichen Monitor-Daten
/*      output = new OutputWidget( this );
      output->setGeometry(0, 0, width(), height());

      output->setFont(f);
      output->setBackgroundColor( colors[config->colors->background] );

      setView(output);*/
      outctrl = new OutputCtrl( this );
      setView(outctrl);
   }
   else
   {
      pannerHome = new QWidget( this );

      panner = new KNewPanner(pannerHome, "panner", KNewPanner::Horizontal,
                                                         KNewPanner::Percent);
      panner->resize(pannerHome->size());

      // Fenster fuer die eigentlichen Monitor-Daten
//      output = new OutputWidget(pannerHome);
      outctrl = new OutputCtrl( pannerHome );
      dxwin = new DXWin( pannerHome, this );

/*      output->setFont(f);
      output->setBackgroundColor( colors[config->colors->background] );*/

//      panner->activate(output, dxwin);
      panner->activate( outctrl, dxwin );
      panner->setSeparatorPos( 100-config->dxWinSize );

      setView(pannerHome);

      dx = new DXCluster();
   }

   closeQuestion = true;


   setupMenuBar();
   if (config->dxclusterspy)
   {
      setupStatusBar();
      pannerHome->setGeometry(0, 0, width(), height()-statusbar->height()-menubar->height());
   }


   show();
}


TopLevel::~TopLevel()
{
   delete outctrl;
}


/*
 * void TopLevel::setupMenuBar()
 * Das Hauptmenue wird aufgebaut und an das KTopLevelWidget angedockt.
 */
void TopLevel::setupMenuBar()
{
   int i,j,k;


   pref = new QPopupMenu();

   pref->insertItem( klocale->translate("&Colors"), this, SLOT(slotPrefColors()));
   pref->insertItem( klocale->translate("&DX-Cluster-Spy"), this, SLOT(slotPrefDX()));
   pref->insertItem( klocale->translate("&QSO-Spy"), this, SLOT(slotPrefQSOSpy()));

   file = new QPopupMenu ();

   file->insertItem( klocale->translate("&Preferences"), pref );
   file->insertSeparator( -1 );
   file->insertItem( klocale->translate("E&xit"), this, SLOT(slotBeenden()), ALT+Key_X);


   dxspy = new QPopupMenu ();

   i = dxspy->insertItem( klocale->translate("&New view"), this, SLOT(slotNewView()));
   j = dxspy->insertItem( klocale->translate("&Delete view"), this, SLOT(slotDeleteView()));
   dxspy->insertSeparator( -1 );
   k = dxspy->insertItem( klocale->translate("&Save viewlist"), this, SLOT(slotSaveViewList()));
   if (!config->dxclusterspy)
   {
      dxspy->setItemEnabled( i, false );
      dxspy->setItemEnabled( j, false );
      dxspy->setItemEnabled( k, false );
   }


   help = new QPopupMenu ();
//   help->insertItem( klocale->translate("&Index"), this, SLOT(slotHelp()));
   help->insertItem( klocale->translate("&About"), this, SLOT(slotAbout()));



   menubar = new KMenuBar (this);
   menubar->insertItem( klocale->translate("&File"), file );
   menubar->insertItem( klocale->translate("&DX-Spy"), dxspy );
   menubar->insertSeparator( -1 );
   menubar->insertItem( klocale->translate("&Help"), help );

   setMenu(menubar);
}


void TopLevel::setupStatusBar()
{
   statusbar = new KStatusBar( this );

   statusbar->insertItem("WWWWWWWWWWWWWWWWWWWW", ID_STATUS_COUNTRY);
   statusbar->insertItem("Distance: 00000.00 miles", ID_STATUS_DIST);
   statusbar->insertItem("000.0 (North-North-West)", ID_STATUS_DEG);

   statusbar->changeItem("", ID_STATUS_COUNTRY);
   statusbar->changeItem("", ID_STATUS_DIST);
   statusbar->changeItem("", ID_STATUS_DEG);

   statusbar->setInsertOrder(KStatusBar::LeftToRight);
   statusbar->setBorderWidth(1);
   setStatusBar( statusbar );
}


void TopLevel::updateStatusbar( const char *dxcall )
{
   char tmp[100];
   s_dxc_dat *dxctmp;
   float dist;
   double degree;

   if (dxcall[0] == '\0')
   {
      statusbar->changeItem("", ID_STATUS_COUNTRY);
      statusbar->changeItem("", ID_STATUS_DIST);
      statusbar->changeItem("", ID_STATUS_DEG);
      return;
   }

   dxctmp = dx->getCallDescription( dxcall );

   if (dxctmp == NULL)
   {
      statusbar->changeItem("", ID_STATUS_COUNTRY);
      statusbar->changeItem("", ID_STATUS_DIST);
      statusbar->changeItem("", ID_STATUS_DEG);
      return;
   }

   statusbar->changeItem(dxctmp->desc, ID_STATUS_COUNTRY);

   // Distanz und Richtung
   dx->calcStnInfos( dxctmp->latitude, dxctmp->longitude, dist, degree );
   if (config->distKM)
      sprintf(tmp, "Distance: %.2f km", dist);
   else
      sprintf(tmp, "Distance: %.2f miles", dist);
   statusbar->changeItem(tmp, ID_STATUS_DIST);
   sprintf(tmp, "%.1f (%s)", degree, dx->courseName(degree));
   statusbar->changeItem(tmp, ID_STATUS_DEG);
}


void TopLevel::closeEvent(QCloseEvent *e)
{
   if (closeQuestion)
      if (KMsgBox::yesNo( NULL,
                          klocale->translate("Quit MonKT?"),
                          klocale->translate("Do you really want to quit MonKT?"),
                          0,
                          klocale->translate("&Yes"),
                          klocale->translate("&No")) != 1)
      {
         e->ignore();
         return;
      }

   e->accept();
}


void TopLevel::resizeEvent(QResizeEvent *e)
{
   KTopLevelWidget::resizeEvent(e);

   if (config->dxclusterspy)
      panner->resize(pannerHome->size());
}


//   void TopLevel::showData(int type, char *buffer, int len)
//
// Gibt die uebergebenen Daten farbig aus.
void TopLevel::showData(int type, char *buffer, int len)
{
   char tmp[BUFSIZE], str[BUFSIZE];
   int i,newlen;
   bool ret;


   memcpy(str, buffer, len);
   str[len] = '\0';


   // Typen, die keine Strings uebergeben
   switch (type)
   {
      case T_QSOOFFER:
           checkQSOSpy( (struct t_QSOMheard *) str );
           return;
      case T_SPYHEADER:
           startQSOSpy( (struct t_QSOMheard *) str );
           return;
      case T_SPYDATA:
           outctrl->spyData( str, len );
           return;
      case T_SPYEND:
           outctrl->spyEnd( (struct t_QSOMheard *) str );
           return;
   }

   do
   {
      ret = false;

      if ((i = POS('\n', str)) > -1)
      {
         memcpy(tmp, str, i);
         tmp[i] = '\0';
         newlen = strlen(str)-i-1;
         memmove(str, str+i+1, newlen);
         str[newlen] = '\0';
         ret = true;
      }
      else
      {
         strcpy(tmp, str);
         str[0] = '\0';
      }

      switch (type)
      {
         case T_ERROR:
              outctrl->monitorWrite( tmp, colors[config->colors->colorError] );
              break;
         case T_PORT:
              outctrl->monitorWrite( tmp, colors[config->colors->colorPort] );
              break;
         case T_KISS:
              outctrl->monitorWrite( tmp, colors[config->colors->colorKiss] );
              break;
         case T_BPQ:
              outctrl->monitorWrite( tmp, colors[config->colors->colorBpq] );
              break;
         case T_DATA:
              outctrl->monitorWrite( tmp, colors[config->colors->colorData] );
              break;
         case T_PROTOCOL:
              outctrl->monitorWrite( tmp, colors[config->colors->colorProtocol] );
              break;
         case T_AXHDR:
              outctrl->monitorWrite( tmp, colors[config->colors->colorAxhdr] );
              break;
         case T_ADDR:
              outctrl->monitorWrite( tmp, colors[config->colors->colorAddr] );
              break;
         case T_IPHDR:
              outctrl->monitorWrite( tmp, colors[config->colors->colorIphdr] );
              break;
         case T_TCPHDR:
              outctrl->monitorWrite( tmp, colors[config->colors->colorTcphdr] );
              break;
         case T_ROSEHDR:
              outctrl->monitorWrite( tmp, colors[config->colors->colorRosehdr] );
              break;
         case T_TIMESTAMP:
              outctrl->monitorWrite( tmp, colors[config->colors->colorTimestamp] );
              break;
         case T_FLEXNET:
              outctrl->monitorWrite( tmp, colors[config->colors->colorFlexnet] );
              break;
         case T_ZIERRAT:
              outctrl->monitorWrite( tmp, colors[config->colors->colorZierrat] );
              break;
         case T_CALL:
              outctrl->monitorWrite( tmp, colors[config->colors->colorCall] );
              break;
         case T_FMCALL:
              outctrl->monitorWrite( tmp, colors[config->colors->colorFmCall] );
              break;
         case T_TOCALL:
              outctrl->monitorWrite( tmp, colors[config->colors->colorToCall] );
              break;
         case T_VIACALL:
              outctrl->monitorWrite( tmp, colors[config->colors->colorViaCall] );
              break;
         case T_HDRVAL:
              outctrl->monitorWrite( tmp, colors[config->colors->colorHdrVal] );
              break;
         case T_DXCLUST:
              if (config->dxclusterspy)
                 proceedDXLine(tmp);
              break;
      }

      if (ret)
         outctrl->monitorNewLine();
   }
   while (str[0] != '\0');
}


//   void TopLevel::proceedDXLine(char *line)
//
// Verwurstet eine "DX de" - Meldung
void TopLevel::proceedDXLine(char *line)
{
   char qrg[50], absender[10], zeit[10], rufzeichen[10],bemerkung[100];
   int len,i;


   // Zeitpunkt
   memcpy(zeit, line+70, 4);
   zeit[4] = '\0';
   line[70] = '\0';
   KillSpacesRight(zeit);

   // "DX de "-Meldung abschneiden
   len = strlen(line)-6;
   memmove(line, line+6, len);
   line[len] = '\0';

   if ((i = POS(':', line)) == -1) return;
   memcpy(absender, line, i);
   absender[i] = '\0';
   len = strlen(line)-i-1;
   memmove(line, line+i+1, len);
   line[len] = '\0';
   KillSpacesLeft(line);

   // QRG
   if ((i = POS(' ', line)) == -1) return;
   memcpy(qrg, line, i);
   qrg[i] = '\0';
   len = strlen(line)-i-1;
   memmove(line, line+i+1, len);
   line[len] = '\0';
   KillSpacesLeft(line);

   // DX-Call
   if ((i = POS(' ', line)) == -1) return;
   memcpy(rufzeichen, line, i);
   rufzeichen[i] = '\0';
   len = strlen(line)-i-1;
   memmove(line, line+i+1, len);
   line[len] = '\0';
   KillSpacesLeft(line);

   // Bemerkungen
   strcpy(bemerkung, line);

   dxwin->addDXMessage(rufzeichen, absender, atof(qrg), atoi(zeit), bemerkung);
}


void TopLevel::slotPrefColors()
{
   DlgColor *dlg = new DlgColor();

   dlg->setGeometry((mykapp->desktop()->width()-dlg->width())/2,
     		    (mykapp->desktop()->height()-dlg->height())/2,
 		    dlg->width(),dlg->height());

   dlg->exec();

   delete dlg;
}


void TopLevel::slotPrefDX()
{
   DlgDX *dlg = new DlgDX();

   dlg->setGeometry((mykapp->desktop()->width()-dlg->width())/2,
     		    (mykapp->desktop()->height()-dlg->height())/2,
 		    dlg->width(),dlg->height());

   dlg->exec();

   delete dlg;
}


void TopLevel::slotPrefQSOSpy()
{
   DlgQSOSpy *dlg = new DlgQSOSpy();

   dlg->setGeometry((mykapp->desktop()->width()-dlg->width())/2,
     		    (mykapp->desktop()->height()-dlg->height())/2,
 		    dlg->width(),dlg->height());

   dlg->exec();

   delete dlg;
}


void TopLevel::slotHelp()
{
}


void TopLevel::slotAbout()
{
   DlgAbout *dlg = new DlgAbout();

   dlg->setGeometry((mykapp->desktop()->width()-dlg->width())/2,
     		    (mykapp->desktop()->height()-dlg->height())/2,
 		    dlg->width(),dlg->height());

   dlg->exec();

   delete dlg;
}


void TopLevel::slotBeenden()
{
   close();
}


void TopLevel::exitApplication()
{
   closeQuestion = false;
   close();
   delete moni;
   moni = NULL;
}


void TopLevel::slotNewView()
{
   double min, max;
   char desc[21];


   DlgAddView *dlg = new DlgAddView();

   QPoint point = this->mapToGlobal (QPoint (0,0));

   QRect pos = this->geometry();
   dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
 		   point.y() + pos.height()/2 - dlg->height()/2,
 		   dlg->width(),dlg->height());

   if (dlg->exec() == 1)
   {
      dlg->getData( min, max, desc );
      dxwin->addDXView( desc, min, max );

      dxwin->resizeTabBar();
   }

   delete dlg;
}



void TopLevel::slotDeleteView()
{
   const char *label;
   DlgDelView *dlg = new DlgDelView( dxwin->getViewsRoot() );

   QPoint point = this->mapToGlobal (QPoint (0,0));

   QRect pos = this->geometry();
   dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
 		   point.y() + pos.height()/2 - dlg->height()/2,
 		   dlg->width(),dlg->height());

   if (dlg->exec() == 1)
   {
      // View loeschen
      label = dlg->getListName();
      dxwin->delDXView( label );
   }

   delete dlg;
}


void TopLevel::slotSaveViewList()
{
   dxwin->slotSaveViewList();
}


//   bool TopLevel::isInList( QStrList *liste, char *call, int ssid)
//
// Guckt, ob das uebergebene Rufzeichen in der Liste enthalten ist.
//    Rueckgabe: true wenn ja, false wenn nein
bool TopLevel::isInList( QStrList *liste, char *call, int ssid)
{
   char *tmp, tmp2[10];


   if ((tmp = liste->first()) == NULL) return false;
   do
   {
      // Gucken, ob in tmp eine SSID enthalten ist
      if (POS('-', tmp) > -1)
      {
         // Ja, SSID
         sprintf(tmp2, "%s-%i", call, ssid);
         if (!strcmp(tmp2, tmp)) return true;
      }
      else
      {
         // Nein, keine SSID
         if (!strcmp(call, tmp)) return true;
      }
   }
   while ((tmp = liste->next()) != NULL);

   return false;
}


//   void checkQSOSpy( struct t_QSOMheard *data )
//
// Ein neues QSO soll gespyt werden. Gucken, obs Ok ist.
void TopLevel::checkQSOSpy( struct t_QSOMheard *data )
{
   char tmp[100];
   bool found;

   // Gucken, ob gespyt werden soll. Wenn ja -> SPYID <nr> schicken.
   // Wenn nein -> nix machen.

   if (config->spywhat == SPY_NOTHING) return;
   if (config->spywhat == SPY_FOLLOWING)
   {
      found = false;
      if (isInList(config->spy, data->fmcall.sCall, data->fmcall.ssid)) found = true;
      if (isInList(config->spy, data->tocall.sCall, data->tocall.ssid)) found = true;
      if (!found) return;
   }

   if (config->ignorewhat == SPY_EVERYTHING) return;
   if (config->ignorewhat == SPY_FOLLOWING)
   {
      if (isInList(config->spy, data->fmcall.sCall, data->fmcall.ssid)) return;
      if (isInList(config->spy, data->tocall.sCall, data->tocall.ssid)) return;
   }

   sprintf(tmp, "SPYID %i", data->qsoid);
   moni->sendCmd(tmp);
}


//   void startQSOSpy( struct t_QSOMheard *data )
//
// Ein neues QSO soll gespyt werden. In die QSO-Liste eintragen und
// eventuell ein neues Spy-Fenster oeffnen
void TopLevel::startQSOSpy( struct t_QSOMheard *data )
{
   char tmp[100];

   if (data->fmcall.ssid == 0)
      strcpy( tmp, data->fmcall.sCall );
   else
      sprintf(tmp, "%s-%i", data->fmcall.sCall, data->fmcall.ssid);
   strcat(tmp, " <-> ");
   if (data->tocall.ssid == 0)
      sprintf(tmp+strlen(tmp), "%s", data->tocall.sCall);
   else
      sprintf(tmp+strlen(tmp), "%s-%i", data->tocall.sCall, data->tocall.ssid);
   outctrl->addSpy( tmp, data->qsoid, data->otherqsoid );
}


void TopLevel::sendMonitor( char *str )
{
   moni->sendCmd( str );
}



//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


void insertList( char *str, QStrList *list )
{
   char tmp[1000], tmp2[500];
   int i, len;


   KillAllSpaces( tmp, str );
   while (tmp[0] != '\0')
   {
      if ((i = POS(',', tmp)) == -1)
      {
         strcpy(tmp2, tmp);
         tmp[0] = '\0';
      }
      else
      {
         memcpy(tmp2, tmp, i);
         tmp2[i] = '\0';
         len = strlen(tmp)-i-1;
         memmove(tmp, tmp+i+1, len);
         tmp[len] = '\0';
      }

      list->append(tmp2);
   }
}


void init_globals()
{
   KConfig *kconfig;
   char *tmp, tmp2[1000];



   config = (s_config *) malloc(sizeof(s_config));
   config->colors = (s_conf_colors *) malloc(sizeof(s_conf_colors));

   config->maindir = (char *) malloc( strlen(getenv("HOME"))+50 );
   sprintf(config->maindir,"%s/.kde/share/apps/monkt",getenv("HOME"));
   mkdir(config->maindir, 448);


   // Konfigurations-File holen
   kconfig = mykapp->getConfig();

   kconfig->setGroup( "Global" );

   if ((tmp = kconfig->readEntry("buffersize").data()) != NULL)
      config->buffersize = atoi( tmp );
   else
      config->buffersize = 2000;

   if ((tmp = kconfig->readEntry("tblsize").data()) != NULL)
      config->tblsize = atoi( tmp );
   else
      config->tblsize = 1000;

   if ((tmp = kconfig->readEntry("ax25spyd_port").data()) != NULL)
      config->ax25spyd_port = atoi( tmp );
   else
      config->ax25spyd_port = 14090;

   if ((tmp = kconfig->readEntry("dxwinsize").data()) != NULL)
      config->dxWinSize = atoi( tmp );
   else
      config->dxWinSize = 25;



   kconfig->setGroup( "Monitor" );

   if ((tmp = kconfig->readEntry("timestamp").data()) != NULL)
      if (atoi(tmp) != 0)
         config->timestamp = true;
      else
         config->timestamp = false;
   else config->timestamp = false;      // Default

   if ((tmp = kconfig->readEntry("onlyIFrames").data()) != NULL)
      if (atoi(tmp) != 0)
         config->onlyIFrames = true;
      else
         config->onlyIFrames = false;
   else config->onlyIFrames = false;      // Default

   if ((tmp = kconfig->readEntry("onlyHeaders").data()) != NULL)
      if (atoi(tmp) != 0)
         config->onlyHeaders = true;
      else
         config->onlyHeaders = false;
   else config->onlyHeaders = false;      // Default

   if ((tmp = kconfig->readEntry("heard").data()) != NULL)
      if (atoi(tmp) != 0)
         config->mheard = true;
      else
         config->mheard = false;
   else config->mheard = false;      // Default

   if ((tmp = kconfig->readEntry("updatemheard").data()) != NULL)
      config->updatemheard = atoi( tmp );
   else
      config->updatemheard = 1000;



   kconfig->setGroup( "DX-Cluster-Spy" );

   if ((tmp = kconfig->readEntry("active").data()) != NULL)
      if (atoi(tmp) != 0)
         config->dxclusterspy = true;
      else
         config->dxclusterspy = false;
   else config->dxclusterspy = true;      // Default

   sprintf(tmp2, "%s/monkt/dxc.dat", (const char *)mykapp->kde_datadir());
   if ((tmp = kconfig->readEntry("dxdata_file").data()) != NULL)
      if (tmp[0] != '\0')
         config->dxdata_file = (char *) strdup( tmp );
      else
         config->dxdata_file = (char *) strdup( tmp2 );
   else
      config->dxdata_file = (char *) strdup( tmp2 );

   if ((tmp = kconfig->readEntry("mylatitude").data()) != NULL)
      config->mylatitude = atol( tmp );
   else
      config->mylatitude = (51L *3600L + 56L *60L + 15L);

   if ((tmp = kconfig->readEntry("mylongitude").data()) != NULL)
      config->mylongitude = atol( tmp );
   else
      config->mylongitude = -(7L *3600L + 42L *60L + 30L);


   kconfig->setGroup( "Colors" );

   if ((tmp = kconfig->readEntry("background").data()) != NULL)
      config->colors->background = atoi( tmp );
   else
      config->colors->background = COLOR_BLACK;

   if ((tmp = kconfig->readEntry("winMarkColor").data()) != NULL)
      config->colors->qsoWinMarkColor = atoi( tmp );
   else
      config->colors->qsoWinMarkColor = 1;

   if ((tmp = kconfig->readEntry("winMarkBack").data()) != NULL)
      config->colors->qsoWinMarkBack = atoi( tmp );
   else
      config->colors->qsoWinMarkBack = 13;

   if ((tmp = kconfig->readEntry("winMarkBold").data()) != NULL)
      if (atoi(tmp) != 0)
         config->colors->mark_bold = true;
      else
         config->colors->mark_bold = false;
   else config->colors->mark_bold = false;      // Default

   if ((tmp = kconfig->readEntry("error").data()) != NULL)
      config->colors->colorError = atoi( tmp );
   else
      config->colors->colorError = COLOR_RED;

   if ((tmp = kconfig->readEntry("port").data()) != NULL)
      config->colors->colorPort = atoi( tmp );
   else
      config->colors->colorPort = COLOR_GREEN;

   if ((tmp = kconfig->readEntry("kiss").data()) != NULL)
      config->colors->colorKiss = atoi( tmp );
   else
      config->colors->colorKiss = COLOR_MAGENTA;

   if ((tmp = kconfig->readEntry("bpq").data()) != NULL)
      config->colors->colorBpq = atoi( tmp );
   else
      config->colors->colorBpq = COLOR_MAGENTA;

   if ((tmp = kconfig->readEntry("data").data()) != NULL)
      config->colors->colorData = atoi( tmp );
   else
      config->colors->colorData = COLOR_WHITE;

   if ((tmp = kconfig->readEntry("protocol").data()) != NULL)
      config->colors->colorProtocol = atoi( tmp );
   else
      config->colors->colorProtocol = COLOR_CYAN;

   if ((tmp = kconfig->readEntry("ax25-hdr").data()) != NULL)
      config->colors->colorAxhdr = atoi( tmp );
   else
      config->colors->colorAxhdr = COLOR_WHITE;

   if ((tmp = kconfig->readEntry("address").data()) != NULL)
      config->colors->colorAddr = atoi( tmp );
   else
      config->colors->colorAddr = COLOR_GREEN;

   if ((tmp = kconfig->readEntry("ip-hdr").data()) != NULL)
      config->colors->colorIphdr = atoi( tmp );
   else
      config->colors->colorIphdr = COLOR_WHITE;

   if ((tmp = kconfig->readEntry("tcp-hdr").data()) != NULL)
      config->colors->colorTcphdr = atoi( tmp );
   else
      config->colors->colorTcphdr = COLOR_BLUE;

   if ((tmp = kconfig->readEntry("rose-hdr").data()) != NULL)
      config->colors->colorRosehdr = atoi( tmp );
   else
      config->colors->colorRosehdr = COLOR_WHITE;

   if ((tmp = kconfig->readEntry("timestamp").data()) != NULL)
      config->colors->colorTimestamp = atoi( tmp );
   else
      config->colors->colorTimestamp = COLOR_MAGENTA;

   if ((tmp = kconfig->readEntry("flexnet").data()) != NULL)
      config->colors->colorFlexnet = atoi( tmp );
   else
      config->colors->colorFlexnet = COLOR_WHITE;

   if ((tmp = kconfig->readEntry("zierrat").data()) != NULL)
      config->colors->colorZierrat = atoi( tmp );
   else
      config->colors->colorZierrat = COLOR_WHITE;

   if ((tmp = kconfig->readEntry("call").data()) != NULL)
      config->colors->colorCall = atoi( tmp );
   else
      config->colors->colorCall = COLOR_GREEN;

   if ((tmp = kconfig->readEntry("fm-call").data()) != NULL)
      config->colors->colorFmCall = atoi( tmp );
   else
      config->colors->colorFmCall = COLOR_GREEN;

   if ((tmp = kconfig->readEntry("to-call").data()) != NULL)
      config->colors->colorToCall = atoi( tmp );
   else
      config->colors->colorToCall = COLOR_GREEN;

   if ((tmp = kconfig->readEntry("via-call").data()) != NULL)
      config->colors->colorViaCall = atoi( tmp );
   else
      config->colors->colorViaCall = COLOR_GREEN;

   if ((tmp = kconfig->readEntry("hdr-val").data()) != NULL)
      config->colors->colorHdrVal = atoi( tmp );
   else
      config->colors->colorHdrVal = COLOR_GREEN;

   if ((tmp = kconfig->readEntry("bold-header").data()) != NULL)
      if (atoi(tmp) != 0)
         config->colors->boldHeader = true;
      else
         config->colors->boldHeader = false;
   else config->colors->boldHeader = true;      // Default

   if ((tmp = kconfig->readEntry("spyColor1").data()) != NULL)
      config->colors->spyColor1 = atoi( tmp );
   else
      config->colors->spyColor1 = COLOR_WHITE;

   if ((tmp = kconfig->readEntry("spyColor2").data()) != NULL)
      config->colors->spyColor2 = atoi( tmp );
   else
      config->colors->spyColor2 = COLOR_CYAN;

   if ((tmp = kconfig->readEntry("spyColorStatus").data()) != NULL)
      config->colors->spyColorStatus = atoi( tmp );
   else
      config->colors->spyColorStatus = COLOR_RED;



   kconfig->setGroup( "QSO-Spy" );

   if ((tmp = kconfig->readEntry("active").data()) != NULL)
      if (atoi(tmp) != 0)
         config->qsospy= true;
      else
         config->qsospy = false;
   else config->qsospy = true;      // Default

   if ((tmp = kconfig->readEntry("spyWhat").data()) != NULL)
      config->spywhat = atoi( tmp );
   else
      config->spywhat = SPY_EVERYTHING;

   if ((tmp = kconfig->readEntry("ignoreWhat").data()) != NULL)
      config->ignorewhat = atoi( tmp );
   else
      config->ignorewhat = SPY_NOTHING;

   config->spy = new QStrList();
   if ((tmp = kconfig->readEntry("spy").data()) != NULL)
      insertList( tmp, config->spy );

   config->ignore = new QStrList();
   if ((tmp = kconfig->readEntry("ignore").data()) != NULL)
      insertList( tmp, config->ignore );
}


int main (int argc, char **argv)
{
   mykapp = new KApplication (argc, argv, "monkt");

   init_globals();

   toplevel = new TopLevel ();
   if (!beenden)
   {
      toplevel->show ();

      mykapp->setMainWidget(toplevel);
      return mykapp->exec ();
   }
}



////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


#define BTN_WIDTH 75
#define BTN_HEIGHT 25


DlgAbout::DlgAbout() : QDialog( 0, "", true )
{

   setFixedSize(350, 230);

   setCaption(klocale->translate("About MonKT..."));


   monkt = new QLabel( this );
   monkt->setText( "MonKT - the LinKT monitor");
   monkt->setFont( QFont("helvetica", 20) );
   monkt->move( 20, 30 );
   monkt->resize( monkt->sizeHint() );


   QString s;
   s = "Version " MONKT_VERSION " (" DATUM ")" \
   "\n\nCopyright (c) 1998-1999 Jochen Sarrazin, DG6VJ\n"\
   "DG6VJ@DB0EA.#NRW.DEU.EU\n" \
   "<jochen@1409.org>";


   copyright = new QLabel(s.data(), this);
   copyright->setGeometry(20, 80, 300, 100);
   copyright->setAlignment(AlignLeft|WordBreak|ExpandTabs);


   ok = new QPushButton( "&Ok", this );
   ok->setGeometry( (width() - BTN_WIDTH)/2, height()-BTN_HEIGHT-10, BTN_WIDTH, BTN_HEIGHT );
   ok->setDefault(true);
   connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
   ok->setFocus();
}


DlgAbout::~DlgAbout()
{
}





#include "main.moc"

