/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *   some parts Copyright (C) by Jonathan Naylor
 */

#include "yapp.h"
#include "yapp.moc"

#include "channel.h"
#include "toolbox.h"
#include "main.h"
#include "dostime.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <kwmmapp.h>

#define	NUL		0x00
#define	SOH		0x01
#define	STX		0x02
#define	ETX		0x03
#define	EOT		0x04
#define	ENQ		0x05
#define	ACK		0x06
#define	DLE		0x10
#define	NAK		0x15
#define	CAN		0x18


#define	STATE_S		0
#define	STATE_SH	   1
#define	STATE_SD	   2
#define	STATE_SE	   3
#define	STATE_ST	   4
#define	STATE_R		5
#define	STATE_RH	   6
#define	STATE_RD	   7


extern TopLevel *toplevel;


int readlen=253;


YAPP::YAPP( QWidget *rxchan ) : QObject()
{
   chan = rxchan;
   rxFile = false;
   filename = NULL;
   shortname = NULL;
   yappc = false;
   fd = -1;
   win = NULL;
   total = 0;
   file_time = -1;
   savedata = NULL;
   savelen = 0;

   timer = new QTimer( this );
   connect(timer, SIGNAL(timeout()), this, SLOT(sendBlock()));
//   timer->start(200, false);
}


YAPP::~YAPP()
{
   if (filename != NULL)
      free(filename);
   if (shortname != NULL)
      free(shortname);
   if (win != NULL)
      delete win;
   if (fd != -1)
      ::close(fd);
   delete timer;
}


void YAPP::SendRR()
{
   char buf[2];

	buf[0] = ACK;
	buf[1] = 0x01;

	sendData(buf, 2);
}


void YAPP::SendRF()
{
   char buf[2];

	buf[0] = ACK;
	buf[1] = 0x02;

	sendData(buf, 2);
}


void YAPP::SendRT()
{
   char buf[2];

	buf[0] = ACK;
	buf[1] = ACK;

	sendData(buf, 2);
}


void YAPP::SendAF()
{
   char buf[2];

	buf[0] = ACK;
	buf[1] = 0x03;

	sendData(buf, 2);
}


void YAPP::SendAT()
{
   char buf[2];

	buf[0] = ACK;
	buf[1] = 0x04;

	sendData(buf, 2);
}


void YAPP::SendSI()
{
   char buf[2];

	buf[0] = ENQ;
	buf[1] = 0x01;

	sendData(buf, 2);
}


void YAPP::SendHD()
{
   char buffer[259];
   char size_buffer[10];
   int len,len_filename;


   sprintf( size_buffer, "%ld", filelen );
   len_filename = strlen(shortname)+1;
   len = len_filename+strlen(size_buffer)+1; // +1, weil die \0 am Ende mitzaehlt

   buffer[0] = SOH;
   buffer[1] = len;

   memcpy(buffer+2, shortname, len_filename);
   memcpy(buffer+2+len_filename, size_buffer, strlen(size_buffer)+1);

   sendData(buffer, len+2);
}


void YAPP::SendDT( int length )
{
	char buf[2];
	
	if (length > 255) length = 0;
	
	buf[0] = STX;
	buf[1] = length;
	
	sendData(buf, 2);
}


void YAPP::SendEF()
{
   char buf[2];

	buf[0] = ETX;
	buf[1] = 0x01;

	sendData(buf, 2);
}


void YAPP::SendET()
{
   char buf[2];

	buf[0] = EOT;
	buf[1] = 0x01;

	sendData(buf, 2);
}


void YAPP::SendNR( char *reason )
{
	char buf[257];
	int length;

	if ((length = strlen(reason)) > 255)
		length = 255;
	
	buf[0] = NAK;
	buf[1] = length;
	memcpy(buf + 2, reason, length);
	
	sendData(buf, length+2);
}


void YAPP::SendRE( int length )
{
	char buf[256];
	int len;

	buf[0] = NAK;
	buf[1] = 'R';
	buf[3] = 0;

	len = sprintf(buf + 4, "%d", length) + 5;
	
	buf[len]     = 'C';
	buf[len + 1] = 0;
	buf[1]       = len;
	
	sendData(buf, len+2);
}


void YAPP::SendCN( char *reason )
{
	char buf[257];
	int length;

	if ((length = strlen(reason)) > 255)
		length = 255;
	
	buf[0] = CAN;
	buf[1] = length;
	memcpy(buf + 2, reason, length);
	
	sendData(buf, length+2);
}


// Resume
void YAPP::SendRS(int length)
{
	char buffer[256];
	int len;

	buffer[0] = NAK;
	buffer[2] = 'R';
	buffer[3] = 0;

	len = sprintf(buffer + 4, "%d", length) + 5;
	
	buffer[len]     = 'C';
	buffer[len + 1] = 0;
	buffer[1]       = len;

   sendData(buffer, len+2);
}	 


bool YAPP::isRxfile()
{
   return rxFile;
}


void YAPP::sendData( char *data, int len )
{
   ((Channel *)chan)->sendString( len, data, false );
}


unsigned char YAPP::checksum( char *data, int len )
{
	int i;
	unsigned char sum = 0;

	for (i=0; i<len; i++)
		sum += data[i];

	return sum;
}


bool YAPP::isSendYapp( char *data, int len )
{
   if (data[0] == ENQ && data[1] == 0x01)
   {
      rxFile = true;
      return true;
   }
   return false;
}


int YAPP::sendYAPP( char *filename )
{
   char tmp[2000];
   int i;


   // Daten des Files holen und abspeichern
   this->filename = (char *) strdup(filename);
   // Shortname
   if ((i = lPOS('/', filename)) == -1)
      this->shortname = (char *) strdup(filename);
   else
   {
      strcpy(tmp, filename+i+1);
      shortname = (char *) strdup(tmp);
   }
   filelen = filesize( filename );

   if ((fd = open(filename, O_RDONLY)) == -1)
      return 1;

   SendSI();
   timer->start(10000, false);

   state = 1;
   ((Channel *)chan)->updateStatusBar(klocale->translate("YAPP: Transfer started"));
   return 0;
}


//   bool YAPP::proceed( char *data, int len )
//
// Bearbeitet einen YAPP-Transfer.
//   Rueckgabe: true, wenn fertig, false, wenn der Transfer noch laeuft.
bool YAPP::proceed( char *data, int len )
{
   char *tmp, *tmp2;
   int rxlen;


   tmp = (char *) malloc(len);
   memcpy(tmp, data, len);

   if (state < 100)
   {
      switch (state)
      {
         // TX
         case 1: // SI abgeschickt
                 if (tmp[0] == ACK && tmp[1] == 0x01)
                 {
                    SendHD();
                    timer->start(10000, false);
                    state = 2;  // HD abgeschickt
                    ((Channel *)chan)->updateStatusBar(klocale->translate("YAPP: Header sent"));
                    break;
                 }
                 if (tmp[0] == ACK && tmp[1] == 0x02)
                 {
                    ((Channel *)chan)->sendYAPP();
                    openTransferWin( true );
                    timer->stop();
                    state = 3;  // Daten abschicken/abgeschickt
                    ((Channel *)chan)->updateStatusBar(klocale->translate("YAPP: Sending data"));
                    break;
                 }
                 if (!lookForAbort(tmp))
                    unknownCode();
                 free(tmp);
                 return true;
         case 2: // HD (Header) abgeschickt
                 if (tmp[0] == NAK && tmp[2] == 'R') // resume
                 {
                    int len;
                    off_t rpos;

                    len = tmp[1];
                    if (tmp[len] == 'C') yappc = true;
                    rpos = atol((char *)tmp + 4);
                    lseek(fd, rpos, SEEK_SET);
                    tmp[0] = ACK;
                    if (yappc)
                       tmp[1] = ACK;
                    else
                       tmp[1] = 0x02;
                 }
                 if (tmp[0] == ACK && (tmp[1] == 0x02 || tmp[1] == ACK))
                 {
                    if (tmp[1] == ACK) yappc = true;

                    ((Channel *)chan)->sendYAPP();
                    openTransferWin( true );
                    state = 3;
                    timer->stop();
                    ((Channel *)chan)->updateStatusBar(klocale->translate("YAPP: Sending data"));
                    break;
                 }
                 if (!lookForAbort(tmp))
                    unknownCode();
                 free(tmp);
                 return true;
         case 3: // Daten abschicken
                 if (!lookForAbort(tmp))
                    unknownCode();
                 free(tmp);
                 return true;
         case 4: // EF gesendet, auf Antwort warten
                 if (tmp[0] == ACK && tmp[1] == 0x03)
                 {
                    SendET();
                    timer->start(10000, false);
                    state = 5;  // ET gesendet
                    ((Channel *)chan)->updateStatusBar(klocale->translate("YAPP: Close transfer"));
                    break;
                 }
                 return true;
         case 5: if (tmp[0] == ACK && tmp[1] == 0x04)
                 {
                    sendTransferInfo( true );
                    free(tmp);
                    return true;
                 }
                 if (!lookForAbort(tmp))
                    unknownCode();
                 free(tmp);
                 return true;
      }
   }


   //////////////////////// RX //////////////////////////
   if (state >= 100)
   {
      if (savelen > 0)
      {
         tmp2 = tmp;
         tmp = (char *) malloc(len+savelen);
         memcpy(tmp, savedata, savelen);
         memcpy(tmp+savelen, tmp2, len);
         len += savelen;
         free(savedata);
         savedata = NULL;
         savelen = 0;
         free(tmp2);
      }

      while (true)
      {
         if (state == 100)
         {
            // Alles vor "ENQ 0x01" loeschen
            if (!lookForStart(tmp, len))
            {
               // Kein  ENQ 0x01  entdeckt - den verbleibenden String (ein
               // Byte) abspeichern und aus dieser Funktion 'raus.
               savedata = (char *) malloc(len);
               savelen = len;
               memcpy(savedata, tmp, len);
               free(tmp);
               return false;
            }
         }
         switch (state)
         {
            case 100: if (tmp[0] == ENQ && tmp[1] == 0x01)
                      {
                         SendRR();
                         timer->start(10000, false);
                         state = 101;
                         ((Channel *)chan)->updateStatusBar(klocale->translate("YAPP: Waiting for header"));
                         len -= 2;
                         memmove(tmp, tmp+2, len);
                         break;
                      }
                      if (!lookForAbort(tmp))
                         unknownCode();
                      free(tmp);
                      return true;
            case 101: // Erwarte Header
                      if (tmp[0] == SOH)
                      {
                         if (len < (unsigned char)tmp[1])
                         {
                            savedata = (char *) malloc(len);
                            memcpy(savedata, tmp, len);
                            savelen = len;
                            free(tmp);
                            return false;
                         }
                         if (readHeader( tmp, len ))
                         {
                            free(tmp);
                            return true;
                         }
                         break;
                      }
                      if (tmp[0] == ENQ && tmp[1] == 0x01)
                      {
                         len -= 2;
                         memmove(tmp, tmp+2, len);
                         break;
                      }
                      if (tmp[0] == EOT && tmp[1] == 0x01)
                      {
                         len -= 2;
                         memmove(tmp, tmp+2, len);
                         timer->stop();
                         SendAT();
                         ((Channel *)chan)->updateStatusBar("");
                         free(tmp);
                         return true;
                      }
                      if (!lookForAbort(tmp))
                         unknownCode();
                      free(tmp);
                      return true;
            case 102: // Empfange Daten
                      if (tmp[0] == STX)
                      {
                         if ((rxlen = (unsigned char)tmp[1]) == 0)
                            rxlen = 256;
                         if ((yappc && (len < rxlen+3)) ||
                            (!yappc && (len < rxlen+2)))
                         {
                            savedata = (char *) malloc(len);
                            memcpy(savedata, tmp, len);
                            savelen = len;
                            free(tmp);
                            return false;
                         }
                         if (readData( tmp, len ))
                         {
                            free(tmp);
                            return true;
                         }
                         break;
                      }
                      if (tmp[0] == ETX && tmp[1] == 0x01)
                      {
                         SendAF();
                         state = 101;
                         ::close(fd);
                         ((Channel *)chan)->updateStatusBar(klocale->translate("YAPP: Transfer ready"));
                         fd = -1;
                         if (win != NULL)
                         {
                            delete win;
                            win = NULL;
                         }
                         sendTransferInfo( false );
                         len -= 2;
                         memmove(tmp, tmp+2, len);
                         break;
                      }
                      if (!lookForAbort(tmp))
                         unknownCode();
                      free(tmp);
                      return true;
         }
         if (len == 0)
         {
            free(tmp);
            return false;
         }
         if (len == 1)
         {
            savedata = (char *) malloc(len);
            savelen = len;
            memcpy(savedata, tmp, len);
            free(tmp);
            return false;
         }
      }
   }

   free(tmp);
   return false;
}


//   bool YAPP::getNextPacket( char *data, int len )
//
// Gibt ein weiteres YAPP-Paket aus.
//   Rueckgabe: true, wenn dies das letzte Paket war,
//              false, wenn noch etwas folgt
bool YAPP::getNextPacket( char *data, int & length )
{
   int len;


   len = read(fd, data+2, readlen);
   data[0] = STX;
   data[1] = len;
   length = len+2;

   if (yappc)
   {
      data[length] = checksum( data+2, len );
      length++;
   }

   total += len;
   win->setReceivedBytes( total );


   if (len != readlen)
   {
      // Ende Gelaende. EF schicken und auf Antwort warten.
      data[length] =	ETX;
      data[length+1] = 0x01;
      length += 2;

      state = 4;
      ((Channel *)chan)->updateStatusBar(klocale->translate("YAPP: Send EOT"));
      return true;
   }
   return false;
}


int YAPP::getState()
{
   return state;
}


void YAPP::abortTransfer()
{
   if (state != 1)
      SendCN("Aborted by OP");
}


void YAPP::openTransferWin( bool tx )
{
   if (tx)
      win = new TransferWin( chan, TRANSART_YAPPTX, shortname, filelen );
   else
      win = new TransferWin( chan, TRANSART_YAPPRX, shortname, filelen );
   win->show();
   win->setReceivedBytes( 0 );
   if (toplevel->currentChannel != NULL)
      if (toplevel->currentChannel->isActiveWindow())
      {
         KWM::activate(toplevel->currentChannel->winId());
         toplevel->currentChannel->setFocus();
      }

   starttime = time(NULL);
}


void YAPP::sendTransferInfo( bool tx )
{
   time_t timediff;
   char *timeptr;
   char tmp2[100];
   char text[100];

   timediff = time(NULL) - starttime;
   if (timediff == 0) timediff = 1;
   timeptr = (char *)spec_time(timediff);

   if (tx)
      strcpy(text,"<LinKT>: YAPP-TX OK. (time: %s, %li baud)\xD");
   else
      strcpy(text,"<LinKT>: YAPP-RX OK. (time: %s, %li baud)\xD");

   sprintf(tmp2, text,
                 timeptr,(filelen*8)/timediff);


   if (((((Channel *)chan)->userinfo->getType() & TYPE_TERMINAL) == TYPE_TERMINAL) && tx)
      ((Channel *)chan)->sendString( tmp2 );
   else
      ((Channel *)chan)->outText( tmp2, strlen(tmp2), config->colors->txText );

   free(timeptr);
}


int YAPP::receiveYAPP( char *filename )
{
   char tmp[2000];
   int i;


   if (filename != NULL)
   {
      // Daten des Files holen und abspeichern
      this->filename = (char *) strdup(filename);
      // Shortname
      if ((i = lPOS('/', filename)) == -1)
         this->shortname = (char *) strdup(filename);
      else
      {
         strcpy(tmp, filename+i+1);
         shortname = (char *) strdup(tmp);
      }
   }

   state = 100;
   ((Channel *)chan)->updateStatusBar(klocale->translate("YAPP: Waiting for header"));
   return 0;
}


bool YAPP::readHeader( char *buffer, int & len )
{
   char *hptr, *hfield[3];
   int length;
   int k=0,i, savelen;
   char tmp[1000], tmp2[1000];


   if ((length = buffer[1]) == 0) length = 256;
   savelen = length;
   hptr = (char *)buffer + 2;

   while (length > 0)
   {
      int hlen;
      hlen = strlen(hptr) + 1;
      hfield[(int)k++] = hptr;
      hptr   += hlen;
      length -= hlen;
   }

   if (k < 3)
      yappc = false;
   else
   {
      file_time = yapp2unix(hfield[2]);
      yappc = true;
   }

   if ((i = lPOS('/', hfield[0])) == -1)
      strcpy(tmp, hfield[0]);
   else
      strcpy(tmp, hfield[0]+i+1);
   if ((i = lPOS('\\', hfield[0])) == -1)
      strcpy(tmp, hfield[0]);
   else
      strcpy(tmp, hfield[0]+i+1);

   if (filename == NULL)
   {
      shortname = (char *) strdup(tmp);
      sprintf(tmp2, "%s/%s", config->dirABin, tmp);
      filename = (char *) strdup(tmp2);
   }
   else
      strcpy(tmp2, filename);

   if ((fd = open(tmp2, O_RDWR | O_APPEND | O_CREAT)) == -1)
   {
      SendNR("Invalid filename");
      strcpy(tmp, "<LinKT>: Cannot open YAPP-datafile. Aborted.\r");
      ((Channel *)chan)->outText( tmp, strlen(tmp), config->colors->txText );
      return true;
   }

   // Zugriffsrechte einstellen
   fchmod(fd,S_IRUSR|S_IWUSR);

   filelen = atoi(hfield[1]);
   openTransferWin( false );

   if (yappc)
   {
      // Wenn der resume-Mode explizit aktiviert wurde (Preferences), wird
      // nach resume gesucht, sonst *nicht*

      if (config->yappResume)
      {
         struct stat sb;

         if (!fstat(fd, &sb) && sb.st_size)
         {
            SendRS(sb.st_size);
            total = sb.st_size;
            lseek(fd, sb.st_size, SEEK_SET);
         }
         else
            SendRT();
      }
      else
         SendRT();
   }
   else
      SendRF();
   timer->stop();

   total = 0;

   state = 102;
   ((Channel *)chan)->updateStatusBar(klocale->translate("YAPP: Waiting for file"));

   len -= savelen+2;
   memmove(buffer, buffer+2+savelen, len);
   return false;
}


bool YAPP::readData( char *data, int & len )
{
   int length;
   char tmp[100];
   unsigned char i;


   if ((length = (unsigned char)data[1]) == 0) length = 256;

   total += length;
   win->setReceivedBytes( total );

   if (yappc)
   {
      if ((i = checksum( data+2, length )) != (unsigned char)data[length + 2])
      {
      	SendCN("Bad Checksum");
         strcpy(tmp, "<LinKT>: Bad checksum in YAPP-transfer. Aborted.\r");
         ((Channel *)chan)->outText( tmp, strlen(tmp), config->colors->txText );
         return true;
      }
   }

   write(fd, data+2, length);

   if (yappc)
   {
      len -= length+3;
      memmove(data, data+length+3, len);
   }
   else
   {
      len -= length+2;
      memmove(data, data+length+2, len);
   }
   return false;
}


void YAPP::sendBlock()
{
   switch (state)
   {
      case 1: SendSI(); break;
      case 2: SendHD(); break;
      case 4: SendEF(); break;
      case 5: SendET(); break;
//      case 101: SendRR(); break;
   }
}


void YAPP::unknownCode()
{
   char tmp[100];


   SendCN("Unknown code");
   ((Channel *)chan)->updateStatusBar("");
   if (state < 100)
      strcpy(tmp, "\r<LinKT>: YAPP-TX aborted (Unknown YAPP-Code)\r");
   else
      strcpy(tmp, "\r<LinKT>: YAPP-RX aborted (Unknown YAPP-Code)\r");

   if ((((Channel *)chan)->userinfo->getType() & TYPE_TERMINAL) == TYPE_TERMINAL)
      ((Channel *)chan)->sendString( tmp );
   else
      ((Channel *)chan)->outText( tmp, strlen(tmp), config->colors->txText );
}


bool YAPP::lookForAbort( char *data )
{
   char str[500], tmp[500];

   if (data[0] == CAN)
   {
      memcpy(tmp, str+2, (unsigned char) str[1]);
      tmp[(unsigned char) str[1]] = '\0';
      if (state < 100)
         sprintf(str, "\r<LinKT>: YAPP-TX aborted by peer.\r" \
                        "         (%s)\r", tmp);
      else
         sprintf(str, "\r<LinKT>: YAPP-RX aborted by peer.\r" \
                        "         (%s)\r", tmp);
      ((Channel *)chan)->outText( str, strlen(str), config->colors->txText );
      return true;
   }

   return false;
}


//
//   bool YAPP::lookForStart( char *tmp, int & len )
//
// Sorgt dafuer, dass  ENQ 0x01  am Anfang des Strings zurueckgegeben
// wird.
//
// Ruckgabe: true, wenn  ENQ 0x01  entdeckt wurde,
//           false, wenn nicht.
//
bool YAPP::lookForStart( char *tmp, int & len )
{
   int i;

   for (i=0;i<len-1;i++)
   {
      if (tmp[i] == ENQ)
         if (tmp[i+1] == 0x01)
         {
            len -= i;
            memmove(tmp, tmp+i, len);
            return true;
         }
   }

   return false;
}


