/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef REMOTE_H
#define REMOTE_H


#include <qwidget.h>


/*
 *  class RemoteCmds
 * In dieser Klasse stehen die Remotebefehle drin.
 */
class RemoteCmds
{
public:
   RemoteCmds( QWidget *parent );
   ~RemoteCmds();

   void checkLine( char *str );

private:
   QWidget *chan;

   void sendString( char *str );
   void sendPrompt();

   // die Befehle
   void cmdQuit();
   void cmdVersion();
   void cmdCS();
   void cmdInfo();
   void cmdHelp();
   void cmdNews();
   void cmdName(char *param);
   void cmdEcho(char *str);
   void cmdRTT(char *str);
   void cmdComp(char *param);
   void cmdTalk(char *param);
   void cmdDate();
   void cmdDDate(char *param );
   void cmdCookie();
   void cmdRing();
};


#endif  /* REMOTE_H */

