/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <qslider.h>
#include <kapp.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qtabdialog.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qmultilinedit.h>

#include "preferences.h"
#include "toolbox.h"
#include "global.h"
#include "ax25k.h"


extern KApplication *mykapp;



class myNumLineEdit : public QLineEdit
{
   Q_OBJECT;
public:
   myNumLineEdit( QWidget *parent = 0, const char *name=0 );
protected:
   void keyPressEvent( QKeyEvent *e);
private:
};


class CfgCalls : public QDialog
{
   Q_OBJECT;
public:
   CfgCalls();
   ~CfgCalls();

public slots:
   void slotOkPressed();
   void slotAbortPressed();
   void addListenCall();
   void delListenCall();
   void addDisconCall();
   void delDisconCall();

private:
   void setupWindow();
   void saveData();
   void readData();
   void deleteDroppedCalls(s_listCalls *akt, s_listCalls *old);
   bool callIsInList(const char *call, s_listCalls *list);
   void addListenCallToPorts(const char *call);
   void deleteListenCallToPorts(const char *call);
   void saveListenToCalls(KConfig *kconfig);
   void saveIgnoredCalls(KConfig *kconfig);

   QLineEdit *sendcall, *listencall, *disconcall;
   QListBox *listencalls, *disconcalls;
   QPushButton *addlistenbtn, *dellistenbtn, *adddisconbtn, *deldisconbtn;

   QPushButton *btnok, *btnabort;
};



class CfgPorts : public QDialog
{
   Q_OBJECT;
public:
   CfgPorts();
   ~CfgPorts();

public slots:
   void select_port(int index);
   void select_useport(bool btn);
   void slotOkPressed();
   void slotAbortPressed();

private:
   void setupWindow();
   void saveData();
   void readData();

   QListBox *ports;
   QCheckBox *use;
   int portcount;

   QPushButton *btnok, *btnabort;
};


class CfgScreen : public QTabDialog
{
   Q_OBJECT;
public:
   CfgScreen();
   ~CfgScreen();

public slots:
   void saveData();
   void slotSliderMoved(int value);
   void slotToggleUmbruch(bool active);

private:
   void setupWindowColors();
   void setupWindowGeneral();
   void setupWindowOthers();

   void readData();
   void readFonts();

   // Farben
   QWidget *winColors;
   QComboBox *rxwin_color, *txwin_color, *status_color, *background_color;
   QCheckBox *qsowin_bold, *txwin_bold, *mark_bold;
   QComboBox *txtext_color, *txbackground_color;
   QComboBox *mark_color, *mark_background;
   // Allgemein
   QWidget *winGeneral;
   myNumLineEdit *rxwin, *txwin;
   QComboBox *rxwin_font, *txwin_font;
   QRadioButton *rxwintop, *rxwinbottom;
   QComboBox *qsowin_size, *txwin_size;
   // Sonstiges
   QWidget *winOthers;
   QLabel *percent;
   QSlider *slider;
   QCheckBox *closewinondisc, *hidewin, *localecho, *beepctrlg;
   QCheckBox *zeilenumbruch, *openchan;
   myNumLineEdit *position;
   QLabel *lUmbruch;
};



class CfgAway : public QDialog
{
   Q_OBJECT;
public:
   CfgAway();
   ~CfgAway();

public slots:
   void slotOkPressed();
   void slotAbortPressed();

private:
   void setupWindow();
   void saveData();
   void readData();

   QLineEdit *phone, *bed, *back_again, *away;
   QPushButton *btnok, *btnabort;
};


class CfgShortcut : public QDialog
{
   Q_OBJECT;
public:
   CfgShortcut();
   ~CfgShortcut();

public slots:
   void slotOkPressed();
   void slotAbortPressed();

private:
   void setupWindow();
   void saveData();
   void readData();

   QLineEdit *f_keys[12];
   QPushButton *btnok, *btnabort;
};



class CfgCallKey : public QDialog
{
   Q_OBJECT;
public:
   CfgCallKey();
   ~CfgCallKey();

public slots:
   void slotOkPressed();
   void slotAbortPressed();

private:
   void setupWindow();
   void saveData();
   void readData();

   QLineEdit *f_keys[10];
   QCheckBox *ssid[10];

   QPushButton *btnok, *btnabort;
};



class CfgFlags : public QDialog
{
   Q_OBJECT;
public:
   CfgFlags();
   ~CfgFlags();

public slots:
   void slotOkPressed();
   void slotAbortPressed();

private:
   void setupWindow();
   void saveData();
   void readData();

   QCheckBox *overwrite, *incssid, *didadit, *yappresume, *extraTransWin;

   QPushButton *btnok, *btnabort;
};



class CfgDirs : public QDialog
{
   Q_OBJECT;
public:
   CfgDirs();
   ~CfgDirs();

public slots:
   void slotOkPressed();
   void slotAbortPressed();

private:
   void setupWindow();
   void readData();

   QLineEdit *abin, *splus, *down, *up;

   QPushButton *btnok, *btnabort;
};


class CfgFiles : public QTabDialog
{
   Q_OBJECT;
public:
   CfgFiles();
   ~CfgFiles();

public slots:
   void slotOkPressed();
   void slotImportCText();
   void slotImportQText();
   void slotImportHelp();
   void slotImportInfo();
   void slotImportNews();

private:
   void createCTextTab();
   void createQTextTab();
   void createHelpTab();
   void createInfoTab();
   void createNewsTab();
   void readData();

   QMultiLineEdit *ctext, *qtext, *info, *help, *news;
   QPushButton *ctext_imp, *qtext_imp, *info_imp, *help_imp, *news_imp;
   QWidget *ctext_widg, *qtext_widg, *info_widg, *help_widg, *news_widg;
};


class CfgSound : public QDialog
{
   Q_OBJECT;
public:
   CfgSound();
   ~CfgSound();

public slots:
   void slotEnabled( bool active );
   void slotOkPressed();
   void slotAbortPressed();
   void slotSwitchEvent( int index );
   void slotSwitchSound( int index );
   void slotAddWAV();
   void slotPlayWAV();

private:
   void setupWindow();
   void saveData();
   void readData();
   int searchKlang( char *str );

   int zuordnung[20];
   char *aktDir;

   QCheckBox *enabled;
   QListBox *ereignisse, *klaenge;
   QLabel *lEreig, *lKlaenge;
   QPushButton *addWAV, *playWAV;

   QPushButton *btnok, *btnabort;
};



#endif // PREFERENCES_H

