/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <qfiledialog.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qkeycode.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <qdir.h>
#include <qstrlist.h>

#include <kmsgbox.h>

#include "preferences.h"
#include "main.h"

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>




#define BTNLENGTH 80
#define BTNHEIGHT 25


extern TopLevel *toplevel;

char long_colors[17][15] = { "black", "white", "darkgray", "gray", "lightgray",
                             "red", "green", "blue", "cyan", "magenta", "yellow",
                             "darkred", "darkgreen", "darkblue", "darkcyan",
                             "darkmagenta", "darkyellow" };


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////



CfgCalls::CfgCalls() : QDialog(0, "", TRUE)
{
   setFixedSize(410, 240);

   setCaption(klocale->translate("LinKT: Calls"));

   setupWindow();
   readData();
}


CfgCalls::~CfgCalls()
{
}


void CfgCalls::setupWindow()
{
   QButtonGroup *tmpbtngrp;
   int abstand;

   // TX-MyCall vorbereiten
   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 10, 10, 120, 50 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("TX-MyCall"));

   sendcall = new QLineEdit( tmpbtngrp );
   sendcall->setGeometry( 10, 20, 100, 20 );
   sendcall->setText( "" );
   sendcall->setMaxLength( 12 );


   // Listen-To-Calls
   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 10, 70, 190, 110 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("MyCalls"));

   listencalls = new QListBox ( tmpbtngrp );
   listencalls->setGeometry( 10, 20, 80, 80 );

   listencall = new QLineEdit ( tmpbtngrp );
   listencall->setGeometry( 100, 20, 80, 20 );
   listencall->setText("");
   connect(listencall, SIGNAL(returnPressed()), this, SLOT(addListenCall()));

   addlistenbtn = new QPushButton( tmpbtngrp );
   addlistenbtn->setGeometry( 120, 45, 40, 20 );
   addlistenbtn->setText("<-");
   connect(addlistenbtn, SIGNAL(clicked()), this, SLOT(addListenCall()));

   dellistenbtn = new QPushButton( tmpbtngrp );
   dellistenbtn->setGeometry( 100, 70, 80, 20 );
   dellistenbtn->setText( klocale->translate ("delete") );
   connect(dellistenbtn, SIGNAL(clicked()), this, SLOT(delListenCall()));



   // Disconnect-Calls
   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 210, 70, 190, 110 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("ignored calls"));

   disconcalls = new QListBox ( tmpbtngrp );
   disconcalls->setGeometry( 10, 20, 80, 80 );

   disconcall = new QLineEdit ( tmpbtngrp );
   disconcall->setGeometry( 100, 20, 80, 20 );
   disconcall->setText("");
   connect(disconcall, SIGNAL(returnPressed()), this, SLOT(addDisconCall()));

   adddisconbtn = new QPushButton( tmpbtngrp );
   adddisconbtn->setGeometry( 120, 45, 40, 20 );
   adddisconbtn->setText("<-");
   connect(adddisconbtn, SIGNAL(clicked()), this, SLOT(addDisconCall()));

   deldisconbtn = new QPushButton( tmpbtngrp );
   deldisconbtn->setGeometry( 100, 70, 80, 20 );
   deldisconbtn->setText( klocale->translate ("delete") );
   connect(deldisconbtn, SIGNAL(clicked()), this, SLOT(delDisconCall()));

   // OK- und Abbruch-Knopf
   abstand = (width()-(2*BTNLENGTH))/3;
   btnok = new QPushButton( this );
   btnok->setText( klocale->translate ("&Ok") );
   btnok->setGeometry(abstand, 200, BTNLENGTH, BTNHEIGHT);
   btnok->setDefault( true );
   connect(btnok, SIGNAL(clicked()), this, SLOT(slotOkPressed()));

   btnabort = new QPushButton( this );
   btnabort->setText( klocale->translate ("&Abort") );
   btnabort->setGeometry(abstand*2+BTNLENGTH, 200, BTNLENGTH, BTNHEIGHT);
   connect(btnabort, SIGNAL(clicked()), this, SLOT(slotAbortPressed()));
}


void CfgCalls::saveData()
{
   KConfig *kconfig;


   kconfig = mykapp->getConfig();

   kconfig->setGroup( "AX.25" );
   strcpy(config->send_mycall,sendcall->text());
   Gross(config->send_mycall);
   kconfig->writeEntry("sendcall",config->send_mycall);

   saveListenToCalls(kconfig);
   saveIgnoredCalls(kconfig);

   kconfig->sync();
}



void CfgCalls::saveListenToCalls(KConfig *kconfig)
{
   unsigned int i;
   s_listCalls *tmpcall,*tmpcall2,*saveCalls;
   char tmp[500];


   saveCalls = config->listento_calls;

//   tmpcall = config->listento_calls;
   config->listento_calls = NULL;
/*   while (tmpcall != NULL)
   {
      tmpcall2 = tmpcall;
      tmpcall = tmpcall->next;
      if (tmpcall2->call != NULL) free(tmpcall2->call);
      free(tmpcall2);
   }*/


   tmp[0] = '\0';
   for (i = 0; i < listencalls->count(); i++)
   {
      // Neuer Eintrag in die Liste
      if (config->listento_calls == NULL)
      {
         config->listento_calls = (s_listCalls *)malloc(sizeof(s_listCalls));
         tmpcall = config->listento_calls;
      }
      else
      {
         tmpcall = config->listento_calls;
         while (tmpcall->next != NULL) tmpcall = tmpcall->next;
         tmpcall->next = (s_listCalls *)malloc(sizeof(s_listCalls));
         tmpcall = tmpcall->next;
      }

      tmpcall->next = NULL;
      tmpcall->call = (char *) strdup(listencalls->text(i));

      // Wenn das neue Rufzeichen nicht in der alten Liste war, soll
      // auf dieses Call gelauscht werden.
      if (!callIsInList(tmpcall->call, saveCalls))
         addListenCallToPorts(tmpcall->call);

      if (tmp[0] == '\0')
         strcpy(tmp, tmpcall->call);
      else
      {
         strcat(tmp, ",");
         strcat(tmp, tmpcall->call);
      }
   }

   // Bei allen Calls, die in saveCalls, aber nicht in config->listento_calls
   // stehen, das lauschen abschalten.
   deleteDroppedCalls(config->listento_calls, saveCalls);

   tmpcall = saveCalls;
   while (tmpcall != NULL)
   {
      tmpcall2 = tmpcall;
      tmpcall = tmpcall->next;
      if (tmpcall2->call != NULL) free(tmpcall2->call);
      free(tmpcall2);
   }

   kconfig->writeEntry("listentocalls",tmp);
}


void CfgCalls::saveIgnoredCalls(KConfig *kconfig)
{
   unsigned int i;
   s_listCalls *tmpcall,*tmpcall2;
   char tmp[500];


   tmpcall = config->discon_calls;
   config->discon_calls = NULL;
   while (tmpcall != NULL)
   {
      tmpcall2 = tmpcall;
      tmpcall = tmpcall->next;
      if (tmpcall2->call != NULL) free(tmpcall2->call);
      free(tmpcall2);
   }


   tmp[0] = '\0';
   for (i = 0; i < disconcalls->count(); i++)
   {
      // Neuer Eintrag in die Liste
      if (config->discon_calls == NULL)
      {
         config->discon_calls = (s_listCalls *)malloc(sizeof(s_listCalls));
         tmpcall = config->discon_calls;
      }
      else
      {
         tmpcall = config->discon_calls;
         while (tmpcall->next != NULL) tmpcall = tmpcall->next;
         tmpcall->next = (s_listCalls *)malloc(sizeof(s_listCalls));
         tmpcall = tmpcall->next;
      }

      tmpcall->next = NULL;
      tmpcall->call = (char *) strdup(disconcalls->text(i));

      if (tmp[0] == '\0')
         strcpy(tmp, tmpcall->call);
      else
      {
         strcat(tmp, ",");
         strcat(tmp, tmpcall->call);
      }
   }

   kconfig->writeEntry("disconcalls",tmp);
}


void CfgCalls::readData()
{
   s_listCalls *tmpcall;


   // Calls in die entsprechenden Felder schreiben
   tmpcall = config->listento_calls;
   while (tmpcall != NULL)
   {
      listencalls->inSort( tmpcall->call);
      tmpcall = tmpcall->next;
   }

   tmpcall = config->discon_calls;
   while (tmpcall != NULL)
   {
      disconcalls->inSort( tmpcall->call);
      tmpcall = tmpcall->next;
   }

   sendcall->setText( config->send_mycall );
}


void CfgCalls::addListenCall()
{
   char tmp[20];

   strcpy(tmp,listencall->text());
   KillSpacesLeft(tmp);
   KillSpacesRight(tmp);
   Gross(tmp);

   if (tmp[0] != '\0')
      listencalls->inSort(tmp);

   listencall->setText("");
}


void CfgCalls::delListenCall()
{
   if (listencalls->currentItem() != -1)
      listencalls->removeItem(listencalls->currentItem());
}


void CfgCalls::addDisconCall()
{
   char tmp[20];

   strcpy(tmp,disconcall->text());
   KillSpacesLeft(tmp);
   KillSpacesRight(tmp);
   Gross(tmp);

   if (tmp[0] != '\0')
      disconcalls->inSort(tmp);

   disconcall->setText("");
}


void CfgCalls::delDisconCall()
{
   if (disconcalls->currentItem() != -1)
      disconcalls->removeItem(disconcalls->currentItem());
}


void CfgCalls::slotOkPressed()
{
   saveData();
   close();
}


void CfgCalls::slotAbortPressed()
{
   close();
}


//  void ConfigLinKT::deleteDroppedCalls(s_listCalls *akt, s_listCalls *old)
// Auf alle Calls, die in old aber nicht mehr in akt stehen, soll nicht
// mehr geachtet werden.
void CfgCalls::deleteDroppedCalls(s_listCalls *akt, s_listCalls *old)
{
   s_listCalls *tmpold, *tmpakt;
   bool found;

   tmpold = old;
   while (tmpold != NULL)
   {
      tmpakt = akt;
      found = false;
      while ((tmpakt != NULL) && !found)
      {
         if (!strcmp(tmpakt->call, tmpold->call)) found = true;
         tmpakt = tmpakt->next;
      }

      // Wenn dieses Rufzeichen in der neuen Liste nicht gefunden wurde,
      // wird es aus der ListenTo-Liste entfernt.
      if (!found)
         deleteListenCallToPorts(tmpold->call);

      tmpold = tmpold->next;
   }
}


bool CfgCalls::callIsInList(const char *call, s_listCalls *list)
{
   s_listCalls *tmp;

   tmp = list;
   while (tmp != NULL)
   {
      if (!strcmp(list->call, call))
         return true;
      tmp = tmp->next;
   }
   return false;
}


void CfgCalls::addListenCallToPorts(const char *call)
{
   s_ports *tmp;

   tmp = portlist;

   while (tmp != NULL)
   {
      if (tmp->ax25 != NULL)
         tmp->ax25->listenToCall(call);
      tmp = tmp->next;
   }
}


void CfgCalls::deleteListenCallToPorts(const char *call)
{
   s_ports *tmp;

   tmp = portlist;

   while (tmp != NULL)
   {
      if (tmp->ax25 != NULL)
         tmp->ax25->deleteListenTo(call);
      tmp = tmp->next;
   }
}


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


CfgPorts::CfgPorts() : QDialog(0, "", TRUE)
{
   setFixedSize(200, 240);

   setCaption(klocale->translate("LinKT: Ports"));

   setupWindow();
   readData();
}


CfgPorts::~CfgPorts()
{
}


void CfgPorts::setupWindow()
{
   QButtonGroup *tmpbtngrp;

   // Liste der vorhandenen Ports
   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 10, 20, 120, 170 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setTitle( klocale->translate ("available ports") );
   tmpbtngrp->setAlignment( 1 );

   ports = new QListBox( tmpbtngrp );
   ports->setGeometry(10,20,100,100);

   use = new QCheckBox( tmpbtngrp );
   use->setText( klocale->translate ("use") );
   use->setGeometry(10,130,100,20);

   // Signale
   connect(ports, SIGNAL(highlighted(int)), this, SLOT(select_port(int)));
   connect(use, SIGNAL(toggled(bool)), this, SLOT(select_useport(bool)));


   // OK- und Abbruch-Knopf
   int abstand = (width()-(2*BTNLENGTH))/3;
   btnok = new QPushButton( this );
   btnok->setText( klocale->translate ("&Ok") );
   btnok->setGeometry(abstand, 200, BTNLENGTH, BTNHEIGHT);
   btnok->setDefault( true );
   connect(btnok, SIGNAL(clicked()), this, SLOT(slotOkPressed()));

   btnabort = new QPushButton( this );
   btnabort->setText( klocale->translate ("&Abort") );
   btnabort->setGeometry(abstand*2+BTNLENGTH, 200, BTNLENGTH, BTNHEIGHT);
   connect(btnabort, SIGNAL(clicked()), this, SLOT(slotAbortPressed()));
}


void CfgPorts::select_port(int index)
{
   const char *name;
   s_ports *tmp;
   bool useport;


   name = ports->text(index);
   tmp = portlist;
   while ((tmp != NULL) && (strcmp(name,tmp->name)))
      tmp = tmp->next;

   if (tmp == NULL) return;

   useport = tmp->ax25 != NULL;
   if (tmp->umschalten) useport = !useport;

   use->setChecked(useport);
}


void CfgPorts::select_useport(bool btn)
{
   const char *name;
   s_ports *tmp;

   name = ports->text(ports->currentItem());
   tmp = portlist;
   while ((tmp != NULL) && (strcmp(name,tmp->name)))
      tmp = tmp->next;

   if (tmp == NULL)
   {
      tmp->umschalten = false;
      return;
   }

   tmp->umschalten = false;
   if (btn && (tmp->ax25 == NULL)) tmp->umschalten = true;
   if (!btn && (tmp->ax25 != NULL)) tmp->umschalten = true;
}


void CfgPorts::slotOkPressed()
{
   saveData();
   close();
}


void CfgPorts::slotAbortPressed()
{
   close();
}


void CfgPorts::saveData()
{
   KConfig *kconfig;
   char tmp[500],tmp2[500];
   int i;
   bool useport;
   s_ports *porttmp;


   kconfig = mykapp->getConfig();

   // Unter dem Punkt "use_ports" werden die Namen aller Ports, die
   // benutzt werden sollen, aufgefuehrt.
   tmp[0] = '\0';
   i = 0;
   porttmp = portlist;
   while (porttmp != NULL)
   {
      useport = porttmp->ax25 != NULL;
      if (porttmp->umschalten) useport = !useport;

      if (useport)
      {
         if (tmp[0] == '\0')
            strcpy(tmp,porttmp->name);
         else
         {
            sprintf(tmp2,",%s",porttmp->name);
            strcat(tmp,tmp2);
         }
      }
      porttmp = porttmp->next;
      i++;
   }

   kconfig->setGroup("AX.25");
   kconfig->writeEntry("ports",tmp);

   kconfig->sync();
}


void CfgPorts::readData()
{
   s_ports *portstmp;



   // Die Liste der vorhandenen Ports in die ports-Liste schreiben
   portstmp = portlist;
   portcount = 0;
   while (portstmp != NULL)
   {
      ports->insertItem(portstmp->name);
      portcount++;
      portstmp = portstmp->next;
   }
   if (portlist != NULL)
   {
      ports->setCurrentItem(0);
      use->setChecked(portlist->ax25 != NULL);
   }
}



////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////



CfgScreen::CfgScreen() : QTabDialog(0, "", TRUE)
{
   setCaption(klocale->translate("LinKT: Screen-Configuration"));

   setupWindowGeneral();
   addTab(winGeneral, klocale->translate("&General"));

   setupWindowColors();
   addTab(winColors, klocale->translate("&Colors"));

   setupWindowOthers();
   addTab(winOthers, klocale->translate("&Others"));

   readData();
   setFixedSize(450,280);

   setCancelButton();

   connect( this, SIGNAL(applyButtonPressed()), SLOT(saveData()));
}


CfgScreen::~CfgScreen()
{
}


void CfgScreen::setupWindowColors()
{
   winColors = new QWidget( this );

   QButtonGroup *tmpbtngrp;
   QLabel *l;


   tmpbtngrp = new QButtonGroup( winColors );
   tmpbtngrp->setGeometry( 10, 10, 190, 125 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("Colors QSO-Win"));

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 20, 80, 20 );
   l->setText(klocale->translate ("RX-Text") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 40, 80, 20 );
   l->setText(klocale->translate ("TX-Text") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 60, 80, 20 );
   l->setText(klocale->translate ("Status") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 80, 80, 20 );
   l->setText(klocale->translate ("Background") );


   rxwin_color = new QComboBox( tmpbtngrp );
   rxwin_color->setGeometry( 90, 20, 90, 20 );

   txwin_color = new QComboBox( tmpbtngrp );
   txwin_color->setGeometry( 90, 40, 90, 20 );

   status_color = new QComboBox( tmpbtngrp );
   status_color->setGeometry( 90, 60, 90, 20 );

   background_color = new QComboBox( tmpbtngrp );
   background_color->setGeometry( 90, 80, 90, 20 );

   qsowin_bold = new QCheckBox( tmpbtngrp );
   qsowin_bold->setGeometry( 90, 100, 90, 20 );
   qsowin_bold->setText( klocale->translate ("bold font") );



   tmpbtngrp = new QButtonGroup( winColors );
   tmpbtngrp->setGeometry( 210, 10, 190, 85 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("Colors TX-Win"));

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 20, 80, 20 );
   l->setText(klocale->translate ("Text") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 40, 80, 20 );
   l->setText(klocale->translate ("Background") );

   txtext_color = new QComboBox( tmpbtngrp );
   txtext_color->setGeometry( 90, 20, 90, 20 );

   txbackground_color = new QComboBox( tmpbtngrp );
   txbackground_color->setGeometry( 90, 40, 90, 20 );

   txwin_bold = new QCheckBox( tmpbtngrp );
   txwin_bold->setGeometry( 90, 60, 90, 20 );
   txwin_bold->setText( klocale->translate ("bold font") );



   tmpbtngrp = new QButtonGroup( winColors );
   tmpbtngrp->setGeometry( 210, 105, 190, 85 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("Colors marked text"));

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 20, 80, 20 );
   l->setText(klocale->translate ("Text") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 40, 80, 20 );
   l->setText(klocale->translate ("Background") );

   mark_color = new QComboBox( tmpbtngrp );
   mark_color->setGeometry( 90, 20, 90, 20 );

   mark_background = new QComboBox( tmpbtngrp );
   mark_background->setGeometry( 90, 40, 90, 20 );

   mark_bold = new QCheckBox( tmpbtngrp );
   mark_bold->setGeometry( 90, 60, 90, 20 );
   mark_bold->setText( klocale->translate ("bold font") );
}


void CfgScreen::readData()
{
   int i;
   char tmp[500];

   // Farben
   for (i=0;i<17;i++)
   {
      rxwin_color->insertItem( klocale->translate(long_colors[i]) );
      txwin_color->insertItem( klocale->translate(long_colors[i]) );
      status_color->insertItem( klocale->translate(long_colors[i]) );
      background_color->insertItem( klocale->translate(long_colors[i]) );
      txtext_color->insertItem( klocale->translate(long_colors[i]) );
      txbackground_color->insertItem( klocale->translate(long_colors[i]) );
      mark_color->insertItem( klocale->translate(long_colors[i]) );
      mark_background->insertItem( klocale->translate(long_colors[i]) );
   }

   rxwin_color->setCurrentItem( config->colors->rxText );
   txwin_color->setCurrentItem( config->colors->txText );
   status_color->setCurrentItem( config->colors->statusText );
   background_color->setCurrentItem( config->colors->background );
   txtext_color->setCurrentItem( config->colors->txwin );
   txbackground_color->setCurrentItem( config->colors->txbackground );
   mark_color->setCurrentItem( config->colors->qsoWinMarkColor );
   mark_background->setCurrentItem( config->colors->qsoWinMarkBack );

   qsowin_bold->setChecked( config->colors->qsowin_bold );
   txwin_bold->setChecked( config->colors->txwin_bold );
   mark_bold->setChecked( config->colors->mark_bold );


   // Puffergroessen
   sprintf(tmp,"%i",config->tx_buffersize);
   txwin->setText(tmp);
   sprintf(tmp,"%i",config->rx_buffersize);
   rxwin->setText(tmp);


   // Schriften richtig eintragen
   readFonts();


   // Fenstergroessen
   for (i=8;i<=20;i++)
   {
      sprintf(tmp,"%i",i);
      qsowin_size->insertItem(tmp);
      txwin_size->insertItem(tmp);
      if (config->qsofontsize == i)
         qsowin_size->setCurrentItem(qsowin_size->count()-1);
      if (config->txfontsize == i)
         txwin_size->setCurrentItem(txwin_size->count()-1);
   }
   for (i=22;i<=48;i=i+2)
   {
      sprintf(tmp,"%i",i);
      qsowin_size->insertItem(tmp);
      txwin_size->insertItem(tmp);
      if (config->qsofontsize == i)
         qsowin_size->setCurrentItem(qsowin_size->count()-1);
      if (config->txfontsize == i)
         txwin_size->setCurrentItem(txwin_size->count()-1);
   }

   // TX- oder RX-Fenster im QSO-Fenster oben?
   rxwinbottom->setChecked( config->txWinOben );
   rxwintop->setChecked( !config->txWinOben );

   // Flags
   closewinondisc->setChecked( config->closeWinOnDisc );
   hidewin->setChecked( config->hideWinOnSwitch );
   localecho->setChecked( config->localEcho );
   beepctrlg->setChecked( config->beepCtrlG );
   openchan->setChecked( config->openChannelWin );

   // Zeilenumbruch
   zeilenumbruch->setChecked( config->zeilenumbruch );
   if (!config->zeilenumbruch)
   {
      lUmbruch->setEnabled( false );
      position->setEnabled( false );
   }
   sprintf(tmp, "%i", config->umbruchpos);
   position->setText( tmp );
}


void CfgScreen::saveData()
{
   KConfig *kconfig;
   char tmp[500];


   kconfig = mykapp->getConfig();


   kconfig->setGroup( "Colors" );

   config->colors->rxText = rxwin_color->currentItem();
   sprintf(tmp,"%i",config->colors->rxText);
   kconfig->writeEntry("receive",tmp);

   config->colors->txText = txwin_color->currentItem();
   sprintf(tmp,"%i",config->colors->txText);
   kconfig->writeEntry("transmit",tmp);

   config->colors->statusText = status_color->currentItem();
   sprintf(tmp,"%i",config->colors->statusText);
   kconfig->writeEntry("status",tmp);

   config->colors->background = background_color->currentItem();
   sprintf(tmp,"%i",config->colors->background);
   kconfig->writeEntry("background",tmp);

   config->colors->txwin = txtext_color->currentItem();
   sprintf(tmp,"%i",config->colors->txwin);
   kconfig->writeEntry("txwin",tmp);

   config->colors->txbackground = txbackground_color->currentItem();
   sprintf(tmp,"%i",config->colors->txbackground);
   kconfig->writeEntry("txbackground",tmp);

   config->colors->qsoWinMarkColor = mark_color->currentItem();
   sprintf(tmp,"%i",config->colors->qsoWinMarkColor);
   kconfig->writeEntry("qsoMarkColor",tmp);

   config->colors->qsoWinMarkBack = mark_background->currentItem();
   sprintf(tmp,"%i",config->colors->qsoWinMarkBack);
   kconfig->writeEntry("qsoMarkBackground",tmp);



   if (qsowin_bold->isChecked())
   {
      kconfig->writeEntry("qsoWinBold","1");
      config->colors->qsowin_bold = true;
   }
   else
   {
      kconfig->writeEntry("qsoWinBold","0");
      config->colors->qsowin_bold = false;
   }

   if (txwin_bold->isChecked())
   {
      kconfig->writeEntry("txWinBold","1");
      config->colors->txwin_bold = true;
   }
   else
   {
      kconfig->writeEntry("txWinBold","0");
      config->colors->txwin_bold = false;
   }

   if (mark_bold->isChecked())
   {
      kconfig->writeEntry("qsoMarkBold","1");
      config->colors->mark_bold = true;
   }
   else
   {
      kconfig->writeEntry("qsoMarkBold","0");
      config->colors->mark_bold = false;
   }


   kconfig->setGroup("Screen");

   kconfig->writeEntry("rxfont", rxwin_font->currentText());
   if (config->rxfontstr != NULL)
      free(config->rxfontstr);
   config->rxfontstr = (char *) strdup(rxwin_font->currentText());
   config->rx_font->setFamily(config->rxfontstr);

   kconfig->writeEntry("txfont", txwin_font->currentText());
   if (config->txfontstr != NULL)
      free(config->txfontstr);
   config->txfontstr = (char *) strdup(txwin_font->currentText());
   config->tx_font->setFamily(config->txfontstr);

   // Schriftgroessen
   config->qsofontsize = atoi(qsowin_size->currentText());
   config->txfontsize = atoi(txwin_size->currentText());
   kconfig->writeEntry("qsofontsize", qsowin_size->currentText());
   kconfig->writeEntry("txfontsize", txwin_size->currentText());


   // Groesse des Vorschreibfensters
   config->txWinSize = slider->value();
   sprintf(tmp,"%i", config->txWinSize);
   kconfig->writeEntry("txWinSize", config->txWinSize);


   // TX- oder RX-Fenster im QSO-Fenster oben?
   if (rxwinbottom->isChecked())
   {
      kconfig->writeEntry("txWinOben", "1");
      config->txWinOben = true;
   }
   else
   {
      kconfig->writeEntry("txWinOben", "0");
      config->txWinOben = false;
   }

   // Kanal-Fenster beim Disconnect schliessen?
   if (closewinondisc->isChecked())
   {
      config->closeWinOnDisc = true;
      kconfig->writeEntry("closeWinOnDisc","1");
   }
   else
   {
      config->closeWinOnDisc = false;
      kconfig->writeEntry("closeWinOnDisc","0");
   }

   // Kanal-Fenster beim Kanalwechsel verstecken
   if (hidewin->isChecked())
   {
      config->hideWinOnSwitch = true;
      kconfig->writeEntry("hideWinOnSwitch","1");
   }
   else
   {
      config->hideWinOnSwitch = false;
      kconfig->writeEntry("hideWinOnSwitch","0");
   }

   // lokal echo?
   if (localecho->isChecked())
   {
      config->localEcho = true;
      kconfig->writeEntry("localEcho","1");
   }
   else
   {
      config->localEcho = false;
      kconfig->writeEntry("localEcho","0");
   }

   // Piepen, wenn CTRL-G empfangen wurde?
   if (beepctrlg->isChecked())
   {
      config->beepCtrlG = true;
      kconfig->writeEntry("beepCtrlG","1");
   }
   else
   {
      config->beepCtrlG = false;
      kconfig->writeEntry("beepCtrlG","0");
   }


   if (openchan->isChecked())
   {
      config->openChannelWin = true;
      kconfig->writeEntry("openChannelWin","1");
   }
   else
   {
      config->openChannelWin = false;
      kconfig->writeEntry("openChannelWin","0");
   }


   // Zeilenumbruch
   if (zeilenumbruch->isChecked())
   {
      kconfig->writeEntry("lineBreak","1");
      config->zeilenumbruch = true;
      // Position des Zeilenumbruchs
      config->umbruchpos = atoi(position->text());
      kconfig->writeEntry("lineBreakPos",position->text());
   }
   else
   {
      kconfig->writeEntry("lineBreak","0");
      config->zeilenumbruch = false;
   }


   kconfig->setGroup("Buffersizes" );

   kconfig->writeEntry("receive",rxwin->text());
   config->rx_buffersize = atoi(rxwin->text());
   kconfig->writeEntry("transmit",txwin->text());
   config->tx_buffersize = atoi(txwin->text());


   kconfig->sync();
}


void CfgScreen::setupWindowGeneral()
{
   winGeneral = new QWidget(this);

   QLabel *l;
   QButtonGroup *tmpbtngrp;


   tmpbtngrp = new QButtonGroup( winGeneral );
   tmpbtngrp->setGeometry( 10, 10, 200, 70 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("Buffersizes"));

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 20, 60, 20 );
   l->setText(klocale->translate ("QSO-Win") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 40, 60, 20 );
   l->setText(klocale->translate ("TX-Win") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 150, 20, 40, 20 );
   l->setText(klocale->translate ("lines") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 150, 40, 40, 20 );
   l->setText(klocale->translate ("lines") );

   rxwin = new myNumLineEdit( tmpbtngrp );
   rxwin->setGeometry( 80, 20, 60, 20 );
   rxwin->setMaxLength( 5 );

   txwin = new myNumLineEdit( tmpbtngrp );
   txwin->setGeometry( 80, 40, 60, 20 );
   txwin->setMaxLength( 4 );



   tmpbtngrp = new QButtonGroup( winGeneral );
   tmpbtngrp->setGeometry( 10, 90, 200, 70 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("Fonts"));

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 20, 60, 20 );
   l->setText(klocale->translate ("QSO-Win") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 40, 60, 20 );
   l->setText(klocale->translate ("TX-Win") );

   rxwin_font = new QComboBox( tmpbtngrp );
   rxwin_font->setGeometry( 80, 20, 110, 20 );

   txwin_font = new QComboBox( tmpbtngrp );
   txwin_font->setGeometry( 80, 40, 110, 20 );




   tmpbtngrp = new QButtonGroup( winGeneral );
   tmpbtngrp->setGeometry( 220, 10, 190, 70 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("QSO-Window"));

   rxwintop = new QRadioButton( tmpbtngrp );
   rxwintop->setGeometry( 10, 20, 170, 20 );
   rxwintop->setText( klocale->translate("QSO-Window top") );
   tmpbtngrp->insert( rxwintop );

   rxwinbottom = new QRadioButton( tmpbtngrp );
   rxwinbottom->setGeometry( 10, 40, 170, 20 );
   rxwinbottom->setText( klocale->translate("QSO-Window bottom") );
   tmpbtngrp->insert( rxwinbottom );




   tmpbtngrp = new QButtonGroup( winGeneral );
   tmpbtngrp->setGeometry( 220, 90, 190, 70 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("Fontsizes"));

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 20, 90, 20 );
   l->setText( klocale->translate("QSO-Win") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 40, 90, 20 );
   l->setText( klocale->translate("TX-Win") );

   qsowin_size = new QComboBox( tmpbtngrp );
   qsowin_size->setGeometry( 90, 20, 80, 20 );

   txwin_size = new QComboBox( tmpbtngrp );
   txwin_size->setGeometry( 90, 40, 80, 20 );
}


//   void ConfigLinKT::readFonts()
//
// Liest eine Liste aller Schriften ein, die unter X11 bekannt sind.
void CfgScreen::readFonts()
{
   Display *kde_display;
   char **fontNames;
   char **fontNames_copy;
   int numFonts,k;
   QString qfontname;
   QStrList fontlist(true);
   bool foundrx=false,foundtx=false;


   kde_display = XOpenDisplay( NULL );

   fontNames = XListFonts(kde_display, "*", 32767, &numFonts);
   fontNames_copy = fontNames;

   for (k=0;k<numFonts;k++)
   {
      if (**fontNames != '-')   // Fontnamen starten nicht mit einem Minus-Zeichen -> ein Alias
      {
         fontNames++;
         continue;
      }

      qfontname = "";
      qfontname = *fontNames;
      int dash = qfontname.find('-',1,true);    // Find next dash

      if (dash == -1)  // Kein weiterer Strich. Das sollte eigentlich nicht
      {                // passieren. Ueberspringen.
         fontNames++;
         continue;
      }

      int dash_two = qfontname.find('-', dash+1, true);

      if (dash == -1)  // Kein weiterer Strich. Das sollte eigentlich nicht
      {                // passieren. Ueberspringen.
         fontNames++;
         continue;
      }

      // Font family name aus dem font-info-string holen
      qfontname = qfontname.mid(dash+1, dash_two-dash-1);

      if (fontlist.find(qfontname) == -1)
         fontlist.inSort(qfontname);

      fontNames++;

   }

   XFreeFontNames(fontNames_copy);
   XCloseDisplay(kde_display);

   k = 0;
   for (fontlist.first(); fontlist.current(); fontlist.next())
   {
      rxwin_font->insertItem(fontlist.current());
      txwin_font->insertItem(fontlist.current());

      if (!strcmp(fontlist.current(),config->rxfontstr))
      {
         rxwin_font->setCurrentItem( k );
         foundrx = true;
      }
      if (!strcmp(fontlist.current(),config->txfontstr))
      {
         txwin_font->setCurrentItem( k );
         foundtx = true;
      }
      if (!strcmp(fontlist.current(),"courier"))
      {
         if (!foundrx)
            rxwin_font->setCurrentItem( k );
         if (!foundtx)
            txwin_font->setCurrentItem( k );
      }

      k++;
   }
}


void CfgScreen::setupWindowOthers()
{
   QButtonGroup *tmpbtngrp;
   QLabel *l;

   winOthers = new QWidget(this);

   tmpbtngrp = new QButtonGroup( winOthers );
   tmpbtngrp->setGeometry( 10, 10, 200, 80 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("TX-Window-Size"));

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 20, 20, 20 );
   l->setText( "0%" );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 150, 20, 40, 20 );
   l->setText( "100%" );
   l->setAlignment( AlignRight );

   percent = new QLabel( tmpbtngrp );
   percent->setGeometry( 50, 55, 100, 20 );
   percent->setText( "0%" );
   percent->setAlignment( AlignCenter );
   slotSliderMoved(config->txWinSize);

   slider = new QSlider( 0, 100, 1, config->txWinSize, QSlider::Horizontal, tmpbtngrp );
   slider->setGeometry( 10, 40, 180, 10 );
   connect(slider, SIGNAL(valueChanged(int)), SLOT(slotSliderMoved(int)));


   // Zeilenumbruch
   tmpbtngrp = new QButtonGroup( winOthers );
   tmpbtngrp->setGeometry( 220, 10, 200, 80 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("line-break"));


   zeilenumbruch = new QCheckBox( tmpbtngrp );
   zeilenumbruch->setGeometry( 10, 25, 180, 20 );
   zeilenumbruch->setText( klocale->translate ("automatic line-break") );
   connect(zeilenumbruch, SIGNAL(toggled(bool)), this, SLOT(slotToggleUmbruch(bool)));

   lUmbruch = new QLabel( tmpbtngrp );
   lUmbruch->setGeometry( 30, 45, 60, 20 );
   lUmbruch->setText( klocale->translate ("in row") );
   lUmbruch->resize(lUmbruch->sizeHint());

   position = new myNumLineEdit( tmpbtngrp );
   position->setGeometry( 35+lUmbruch->width(), 45, 50, 20);
   position->setMaxLength( 3 );



   closewinondisc = new QCheckBox( winOthers );
   closewinondisc->setGeometry( 10, 100, 280, 20 );
   closewinondisc->setText( klocale->translate ("close window on disconnect") );

   hidewin = new QCheckBox( winOthers );
   hidewin->setGeometry( 10, 120, 280, 20 );
   hidewin->setText( klocale->translate ("hide window if you switch channel") );

   localecho = new QCheckBox( winOthers );
   localecho->setGeometry( 10, 140, 280, 20 );
   localecho->setText( klocale->translate ("local echo") );

   beepctrlg = new QCheckBox( winOthers );
   beepctrlg->setGeometry( 10, 160, 280, 20 );
   beepctrlg->setText( klocale->translate ("beep on ctrl-g") );

   openchan = new QCheckBox( winOthers );
   openchan->setGeometry( 10, 180, 280, 20 );
   openchan->setText( klocale->translate ("open channel-window immediately") );
}


void CfgScreen::slotSliderMoved(int value)
{
   char tmp[50];

   sprintf(tmp, "%i%%", value);
   percent->setText(tmp);
}


void CfgScreen::slotToggleUmbruch(bool active)
{
   position->setEnabled( active );
   lUmbruch->setEnabled( active );
}


///////////////////////////////////////////////////////////////////
// myNumLineEdit
///////////////////////////////////////////////////////////////////
// Eingabe-Widget, das nur Integer-Zahlen zulaesst - keine
// Buchstaben etc
///////////////////////////////////////////////////////////////////


myNumLineEdit::myNumLineEdit( QWidget *parent = 0, const char *name=0 )
                       : QLineEdit(parent,name)
{
}


void myNumLineEdit::keyPressEvent( QKeyEvent *e)
{
   // Nur Tasten zwischen 0 und 9 sowie Return zulassen
   if (e->key() >= Key_A && e->key() <= Key_Z)
   {
      // Keine erlaubte Taste->piepen
      QApplication::beep();
      return;
   }

   QLineEdit::keyPressEvent( e );
}


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


CfgAway::CfgAway() : QDialog(0, "", TRUE)
{
   setFixedSize(440, 165);

   setCaption(klocale->translate("LinKT: Away-Settings"));

   setupWindow();
   readData();
}


CfgAway::~CfgAway()
{
}


void CfgAway::setupWindow()
{
   QButtonGroup *tmpbtngrp;
   QLabel *l;

   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 10, 10, 420, 110 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("Away-Texts"));

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 20, 80, 20 );
   l->setText( klocale->translate("on the phone") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 40, 80, 20 );
   l->setText( klocale->translate("in bed") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 60, 80, 20 );
   l->setText( klocale->translate("back again") );

   l = new QLabel( tmpbtngrp );
   l->setGeometry( 10, 80, 80, 20 );
   l->setText( klocale->translate("away") );


   phone = new QLineEdit( tmpbtngrp );
   phone->setGeometry( 90, 20, 310, 20 );
   phone->setText( "" );

   bed = new QLineEdit( tmpbtngrp );
   bed->setGeometry( 90, 40, 310, 20 );
   bed->setText( "" );

   back_again = new QLineEdit( tmpbtngrp );
   back_again->setGeometry( 90, 60, 310, 20 );
   back_again->setText( "" );

   away = new QLineEdit( tmpbtngrp );
   away->setGeometry( 90, 80, 310, 20 );
   away->setText( "" );


   // OK- und Abbruch-Knopf
   int abstand = (width()-(2*BTNLENGTH))/3;
   btnok = new QPushButton( this );
   btnok->setText( klocale->translate ("&Ok") );
   btnok->setGeometry(abstand, 130, BTNLENGTH, BTNHEIGHT);
   btnok->setDefault( true );
   connect(btnok, SIGNAL(clicked()), this, SLOT(slotOkPressed()));

   btnabort = new QPushButton( this );
   btnabort->setText( klocale->translate ("&Abort") );
   btnabort->setGeometry(abstand*2+BTNLENGTH, 130, BTNLENGTH, BTNHEIGHT);
   connect(btnabort, SIGNAL(clicked()), this, SLOT(slotAbortPressed()));
}


void CfgAway::saveData()
{
   KConfig *kconfig;


   kconfig = mykapp->getConfig();

   // Away-Text speichern
   kconfig->setGroup("Away");

   free(config->away.phone);
   config->away.phone = (char *) strdup( phone->text() );
   kconfig->writeEntry("phone", config->away.phone);

   free(config->away.bed);
   config->away.bed = (char *) strdup( bed->text() );
   kconfig->writeEntry("bed", config->away.bed);

   free(config->away.back);
   config->away.back = (char *) strdup( back_again->text() );
   kconfig->writeEntry("back", config->away.back);

   free(config->away.away);
   config->away.away = (char *) strdup( away->text() );
   kconfig->writeEntry("away", config->away.away);


   kconfig->sync();
}


void CfgAway::readData()
{
   // Away-Texte
   phone->setText(config->away.phone);
   bed->setText(config->away.bed);
   back_again->setText(config->away.back);
   away->setText(config->away.away);
}


void CfgAway::slotOkPressed()
{
   saveData();
   close();
}


void CfgAway::slotAbortPressed()
{
   close();
}



////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


CfgShortcut::CfgShortcut() : QDialog(0, "", TRUE)
{
   setFixedSize(340, 290);

   setCaption(klocale->translate("LinKT: Shortcut-Settings"));

   setupWindow();
   readData();
}


CfgShortcut::~CfgShortcut()
{
}


void CfgShortcut::setupWindow()
{
   QButtonGroup *tmpbtngrp;
   QLabel *l;
   int i,y;
   char tmp[20];

   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 10, 10, 320, 230 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("Shortcuts"));

   y = 20;
   for (i=0;i<10;i++)
   {
      l = new QLabel( tmpbtngrp );
      l->setGeometry( 10, y, 75, 20 );
      sprintf(tmp, "CTRL+%i", i);
      l->setText( tmp );

      f_keys[i] = new QLineEdit( tmpbtngrp );
      f_keys[i]->setGeometry( 80, y, 230, 20 );
      f_keys[i]->setText( "" );

      y += 20;
   }


   // OK- und Abbruch-Knopf
   int abstand = (width()-(2*BTNLENGTH))/3;
   btnok = new QPushButton( this );
   btnok->setText( klocale->translate ("&Ok") );
   btnok->setGeometry(abstand, 250, BTNLENGTH, BTNHEIGHT);
   btnok->setDefault( true );
   connect(btnok, SIGNAL(clicked()), this, SLOT(slotOkPressed()));

   btnabort = new QPushButton( this );
   btnabort->setText( klocale->translate ("&Abort") );
   btnabort->setGeometry(abstand*2+BTNLENGTH, 250, BTNLENGTH, BTNHEIGHT);
   connect(btnabort, SIGNAL(clicked()), this, SLOT(slotAbortPressed()));
}


void CfgShortcut::saveData()
{
   KConfig *kconfig;
   int i;
   char tmp[50];


   kconfig = mykapp->getConfig();

   // Away-Text speichern
   kconfig->setGroup("Shortcuts");
   for (i=0;i<10;i++)
   {
      if (config->shortcuts[i] != NULL)
         free(config->shortcuts[i]);

      if (f_keys[i]->text()[0] != '\0')
         config->shortcuts[i] = (char *) strdup(f_keys[i]->text());
      else
         config->shortcuts[i] = NULL;

      sprintf(tmp, "CTRL+%i", i);
      kconfig->writeEntry(tmp, f_keys[i]->text());
   }


   kconfig->sync();
}


void CfgShortcut::readData()
{
   int i;

   for (i=0;i<10;i++)
      if (config->shortcuts[i] != NULL)
         f_keys[i]->setText(config->shortcuts[i]);
      else
         f_keys[i]->setText("");
}


void CfgShortcut::slotOkPressed()
{
   saveData();
   close();
}


void CfgShortcut::slotAbortPressed()
{
   close();
}



////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


CfgCallKey::CfgCallKey() : QDialog(0, "", TRUE)
{
   setFixedSize(230, 290);

   setCaption(klocale->translate("LinKT: CallKey-Settings"));

   setupWindow();
   readData();
}


CfgCallKey::~CfgCallKey()
{
}


void CfgCallKey::setupWindow()
{
   QButtonGroup *tmpbtngrp;
   QLabel *l;
   int i,y;
   char tmp[20];

   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 10, 10, 210, 230 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );
   tmpbtngrp->lower();
   tmpbtngrp->setTitle(klocale->translate ("CallKeys"));

   y = 20;
   for (i=0;i<10;i++)
   {
      l = new QLabel( tmpbtngrp );
      l->setGeometry( 10, y, 30, 20 );
      sprintf(tmp, "F%i", i+1);
      l->setText( tmp );

      f_keys[i] = new QLineEdit( tmpbtngrp );
      f_keys[i]->setGeometry( 40, y, 100, 20 );
      f_keys[i]->setText( "" );
      f_keys[i]->setMaxLength( 10 );

      ssid[i] = new QCheckBox( tmpbtngrp );
      ssid[i]->setText("ssid");
      ssid[i]->setGeometry(150, y, 50, 20);

      y += 20;
   }


   // OK- und Abbruch-Knopf
   int abstand = (width()-(2*BTNLENGTH))/3;
   btnok = new QPushButton( this );
   btnok->setText( klocale->translate ("&Ok") );
   btnok->setGeometry(abstand, 250, BTNLENGTH, BTNHEIGHT);
   btnok->setDefault( true );
   connect(btnok, SIGNAL(clicked()), this, SLOT(slotOkPressed()));

   btnabort = new QPushButton( this );
   btnabort->setText( klocale->translate ("&Abort") );
   btnabort->setGeometry(abstand*2+BTNLENGTH, 250, BTNLENGTH, BTNHEIGHT);
   connect(btnabort, SIGNAL(clicked()), this, SLOT(slotAbortPressed()));
}


void CfgCallKey::saveData()
{
   KConfig *kconfig;
   int i,k;
   char tmp[50];


   kconfig = mykapp->getConfig();

   kconfig->setGroup("CallKey");
   for (i=0;i<10;i++)
   {
      if (config->callKey[i] != NULL)
         free(config->callKey[i]);

      if (f_keys[i]->text()[0] != '\0')
      {
         config->callKey[i] = (s_callKey *) malloc(sizeof(s_callKey));
         strcpy(config->callKey[i]->call, f_keys[i]->text());
         config->callKey[i]->ssid = ssid[i]->isChecked();

         if (!config->callKey[i]->ssid)
            if ((k = POS('-', config->callKey[i]->call)) > -1)
               config->callKey[i]->call[k] = '\0';

         Gross(config->callKey[i]->call);
      }
      else
         config->callKey[i] = NULL;

      sprintf(tmp, "F%i", i);
      kconfig->writeEntry(tmp, config->callKey[i]->call);

      sprintf(tmp,"ssid%i", i);
      if (ssid[i]->isChecked())
         kconfig->writeEntry(tmp, "1");
      else
         kconfig->writeEntry(tmp, "0");
   }

   kconfig->sync();
}


void CfgCallKey::readData()
{
   int i;

   for (i=0;i<10;i++)
      if (config->callKey[i] != NULL)
      {
         f_keys[i]->setText( config->callKey[i]->call );
         ssid[i]->setChecked( config->callKey[i]->ssid );
      }
}


void CfgCallKey::slotOkPressed()
{
   saveData();
   close();
}


void CfgCallKey::slotAbortPressed()
{
   close();
}





////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


CfgFlags::CfgFlags() : QDialog(0, "", TRUE)
{
   setCaption(klocale->translate("LinKT: Flags"));

   setupWindow();
   readData();
}


CfgFlags::~CfgFlags()
{
   delete overwrite;
   delete incssid;
   delete btnok;
   delete btnabort;
   delete extraTransWin;
}


void CfgFlags::setupWindow()
{
   int w;

   
   overwrite = new QCheckBox( this );
   overwrite->setText( klocale->translate( "overwrite existing files") );
   overwrite->move( 10, 10 );
   overwrite->resize( overwrite->sizeHint() );
   w = overwrite->width();

   incssid = new QCheckBox( this );
   incssid->setText( klocale->translate( "increment SSID") );
   incssid->move( 10, 30 );
   incssid->resize( incssid->sizeHint() );
   if (incssid->width() > w) w = incssid->width();


   yappresume = new QCheckBox( this );
   yappresume->setText( klocale->translate( "Activate YAPP-resume?") );
   yappresume->move( 10, 50 );
   yappresume->resize( yappresume->sizeHint() );
   if (yappresume->width() > w) w = yappresume->width();


   extraTransWin = new QCheckBox( this );
   extraTransWin->setText( klocale->translate( "Open extra transfer-window?") );
   extraTransWin->move( 10, 70 );
   extraTransWin->resize( extraTransWin->sizeHint() );
   if (extraTransWin->width() > w) w = extraTransWin->width();
   // disablen
   extraTransWin->setEnabled( false );




   setFixedSize(w+20, 170);


   // OK- und Abbruch-Knopf
   int abstand = (width()-(2*BTNLENGTH))/3;
   btnok = new QPushButton( this );
   btnok->setText( klocale->translate ("&Ok") );
   btnok->setGeometry(abstand, height()-30, BTNLENGTH, BTNHEIGHT);
   btnok->setDefault( true );
   connect(btnok, SIGNAL(clicked()), this, SLOT(slotOkPressed()));

   btnabort = new QPushButton( this );
   btnabort->setText( klocale->translate ("&Abort") );
   btnabort->setGeometry(abstand*2+BTNLENGTH, height()-30, BTNLENGTH, BTNHEIGHT);
   connect(btnabort, SIGNAL(clicked()), this, SLOT(slotAbortPressed()));
}


void CfgFlags::saveData()
{
   KConfig *kconfig;


   kconfig = mykapp->getConfig();

   kconfig->setGroup("CallKey");


   if (overwrite->isChecked())
   {
      kconfig->writeEntry("overwriteExisting","1");
      config->overwriteExisting = true;
   }
   else
   {
      kconfig->writeEntry("overwriteExisting","0");
      config->overwriteExisting = false;
   }

   if (incssid->isChecked())
   {
      kconfig->writeEntry("autoIncSSID","1");
      config->autoIncSSID = true;
   }
   else
   {
      kconfig->writeEntry("autoIncSSID","0");
      config->autoIncSSID = false;
   }


   kconfig->setGroup( "AX.25" );
   if (yappresume->isChecked())
   {
      kconfig->writeEntry("yappResume","1");
      config->yappResume = true;
   }
   else
   {
      kconfig->writeEntry("yappResume","0");
      config->yappResume = false;
   }

   if (extraTransWin->isChecked())
   {
      kconfig->writeEntry("extraTransferWin","1");
      config->extraTransferWin = true;
   }
   else
   {
      kconfig->writeEntry("extraTransferWin","1");
      config->extraTransferWin = false;
   }


   kconfig->sync();
}


void CfgFlags::readData()
{
   overwrite->setChecked( config->overwriteExisting );
   incssid->setChecked( config->autoIncSSID );
   yappresume->setChecked( config->yappResume );
   extraTransWin->setChecked(config->extraTransferWin );
}


void CfgFlags::slotOkPressed()
{
   saveData();
   close();
}


void CfgFlags::slotAbortPressed()
{
   close();
}



////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////



CfgDirs::CfgDirs() : QDialog(0, "", TRUE)
{
   setCaption(klocale->translate("LinKT: Directories"));

   setupWindow();
   readData();
}


CfgDirs::~CfgDirs()
{
}


void CfgDirs::setupWindow()
{
   int w;
   QLabel *l;


   l = new QLabel( this );
   l->setText("AutoBIN:");
   l->move( 10, 10 );
   l->resize( l->sizeHint() );
   w = l->width();

   l = new QLabel( this );
   l->setText("7plus:");
   l->move( 10, 30 );
   l->resize( l->sizeHint() );
   if (l->width() > w) w = l->width();

   l = new QLabel( this );
   l->setText("down:");
   l->move( 10, 50 );
   l->resize( l->sizeHint() );
   if (l->width() > w) w = l->width();

   l = new QLabel( this );
   l->setText("up:");
   l->move( 10, 70 );
   l->resize( l->sizeHint() );
   if (l->width() > w) w = l->width();


   abin = new QLineEdit( this );
   abin->setText("");
   abin->setGeometry( w+20, 10, 300, 20);

   splus = new QLineEdit( this );
   splus->setText("");
   splus->setGeometry( w+20, 30, 300, 20);

   down = new QLineEdit( this );
   down->setText("");
   down->setGeometry( w+20, 50, 300, 20);

   up = new QLineEdit( this );
   up->setText("");
   up->setGeometry( w+20, 70, 300, 20);



   setFixedSize(w+330, 140);


   // OK- und Abbruch-Knopf
   int abstand = (width()-(2*BTNLENGTH))/3;
   btnok = new QPushButton( this );
   btnok->setText( klocale->translate ("&Ok") );
   btnok->setGeometry(abstand, 100, BTNLENGTH, BTNHEIGHT);
   btnok->setDefault( true );
   connect(btnok, SIGNAL(clicked()), this, SLOT(slotOkPressed()));

   btnabort = new QPushButton( this );
   btnabort->setText( klocale->translate ("&Abort") );
   btnabort->setGeometry(abstand*2+BTNLENGTH, 100, BTNLENGTH, BTNHEIGHT);
   connect(btnabort, SIGNAL(clicked()), this, SLOT(slotAbortPressed()));
}


void CfgDirs::readData()
{
   abin->setText( config->dirABin );
   splus->setText( config->dir7plus );
   down->setText( config->dirDown );
   up->setText( config->dirUp );
}


void CfgDirs::slotOkPressed()
{
   KConfig *kconfig;
   int fd;
   char tmp[1000];


   kconfig = mykapp->getConfig();

   kconfig->setGroup("Directories");


   sprintf(tmp,"%s/aaaaaaa.check", abin->text());
   if ((fd = open(tmp, O_CREAT|O_WRONLY)) == -1)
   {
      sprintf(tmp, klocale->translate("Cannot write to '%s'.\n(%s)"), abin->text(), strerror(errno));
      KMsgBox::message(0, klocale->translate("Error"), tmp);
      return;
   }
   fchmod(fd,S_IRUSR|S_IWUSR);
   ::close(fd);
   unlink(tmp);


   sprintf(tmp,"%s/aaaaaaa.check", splus->text());
   if ((fd = open(tmp, O_CREAT|O_WRONLY)) == -1)
   {
      sprintf(tmp, klocale->translate("Cannot write to '%s'.\(%s)"), splus->text(), strerror(errno));
      KMsgBox::message(0, klocale->translate("Error"), tmp);
      return;
   }
   fchmod(fd,S_IRUSR|S_IWUSR);
   ::close(fd);
   unlink(tmp);


   sprintf(tmp,"%s/aaaaaaa.check", down->text());
   if ((fd = open(tmp, O_CREAT|O_WRONLY)) == -1)
   {
      sprintf(tmp, klocale->translate("Cannot write to '%s'.\(%s)"), down->text(), strerror(errno));
      KMsgBox::message(0, klocale->translate("Error"), tmp);
      return;
   }
   fchmod(fd,S_IRUSR|S_IWUSR);
   ::close(fd);
   unlink(tmp);


   sprintf(tmp,"%s/aaaaaaa.check", up->text());
   if ((fd = open(tmp, O_CREAT|O_WRONLY)) == -1)
   {
      sprintf(tmp, klocale->translate("Cannot write to '%s'.\(%s)"), up->text(), strerror(errno));
      KMsgBox::message(0, klocale->translate("Error"), tmp);
      return;
   }
   fchmod(fd,S_IRUSR|S_IWUSR);
   ::close(fd);
   unlink(tmp);



   free(config->dir7plus);
   config->dir7plus = (char *) strdup(splus->text());
   kconfig->writeEntry("7plus", splus->text());

   free(config->dirABin);
   config->dirABin = (char *) strdup(abin->text());
   kconfig->writeEntry("abin", abin->text());

   free(config->dirDown);
   config->dirDown = (char *) strdup(down->text());
   kconfig->writeEntry("down", down->text());

   free(config->dirUp);
   config->dirUp = (char *) strdup(up->text());
   kconfig->writeEntry("up", up->text());


   kconfig->sync();
   close();
}


void CfgDirs::slotAbortPressed()
{
   close();
}



////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////



CfgFiles::CfgFiles() : QTabDialog(0, "", TRUE)
{
   setCaption(klocale->translate("LinKT: Files-Configuration"));

   createCTextTab();
   addTab( ctext_widg, "ctext" );

   createQTextTab();
   addTab( qtext_widg, "qtext" );

   createInfoTab();
   addTab( info_widg, "info" );

   createHelpTab();
   addTab( help_widg, "help" );

   createNewsTab();
   addTab( news_widg, "news" );

   readData();
   setFixedSize(430,300);

   setCancelButton();
   connect( this, SIGNAL(applyButtonPressed()), SLOT(slotOkPressed()));
}


CfgFiles::~CfgFiles()
{
}


void CfgFiles::createCTextTab()
{
   ctext_widg = new QWidget( this );

   ctext = new QMultiLineEdit( ctext_widg );
   ctext->setGeometry( 10, 10, 400, 180 );

   ctext_imp = new QPushButton( ctext_widg );
   ctext_imp->setGeometry( 10, 195, 80, 25 );
   ctext_imp->setText( klocale->translate("Import...") );
   connect( ctext_imp, SIGNAL(clicked()), SLOT(slotImportCText()));
}


void CfgFiles::createQTextTab()
{
   qtext_widg = new QWidget( this );

   qtext = new QMultiLineEdit( qtext_widg );
   qtext->setGeometry( 10, 10, 400, 180 );

   qtext_imp = new QPushButton( qtext_widg );
   qtext_imp->setGeometry( 10, 195, 80, 25 );
   qtext_imp->setText( klocale->translate("Import...") );
   connect( qtext_imp, SIGNAL(clicked()), SLOT(slotImportQText()));
}


void CfgFiles::createHelpTab()
{
   help_widg = new QWidget( this );

   help = new QMultiLineEdit( help_widg );
   help->setGeometry( 10, 10, 400, 180 );

   help_imp = new QPushButton( help_widg );
   help_imp->setGeometry( 10, 195, 80, 25 );
   help_imp->setText( klocale->translate("Import...") );
   connect( help_imp, SIGNAL(clicked()), SLOT(slotImportHelp()));
}


void CfgFiles::createInfoTab()
{
   info_widg = new QWidget( this );

   info = new QMultiLineEdit( info_widg );
   info->setGeometry( 10, 10, 400, 180 );

   info_imp = new QPushButton( info_widg );
   info_imp->setGeometry( 10, 195, 80, 25 );
   info_imp->setText( klocale->translate("Import...") );
   connect( info_imp, SIGNAL(clicked()), SLOT(slotImportInfo()));
}


void CfgFiles::createNewsTab()
{
   news_widg = new QWidget( this );

   news = new QMultiLineEdit( news_widg );
   news->setGeometry( 10, 10, 400, 180 );

   news_imp = new QPushButton( news_widg );
   news_imp->setGeometry( 10, 195, 80, 25 );
   news_imp->setText( klocale->translate("Import...") );
   connect( news_imp, SIGNAL(clicked()), SLOT(slotImportNews()));
}


void CfgFiles::readData()
{
   char tmp[5000];
   FILE *f;
   int i,line;


   ///////////////// Connect-Text ////////////////////////////////
   sprintf(tmp,"%s/ctext", config->maindir);
   if ((f = fopen(tmp, "r")) != NULL)
   {
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         ctext->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }


   ///////////////// Quit-Text ////////////////////////////////
   sprintf(tmp,"%s/qtext", config->maindir);
   if ((f = fopen(tmp, "r")) != NULL)
   {
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         qtext->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }


   ///////////////// Hilfe-Text ////////////////////////////////
   sprintf(tmp,"%s/help.linkt", config->maindir);
   if ((f = fopen(tmp, "r")) != NULL)
   {
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         help->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }


   ///////////////// Info-Text ////////////////////////////////
   sprintf(tmp,"%s/info.linkt", config->maindir);
   if ((f = fopen(tmp, "r")) != NULL)
   {
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         info->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }


   ///////////////// News-Text ////////////////////////////////
   sprintf(tmp,"%s/news.linkt", config->maindir);
   if ((f = fopen(tmp, "r")) != NULL)
   {
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         news->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }

}


void CfgFiles::slotOkPressed()
{
   char tmp[5000];
   FILE *f;
   int i,anz;


   /////////////// Connect-Text //////////////////////////////
   sprintf(tmp,"%s/ctext", config->maindir);
   if ((anz = ctext->numLines()) > 0)
   {
      if (anz == 1 && strlen(ctext->textLine(0)) == 0)
         unlink(tmp);
      else
      {
         if ((f = fopen(tmp, "w")) == NULL)
         {
            sprintf(tmp, klocale->translate("The %s-file cannot be created.\n(%s)"), "ctext", strerror(errno));
            KMsgBox::message(0, klocale->translate("File-Error"), tmp);
         }
         else
         {
            for (i=0; i<anz; i++)
            {
               strcpy(tmp, ctext->textLine(i));
               strcat(tmp, "\n");
               fputs(tmp, f);
            }
            fclose(f);
         }
      }
   }
   else unlink(tmp);


   /////////////// Quit-Text //////////////////////////////
   sprintf(tmp,"%s/qtext", config->maindir);
   if ((anz = qtext->numLines()) > 0)
   {
      if (anz == 1 && strlen(qtext->textLine(0)) == 0)
         unlink(tmp);
      else
      {
         if ((f = fopen(tmp, "w")) == NULL)
         {
            sprintf(tmp, klocale->translate("The %s-file cannot be created.\n(%s)"), "qtext", strerror(errno));
            KMsgBox::message(0, klocale->translate("File-Error"), tmp);
         }
         else
         {
            for (i=0; i<anz; i++)
            {
               strcpy(tmp, qtext->textLine(i));
               strcat(tmp, "\n");
               fputs(tmp, f);
            }
            fclose(f);
         }
      }
   }
   else unlink(tmp);


   /////////////// Help-Text //////////////////////////////
   sprintf(tmp,"%s/help.linkt", config->maindir);
   if ((anz = help->numLines()) > 0)
   {
      if (anz == 1 && strlen(help->textLine(0)) == 0)
         unlink(tmp);
      else
      {
         if ((f = fopen(tmp, "w")) == NULL)
         {
            sprintf(tmp, klocale->translate("The %s-file cannot be created.\n(%s)"), "help", strerror(errno));
            KMsgBox::message(0, klocale->translate("File-Error"), tmp);
         }
         else
         {
            for (i=0; i<anz; i++)
            {
               strcpy(tmp, help->textLine(i));
               strcat(tmp, "\n");
               fputs(tmp, f);
            }
            fclose(f);
         }
      }
   }
   else unlink(tmp);


   /////////////// Info-Text //////////////////////////////
   sprintf(tmp,"%s/info.linkt", config->maindir);
   if ((anz = info->numLines()) > 0)
   {
      if (anz == 1 && strlen(info->textLine(0)) == 0)
         unlink(tmp);
      else
      {
         if ((f = fopen(tmp, "w")) == NULL)
         {
            sprintf(tmp, klocale->translate("The %s-file cannot be created.\n(%s)"), "info", strerror(errno));
            KMsgBox::message(0, klocale->translate("File-Error"), tmp);
         }
         else
         {
            for (i=0; i<anz; i++)
            {
               strcpy(tmp, info->textLine(i));
               strcat(tmp, "\n");
               fputs(tmp, f);
            }
            fclose(f);
         }
      }
   }
   else unlink(tmp);


   /////////////// News-Text //////////////////////////////
   sprintf(tmp,"%s/news.linkt", config->maindir);
   if ((anz = news->numLines()) > 0)
   {
      if (anz == 1 && strlen(news->textLine(0)) == 0)
         unlink(tmp);
      else
      {
         if ((f = fopen(tmp, "w")) == NULL)
         {
            sprintf(tmp, klocale->translate("The %s-file cannot be created.\n(%s)"), "news", strerror(errno));
            KMsgBox::message(0, klocale->translate("File-Error"), tmp);
         }
         else
         {
            for (i=0; i<anz; i++)
            {
               strcpy(tmp, news->textLine(i));
               strcat(tmp, "\n");
               fputs(tmp, f);
            }
            fclose(f);
         }
      }
   }
   else unlink(tmp);
}



void CfgFiles::slotImportCText()
{
   char tmp[1000];
   int i,line;
   FILE *f;


   strcpy(tmp, config->maindir);
   QString str = QFileDialog::getOpenFileName(tmp);

   // Cancel
   if (str.isEmpty()) return;

   strcpy(tmp, (const char *)str);

   if (!file_exist(tmp))
   {
      KMsgBox::message(NULL, klocale->translate("File not found"),
                             klocale->translate("Cannot find specified file."));
      return;
   }


   if ((f = fopen(tmp, "r")) != NULL)
   {
      ctext->clear();
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         ctext->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }
   else
      KMsgBox::message(NULL, klocale->translate("Cannot open file"),
                             klocale->translate("Cannot open specified file."));
}


void CfgFiles::slotImportQText()
{
   char tmp[1000];
   int i,line;
   FILE *f;


   strcpy(tmp, config->maindir);
   QString str = QFileDialog::getOpenFileName(tmp);

   // Cancel
   if (str.isEmpty()) return;

   strcpy(tmp, (const char *)str);

   if (!file_exist(tmp))
   {
      KMsgBox::message(NULL, klocale->translate("File not found"),
                             klocale->translate("Cannot find specified file."));
      return;
   }


   if ((f = fopen(tmp, "r")) != NULL)
   {
      qtext->clear();
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         qtext->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }
   else
      KMsgBox::message(NULL, klocale->translate("Cannot open file"),
                             klocale->translate("Cannot open specified file."));
}


void CfgFiles::slotImportHelp()
{
   char tmp[1000];
   int i,line;
   FILE *f;


   strcpy(tmp, config->maindir);
   QString str = QFileDialog::getOpenFileName(tmp);

   // Cancel
   if (str.isEmpty()) return;

   strcpy(tmp, (const char *)str);

   if (!file_exist(tmp))
   {
      KMsgBox::message(NULL, klocale->translate("File not found"),
                             klocale->translate("Cannot find specified file."));
      return;
   }


   if ((f = fopen(tmp, "r")) != NULL)
   {
      help->clear();
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         help->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }
   else
      KMsgBox::message(NULL, klocale->translate("Cannot open file"),
                             klocale->translate("Cannot open specified file."));
}


void CfgFiles::slotImportInfo()
{
   char tmp[1000];
   int i,line;
   FILE *f;


   strcpy(tmp, config->maindir);
   QString str = QFileDialog::getOpenFileName(tmp);

   // Cancel
   if (str.isEmpty()) return;

   strcpy(tmp, (const char *)str);

   if (!file_exist(tmp))
   {
      KMsgBox::message(NULL, klocale->translate("File not found"),
                             klocale->translate("Cannot find specified file."));
      return;
   }


   if ((f = fopen(tmp, "r")) != NULL)
   {
      info->clear();
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         info->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }
   else
      KMsgBox::message(NULL, klocale->translate("Cannot open file"),
                             klocale->translate("Cannot open specified file."));
}


void CfgFiles::slotImportNews()
{
   char tmp[1000];
   int i,line;
   FILE *f;


   strcpy(tmp, config->maindir);
   QString str = QFileDialog::getOpenFileName(tmp);

   // Cancel
   if (str.isEmpty()) return;

   strcpy(tmp, (const char *)str);

   if (!file_exist(tmp))
   {
      KMsgBox::message(NULL, klocale->translate("File not found"),
                             klocale->translate("Cannot find specified file."));
      return;
   }


   if ((f = fopen(tmp, "r")) != NULL)
   {
      news->clear();
      line = 0;
      while (fgets(tmp, 4999, f) != NULL)
      {
         if ((i = POS('\r', tmp)) > -1)
            tmp[i] = '\0';
         if ((i = POS('\n', tmp)) > -1)
            tmp[i] = '\0';
         news->insertLine(tmp, line);
         line++;
      }
      fclose(f);
   }
   else
      KMsgBox::message(NULL, klocale->translate("Cannot open file"),
                             klocale->translate("Cannot open specified file."));
}


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


CfgSound::CfgSound() : QDialog(0, "", true)
{
   char tmp[500], *str;
   sprintf(tmp,"%s/linkt/sound/",(const char *)mykapp->kde_datadir());
   QDir d(tmp);
   QStrList *list;


   setFixedSize(420, 400);

   setCaption(klocale->translate("LinKT: Sounds"));

   aktDir = NULL;

   setupWindow();
   readData();

   // Alle Sound-Files, die im LinKT-Sound-Verzeichnis stehen, in die Liste
   // eintragen
   if ((list = (QStrList *)d.entryList("*.wav")) != NULL)
   {
      if ((str = list->first()) == NULL) return;
      do
      {
         sprintf(tmp,"%s/linkt/sound/%s",(const char *)mykapp->kde_datadir(), str);
         if (searchKlang( tmp ))
           klaenge->insertItem( tmp );
      }
      while ((str = list->next()) != NULL);
   }
}


CfgSound::~CfgSound()
{
}


void CfgSound::setupWindow()
{
   QButtonGroup *tmpbtngrp;

   enabled = new QCheckBox( this );
   enabled->setGeometry( 10, 10, 200, 20 );
   enabled->setText( klocale->translate("enable sounds") );
   connect( enabled, SIGNAL(toggled(bool)), this, SLOT(slotEnabled(bool)) );

   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->setGeometry( 10, 40, 400, 300 );
   tmpbtngrp->setFrameStyle( 49 );
   tmpbtngrp->setAlignment( 1 );

   ereignisse = new QListBox( tmpbtngrp );
   ereignisse->setGeometry( 10, 30, (tmpbtngrp->width()-20)/2-5, tmpbtngrp->height()-65 );
   connect( ereignisse, SIGNAL(highlighted(int)), this, SLOT(slotSwitchEvent(int)) );

   lEreig = new QLabel( tmpbtngrp );
   lEreig->setGeometry( 10, 10, (tmpbtngrp->width()-20)/2-5, 20 );
   lEreig->setText( klocale->translate("Events") );

   klaenge = new QListBox( tmpbtngrp );
   klaenge->setGeometry((tmpbtngrp->width()-20)/2+15, 30, tmpbtngrp->width()-25-((tmpbtngrp->width()-20)/2), tmpbtngrp->height()-65 );
   connect( klaenge, SIGNAL(highlighted(int)), this, SLOT(slotSwitchSound(int)) );

   lKlaenge = new QLabel( tmpbtngrp );
   lKlaenge->setGeometry((tmpbtngrp->width()-20)/2+15, 10, tmpbtngrp->width()-25-((tmpbtngrp->width()-20)/2), 20 );
   lKlaenge->setText( klocale->translate("Sounds") );

   addWAV = new QPushButton( tmpbtngrp );
   addWAV->setGeometry( (tmpbtngrp->width()-20)/2+15, tmpbtngrp->height()-30, 75, 25 );
   addWAV->setText(klocale->translate("Add WAV"));
   connect( addWAV, SIGNAL(clicked()), this, SLOT(slotAddWAV()) );

   playWAV = new QPushButton( tmpbtngrp );
   playWAV->setGeometry( tmpbtngrp->width()-95, tmpbtngrp->height()-30, 75, 25 );
   playWAV->setText(klocale->translate("Play WAV"));
   connect( playWAV, SIGNAL(clicked()), this, SLOT(slotPlayWAV()) );



   // OK- und Abbruch-Knopf
   int abstand = (width()-(2*BTNLENGTH))/3;
   btnok = new QPushButton( this );
   btnok->setText( klocale->translate ("&Ok") );
   btnok->setGeometry(abstand, height()-BTNHEIGHT-10, BTNLENGTH, BTNHEIGHT);
   btnok->setDefault( true );
   connect(btnok, SIGNAL(clicked()), this, SLOT(slotOkPressed()));

   btnabort = new QPushButton( this );
   btnabort->setText( klocale->translate ("&Abort") );
   btnabort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-10, BTNLENGTH, BTNHEIGHT);
   connect(btnabort, SIGNAL(clicked()), this, SLOT(slotAbortPressed()));
}


void CfgSound::readData()
{
   int i;


   // enable sound-Zeugs
   enabled->setChecked( config->sound->enabled );
   setEnabled( config->sound->enabled );



   klaenge->insertItem( klocale->translate("(none)") );


   ereignisse->insertItem( "connect" );
   if (config->sound->connect == NULL)
      zuordnung[SOUND_CONNECT] = 0;
   else
   {
      if ((i = searchKlang( config->sound->connect )) == -1)
      {
         klaenge->insertItem( config->sound->connect );
         zuordnung[SOUND_CONNECT] = klaenge->count()-1;
      }
      else
         zuordnung[SOUND_CONNECT] = i;
   }
   klaenge->setCurrentItem(zuordnung[SOUND_CONNECT]);
   ereignisse->setCurrentItem(SOUND_CONNECT);


   ereignisse->insertItem( "disconnect" );
   if (config->sound->disconnect == NULL)
      zuordnung[SOUND_DISCONNECT] = 0;
   else
   {
      if ((i = searchKlang( config->sound->disconnect )) == -1)
      {
         klaenge->insertItem( config->sound->disconnect );
         zuordnung[SOUND_DISCONNECT] = klaenge->count()-1;
      }
      else
         zuordnung[SOUND_DISCONNECT] = i;
   }


   ereignisse->insertItem( "//ring" );
   if (config->sound->ring == NULL)
      zuordnung[SOUND_RING] = 0;
   else
   {
      if ((i = searchKlang( config->sound->ring )) == -1)
      {
         klaenge->insertItem( config->sound->ring );
         zuordnung[SOUND_RING] = klaenge->count()-1;
      }
      else
         zuordnung[SOUND_RING] = i;
   }
}


int CfgSound::searchKlang( char *str )
{
   int i;

   for (i=0; i<(int)klaenge->count(); i++)
   {
      if (!strcmp(str, klaenge->text(i)))
         return i;
   }

   return -1;
}


void CfgSound::slotSwitchEvent( int index )
{
   klaenge->setCurrentItem( zuordnung[index] );
}


void CfgSound::slotSwitchSound( int index )
{
   zuordnung[ereignisse->currentItem()] = index;
}


void CfgSound::saveData()
{
   KConfig *kconfig;


   if (config->sound->connect != NULL)
      free(config->sound->connect);
   if (zuordnung[SOUND_CONNECT] == 0)
      config->sound->connect = NULL;
   else
      config->sound->connect = (char *) strdup(klaenge->text(zuordnung[SOUND_CONNECT]));

   if (config->sound->disconnect != NULL)
      free(config->sound->disconnect);
   if (zuordnung[SOUND_DISCONNECT] == 0)
      config->sound->disconnect = NULL;
   else
      config->sound->disconnect = (char *) strdup(klaenge->text(zuordnung[SOUND_DISCONNECT]));

   if (config->sound->ring != NULL)
      free(config->sound->ring);
   if (zuordnung[SOUND_RING] == 0)
      config->sound->ring = NULL;
   else
      config->sound->ring = (char *) strdup(klaenge->text(zuordnung[SOUND_RING]));

   config->sound->enabled = enabled->isChecked();


   // Daten im Config-File abspeichern
   kconfig = mykapp->getConfig();

   kconfig->setGroup( "Sound" );

   if (config->sound->enabled)
      kconfig->writeEntry( "enabled", "1" );
   else
      kconfig->writeEntry( "enabled", "0" );
   kconfig->writeEntry( "connect", config->sound->connect );
   kconfig->writeEntry( "disconnect", config->sound->disconnect );
   kconfig->writeEntry( "ring", config->sound->ring );

   kconfig->sync();

}


void CfgSound::slotEnabled( bool active )
{
   ereignisse->setEnabled( active );
   klaenge->setEnabled( active );
   addWAV->setEnabled( active );
}


void CfgSound::slotOkPressed()
{
   saveData();
   close();
}


void CfgSound::slotAbortPressed()
{
   close();
}


void CfgSound::slotAddWAV()
{
   char tmp[5000];
   int i;


   if (aktDir == NULL)
      strcpy(tmp, config->maindir);
   else
      strcpy(tmp, aktDir);
   QString str = QFileDialog::getOpenFileName(tmp, "*.wav", this);

   // Cancel
   if (str.isEmpty()) return;

   strcpy(tmp, (const char *)str);
   if (aktDir != NULL)
      free(aktDir);

   // Verzeichnisnamen nach aktDir
   if ((i = lPOS('/', tmp)) == -1)
      aktDir = NULL;
   else
   {
      aktDir = (char *) strdup(tmp);
      aktDir[i] = '\0';
   }

   if (!file_exist(tmp))
   {
      KMsgBox::message(NULL, klocale->translate("File not found"),
                             klocale->translate("Cannot find specified file."));
      return;
   }


   klaenge->insertItem( tmp );
}


void CfgSound::slotPlayWAV()
{
   if (klaenge->currentItem() > 0)
      toplevel->playSound( klaenge->text(klaenge->currentItem()) );
}



#include "preferences.moc"

