/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef MAIN_H
#define MAIN_H


// Wenn LinKT ohne Audio-Unterstuetzung (KAudio) compiliert werden soll,
// muss WITHOUT_AUDIO defined sein.
#undef WITHOUT_AUDIO

#ifndef WITHOUT_AUDIO
   extern "C"
   {
      #include <mediatool.h>
   }
#endif

#include "channel.h"
#include <qobject.h>
#include <qpopupmenu.h>
#include <qaccel.h>
#include <qrect.h>

#include <kapp.h>
#include <kstatusbar.h>
#include <ktopwidget.h>
#include <kmenubar.h>
#ifndef WITHOUT_AUDIO
   #include <kaudio.h>
#endif

#include "ax25k.h"
#include "chanlist.h"
#include "interface.h"
#include "router.h"



/*
 *  typedef struct _s_chanlist (s_chanlist)
 * Hier wird eine Liste aller im Augenblick offener Kanaele abgespeichert.
 */
typedef struct _s_chanlist
{
   struct _s_chanlist *next;
   Channel *channel;
} s_chanlist;



class TopLevel : public KTopLevelWidget
{
   Q_OBJECT;
public:
   TopLevel( const char *name=0 );
   ~TopLevel();

   Router *router;
   s_chanlist * addChannelList();
   s_chanlist * getChanListPtr();
   ChanList *chanListTable;
   void deleteChannelList( Channel *chan );
   void checkForFirstRun();
   void setMainwinSize();
   void activateChannel(QWidget *win, QWidget *oldwin, bool show);
   QWidget *currentChannel;

   int makeConnect( char *call, char *digis, char *mycall, char *port, int * error );
   void readLastConnectedCalls();

   void addConnectList( const char *call );
   bool incSSID(char *call);

   void setQsoWinGeometry( const QRect rect );
   QRect & getQsoWinGeometry();
   bool qsoWinGeometrySet();
   void playSound( int id );
   void playSound( const char *filename );

private:
   QPopupMenu *file, *channel, *help, *pref, *route;
   KMenuBar *menubar;
   QWidget *chanListWidget;
#ifndef WITHOUT_AUDIO
   KAudio KAServer;
#endif

   QRect qsoWinGeometry;
   bool qsoWinGeometryFlag;

   void setupMenuBar();
   void setupChanListWidget();

   s_chanlist *chanlist;

public slots:
   void slotBeenden();
   void slotConnect();
   void slotAbout();
   void slotHelp();
   void slotAway();
   void slotPrefCalls();
   void slotPrefPorts();
   void slotPrefScreen();
   void slotPrefAway();
   void slotPrefShortcut();
   void slotPrefCallKey();
   void slotPrefFlags();
   void slotPrefDirs();
   void slotPrefFiles();
   void slotPrefSound();

   void slotCallKey(int id);
   void slotRouteAdd();
   void slotRouteDelete();
   void slotRouteShowList();
   void slotRouteShowTree();

protected:
   void closeEvent(QCloseEvent *e);
};




/////////////////////////////////////////////////////////////////////
// Sonstige Prototypen
/////////////////////////////////////////////////////////////////////

//   void init_globals()
// Globale Variablen aus dem linktrc-File holen und in die config-
// Struktur packen.
void init_globals();

//   void createDirectories()
//
// Verzechnisse erstellen, wenn es sie noch nicht gibt.
void createDirectories();


//   void readBoxCheckFile()
//
// Einlesen der Daten, die fuers BoxCheck benoetigt werden
void readBoxCheckFile();

// Utility-Funktionen fuer readBoxCheckFile()
void addFestesZeichen(char *str, s_boxcheck *bc);
bool getPosLen( char *str, int & pos, int & len );
s_boxcheck * newBoxCheckEntry();




#endif

