/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DIDADIT_H
#define DIDADIT_H


#include <time.h>
#include <qwidget.h>
#include <qtimer.h>
#include "dialog.h"


// KISS-Konstanten
#define FEND '\xC0'             // FrameEND
#define FESC '\xDB'             // FrameESCape
#define TFEND '\xDC'            // Transponiertes FrameEND
#define TFESC '\xDD'            // Transponiertes FrameESCape

#define KBLOCK_INFO 1
#define KBLOCK_START 2
#define KBLOCK_ERR 3
#define KBLOCK_DATA 4
#define KBLOCK_FIN 5
#define KBLOCK_REQ 6
#define KBLOCK_FINACK 7
#define KBLOCK_TYPEREJ 8
#define KBLOCK_ECHOREQ 9
#define KBLOCK_ECHOREP 10
#define KBLOCK_ABORT 11

#define MAXBLOCKSIZE 8192
#define MAXROHBLOCKSIZE 2*MAXBLOCKSIZE+100

#define DIDADIT_VERSION "0.5.6"


typedef struct _s_rxliste
{
   struct _s_rxliste *next;
   unsigned long start;
   unsigned long ende;
} s_rxliste;


typedef struct _s_reqliste
{
   struct _s_reqliste *next;
   unsigned long offset;
   unsigned long len;
} s_reqliste;


typedef struct
{
   bool error;
   unsigned short id;         // Block-ID
   int len;                   // Laenge der Daten
   char *data;                // Daten
   unsigned short crc;        // 16-Bit CRC
   unsigned char md5[16];     // 16 Bytes MD5-Hash
} t_KBlock;


/*
 * class DIDADIT
 *
 * Funktionen und variablen, die man zum Senden und zum Empfangen
 * benoetigt.
 */
class DIDADIT : public QObject
{
   Q_OBJECT;
public:
   DIDADIT(QWidget *_chan, char *_filename, bool senden);
   ~DIDADIT();

   int proceed(char *data, int len);

   void SendBytes(char *, int);
   void sendMessage(char *);
   void abortIt();

   bool getNextPacket( char *data, int & len );
   bool didaditTx();

public slots:
   void sendBlock();

private:
   void SendBlock (char *data, int datalen, unsigned short blockid);
   void DecodeBlock(char *data, int len, t_KBlock *block);

   int checkBlock(char *data, int len);
   void sendInfoBlock();
   void sendStartBlock();
   void sendReqBlock( unsigned long start, unsigned long stop );
   void getHexMD5( unsigned char *md5, char *hexmd5 );
   void md5HexToBin( char *hex, unsigned char *bin );

   void readInfoBlock();
   void readStartBlock();
   bool readDataBlock();
   bool readFinBlock();
   void readFinAck();
   void readReqBlock();


   // Routinen, um die Verwaltungs- und Datenfiles zu verwalten
   void createDataFiles();
   void writeRFile();
   void deleteRFile();
   unsigned long lookForRFile();

   void addRXListe( unsigned long start, unsigned long ende );
   void showEndText( bool rx );
   bool allReceived();

   bool waitForOkAbort;
   QWidget *chan;
   char *longname, *shortname;
   long size;
   long rxbytes;
   time_t modtime;
   time_t starttime;
   int blocksize;
   unsigned char md5[16];
   int status;
   bool firstblock;
   unsigned long offset;

   int lastBlockSent;
   QTimer *timer;

   int reqCount;
   long reqLength;

   int fd_data;
   int fd_r;

   char *rxData;        // Hier wird gerade ein Block empfangen
   int rxDataLen;
   t_KBlock block;

   s_rxliste *rxlistroot;
   s_reqliste *reqlistroot;

   TransferWin *win;
};




#endif /* DIDADIT_H */

