/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef DIALOG_H
#define DIALOG_H

#include <qdialog.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qtabdialog.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qprogressbar.h>
#include <qlabel.h>
#include <qradiobutton.h>

#include <time.h>




class Connect : public QDialog
{
   Q_OBJECT
public:
   Connect(QWidget *parent = 0);
   ~Connect();
   const char *getText();
   const char *getPort();
   const char *getMycall();

private:
   QComboBox *combo, *call;
   QLineEdit *mycall;

   QAccel *a;
};



class AboutDlg : public QDialog
{
   Q_OBJECT
public:
   AboutDlg(QWidget *parent = 0);
};



#define TRANSART_SIEBEN 1
#define TRANSART_ABINTX 2
#define TRANSART_ABINRX 3
#define TRANSART_DIDADITTX 4
#define TRANSART_DIDADITRX 5
#define TRANSART_YAPPTX 6
#define TRANSART_YAPPRX 7

class TransferWin : public QDialog
{
   Q_OBJECT;
public:
   TransferWin( void *rxparent, int art, char *filename, int size );
   ~TransferWin();

public slots:
   void closeTransferWin();
   void updateClockAndBaud();

   void setReceivedBytes( int bytes );
   void setFilesizeBytes( int bytes );

private:
   QLabel *lBytes, *lBaudEff, *lTimeCons, *lTimeLeft;
   QProgressBar *progressbar;
   void *parent;

   int filesize;
   int bytes_got;
   time_t starttime;
   int transart;
};


class send7plus : public QDialog
{
   Q_OBJECT;
public:
   send7plus();
   ~send7plus();

   const char * getFilename();
   int getFileCount();
   int startWithFile();
   const char * getSendLine( int filenr );

public slots:
   void slotCheckInput();
   void slotSelectFile();
   void slotToggleStartWith(bool active);

private:
   QLineEdit *board, *verteiler, *title, *filename, *lifetime, *startwith;
   QLabel *info;
   QPushButton *search;
   QRadioButton *cmd_s, *cmd_sb, *cmd_sp, *send_all, *send_startwiththis;

   int filecount;

   bool checkForAllFiles();
   void checkFileCount();
   void macroLine( char *dest, const char *src, int filenr );
};


class AwayDlg : public QDialog
{
   Q_OBJECT;
public:
   AwayDlg(QWidget *parent = 0);
   ~AwayDlg();

   void getInfos(unsigned char & wo, char *text);
private:
   QRadioButton *here, *phone, *sleep, *other;
   QLineEdit *othertext;
   QPushButton *ok, *abort;
public slots:
   void slotToggleOther(bool checked);
   void slotReady();
};


class DlgAddRoute : public QDialog
{
public:
   DlgAddRoute(QWidget *parent = 0);
   ~DlgAddRoute();

   void getRoute( char *_call, char *_via, char *_port );
private:
   QPushButton *btnok, *btnabort;
   QLineEdit *call, *via;
   QComboBox *port;
};


class DlgYAPP : public QDialog
{
   Q_OBJECT;
public:
   DlgYAPP( QWidget *parent=0 );
   ~DlgYAPP();

   void getData( int & xfer, char *name );

public slots:
   void slotBrowseFile();

private:
   QRadioButton *rx, *tx;
   QButtonGroup *btngrp;
   QPushButton *btnok, *btnabort;
   QLabel *lFName;
   QLineEdit *filename;
   QPushButton *browse;
};


class TransferInfo : public QWidget
{
   Q_OBJECT;
public:
   TransferInfo( QWidget *parent, int art, char *filename, int size );
   ~TransferInfo();

   void setReceivedBytes( int rxbytes );
   void setFilesizeBytes( int bytes );

private:
   int filesize;
   int bytes_got;
   time_t starttime;

   QProgressBar *progressbar;
   QLabel *lBytes, *lBaudEff, *lFileName, *lTimeLeft;
};

#endif /* DIALOG_H */

