/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef BOXCHECK_H
#define BOXCHECK_H


#include "global.h"

#include <qobject.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qaccel.h>
#include <qheader.h>
#include <qpushbutton.h>
#include <qlist.h>
#include <qglist.h>
#include <qlistbox.h>


class QListTbl;



class DlgTransfer : public QDialog
{
   Q_OBJECT;
public:
   DlgTransfer(char *board, int nr);
   ~DlgTransfer();

   void getInfo( char *board, char *mbx );

private:
   QLineEdit *le_board, *le_mbx;
   QAccel *retaccel;
};


class DlgSetLT : public QDialog
{
   Q_OBJECT;
public:
   DlgSetLT(char *board, int nr);
   ~DlgSetLT();

   int getLT();

public slots:
   void slotReturn();

private:
   QLineEdit *le_newlt;
   QAccel *retaccel;

   int newlt;
};


class BCTableEntry : public QObject
{
public:
   BCTableEntry( char *_sender, char *_rubrik, int _nr, char *_datum, char *_mbx, int _bytes, int _lt, char *_titel );
   ~BCTableEntry();

   void paintCell( QPainter *p, int x1, int y1, int x2, int y2, int col, bool currentrow );
   void toggleChecked();
   bool isChecked();
   void getInfo( char *board, int & mailnr );

private:
   char sender[20], rubrik[20], datum[20], mbx[20], titel[100];
   char nr[10], bytes[10], lt[10];

   bool checked;
};


class BCTable : public QTableView
{
    Q_OBJECT
public:
   BCTable( QWidget* parent=0, int type=0);
   ~BCTable();

   void addEntry( char *sender, char *rubrik, int nr, char *datum, char *mbx, int bytes, int lt, char *titel);
   void clear();
   void sendRequest();
   void clearMarks();

public slots:
   void slotSizeChange(int col, int, int size);

signals:
   void sendString( char *str );

protected:
   void paintCell( QPainter*, int row, int col );
   void mousePressEvent( QMouseEvent *e );
   void mouseDoubleClickEvent( QMouseEvent* e );
   void keyPressEvent( QKeyEvent *e );
   int cellWidth(int cell);

private:
   QListTbl *contents;
   int breite[8];
   QWidget *prnt;

   int curRow;
   int rowsMarked;
   int type;

   void eraseMail();
   void readCurrentMail();
   void transferCurrentMail();
   void setLifetime();
};




class BoxCheckWin : public QDialog
{
   Q_OBJECT;

public:
   BoxCheckWin( QObject *prnt, int type );
   ~BoxCheckWin();

   void resizeEvent(QResizeEvent *event);

   void addEntry( char *sender, char *rubrik, int nr, char *datum, char *mbx, int bytes, int lt, char *titel);
   void clear();

public slots:
   void slotSend();

private:
   QObject *parent;
   QAccel *AccelReturn, *AccelSpace;
   QHeader *header;
   BCTable *table;

   QPushButton *send;
   QPushButton *abort;
};



class BoxCheck : QObject
{
   Q_OBJECT;
public:
   BoxCheck( QWidget *widget );
   ~BoxCheck();

   void readData( const char *desc );
   void proceed( char *str, int len );
   void showWindow();

public slots:
   void sendString( char *str );

private:
   s_boxcheck *data;
   int status;
   QWidget *parent;

   BoxCheckWin *win;
};




#endif

