/*
 *  LinKT - the Linux Kde pr-Terminal
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "boxcheck.h"
#include "toolbox.h"
#include "channel.h"
#include "main.h"

#include <stdio.h>
#include <stdlib.h>

#include <kmsgbox.h>
#include <kwmmapp.h>

#include <qcolor.h>
#include <qkeycode.h>



#define BTNLENGTH 80
#define BTNHEIGHT 25


extern TopLevel *toplevel;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


DlgTransfer::DlgTransfer( char *board, int nr )
                   : QDialog( 0, "", true )
{
   QLabel *l;
   char tmp[100];

   setCaption(klocale->translate("LinKT: transfer mail"));


   resize( 230, 120 );
   setFixedSize(size());

   l = new QLabel( this );
   l->setGeometry( 10, 10, 250, 20 );
   sprintf(tmp, "Transfer: %s %i", board, nr);
   l->setText( tmp );

   le_board = new QLineEdit( this );
   le_board->setGeometry( 10, 40, 100, 20 );
   le_board->setText("");
   le_board->setMaxLength( 8 );

   le_mbx = new QLineEdit( this );
   le_mbx->setGeometry( 125, 40, 100, 20 );
   le_mbx->setText("");
   le_mbx->setMaxLength( 8 );

   l = new QLabel( this );
   l->setGeometry(112, 40, 15, 20);
   l->setText("@");



   int abstand = (width()-(2*BTNLENGTH))/3;
   QPushButton *send = new QPushButton( this );
   send->setGeometry(abstand, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   send->setText( klocale->translate("&Send") );
   connect(send, SIGNAL(clicked()), this, SLOT(accept()));

   QPushButton *abort = new QPushButton( this );
   abort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   abort->setText( klocale->translate("&Abort") );
   connect(abort, SIGNAL(clicked()), this, SLOT(reject()));

   retaccel = new QAccel( this );
   retaccel->connectItem( retaccel->insertItem( Key_Return ), this, SLOT(accept()) );

   le_board->setFocus();
}


DlgTransfer::~DlgTransfer()
{
   delete le_board;
   delete le_mbx;

   delete retaccel;
}


void DlgTransfer::getInfo( char *board, char *mbx )
{
   strcpy(board, le_board->text());
   strcpy(mbx, le_mbx->text());
}


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


DlgSetLT::DlgSetLT( char *board, int nr )
                   : QDialog( 0, "", true )
{
   QLabel *l;
   char tmp[100];

   setCaption(klocale->translate("LinKT: set new lifetime"));


   resize( 230, 120 );
   setFixedSize(size());

   l = new QLabel( this );
   l->setGeometry( 10, 10, 250, 20 );
   sprintf(tmp, "Set lifetime for %s %i", board, nr);
   l->setText( tmp );

   le_newlt = new QLineEdit( this );
   le_newlt->setGeometry( 100, 40, 50, 20 );
   le_newlt->setText("");
   le_newlt->setMaxLength( 3 );

   l = new QLabel( this );
   l->setGeometry( 10, 40, 80, 20);
   l->setText("new lifetime:");



   int abstand = (width()-(2*BTNLENGTH))/3;
   QPushButton *send = new QPushButton( this );
   send->setGeometry(abstand, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   send->setText( klocale->translate("&Send") );
   connect(send, SIGNAL(clicked()), this, SLOT(slotReturn()));

   QPushButton *abort = new QPushButton( this );
   abort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   abort->setText( klocale->translate("&Abort") );
   connect(abort, SIGNAL(clicked()), this, SLOT(reject()));

   retaccel = new QAccel( this );
   retaccel->connectItem( retaccel->insertItem( Key_Return ), this, SLOT(slotReturn()) );

   le_newlt->setFocus();
}


DlgSetLT::~DlgSetLT()
{
   delete le_newlt;

   delete retaccel;
}


int DlgSetLT::getLT()
{
   return newlt;
}


void DlgSetLT::slotReturn()
{
   newlt = atoi(le_newlt->text());

   if (newlt > 999 || newlt < 1)
   {
      KMsgBox::message(0, klocale->translate("Set Lifetime"), klocale->translate("The lifetime must be between 1 and 999."));
      return;
   }

   accept();
}


/////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////



Q_DECLARE(QListM, BCTableEntry);

class QListTbl : public QListM(BCTableEntry)
{
   int compareItems( GCI i1, GCI i2 );
};



int QListTbl::compareItems( GCI i1, GCI i2 )
{
   int i, fnr, snr;
   char f[100], s[100];

   ((BCTableEntry *)i1)->getInfo(f, fnr);
   ((BCTableEntry *)i2)->getInfo(s, snr);

   i = strcmp(f, s);

   if (i == 0)
      return 0;

   return i;
}


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////



BoxCheck::BoxCheck( QWidget *widget )
{
   parent = widget;
   status = 0;
   win = NULL;
}


BoxCheck::~BoxCheck()
{
   if (win != NULL)
   {
      delete win;
      win = NULL;
   }
}


void BoxCheck::readData( const char *desc )
{
   s_boxcheck *tmp;
   bool found=false;

   tmp = boxcheckroot;

   while ((tmp != NULL) && !found)
   {
      if (!strcmp(tmp->desc, desc))
      {
         data = tmp;
         found = true;
      }
      else
         tmp = tmp->next;
   }
   if (!found)
   {
      data = NULL;
      return;
   }
}


void BoxCheck::proceed( char *rxdata, int len )
{
   char tmp[100], str[1000], *rxstr;
   int i, nr, bytes, lt, k;
   char sender[100], rubrik[100], datum[100], mbx[100], titel[100];


   rxstr = (char *) malloc(len+1);
   memcpy(rxstr, rxdata, len);
   rxstr[len] = '\0';


   if (data == NULL) return;

   if ((i = POS('\r', rxstr)) > -1) rxstr[i] = '\0';
   if ((i = POS('\n', rxstr)) > -1) rxstr[i] = '\0';

   strcpy(str, rxstr);
   len = strlen(str);


   // Wenn gerade nix empfangen wird (status == 0) gucken, ob ein
   // korrekter Header empfangen wurde. Wenn nicht -> Ende Gelaende.
   // Wenn schon: status = 1
   if (status == 0)
   {
      if (strcmp(str, data->title))
      {
         free(rxstr);
         return;
      }
      status = 1;

      // Wenn das CheckBox-Fenster dieses Kanals noch nicht existiert,
      // wird es erstellt.
      if (win == NULL)
         win = new BoxCheckWin( this, data->type );
      else
         win->clear();
      ((Channel *)parent)->enableBoxcheckMenu();
      free(rxstr);
      return;
   }

   if (len == 0)
   {
      if (data->type==BOXC_TYPE_DIEBOX)
      {
         // Diese Zeile ist ziemlich leer.
         // Wenn das die erste Leerzeile ist, isses ok. Wenn nicht wars das
         // mit diesem Check.

         switch (status)
  	      {
            case 1: status = 2; break;
            case 2: status = 0; break;
         }
      }

      if (data->type==BOXC_TYPE_RLI)
         status = 0;

      free(rxstr);
      return;
   }


   if (win == NULL)
   {
      free(rxstr);
      return;
   }


   i = 0;
   for (i=0; i<data->mustcount; i++)
   {
      if (len < data->must[i]->pos)
      {
         status = 0;
         free(rxstr);
         return;
      }

      if (str[data->must[i]->pos-1] != data->must[i]->zeichen)
      {
         status = 0;
         free(rxstr);
         return;
      }
   }


   COPY(sender, str, data->pos[BOXCHECK_SENDER]->pos-1, data->pos[BOXCHECK_SENDER]->len);
   COPY(rubrik, str, data->pos[BOXCHECK_RUBRIK]->pos-1, data->pos[BOXCHECK_RUBRIK]->len);
   if ((i = POS('.', rubrik)) > -1)
      rubrik[i] = '\0';
   COPY(tmp, str, data->pos[BOXCHECK_MAILNR]->pos-1, data->pos[BOXCHECK_MAILNR]->len);
   i = 0;
   while (tmp[i] == '.') i++;
   k = strlen(tmp)-i;
   memmove(tmp, tmp+i, k);
   tmp[k] = '\0';
   nr = atoi(tmp);
   COPY(datum, str, data->pos[BOXCHECK_DATUM]->pos-1, data->pos[BOXCHECK_DATUM]->len);
   COPY(mbx, str, data->pos[BOXCHECK_MBX]->pos-1, data->pos[BOXCHECK_MBX]->len);
   COPY(tmp, str, data->pos[BOXCHECK_BYTES]->pos-1, data->pos[BOXCHECK_BYTES]->len);
   bytes = atoi(tmp);
   COPY(tmp, str, data->pos[BOXCHECK_LT]->pos-1, data->pos[BOXCHECK_LT]->len);
   lt = atoi(tmp);
   COPY(titel, str, data->pos[BOXCHECK_TITEL]->pos-1, data->pos[BOXCHECK_TITEL]->len);


   win->addEntry( sender, rubrik, nr, datum, mbx, bytes, lt, titel);

   free(rxstr);
}


void BoxCheck::showWindow()
{
   if (win == NULL)
   {
      KMsgBox::message(0, klocale->translate("BoxCheck"), klocale->translate("You didn't receive a checklist until now."));
      return;
   }

   KWM::activate(win->winId());
   win->show();
   win->setFocus();
}


void BoxCheck::sendString( char *str )
{
   ((Channel *)parent)->sendString(str);
}


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


BCTableEntry::BCTableEntry( char *_sender, char *_rubrik, int _nr, char *_datum, char *_mbx, int _bytes, int _lt, char *_titel )
{
   strcpy(sender, _sender);
   strcpy(rubrik, _rubrik);
   strcpy(datum, _datum);
   strcpy(mbx, _mbx);
   strcpy(titel, _titel);
   sprintf(nr, "%i", _nr);
   sprintf(bytes, "%i", _bytes);
   sprintf(lt, "%i", _lt);

   checked = false;
}


BCTableEntry::~BCTableEntry()
{
}


void BCTableEntry::paintCell( QPainter *p, int x1, int y1, int x2, int y2, int col, bool currentrow )
{
   if (currentrow)
   {
      // Dies ist die aktuelle Zeile. Rahmen drum rum zeichnen
      p->drawLine( 0, y2, x2, y2 );
      p->drawLine( 0, 0, x2, 0 );
   }

   // Extra-Rahmen malen
   if (checked)
   {
      p->setBrush(QColor(blue));
      p->setPen(QColor(blue));
      p->drawRect( 0, 0, x2+1, y2+1 );
      p->setBrush(QColor(white));
      p->setPen(QColor(white));
      if (currentrow)
      {
         // Dies ist die aktuelle Zeile. Rahmen drum rum zeichnen
         p->drawLine( 0, y2, x2, y2 );
         p->drawLine( 0, 0, x2, 0 );
      }
   }


   switch (col)
   {
      case 0:
           p->drawText( 2, 2, x2-x1, y2-y1, AlignLeft, sender );
           break;
      case 1:
           p->drawText( 2, 2, x2-x1, y2-y1, AlignLeft, rubrik );
           break;
      case 2:
           p->drawText( 2, 2, x2-x1, y2-y1, AlignLeft, mbx );
           break;
      case 3:
           p->drawText( 2, 2, x2-x1, y2-y1, AlignLeft, nr );
           break;
      case 4:
           p->drawText( 2, 2, x2-x1, y2-y1, AlignLeft, datum );
           break;
      case 5:
           p->drawText( 2, 2, x2-x1, y2-y1, AlignLeft, bytes );
           break;
      case 6:
           p->drawText( 2, 2, x2-x1, y2-y1, AlignLeft, lt );
           break;
      case 7:
           p->drawText( 2, 2, x2-x1, y2-y1, AlignLeft, titel );
           break;
   }
}


void BCTableEntry::toggleChecked()
{
   if (checked)
      checked = false;
   else
      checked = true;
}


bool BCTableEntry::isChecked()
{
   return checked;
}


void BCTableEntry::getInfo( char *board, int & mailnr )
{
   strcpy(board, rubrik);
   mailnr = atoi(nr);
}


//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


BCTable::BCTable( QWidget *parent, int _type ) : QTableView(parent)
{
   prnt = parent;
   type = _type;
   curRow = 0;
   rowsMarked = 0;

   setFocusPolicy( StrongFocus );
   setBackgroundMode( PaletteBase );
   setNumCols( 8 );
   setNumRows( 0 );
   setCellWidth( 0 );
   setCellHeight( 18 );
   setTableFlags( Tbl_vScrollBar |
  	               Tbl_hScrollBar |
                  Tbl_clipCellPainting |
	               Tbl_smoothScrolling);

   breite[0] = 60;
   breite[1] = 75;
   breite[2] = 60;
   breite[3] = 60;
   breite[4] = 60;
   breite[5] = 60;
   breite[6] = 40;
   breite[7] = width()-breite[0]-breite[1]-breite[2]-breite[3]-breite[4]-breite[5]-breite[6];

   contents = new QListTbl;
}


/*
  Destructor: deallocates memory for contents
*/
BCTable::~BCTable()
{
    delete contents;				// deallocation
}


void BCTable::addEntry( char *sender, char *rubrik, int nr, char *datum, char *mbx, int bytes, int lt, char *titel)
{
   BCTableEntry *e;

   e = new BCTableEntry(sender, rubrik, nr, datum, mbx, bytes, lt, titel);
   if (config->sortBoxCheck)
      contents->inSort(e);
   else
      contents->append(e);
   setNumRows( numRows()+1 );
}


int BCTable::cellWidth(int cell)
{
   return breite[cell];
}


void BCTable::clear()
{
   delete contents;
   contents = new QListTbl;

   setNumRows( 0 );
   update();
}


void BCTable::paintCell( QPainter* p, int row, int col )
{
   int w = cellWidth( col );
   int h = cellHeight( row );
   int x2 = w - 1;
   int y2 = h - 1;


   contents->at(row)->paintCell( p, 0, 0, x2, y2, col, (curRow == row) );
}


void BCTable::mousePressEvent( QMouseEvent* e )
{
   int i;
   int oldRow = curRow;

   QPoint clickedPos = e->pos();
   curRow = findRow( clickedPos.y() );

   if (oldRow != curRow)
      for (i=0; i<8; i++)
      {
         if (rowIsVisible(oldRow))
            updateCell( oldRow, i );
         if (rowIsVisible(curRow))
            updateCell( curRow, i );
      }
   QTableView::mousePressEvent(e);
}


void BCTable::mouseDoubleClickEvent( QMouseEvent* e )
{
   int i;
   int oldRow = curRow;
   BCTableEntry *entry;

   QPoint clickedPos = e->pos();
   curRow = findRow( clickedPos.y() );

   entry = contents->at(curRow);
   entry->toggleChecked();
   if (entry->isChecked())
      rowsMarked++;
   else
      rowsMarked--;


   for (i=0; i<8; i++)
   {
      if (rowIsVisible(oldRow))
         updateCell( oldRow, i );
      if (rowIsVisible(curRow))
         updateCell( curRow, i );
   }

   QTableView::mousePressEvent(e);
}


void BCTable::keyPressEvent( QKeyEvent* e )
{
   int oldRow = curRow;
   int i;
   bool checked=false;
   BCTableEntry *entry;

   switch (e->key())
   {
      case Key_Down:
           curRow++;
           break;
      case Key_Up:
           curRow--;
           break;
      case Key_Space:
           entry = contents->at(curRow);
           entry->toggleChecked();
           if (entry->isChecked())
              rowsMarked++;
           else
              rowsMarked--;
           checked = true;
           break;
      case Key_Return:
           sendRequest();
           clearMarks();
           break;
      case Key_E:
           eraseMail();
           break;
      case Key_R:
           readCurrentMail();
           break;
      case Key_T:
           transferCurrentMail();
           break;
      case Key_L:
           setLifetime();
           break;
   	default:
	        e->ignore();
	        return;
   }
   e->accept();


   if (curRow > numRows()-1)
      curRow = numRows()-1;

   if (curRow < 0)
      curRow = 0;

   if (curRow < topCell())
      setTopCell(curRow);

   if (curRow > lastRowVisible())
      setTopCell(topCell()+1);


   if (curRow != oldRow || checked)
      for (i=0; i<8; i++)
      {
         if (rowIsVisible(oldRow))
            updateCell( oldRow, i );
         if (rowIsVisible(curRow))
            updateCell( curRow, i );
      }
}


void BCTable::slotSizeChange(int col, int, int size)
{
   breite[col] = size;
   update();
}


void BCTable::sendRequest()
{
   BCTableEntry *entry;
   char tmp[200], str[200], board[50], lastboard[50];
   int nr;
   int startnr=-1, endnr=-1;


   tmp[0] = '\0';
   str[0] = '\0';
   lastboard[0] = '\0';
   if (type==BOXC_TYPE_RLI)
     strcpy(str,"R ");
   entry = contents->first();
   if (entry != NULL)
      do
      {
         if (entry->isChecked())
	   {
	     if (type==BOXC_TYPE_DIEBOX) 
	       {
		 // Ok, diese Mail soll angefordert werden
	     
		 entry->getInfo( board, nr );
		 if (nr > 0)
		   {
		     if (!strcmp(lastboard, board))
		       {
			 // Das selbe Board.
			 if (nr == endnr+1)
			   {
			     // Die folgende Mail im selben Board.
			     endnr++;
			   }
			 else
			   {
			     // Eine neue Mail der gleichen Rubrik.
			     if (startnr != endnr)
			   sprintf(tmp, "R %s %i-%i", board, startnr, endnr);
			     else
			       sprintf(tmp, "R %s %i", board, startnr);
			     startnr = nr;
			     endnr = nr;
			     if (str[0] == '\0')
			       strcpy(str, tmp);
			     else
			       sprintf(str+strlen(str), ";%s", tmp);
			   }
		       }
		     else
		       {
			 // Ein anderes Board
			 if (startnr != -1)
			   if (startnr != endnr)
			     sprintf(tmp, "R %s %i-%i", lastboard, startnr, endnr);
			   else
			     sprintf(tmp, "R %s %i", lastboard, startnr);
			 startnr = nr;
			 endnr = nr;
			 strcpy(lastboard, board);
			 if (str[0] == '\0')
			   strcpy(str, tmp);
			 else
			   sprintf(str+strlen(str), ";%s", tmp);
		       }
		   }
	       }
	     if (type==BOXC_TYPE_RLI) 
	       { 
		 entry->getInfo(board,nr);
		 sprintf(str+strlen(str),"%i ",nr);
	       }
            if (strlen(str) > 100)
            {
               strcat(str, "\r");
               emit sendString(str);
               str[0] = '\0';
	       if (type==BOXC_TYPE_RLI)
		 strcpy(str,"R ");

            }
         }
      } while ((entry = contents->next()) != NULL);

   if (type==BOXC_TYPE_DIEBOX) {
     if (startnr != endnr || startnr != -1)
       {
	 if (startnr != endnr)
	   sprintf(tmp, "R %s %i-%i", lastboard, startnr, endnr);
	 else
	   sprintf(tmp, "R %s %i", lastboard, startnr);
	 
	 if (str[0] == '\0')
	   strcpy(str, tmp);
	 else
	   sprintf(str+strlen(str), ";%s", tmp);
       }
   }
   if (str[0] != '\0')
   {
      strcat(str, "\r");
      emit sendString(str);
   }

   clearMarks();
}


void BCTable::clearMarks()
{
   BCTableEntry *entry;


   entry = contents->first();
   if (entry != NULL)
      do
      {
         if (entry->isChecked())
            entry->toggleChecked();
      } while ((entry = contents->next()) != NULL);

   update();
}


//   void BCTable::eraseMail()
//
// Wenn mehrere Mails ausgewaehlt sind werden die ausgewaehlten geloescht,
// sonst die, auf der der Cursor steht.
void BCTable::eraseMail()
{
   char tmp[500], board[100];
   int nr;
   BCTableEntry *entry;

   if ((entry = contents->current()) == NULL) return;

   entry->getInfo( board, nr );
   sprintf(tmp, klocale->translate("Do you really want to delete the mail %s %i?"),
                board, nr);

   if (KMsgBox::yesNo(NULL,
                      klocale->translate("Delete Mail?"),
                      tmp,
                      0,
                      klocale->translate("&Yes"),
                      klocale->translate("&No")) != 1)
      return;
   if (type==BOXC_TYPE_DIEBOX)
     sprintf( tmp,"E %s %i\r", board, nr );
   if (type==BOXC_TYPE_RLI)
     sprintf(tmp, "k %i\r",nr);
   emit sendString( tmp );
}


//   void BCTable::readCurrentMail()
//
// Liest nur die Mail aus, auf der der Cursor gerade steht
void BCTable::readCurrentMail()
{
   BCTableEntry *entry;
   char board[100], tmp[100];
   int nr;

   if ((entry = contents->current()) == NULL) return;
   entry->getInfo( board, nr );
   if (type==BOXC_TYPE_DIEBOX)
     sprintf( tmp,"R %s %i\r", board, nr );
   if (type==BOXC_TYPE_RLI)
     sprintf(tmp, "r %i\r",nr);
   emit sendString( tmp );
}


//   void BCTable::transferCurrentMail()
//
// Transferiert die Mail, auf der der Cursor gerade steht
void BCTable::transferCurrentMail()
{
   BCTableEntry *entry;
   char board[100], newboard[100], newmbx[100], tmp[500];
   int nr;


   if ((entry = contents->current()) == NULL) return;
   entry->getInfo( board, nr );

   DlgTransfer *dlg = new DlgTransfer(board, nr);

   dlg->setGeometry((this->width()-dlg->width())/2,
     		           (this->height()-dlg->height())/2,
  		              dlg->width(),dlg->height());

   if (dlg->exec() == 1)
   {
      dlg->getInfo( newboard, newmbx );

      if (newboard[0] == '\0') return;
      if (type==BOXC_TYPE_DIEBOX) {
	sprintf(tmp,"TR %s %i %s", board, nr, newboard);
	if (newmbx[0] != '\0')
	  sprintf(tmp+strlen(tmp), " @ %s\r", newmbx);
	else
	  strcat(tmp, "\r");
      }
      if (type == BOXC_TYPE_RLI) {
	sprintf(tmp,"sc %i %s", nr, newboard);
	if (newmbx[0] != '\0')
	  sprintf(tmp+strlen(tmp), "@%s\r/ex\r", newmbx);
	else
	  strcat(tmp, "\r/ex\r");
      }
      emit sendString( tmp );
   }

   delete dlg;
}


//   void BCTable::setLifetime()
//
// Setzt die Lifetime fuer die Mail, auf der der Cursor gerade steht
void BCTable::setLifetime()
{
   BCTableEntry *entry;
   char board[100], tmp[500];
   int nr, newlt;
   
   if (type==BOXC_TYPE_RLI)
     return;


   if ((entry = contents->current()) == NULL) return;
   entry->getInfo( board, nr );

   DlgSetLT *dlg = new DlgSetLT(board, nr);

   dlg->setGeometry((this->width()-dlg->width())/2,
     		           (this->height()-dlg->height())/2,
  		              dlg->width(),dlg->height());

   if (dlg->exec() == 1)
   {
      newlt = dlg->getLT();

      sprintf(tmp,"SETL %s %i %i\r", board, nr, newlt);
      emit sendString( tmp );
   }

   delete dlg;
}




//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////



BoxCheckWin::BoxCheckWin( QObject *prnt ,int type)
     : QDialog( 0, "", false )
{
   parent = prnt;


   resize(600, 350);

   header = new QHeader( this );
   header->setGeometry(0, 0, width(), 20);


   header->addLabel( klocale->translate("Sender") );
   header->addLabel( klocale->translate("Board") );
   header->addLabel( klocale->translate("MBX") );
   header->addLabel( klocale->translate("No.") );
   header->addLabel( klocale->translate("Date") );
   header->addLabel( klocale->translate("Size") );
   header->addLabel( klocale->translate("Lt") );
   header->addLabel( klocale->translate("Title") );

   header->setCellSize(0, 60);
   header->setCellSize(1, 75);
   header->setCellSize(2, 60);
   header->setCellSize(3, 60);
   header->setCellSize(4, 60);
   header->setCellSize(5, 60);
   header->setCellSize(6, 40);
   header->setCellSize(7, width()-header->cellSize(0)-header->cellSize(1)-
                                  header->cellSize(2)-header->cellSize(3)-
                                  header->cellSize(4)-header->cellSize(5)-
                                  header->cellSize(6));



   table = new BCTable( this ,type);
   table->setGeometry(0, header->height(), width(), height()-header->height()-BTNHEIGHT-10);
   table->slotSizeChange(7, 0, header->cellSize(7));
   table->setFocus();

   connect(header, SIGNAL(sizeChange(int,int,int)), table, SLOT(slotSizeChange(int,int,int)));
   connect(table, SIGNAL(sendString(char *)), parent, SLOT(sendString(char *)) );



   int abstand = (width()-(2*BTNLENGTH))/3;
   send = new QPushButton( this );
   send->setGeometry(abstand, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   send->setText( klocale->translate("&Send") );
   connect(send, SIGNAL(released()), this, SLOT(slotSend()));

   abort = new QPushButton( this );
   abort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   abort->setText( klocale->translate("&Abort") );
   connect(abort, SIGNAL(released()), this, SLOT(reject()));
}


BoxCheckWin::~BoxCheckWin()
{
   delete header;
   delete table;
}


void BoxCheckWin::addEntry( char *sender, char *rubrik, int nr, char *datum, char *mbx, int bytes, int lt, char *titel)
{
   table->addEntry(sender, rubrik, nr, datum, mbx, bytes, lt, titel);
}


void BoxCheckWin::clear()
{
   table->clear();
}


void BoxCheckWin::slotSend()
{
   table->sendRequest();
}


void BoxCheckWin::resizeEvent(QResizeEvent *event)
{
   QDialog::resizeEvent(event);

   int abstand = (width()-(2*BTNLENGTH))/3;
   header->setGeometry(0, 0, width(), 20);
   table->setGeometry(0, header->height(), width(), height()-header->height()-BTNHEIGHT-10);
   send->setGeometry(abstand, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
   abort->setGeometry(abstand*2+BTNLENGTH, height()-BTNHEIGHT-5, BTNLENGTH, BTNHEIGHT);
}



#include "boxcheck.moc"

