/*
 *  ConvKT - a LinKT convers vitalizer
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef USERLIST_H
#define USERLIST_H


#include <qobject.h>
#include <qtableview.h>
#include <qlist.h>
#include <qwidget.h>
#include <qpainter.h>


class UserListEntry : public QObject
{
   Q_OBJECT;
public:
   UserListEntry( char *call, char *host, bool away );
   ~UserListEntry();

   void getString( char *str );
   bool isStation( char *call, char *host );
   void setAway();
   void clearAway();
   bool isFiltered();
   void setFiltered( bool active );

private:
   char *call;
   char *host;
   bool away;
   bool filtered;
};


class UserListe : public QTableView
{
   Q_OBJECT;
public:
   UserListe( QWidget* parent=0 );
   ~UserListe();

   void insertItem( char *call, char *host, bool away );
   void setAway( char *call, char *host );
   void clearAway( char *call, char *host );
   void clearFromList( char *call, char *host );
   void clearList();
   void clearAllFilters();
   void addFilterCalls( char *calls );

private:
   QList<UserListEntry> *rows;

protected:
   void paintCell( QPainter *p, int row, int col );
};



#endif

