/*
 *  ConvKT - a LinKT convers vitalizer
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "userlist.h"
#include "userlist.moc"
#include "global.h"
#include "toolbox.h"

#include <stdio.h>
#include <stdlib.h>



UserListEntry::UserListEntry( char *call, char *host, bool away )
{
   this->call = (char *) strdup(call);
   this->host = (char *) strdup(host);
   this->away = away;

   if (filterCalls.find(call) == -1)
      filtered = false;
   else
      filtered = true;
}


UserListEntry::~UserListEntry()
{
   free(call);
   free(host);
}


void UserListEntry::getString( char *str )
{
   strcpy(str, call);

   if (filtered) return;

   if (away)
      strcat(str, " (A)");
}


bool UserListEntry::isStation( char *call, char *host )
{
   if (strcmp(call, this->call)) return false;
   if (host != NULL)
      if (strcmp(host, this->host)) return false;

   return true;
}


void UserListEntry::setAway()
{
   away = true;
}


void UserListEntry::clearAway()
{
   away = false;
}


bool UserListEntry::isFiltered()
{
   return filtered;
}


void UserListEntry::setFiltered( bool active )
{
   filtered = active;
}




////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


UserListe::UserListe( QWidget* parent ) : QTableView( parent )
{
   setNumCols(1);
   setNumRows(0);
   setCellWidth(100);
   setCellHeight(15);

   setTableFlags( Tbl_clipCellPainting | Tbl_autoVScrollBar );
   setBackgroundMode( PaletteBase );
   setFrameStyle( QFrame::WinPanel|QFrame::Sunken );
//   setFocusPolicy(StrongFocus);

   rows = new QList<UserListEntry>();
   rows->setAutoDelete( true );
   setAutoUpdate( true );
}


UserListe::~UserListe()
{
   delete rows;
}


void UserListe::paintCell( QPainter *p, int row, int col )
{
   UserListEntry *entry;
   char str[100];
   int w = cellWidth( col );			// width of cell in pixels
   int h = cellHeight( row );			// height of cell in pixels

   entry = rows->at(row);
   entry->getString( str );
   if (entry->isFiltered())
      p->setPen( colors[config->colors->filtered] );
   else
      p->setPen( colors[COLOR_BLACK] );
   p->drawText( 2, 0, w, h, AlignLeft, str );
}


void UserListe::insertItem( char *call, char *host, bool away )
{
   UserListEntry *entry;

   entry = new UserListEntry( call, host, away );
   rows->append( entry );
   setNumRows(rows->count());
}


void UserListe::setAway( char *call, char *host )
{
   UserListEntry *entry;


   if ((entry = rows->first()) == NULL) return;
   do
   {
      if (entry->isStation( call, host ))
      {
         entry->setAway();
         updateCell( rows->at(), 0 , true );
      }
   }
   while ((entry = rows->next()) != NULL);
}


void UserListe::clearAway( char *call, char *host )
{
   UserListEntry *entry;


   if ((entry = rows->first()) == NULL) return;
   do
   {
      if (entry->isStation( call, host ))
      {
         entry->clearAway();
         updateCell( rows->at(), 0 , true );
      }
   }
   while ((entry = rows->next()) != NULL);
}


void UserListe::clearFromList( char *call, char *host )
{
   UserListEntry *entry;


   if ((entry = rows->first()) == NULL) return;
   do
   {
      if (entry->isStation( call, host ))
      {
         rows->remove(entry);
         setNumRows(rows->count());
         return;
      }
   }
   while ((entry = rows->next()) != NULL);
}


void UserListe::clearList()
{
   rows->clear();
   setNumRows(0);
   update();
}


void UserListe::clearAllFilters()
{
   UserListEntry *entry;


   filterCalls.clear();

   if ((entry = rows->first()) == NULL) return;
   do
   {
      entry->setFiltered( false );
   }
   while ((entry = rows->next()) != NULL);
   update();
}


void UserListe::addFilterCalls( char *calls )
{
   char tmp[500], str[500];
   UserListEntry *entry;
   int i,len;


   filterCalls.clear();

   // Erstmal alle alten Filter-Eintraege entfernen
   if ((entry = rows->first()) == NULL) return;
   do
   {
      entry->setFiltered( false );
   }
   while ((entry = rows->next()) != NULL);


   OnlyOneSpace(str, calls);
   KillSpacesLeft(str);
   KillSpacesRight(str);
   while (str[0] != '\0')
   {
      if ((i = POS(' ', str)) == -1)
      {
         strcpy(tmp, str);
         str[0] = '\0';
      }
      else
      {
         memcpy(tmp, str, i);
         len = strlen(str)-i-1;
         memmove(str, str+i+1, len);
      }

      filterCalls.append(tmp);

      if ((entry = rows->first()) == NULL) return;
      do
      {
         if (entry->isStation( tmp, NULL ))
            entry->setFiltered(true);
      }
      while ((entry = rows->next()) != NULL);
   }

   repaint( false );
}



