/*
 *  ConvKT - a LinKT convers vitalizer
 *  Copyright (C) 1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef MAIN_H
#define MAIN_H


#include <kapp.h>
#include <ktopwidget.h>
#include <knewpanner.h>
#include <kmenubar.h>
#include <ktoolbar.h>

#include <qpopupmenu.h>
#include <qlist.h>
#include <qheader.h>

#include <unistd.h>

#include "output.h"
#include "global.h"
#include "convchan.h"
#include "ax25k.h"
#include "buttonbar.h"


extern QColor colors[17];



#define MSGTYP_TEXT 1
#define MSGTYP_JOINED 2

#define STATUS_GETUSRLST 1
#define STATUS_GETUSRLSTTNN 2
#define STATUS_AWAY 3
#define STATUS_GETCHLIST 4
#define STATUS_PERSTEXT 5


typedef struct
{
   char call[20];
   ConversChannel *chan;
} s_lastjoined;


typedef struct
{
   char call[20];
   char host[20];
   ConversChannel *chan;
} s_lastaway;


class TopLevel : public KTopLevelWidget
{
   Q_OBJECT;
public:
   TopLevel( const char *name=0 );
   ~TopLevel();

   ButtonBar *buttonbar;

   ConversChannel * addChannel( int channr );
   void chooseChannel( ConversChannel *chan );
   void workWithFrame( char *str, int len );
   void makeAX25Connect( char *call, char *path, char *port, char *mycall );
   void setStatus( int axstate );
   void reconnectHost();

   void outText( ConversChannel *chan, char *str, QColor color, bool ret );

   void sendString( char *str, int len );
   void sendString( char *str );
   void sendString( int ch, char *str );

   void resizeEvent(QResizeEvent *e);

   bool isVisible( ConversChannel *chan );

public slots:
   void slotBeenden();
   void slotUserListe();
   void slotConnect();
   void slotDisconnect();
   void slotFunctionKey(int id);

private:
   QList<ConversChannel> *chans;
   AX25 *ax25;

   KToolBar *toolbar;
   int tb_conn, tb_disc;

/*   QPopupMenu *file, *help, *pref;
   KMenuBar *menubar;*/

   QWidget *output;

   int old_status;
   char *savestr;
   int savestrlen;
   int delspaces;
   char conncall[20];
   bool reconnecting;
   int recChanNrs[50];
   int recChanCount;
//   ConversChannel *aktChan;
   ConversChannel *lastSternMsg;
   ConversChannel *visibleChan;
   bool gettingUserList;

   void setupMenuBar();
   void setupToolBar();

   void deleteChannelView( int chnr );

   ConversChannel * getChanPtr( int chnr );
   void lookForSystemMessages( char *str );
   void getConnData( const char *call );
   void sendStartScript();
   void clearAllFilters();
   void updateFilters( char *calls );
   void sendReconnectData();

   /////////////////////////////////////////////////////
   void sendAllAway( char *call, char *host, char *str );
   void sendAllAwayText( char *call, char *host, char *text );
   void sendAllBackAgain( char *call, char *host, char *line );

   bool firstconn;
   int status;
   int lastMsgTyp;
   ConversChannel *lastChan;  // Zeiger auf den Kanal, von dem als letztes
                              // etwas empfangen wurde
   ConversChannel *aktChan;   // Zeiger auf den Kanal, der im Augenblick
                              // aktuell ist

   s_lastjoined lastjoined;
   s_lastaway lastaway;

protected:
   void closeEvent(QCloseEvent *e);
};

void init_globals();
void init_stnlist();


#endif /* MAIN_H */

