 /*
 *  ConvKT - a LinKT convers vitalizer
 *  Copyright (C) 1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "main.h"
#include "global.h"
#include "toolbox.h"
#include "dialog.h"
#include "version.h"

#include <stdlib.h>
#include <stdio.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#include <kmsgbox.h>
#include <kiconloader.h>

#include <qkeycode.h>
#include <qaccel.h>
#include <qsplitter.h>

#define BUTTON_WIDTH 60
#define BUTTON_HEIGHT 25


QColor colors[17] = {black,white,darkGray,gray,lightGray,red,green,
                     blue,cyan,magenta,yellow,darkRed,darkGreen,darkBlue,
                     darkCyan,darkMagenta,darkYellow};

bool beenden=false;


KApplication *mykapp;
TopLevel *toplevel;
// Aus global.h
s_config *config;
s_stnlist *stnlist;
QStrList filterCalls;





/*
 *  TopLevel::TopLevel( QWidget *parent=0, const char *name=0 )
 * Konstruktor des Hauptfensters
 */
TopLevel::TopLevel( const char *name )
             : KTopLevelWidget(name)
{
   QFont fOut( config->output_font, config->output_size );
   QFont fUsr( config->userlist_font, config->userlist_size );
   QFontMetrics fmOut(fOut), fmUsr(fUsr);

   int screenwidth = (config->screenwidth+5) * fmOut.width("m") +
                     12 * fmUsr.width("m");

   setMinimumSize (300, 200);
   resize( screenwidth, 400 );

   setCaption(klocale->translate("ConvKT - the LinKT convers vitalizer"));


   chans = new QList<ConversChannel>();
   chans->setAutoDelete(true);


//   setupMenuBar();
   setupToolBar();

   output = new QWidget( this );
   savestr = NULL;
   savestrlen = 0;
   aktChan = NULL;
   delspaces = 0;
   lastSternMsg = NULL;
   gettingUserList = false;
   visibleChan = NULL;
   old_status = 0;
   firstconn = true;
   conncall[0] = '\0';
   reconnecting = false;
   recChanCount = -1;

   lastChan = NULL;
   status = 0;
   lastMsgTyp = 0;

   buttonbar = new ButtonBar( output );

   QAccel *a = new QAccel( this );
   a->connectItem( a->insertItem( Key_W+ALT ), this, SLOT(slotUserListe()) );

   output->setGeometry( 0, 0, width(), height()-toolbar->height() );
   buttonbar->setGeometry( 0, output->height()-BBAR_BTNHEIGHT, output->width(), BBAR_BTNHEIGHT );

   setView(output);

   show();
}


TopLevel::~TopLevel()
{
}



void TopLevel::setupToolBar()
{
   toolbar = new KToolBar( this );

   KIconLoader *loader = mykapp->getIconLoader();

   QPixmap pixmap;


   pixmap = loader->loadIcon( "disconnected.xpm" );
   tb_conn = 1;
   toolbar->insertButton( pixmap, 1,
                          SIGNAL(clicked()), this,
                          SLOT(slotConnect()), true, "make connect");

   pixmap = loader->loadIcon( "connected.xpm" );
   tb_disc = 2;
   toolbar->insertButton( pixmap, 2,
                          SIGNAL(clicked()), this,
                          SLOT(slotDisconnect()), false, "disconnect");

   toolbar->setBarPos( KToolBar::Top );

   addToolBar(toolbar);
}



/*
 *  void TopLevel::setupMenuBar()
 * Das Hauptmenue wird aufgebaut und an das KTopLevelWidget angedockt.
 */
void TopLevel::setupMenuBar()
{
/*   pref = new QPopupMenu();

   pref->insertItem( klocale->translate("&Colors"), this, SLOT(slotPrefColors()));
   pref->insertItem( klocale->translate("&DX-Cluster-Spy"), this, SLOT(slotPrefDX()));


   file = new QPopupMenu ();

   file->insertItem( klocale->translate("&Preferences"), pref );
   file->insertSeparator( -1 );
   file->insertItem( klocale->translate("E&xit"), this, SLOT(slotBeenden()), ALT+Key_X);


   help = new QPopupMenu ();
   help->insertItem( klocale->translate("&Index"), this, SLOT(slotHelp()));
   help->insertItem( klocale->translate("&About"), this, SLOT(slotAbout()));



   menubar = new KMenuBar (this);
   menubar->insertItem( klocale->translate("&File"), file );
   menubar->insertSeparator( -1 );
   menubar->insertItem( klocale->translate("&Help"), help );

   setMenu(menubar);*/
}


void TopLevel::closeEvent(QCloseEvent *e)
{
   if (KMsgBox::yesNo(NULL,
                      klocale->translate("Quit ConvKT?"),
                      klocale->translate("Do you really want to quit ConvKT?"),
                      0,
                      klocale->translate("&Yes"),
                      klocale->translate("&No")) != 1)
   {
      e->ignore();
      return;
   }

   e->accept();
}


void TopLevel::resizeEvent(QResizeEvent *e)
{
   ConversChannel *tmp;

   KTopLevelWidget::resizeEvent(e);


   if ((tmp = chans->first()) == NULL) return;

   do
   {
      tmp->setGeometry( 0, 0, output->width(), output->height()-buttonbar->height() );
   }
   while ((tmp = chans->next()) != NULL);

   buttonbar->setGeometry( 0, output->height()-BBAR_BTNHEIGHT, output->width(), BBAR_BTNHEIGHT );
}


void TopLevel::slotBeenden()
{
   close();
}


ConversChannel * TopLevel::addChannel( int channr )
{
   ConversChannel *chan = new ConversChannel( output, channr );
   chan->setGeometry( 0, 0, output->width(), output->height()-buttonbar->height() );

   chans->append( chan );

   chan->show();
   chooseChannel( chan );

   chan->setSize();

   return chan;
}


void TopLevel::chooseChannel( ConversChannel *chan )
{
   ConversChannel *tmp;

   if ((tmp = chans->first()) == NULL) return;

   do
   {
      if (tmp == chan)
      {
         tmp->btn->setDown( true );
         tmp->show();
         tmp->setNew( false );
         tmp->input->setFocus();
         visibleChan = tmp;
      }
      else
      {
         tmp->btn->setDown( false );
         tmp->hide();
      }
   } while ((tmp = chans->next()) != NULL);
}


void TopLevel::makeAX25Connect( char *call, char *path, char *port, char *mycall )
{
   ax25 = new AX25( call, path, port, mycall );
}


void TopLevel::sendString( char *str, int len )
{
   write( ax25->fd, str, len );
}


void TopLevel::sendString( char *str )
{
   sendString(str, strlen(str));
}


void TopLevel::sendString( int ch, char *str )
{
   char *tmp;

   if (ch == aktChan->getChanNr() || str[0] == '/')
   {
      sendString( str, strlen(str) );
      return;
   }

   tmp = (char *) malloc( strlen(str)+50 );
   sprintf( tmp, "/m #%i %s", ch, str );
   sendString( tmp, strlen(tmp) );
   free(tmp);
}


void TopLevel::setStatus( int axstate )
{
   char tmp[500];


   // Haben wir connected?
   if (((old_status == 1) && (axstate == 4)) ||
       ((old_status == 0) && (axstate == 4)))
   {

      if (config->emptyframe)
         sendString( "\r" );

      if (config->pw)
         if (config->pwstr == NULL)
            sendString( "\r" );
         else
         {
            sprintf(tmp, "%s\r", config->pwstr);
            sendString( tmp );
         }


      sprintf(tmp, "%s\r", config->convstr );
      sendString( tmp );
   }

   // Verbindungsabbau
   if ((old_status > 1) && (axstate == 0))
   {
      delete ax25;
      ax25 = NULL;
   }
   old_status = axstate;
}


void TopLevel::workWithFrame( char *rxstr, int rxstrlen )
{
   int i, j, k, len, chnr;
   char str[5000], str2[5000], call[50], data[500], tmp[1000];



   len = 0;
   if (savestr != NULL)
   {
      memcpy(str, savestr, savestrlen);
      len = savestrlen;
      free(savestr);
      savestr = NULL;
      savestrlen = 0;
   }

   memcpy(str+len, rxstr, rxstrlen);
   len += rxstrlen;
   str[len] = '\0';


   while (str[0] != '\0')
   {
      if ((i = POS('\r', str)) == -1)
      {
         // Kein Return - abspeichern
         savestr = (char *) malloc(len);
         memcpy(savestr, str, len);
         savestrlen = len;
         return;
      }
      else
      {
         memcpy( str2, str, i );
         str2[i] = '\0';
         len -= (i+1);
         memmove( str, str+i+1, len );
         str[len] = '\0';
      }


      if (status == 0)
      {
         if (str2[0] == '<')
         {
/*            if (str2[1] == '*')
            {
               // Persoenliche Nachricht
               if (config->openPersWin)
               {
                  // Eigenes Fenster dafuer aufmachen
               }
            }
            else
            {*/
               // Ein normaler Text wird empfangen
               if (((i = POS('>', str2)) == -1) || ((k = POS(':', str2)) == -1) || (k > i))
               {
                  lastChan = aktChan;
                  lastChan->textGot(str2);
                  lastMsgTyp = MSGTYP_TEXT;
                  delspaces = 0;
               }
               else
               {
                  j = strlen(str2)-i-3;
                  memcpy( data, str2+i+3, j );
                  data[j] = '\0';

                  memcpy( tmp, str2+1, i-1 );
                  tmp[i-1] = '\0';
                  if (sscanf(tmp, "%i:%s", &chnr, call) != 2)
                  {
                     lastChan = aktChan;
                     lastChan->textGot(str2);
                     lastMsgTyp = MSGTYP_TEXT;
                     delspaces = 0;
                  }
                  else
                  {
                     sprintf(str2, "<%s>: %s", call, data);
                     sprintf(tmp, "%i", chnr);
                     delspaces = strlen(tmp)+1;
                     lastChan = getChanPtr( chnr );
                     lastChan->textGot(str2);
                     lastMsgTyp = MSGTYP_TEXT;
                  }
               }
//            }
         }
         else if (str2[0] == '*')
                 lookForSystemMessages( str2 );
              else if (lastChan != NULL)
                   {
                      // Gucken, ob eine /w * - Liste oder aehnliches empfangen
                      // wird
                      if (!strcmp(str2, "User      Host      Via       Channel   Idle"))
                      {
                         status = STATUS_GETUSRLST;
                         aktChan->clearUserList();
                         outText( aktChan, str2, colors[config->colors->rx], true );
                      }
                      else
                         if (!strcmp(str2, "User    Host   Via    Chan.   Idle Personal"))
                         {
                            status = STATUS_GETUSRLSTTNN;
                            aktChan->clearUserList();
                            outText( aktChan, str2, colors[config->colors->rx], true );
                         }
                         else
                            if (!strcmp(str2, "Channel Flags  Topic"))
                            {
                               outText( aktChan, str2, colors[config->colors->rx], true );
                               status = STATUS_GETCHLIST;
                            }
                            else
                            {
                               lastChan->textGot(str2+delspaces);
                               lastMsgTyp = MSGTYP_TEXT;
                            }
                   }
      }
      else switch (status)  // Besondere Staten, wie z.B. das Empfangen von /w - Listen etc
           {
              case STATUS_GETUSRLST: //  /w * - Liste wird gerade empfangen
                   outText( aktChan, str2, colors[config->colors->rx], true );
                   if (!strcmp(str2, "***"))
                      status = 0;
                   else
                      aktChan->userListEntry( str2, TYPE_PP );
                   break;
              case STATUS_GETUSRLSTTNN: //  /w * - Liste wird gerade empfangen (TNN-Format)
                   outText( aktChan, str2, colors[config->colors->rx], true );
                   if (!strcmp(str2, "***"))
                      status = 0;
                   else
                      aktChan->userListEntry( str2, TYPE_TNN );
                   break;
              case STATUS_AWAY:
                   sendAllAwayText( lastaway.call,
                                    lastaway.host,
                                    str2 );
                   status = 0;
                   break;
              case STATUS_GETCHLIST:
                   outText( aktChan, str2, colors[config->colors->rx], true );
                   if (!strcmp(str2, "***"))
                      status = 0;
                   break;
              case STATUS_PERSTEXT:
                   outText( lastChan, str2, colors[config->colors->system], true );
                   status = 0;
                   break;
           }
   }
}


ConversChannel * TopLevel::getChanPtr( int chnr )
{
   ConversChannel *tmp;

   if ((tmp = chans->first()) == NULL) return NULL;

   do
   {
      if (tmp->getChanNr() == chnr) return tmp;
   } while ((tmp = chans->next()) != NULL);

   return NULL;
}


void TopLevel::lookForSystemMessages( char *str )
{
   char tmp[500], call[100], host[100], *ptr;
   int len,i,chnr;
   ConversChannel *convchan;


   // Alleine auf einen neuen Kanal
   if (sscanf(str, "*** You created a new channel %i.", &chnr) == 1)
   {
      // Neuer Kanal
      aktChan = addChannel( chnr );
      lastChan = aktChan;
      lastMsgTyp = 0;
      sendString("/w *\r");
      if (firstconn)
      {
         sendStartScript();
         firstconn = false;
      }
      if (reconnecting)
      {
         sendReconnectData();
         reconnecting = false;
      }

      outText( aktChan, str, colors[config->colors->system], true );
      return;
   }


   // Ein schon bestehender Kanal wird gejoined, es sind User da.
   if (sscanf(str, "*** (%i:%i) You are now talking to channel %i. There are %i users.", &i, &i, &chnr, &i) == 4)
   {
      // Gucken, ob dieser Kanal schon vorhanden ist
      aktChan = getChanPtr( chnr );
      if (aktChan == NULL)
      {
         // Neuer Kanal
         aktChan = addChannel( chnr );
         lastChan = aktChan;
         lastMsgTyp = 0;
         sendString("/w *\r");
         if (firstconn)
         {
            sendStartScript();
            firstconn = false;
         }
         if (reconnecting)
         {
            sendReconnectData();
            reconnecting = false;
         }

         outText( aktChan, str, colors[config->colors->system], true );
      }
      else
      {
         chooseChannel(aktChan);
         lastChan = aktChan;
      }
      return;
   }


   // Es wird waehrend dem Betrieb auf einen anderen Kanal umgeschaltet.
   if (sscanf(str, "*** (%i:%i) You are now talking to channel %i. You're %s.", &i, &i, &chnr, tmp) == 4)
   {
      // Gucken, ob dieser Kanal schon vorhanden ist
      aktChan = getChanPtr( chnr );
      if (aktChan == NULL)
      {
         // Neuer Kanal
         aktChan = addChannel( chnr );
         lastChan = aktChan;
         lastMsgTyp = 0;
         sendString("/w *\r");
         if (firstconn)
         {
            sendStartScript();
            firstconn = false;
         }
         if (reconnecting)
         {
            sendReconnectData();
            reconnecting = false;
         }

         outText( aktChan, str, colors[config->colors->system], true );
      }
      else
      {
         chooseChannel(aktChan);
         lastChan = aktChan;
      }
      return;
   }


   // Im Betrieb wird ein anderer als der aktuelle Kanal verlassen
   if (sscanf(str, "*** (%i:%i) Left channel %i.", &i, &i, &chnr) == 3)
   {
      if ((convchan = getChanPtr( chnr )) != NULL)
      {
         chans->remove( convchan );
         buttonbar->deleteButton( convchan->btn );
         buttonbar->redrawButtons();
      }
      outText( aktChan, str, colors[config->colors->system], true );
      return;
   }


   // Im Betrieb wird der aktuelle Kanal verlassen
   if (sscanf(str, "*** (%i:%i) Default channel is now %i.", &i, &i, &chnr) == 3)
   {
      chans->remove( aktChan );
      buttonbar->deleteButton( aktChan->btn );
      buttonbar->redrawButtons();

      if ((aktChan = getChanPtr( chnr )) != NULL)
      {
         outText( aktChan, str, colors[config->colors->system], true );
         chooseChannel(aktChan);
      }
      return;
   }


   if (strstr(str, " joined channel") != NULL)
   {
      // Eine neue Station hat diesen Kanal gejoined...
      len = strlen(str)-12;
      memcpy(tmp, str+12, len);
      tmp[len] = '\0';

      if ((i = POS('@', tmp)) == -1)
      {
         outText( aktChan, str, colors[config->colors->system], true );
         return;
      }
      memcpy(call, tmp, i);
      call[i] = '\0';
      len = strlen(tmp)-i-1;
      memmove(tmp, tmp+i+1, len);
      tmp[len] = '\0';

      if ((i = POS(' ', tmp)) == -1)
      {
         outText( aktChan, str, colors[config->colors->system], true );
         return;
      }
      memcpy(host, tmp, i);
      host[i] = '\0';
      len = strlen(tmp)-i-1;
      memmove(tmp, tmp+i+1, len);
      tmp[len] = '\0';

      if (sscanf(tmp, "joined channel %i", &chnr) != 1)
      {
         outText( aktChan, str, colors[config->colors->system], true );
         return;
      }

      if ((convchan = getChanPtr( chnr )) == NULL)
      {
         outText( aktChan, str, colors[config->colors->system], true );
         return;
      }

      outText( convchan, str, colors[config->colors->system], true );
      lastChan = convchan;
      convchan->addUserList( call, host, "", false );
      // lastMsgTyp = joined, d.h. als naechstes kommt eventuell der Perstext
      lastMsgTyp = MSGTYP_JOINED;

      strcpy( lastjoined.call, call );
      lastjoined.chan = convchan;
      return;
   }


   if (strstr(str, " left channel") != NULL)
   {
      len = strlen(str)-12;
      memcpy(tmp, str+12, len);
      tmp[len] = '\0';

      if ((i = POS('@', tmp)) == -1)
      {
         outText( aktChan, str, colors[config->colors->system], true );
         return;
      }
      memcpy(call, tmp, i);
      call[i] = '\0';
      len = strlen(tmp)-i-1;
      memmove(tmp, tmp+i+1, len);
      tmp[len] = '\0';

      if ((i = POS(' ', tmp)) == -1)
      {
         outText( aktChan, str, colors[config->colors->system], true );
         return;
      }
      memcpy(host, tmp, i);
      host[i] = '\0';
      len = strlen(tmp)-i-1;
      memmove(tmp, tmp+i+1, len);
      tmp[len] = '\0';

      if (sscanf(tmp, "left channel %i %s", &chnr, tmp) != 2)
      {
         outText( aktChan, str, colors[config->colors->system], true );
         return;
      }

      if ((convchan = getChanPtr( chnr )) == NULL)
      {
         outText( aktChan, str, colors[config->colors->system], true );
         return;
      }

      outText( convchan, str, colors[config->colors->system], true );
      lastChan = convchan;
      convchan->delUserList( call, host );
      lastMsgTyp = 0;
      return;
   }


   // Ist jemand away gegangen?
   if (strstr(str, " has gone away") != NULL)
   {
      len = strlen(str)-12;
      memcpy(tmp, str+12, len);
      tmp[len] = '\0';

      if ((i = POS('@', tmp)) == -1)
      {
         outText( aktChan, str, colors[config->colors->system], true );
         return;
      }
      memcpy(call, tmp, i);
      call[i] = '\0';
      len = strlen(tmp)-i-1;
      memmove(tmp, tmp+i+1, len);
      tmp[len] = '\0';

      if ((i = POS(' ', tmp)) == -1)
      {
         outText( aktChan, str, colors[config->colors->system], true );
         return;
      }
      memcpy(host, tmp, i);
      host[i] = '\0';
      len = strlen(tmp)-i-1;
      memmove(tmp, tmp+i+1, len);
      tmp[len] = '\0';

      sendAllAway( call, host, str );
      // als naechstes kommt der Away-Text (eine Zeile)
      status = STATUS_AWAY;

      strcpy( lastaway.call, call );
      strcpy( lastaway.host, host );
      lastaway.chan = aktChan;
      return;
   }



   // Wieder da (nicht mehr away)
   if (strstr(str, " is back again") != NULL)
   {
      len = strlen(str)-12;
      memcpy(tmp, str+12, len);
      tmp[len] = '\0';

      if ((i = POS('@', tmp)) == -1)
      {
         outText( aktChan, str, colors[config->colors->system], true );
         return;
      }
      memcpy(call, tmp, i);
      call[i] = '\0';
      len = strlen(tmp)-i-1;
      memmove(tmp, tmp+i+1, len);
      tmp[len] = '\0';

      if ((i = POS(' ', tmp)) == -1)
      {
         outText( aktChan, str, colors[config->colors->system], true );
         return;
      }
      memcpy(host, tmp, i);
      host[i] = '\0';
      len = strlen(tmp)-i-1;
      memmove(tmp, tmp+i+1, len);
      tmp[len] = '\0';

      sendAllBackAgain( call, host, str );
      return;
   }


   // Die Station setzt gerade den Personal-Text
   if ((ptr = strstr(str, "on channel")) != NULL)
      if (sscanf(ptr, "on channel %i set personal text:", &chnr) == 1)
      {
         lastChan = getChanPtr( chnr );
         outText( lastChan, str, colors[config->colors->system], true );
         status = STATUS_PERSTEXT;
         return;
      }



   if (!strcmp(str, "*** Filter switched off."))
   {
      outText( aktChan, str, colors[config->colors->system], true );
      clearAllFilters();
      return;
   }


   // Filter setzen
   if (sscanf(str, "*** Filter active: %s", tmp) == 1)
   {
      outText( aktChan, str, colors[config->colors->system], true );
      updateFilters( tmp );
      return;
   }


   if (sscanf(str, "*** Filter updated. now filtering %s", tmp) == 1)
   {
      outText( aktChan, str, colors[config->colors->system], true );
      updateFilters( tmp );
      return;
   }



   // lastMsgTyp abfragen
   switch (lastMsgTyp)
   {
      case MSGTYP_JOINED: // Jetzt kommt der Pers-Text
           lastjoined.chan->perstextSet( lastjoined.call, str+4 );
           lastMsgTyp = 0;
           outText( lastjoined.chan, str, colors[config->colors->system], true );
           return;
   }


   // Unbekannte Frames, die mit *** anfangen, werden einfach so ausgesendet.
   outText( aktChan, str, colors[config->colors->system], true );
}


void TopLevel::clearAllFilters()
{
   ConversChannel *tmp;


   if ((tmp = chans->first()) == NULL) return;

   do
   {
      tmp->userliste->clearAllFilters();
   }
   while ((tmp = chans->next()) != NULL);
}


void TopLevel::updateFilters( char *calls )
{
   ConversChannel *tmp;


   if ((tmp = chans->first()) == NULL) return;

   do
   {
      tmp->userliste->addFilterCalls( calls );
   }
   while ((tmp = chans->next()) != NULL);
}


void TopLevel::outText( ConversChannel *chan, char *str, QColor color, bool ret )
{
   int i=0;


   if (chan == NULL) return;

   while (str[i] != '\0')
   {
      if (str[i] == 0x07)
      {
         str[i] = '#';
         if (config->beepCtrlG)
            QApplication::beep();
      }
      i++;
   }

   chan->output->writeText( str, color, STYLE_NORMAL );
   if (ret)
      chan->output->newLine();

   if (visibleChan != chan)
      chan->setNew( true );
}


void TopLevel::deleteChannelView( int chnr )
{
/*   ConversChannel *tmp;

   if ((tmp = chans->first()) == NULL) return;

   do
   {
      if (tmp->getChanNr() == chnr)
      {
         if (tmp == aktChan) aktChan = NULL;
         if (tmp == lastSternMsg) lastSternMsg = NULL;
         chans->remove();
         redrawButtons();
         return;
      }
   }
   while ((tmp = chans->next()) != NULL);*/
}


void TopLevel::slotUserListe()
{
/*   if (visibleChan == NULL) return;

   DlgUserList *dlg = new DlgUserList( visibleChan->getChanNr(), visibleChan );

   QPoint point = this->mapToGlobal (QPoint (0,0));

   QRect pos = this->geometry();
   dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
 		   point.y() + pos.height()/2 - dlg->height()/2,
 		   dlg->width(),dlg->height());

   dlg->exec();

   delete dlg;*/
}


void TopLevel::slotConnect()
{
   DlgConnect *dlg = new DlgConnect();

   QPoint point = this->mapToGlobal (QPoint (0,0));

   QRect pos = this->geometry();
   dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
 		   point.y() + pos.height()/2 - dlg->height()/2,
 		   dlg->width(),dlg->height());

   if (dlg->exec() == 1)
   {
      strcpy( conncall, dlg->getCall() );
      getConnData( conncall );
   }

   delete dlg;
}


void TopLevel::getConnData( const char *call )
{
   s_stnlist *tmp;
   char str[100];

   tmp = stnlist;
   while (tmp != NULL)
   {
      strcpy(str, tmp->hostcall);
      Gross(str);
      if (!strcmp(str, call))
      {
         // Diesen Eintrag wollen wir. Checken, ob alles ok ist
         if (tmp->mycall == NULL)
         {
            KMsgBox::message(0,klocale->translate("Error"),klocale->translate("You have to specify a mycall"));
            return;
         }
         else if (tmp->mycall[0] == '\0')
              {
                 KMsgBox::message(0,klocale->translate("Error"),klocale->translate("You have to specify a mycall"));
                 return;
              }

         if (tmp->login_cmd == NULL)
         {
            KMsgBox::message(0,klocale->translate("Error"),klocale->translate("You have to specify a login-command"));
            return;
         }
         else if (tmp->login_cmd[0] == '\0')
              {
                 KMsgBox::message(0,klocale->translate("Error"),klocale->translate("You have to specify a login-command"));
                 return;
              }

         if (tmp->hostcall == NULL)
         {
            KMsgBox::message(0,klocale->translate("Error"),klocale->translate("You have to specify a hostcall"));
            return;
         }
         else if (tmp->hostcall[0] == '\0')
              {
                 KMsgBox::message(0,klocale->translate("Error"),klocale->translate("You have to specify a hostcall"));
                 return;
              }

         if (tmp->port == NULL)
         {
            KMsgBox::message(0,klocale->translate("Error"),klocale->translate("You have to specify a port"));
            return;
         }
         else if (tmp->port[0] == '\0')
              {
                 KMsgBox::message(0,klocale->translate("Error"),klocale->translate("You have to specify a port"));
                 return;
              }

         config->pw = tmp->linuxpw;
         config->pwstr = tmp->pw;
         config->emptyframe = tmp->emptyframe;
         config->convstr = tmp->login_cmd;
         config->script = tmp->script;

         makeAX25Connect( tmp->hostcall, tmp->path, tmp->port, tmp->mycall );

         // An dieser Stelle wird das andere Toolbar-Icon aktiviert werden
         toolbar->getButton(tb_conn)->setEnabled( false );
         toolbar->getButton(tb_disc)->setEnabled( true );
         return;
      }
      tmp = tmp->next;
   }

   sprintf(str, klocale->translate("Data for %s cannot be found."), call);
   KMsgBox::message(0, klocale->translate("Error"), str);
}


void TopLevel::slotDisconnect()
{

   if (KMsgBox::yesNo(NULL,
                      klocale->translate("Close connection?"),
                      klocale->translate("Do you really want to close the current connection?"),
                      0,
                      klocale->translate("&Yes"),
                      klocale->translate("&No")) == 1)
   {

      // Die AX.25-Verbindung killen
      delete ax25;
      ax25 = NULL;

      delete chans;

      chans = new QList<ConversChannel>();
      chans->setAutoDelete(true);

      // Andere Variablen neu initialisieren
      if (savestr != NULL)
         free(savestr);
      savestr = NULL;
      savestrlen = 0;
      aktChan = NULL;
      delspaces = 0;
      lastSternMsg = NULL;
      gettingUserList = false;
      visibleChan = NULL;
      old_status = 0;
      firstconn = true;
      conncall[0] = '\0';

      lastChan = NULL;
      status = 0;
      lastMsgTyp = 0;

      // Das alte Icon wieder hin
      toolbar->getButton(tb_conn)->setEnabled( true );
      toolbar->getButton(tb_disc)->setEnabled( false );
      return;
   }
}


void TopLevel::sendAllAway( char *call, char *host, char *str )
{
   ConversChannel *tmp;

   if ((tmp = chans->first()) == NULL) return;

   do
   {
      tmp->awaySet( call, host, str );
   }
   while ((tmp = chans->next()) != NULL);
}


void TopLevel::sendAllAwayText( char *call, char *host, char *text )
{
   ConversChannel *tmp;
   char str[500];

   strcpy(str, text);
   KillSpacesLeft(str);
   KillSpacesRight(str);

   if ((tmp = chans->first()) == NULL) return;

   do
   {
      tmp->awayTextSet( call, host, str, text );
   }
   while ((tmp = chans->next()) != NULL);
}


void TopLevel::sendAllBackAgain( char *call, char *host, char *line )
{
   ConversChannel *tmp;

   if ((tmp = chans->first()) == NULL) return;

   do
   {
      tmp->awayClear( call, host, line );
   }
   while ((tmp = chans->next()) != NULL);
}


bool TopLevel::isVisible( ConversChannel *chan )
{
   return (chan == visibleChan);
}


void TopLevel::slotFunctionKey(int id)
{
   if (id >= (int)chans->count()) return;

   chooseChannel(chans->at(id));
}


void TopLevel::sendStartScript()
{
   FILE *f;
   char str[500];
   int i;


   if ((f = fopen(config->script, "r")) == NULL) return;

   while (fgets(str, 499, f) != NULL)
   {
      if ((i = POS('\r', str)) != -1) str[i] = '\0';
      if ((i = POS('\n', str)) != -1) str[i] = '\0';

      outText( aktChan, str, colors[config->colors->tx], true );
      strcat(str, "\r");
      sendString(str);
   }

   fclose(f);
}


void TopLevel::reconnectHost()
{
   ConversChannel *tmp;

   if (reconnecting) return;
   getConnData( conncall );
   reconnecting = true;
   firstconn = true;
   if (savestr != NULL)
      free(savestr);
   savestr = NULL;
   savestrlen = 0;
   aktChan = NULL;
   delspaces = 0;
   lastSternMsg = NULL;
   gettingUserList = false;
   visibleChan = NULL;
   old_status = 0;
   lastChan = NULL;
   status = 0;
   lastMsgTyp = 0;

   // Zuerst mal eine Liste der eingeloggten Kanaele abspeichern (maximal 50)
   if ((tmp = chans->first()) == NULL) return;
   do
   {
      recChanNrs[recChanCount] = tmp->getChanNr();
      recChanCount++;
   }
   while ((tmp = chans->next()) != NULL && recChanCount < 50);

   // Alle Kanaele entfernen
   delete chans;

   chans = new QList<ConversChannel>();
   chans->setAutoDelete(true);
}


void TopLevel::sendReconnectData()
{
   char str[100];
   int i;

   // Verbindung wurde aufgebaut. "/c <nr>\r" fuer alle Kanaele abschicken,
   // in die wir vorher eingeloggt waren
   for (i=0; i<recChanCount; i++)
   {
      sprintf(str, "/c %i\r", recChanNrs[i]);
      sendString(str);
   }
   recChanCount = -1;
}



//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////


void init_globals()
{
   KConfig *kconfig;
   char *tmp, str[1000], str2[1000];
   int i,len;
   s_conf_colorlines *ctmp;


   config = (s_config *) malloc(sizeof(s_config));
   config->colors = (s_conf_colors *) malloc(sizeof(s_conf_colors));
   config->clines = NULL;

   config->maindir = (char *) malloc( strlen(getenv("HOME"))+50 );
   sprintf(config->maindir,"%s/.kde/share/apps/convkt",getenv("HOME"));
   mkdir(config->maindir, 448);


   // Konfigurations-File holen
   kconfig = mykapp->getConfig();

   kconfig->setGroup( "Global" );

   if ((tmp = kconfig->readEntry("buffersize").data()) != NULL)
      config->buffersize = atoi( tmp );
   else
      config->buffersize = 2000;

   if ((tmp = kconfig->readEntry("zeilenumbruch").data()) != NULL)
      config->zeilenumbruch = atoi( tmp );
   else
      config->zeilenumbruch = 0;

   if ((tmp = kconfig->readEntry("outputsize").data()) != NULL)
      config->outputsize = atoi( tmp );
   else
      config->outputsize = 70;

   if ((tmp = kconfig->readEntry("clines").data()) != NULL)
   {
      strcpy(str, tmp);
      len = strlen(tmp);
      while (str[0] != '\0')
      {
         if ((i = POS(',', str)) != -1)
         {
            memcpy( str2, str, i );
            str2[i] = '\0';
            len -= (i+1);
            memmove( str, str+i+1, len );
            str[len] = '\0';
         }
         else
         {
            strcpy(str2, str);
            str[0] = '\0';
         }

         if (config->clines == NULL)
         {
            // Erster Eintrag
            config->clines = (s_conf_colorlines *)malloc(sizeof(s_conf_colorlines));
            ctmp = config->clines;
         }
         else
         {
            ctmp = config->clines;
            while (ctmp->next != NULL) ctmp = ctmp->next;

            ctmp->next = (s_conf_colorlines *)malloc(sizeof(s_conf_colorlines));
            ctmp = ctmp->next;
         }

         ctmp->next = NULL;
         ctmp->str = (char *) strdup(str2);
      }
   }

   // Kanal-Fenster beim Disconnect schliessen?
   if ((tmp = kconfig->readEntry("openPersWin").data()) != NULL)
      if (atoi(tmp) != 0)
         config->openPersWin = true;
      else
         config->openPersWin = false;
   else config->openPersWin = true;

   // Kanal-Fenster beim Disconnect schliessen?
   if ((tmp = kconfig->readEntry("beepCtrlG").data()) != NULL)
      if (atoi(tmp) != 0)
         config->beepCtrlG = true;
      else
         config->beepCtrlG = false;
   else config->beepCtrlG = true;

   // Kanal-Fenster beim Disconnect schliessen?
   if ((tmp = kconfig->readEntry("localEcho").data()) != NULL)
      if (atoi(tmp) != 0)
         config->localEcho = true;
      else
         config->localEcho = false;
   else config->localEcho = true;


   if ((tmp = kconfig->readEntry("sizeNew").data()) != NULL)
      config->sizeNew = atoi( tmp );
   else
      config->sizeNew = 14;

   if ((tmp = kconfig->readEntry("sizeOld").data()) != NULL)
      config->sizeOld = atoi( tmp );
   else
      config->sizeOld = 12;

   if ((tmp = kconfig->readEntry("screenwidth").data()) != NULL)
      config->screenwidth = atoi( tmp );
   else
      config->screenwidth = 80;


   kconfig->setGroup( "Fonts&Sizes" );
   if ((tmp = kconfig->readEntry("vorschr_size").data()) != NULL)
      config->vorschr_size = atoi( tmp );
   else
      config->vorschr_size = 11;

   if ((tmp = kconfig->readEntry("userlist_size").data()) != NULL)
      config->userlist_size = atoi( tmp );
   else
      config->userlist_size = 10;

   if ((tmp = kconfig->readEntry("output_size").data()) != NULL)
      config->output_size = atoi( tmp );
   else
      config->output_size = 11;

   if ((tmp = kconfig->readEntry("output_font").data()) != NULL)
      config->output_font = (char *) strdup(tmp);
   else
      config->output_font = (char *) strdup("fixed");

   if ((tmp = kconfig->readEntry("vorschr_font").data()) != NULL)
      config->vorschr_font = (char *) strdup(tmp);
   else
      config->vorschr_font = (char *) strdup("fixed");

   if ((tmp = kconfig->readEntry("userlist_font").data()) != NULL)
      config->userlist_font = (char *) strdup(tmp);
   else
      config->userlist_font = (char *) strdup("fixed");



   kconfig->setGroup( "Colors" );

   if ((tmp = kconfig->readEntry("winMarkColor").data()) != NULL)
      config->colors->qsoWinMarkColor = atoi( tmp );
   else
      config->colors->qsoWinMarkColor = 1;

   if ((tmp = kconfig->readEntry("winMarkBack").data()) != NULL)
      config->colors->qsoWinMarkBack = atoi( tmp );
   else
      config->colors->qsoWinMarkBack = 13;

   if ((tmp = kconfig->readEntry("colorlines").data()) != NULL)
      config->colors->colorlines = atoi( tmp );
   else
      config->colors->colorlines = COLOR_BLUE;

   if ((tmp = kconfig->readEntry("system").data()) != NULL)
      config->colors->system = atoi( tmp );
   else
      config->colors->system = COLOR_RED;

   if ((tmp = kconfig->readEntry("tx").data()) != NULL)
      config->colors->tx = atoi( tmp );
   else
      config->colors->tx = COLOR_DARKGREEN;

   if ((tmp = kconfig->readEntry("rx").data()) != NULL)
      config->colors->rx = atoi( tmp );
   else
      config->colors->rx = COLOR_BLACK;

   if ((tmp = kconfig->readEntry("filtered").data()) != NULL)
      config->colors->filtered = atoi( tmp );
   else
      config->colors->filtered = COLOR_DARKMAGENTA;
}


void init_stnlist()
{
   s_stnlist *tmp, *last;
   FILE *f;
   char str[1000], str2[1000];
   int i, k, len;


   stnlist = NULL;
   last = NULL;
   sprintf(str, "%s/hosts.list", config->maindir);
   if ((f = fopen(str, "r")) == NULL) return;

   while (fgets(str, 999, f) != NULL)
   {
      if ((i = POS('\n', str)) != -1) str[i] = '\0';

      // Neuer Eintrag
      if (stnlist == NULL)
      {
         // Erster Eintrag
         stnlist = (s_stnlist *)malloc(sizeof(s_stnlist));
         tmp = stnlist;
      }
      else
      {
         tmp = stnlist;
         while (tmp->next != NULL) tmp = tmp->next;

         tmp->next = (s_stnlist *)malloc(sizeof(s_stnlist));
         tmp = tmp->next;
      }

      tmp->next = NULL;
      tmp->last = last;
      last = tmp;
      tmp->hostcall = NULL;
      tmp->path = NULL;
      tmp->mycall = NULL;
      tmp->login_cmd = NULL;
      tmp->port = NULL;
      tmp->emptyframe = false;
      tmp->linuxpw = false;
      tmp->pw = NULL;
      tmp->script = NULL;
/*      tmp->axtcp = 1;
      tmp->ipaddress = NULL;
      tmp->portnr = 0;*/

      k = 0;
      len = strlen(str);
      while (str[0] != '\0')
      {
         if ((i = POS(';', str)) == -1)
         {
            strcpy(str2, str);
            str[0] = '\0';
         }
         else
         {
            memcpy( str2, str, i );
            str2[i] = '\0';
            len -= (i+1);
            memmove( str, str+i+1, len );
            str[len] = '\0';
         }

         switch (k)
         {
            case 0: // hostcall
                    if (str2[0] != '\0')
                       tmp->hostcall = (char *) strdup(str2);
                    break;
            case 1: // path
                    if (str2[0] != '\0')
                       tmp->path = (char *) strdup(str2);
                    break;
            case 2: // mycall
                    if (str2[0] != '\0')
                       tmp->mycall = (char *) strdup(str2);
                    break;
            case 3: // Login-Cmd
                    if (str2[0] != '\0')
                       tmp->login_cmd = (char *) strdup(str2);
                    break;
            case 4: // Passwort
                    if (str2[0] != '\0')
                       tmp->pw = (char *) strdup(str2);
                    break;
            case 5: // Port
                    if (str2[0] != '\0')
                       tmp->port = (char *) strdup(str2);
                    break;
            case 6: // Flags
                    if (strlen(str2) >= 2)
                    {
                       if (str2[0] == '1') tmp->emptyframe = true;
                       if (str2[1] == '1') tmp->linuxpw = true;
                    }
                    break;
            case 7: // Start-Script
                    if (str2[0] != '\0')
                       tmp->script = (char *) strdup(str2);
                    break;
/*            case 8: // ax.25- oder tcp/ip-verbindung?
                    tmp->axtcp = atoi(str2);
                    if (tmp->axtcp == 0)
                       tmp->axtcp = 1;
                    break;
            case 9: // ip-adresse
                    if (str2[0] != '\0')
                       tmp->ipaddress = (char *) strdup(str2);
                    break;
            case 10: // portnr
                     tmp->portnr = atoi(str2);
                     break;*/
         }

         k++;
      }
   }

   fclose(f);
}


int main (int argc, char **argv)
{
   mykapp = new KApplication (argc, argv, "convkt");

   init_globals();
   init_stnlist();
   ax25_readportlist = false;

   toplevel = new TopLevel ();
   if (!beenden)
   {
      toplevel->show ();

      mykapp->setMainWidget(toplevel);
      return mykapp->exec ();
   }
}


#include "main.moc"

