/*
 *  ConvKT - a monitor for LinKT
 *  Copyright (C) 1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GLOBAL_H
#define GLOBAL_H


#include <time.h>
#include <qcolor.h>
#include <qfont.h>
#include <qlist.h>
#include <qwidget.h>
#include <qstrlist.h>
#include <stdlib.h>



#define COLOR_BLACK 0
#define COLOR_WHITE 1
#define COLOR_DARKGRAY 2
#define COLOR_GRAY 3
#define COLOR_LIGHTGRAY 4
#define COLOR_RED 5
#define COLOR_GREEN 6
#define COLOR_BLUE 7
#define COLOR_CYAN 8
#define COLOR_MAGENTA 9
#define COLOR_YELLOW 10
#define COLOR_DARKRED 11
#define COLOR_DARKGREEN 12
#define COLOR_DARKBLUE 13
#define COLOR_DARKCYAN 14
#define COLOR_DARKMAGENTA 15
#define COLOR_DARKYELLOW 16


#define TYPE_PP 1
#define TYPE_TNN 2

// Zeilen, die mit einem dieser Strings beginnen, farbig machen
typedef struct _s_conf_colorlines
{
   struct _s_conf_colorlines *next;
   char *str;
} s_conf_colorlines;


typedef struct
{
   int qsoWinMarkColor;     // Farbe von markiertem Text im QSO-Fenster
   int qsoWinMarkBack;      // Hintergrund von markiertem Text im QSO-Fenster
   bool mark_bold;          // markierten Text fett schreiben?

   int colorlines;

   int system;
   int tx;
   int rx;
   int filtered;
} s_conf_colors;


typedef struct
{
   int buffersize;
   int zeilenumbruch;
   int outputsize;

   bool pw;
   char *pwstr;
   bool emptyframe;
   char *convstr;
   char *script;

   // Groesse der Schrift der Kanal-Buttons bei
   int sizeNew;     // neuem Text
   int sizeOld;     // keinem neuen Text

   bool openPersWin;

   // Bei CTRL-G piepen?
   bool beepCtrlG;
   // Lokales Echo?
   bool localEcho;

   // Was ist die Bildschirmbreite? (Wird dem Convers ebenfalls mitgeteilt)
   int screenwidth;

   s_conf_colors *colors;
   s_conf_colorlines *clines;

   char *maindir;

   // Fonts und Schriftgroessen
   int vorschr_size;
   int output_size;
   int userlist_size;
   char *vorschr_font;
   char *output_font;
   char *userlist_font;
} s_config;

extern s_config *config;

extern QColor colors[17];


typedef struct _s_stnlist
{
   struct _s_stnlist *next;
   struct _s_stnlist *last;
   char *hostcall;
   char *path;
   char *mycall;
   char *login_cmd;
   char *port;
   bool emptyframe;
   bool linuxpw;
   char *pw;
   char *script;
/*   int axtcp;        // 1 = AX.25, 2 = TCP/IP
   char *ipaddress;
   int portnr;*/
} s_stnlist;

extern bool ax25_readportlist;

extern s_stnlist *stnlist;

extern QStrList filterCalls;


#endif   /* GLOBAL_H */

