/*
 *  ConvKT - a LinKT convers vitalizer
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef DIALOG_H
#define DIALOG_H


#include "convchan.h"
#include "global.h"

#include <qdialog.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>

#include <ktablistbox.h>


class DlgUserList : public QDialog
{
   Q_OBJECT;
public:
   DlgUserList( int ch, ConversChannel *convchan );
   ~DlgUserList();

private:
   QPushButton *ready;
   KTabListBox *liste;
};



class DlgConnect : public QDialog
{
   Q_OBJECT;
public:
   DlgConnect();
   ~DlgConnect();

   const char * getCall();

public slots:
   void slotSettings();

private:
   QPushButton *abort, *ok, *settings;
   QComboBox *host;

   void readStnListe();
   void saveStnListe();
};



class DlgConnSet : public QDialog
{
   Q_OBJECT;
public:
   DlgConnSet();
   ~DlgConnSet();

   void gimmeStnListe();

public slots:
   void slotTogglePW( bool active );
   void slotTextChanged( const char * );
   void slotCbChanged( bool );
   void slotOkClicked();
   void slotNewDS();
   void slotSaveDS();
   void slotNextDS();
   void slotLastDS();
   void slotPrevDS();
   void slotFirstDS();
   void slotBrowseScript();
/*   void slotAX25Clicked();
   void slotTCPIPClicked();*/

private:
   QLineEdit *hostcall, *path, *mycall, *logincmd, *passwd, *port, *script;
   QCheckBox *cbEmptyframe, *cbPassword;
/*   QRadioButton *ax25, *tcpip;
   QButtonGroup *tmpbtngrp;

   QLabel *lIp, *lPortNr;
   QLineEdit *ip, *portnr;*/

   QPushButton *ok, *abort, *neu, *weg, *erster, *letzter, *naechster, *vorheriger, *save, *browse;
   QLabel *lHost, *lPath, *lMycall, *lLogincmd, *lPort, *lscript;

   bool changed;
   s_stnlist *liste, *current;

   void copyStnList();
   void showEntry( s_stnlist *entry );
};


#endif

