/*
 *  ConvKT - a LinKT convers vitalizer
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <qfiledialog.h>
#include "dialog.h"
#include "dialog.moc"

#include "toolbox.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#include <kapp.h>
#include <kiconloader.h>
#include <kmsgbox.h>

#include <qlabel.h>


extern KApplication *mykapp;

#define BUTTONWIDTH 65
#define BUTTONHEIGHT 25


DlgUserList::DlgUserList( int ch, ConversChannel *convchan ) : QDialog(0, "", true)
{
   char tmp[500], sep;
   s_userlist *userlist;


   setFixedSize( 300, 200 );

   setCaption(klocale->translate("Userlist"));

   QLabel *l = new QLabel( this );
   l->setGeometry(10, 5, 100, 20);
   sprintf(tmp, "Channel #%i", ch);
   l->setText(tmp);

   ready = new QPushButton( this );
   ready->setGeometry( width()-BUTTONWIDTH-5, height()-5-BUTTONHEIGHT, BUTTONWIDTH, BUTTONHEIGHT);
   ready->setText( klocale->translate("Ready") );
   connect( ready, SIGNAL(clicked()), this, SLOT(reject()) );



   liste = new KTabListBox( this );
   liste->setGeometry(0,30,width(), height()-BUTTONHEIGHT-40);
   liste->setTableFlags( liste->tableFlags()|Tbl_autoVScrollBar);

   // Spalten: Port, Rufzeichen, Pfad
   liste->setNumCols(3);

   liste->setColumn(0, klocale->translate("Call"), 80, KTabListBox::TextColumn);
   liste->setColumn(1, klocale->translate("Host"), 80, KTabListBox::TextColumn);
   liste->setColumn(2, klocale->translate("Pers-Text"), 200, KTabListBox::TextColumn);

   userlist = convchan->getUserList();

   sep = liste->separator();


   while (userlist != NULL)
   {
      sprintf(tmp, "%s%c%s%c%s",
                   userlist->call, sep,
                   userlist->host, sep,
                   userlist->pers);
      liste->insertItem(tmp);

      userlist = userlist->next;
   }

   // Zeigt die Routen an
//   showRoutes();
   liste->setCurrentItem(0);

}


DlgUserList::~DlgUserList()
{
}



////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


DlgConnect::DlgConnect() : QDialog(0, "", true)
{
   setFixedSize(220, 120);
   setCaption(klocale->translate("Connect..."));

   QLabel *l = new QLabel( this );
   l->setGeometry( 10, 5, 100, 20 );
   l->setText("Connect to host");

   host = new QComboBox( this );
   host->setGeometry( 10, 30, 120, BUTTONHEIGHT );

   settings = new QPushButton( this );
   settings->setGeometry( 140, 30, 75, BUTTONHEIGHT );
   settings->setText("&Settings");
   connect( settings, SIGNAL(clicked()), this, SLOT(slotSettings()) );



   // OK- und Abbruch-Knopf
   int abstand = (width()-(2*BUTTONWIDTH))/3;
   ok = new QPushButton( this );
   ok->setText( klocale->translate ("&Ok") );
   ok->setGeometry(abstand, height()-BUTTONHEIGHT-10, BUTTONWIDTH, BUTTONHEIGHT);
   connect( ok, SIGNAL(clicked()), this, SLOT(accept()) );

   abort = new QPushButton( this );
   abort->setText( klocale->translate ("&Abort") );
   abort->setGeometry(abstand*2+BUTTONWIDTH, height()-BUTTONHEIGHT-10, BUTTONWIDTH, BUTTONHEIGHT);
   connect( abort, SIGNAL(clicked()), this, SLOT(reject()) );

   readStnListe();
}


DlgConnect::~DlgConnect()
{
}


void DlgConnect::slotSettings()
{
   DlgConnSet *dlg = new DlgConnSet();

   QPoint point = this->mapToGlobal (QPoint (0,0));

   QRect pos = this->geometry();
   dlg->setGeometry(point.x() + pos.width()/2  - dlg->width()/2,
 		   point.y() + pos.height()/2 - dlg->height()/2,
 		   dlg->width(),dlg->height());

   if (dlg->exec() == 1)
   {
      dlg->gimmeStnListe();
      readStnListe();
      saveStnListe();
   }

   delete dlg;
}


void DlgConnect::readStnListe()
{
   s_stnlist *tmp;
   char str[100];

   host->clear();

   tmp = stnlist;
   while (tmp != NULL)
   {
      if (tmp->hostcall != NULL)
         if (tmp->hostcall[0] != '\0')
         {
            strcpy(str, tmp->hostcall);
            Gross(str);
            host->insertItem( str );
         }
      tmp = tmp->next;
   }
}


const char * DlgConnect::getCall()
{
   return host->currentText();
}


void DlgConnect::saveStnListe()
{
   s_stnlist *tmp;
   char str[1000], flags[11]/*, strtmp[10]*/;
   int fd;


   sprintf(str, "%s/hosts.list", config->maindir);
   if ((fd = open(str, O_CREAT|O_WRONLY|O_TRUNC)) == -1) return;

   fchmod(fd,S_IRUSR|S_IWUSR);

   tmp = stnlist;
   while (tmp != NULL)
   {
      if (tmp->emptyframe)
         flags[0] = '1';
      else
         flags[0] = '0';
      if (tmp->linuxpw)
         flags[1] = '1';
      else
         flags[1] = '0';
      flags[2] = '\0';

      str[0] = '\0';
      if (tmp->hostcall != NULL)
         strcat(str, tmp->hostcall);
      strcat(str, ";");
      if (tmp->path != NULL)
         strcat(str, tmp->path);
      strcat(str, ";");
      if (tmp->mycall != NULL)
         strcat(str, tmp->mycall);
      strcat(str, ";");
      if (tmp->login_cmd != NULL)
         strcat(str, tmp->login_cmd);
      strcat(str, ";");
      if (tmp->pw != NULL)
         strcat(str, tmp->pw);
      strcat(str, ";");
      if (tmp->port != NULL)
         strcat(str, tmp->port);
      strcat(str, ";");
      strcat(str, flags);
      strcat(str, ";");
      if (tmp->script != NULL)
         strcat(str, tmp->script);
/*      strcat(str, ";");
      sprintf(strtmp, "%i", tmp->axtcp);
      strcat(str, strtmp);
      strcat(str, ";");
      if (tmp->ipaddress != NULL)
         strcat(str, tmp->ipaddress);
      strcat(str, ";");
      sprintf(strtmp, "%i", tmp->portnr);
      strcat(str, strtmp);*/

      strcat(str, "\n");

      write(fd, str, strlen(str));

      tmp = tmp->next;
   }

   ::close(fd);
}



////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


DlgConnSet::DlgConnSet() : QDialog( 0,"",true )
{
   setFixedSize(450, 270);
   setCaption(klocale->translate("Host-Configuration..."));

   lMycall = new QLabel( this );
   lMycall->setGeometry( 10, 10, 80, 20 );
   lMycall->setText( "MyCall" );

   mycall = new QLineEdit( this );
   mycall->setGeometry( 10, 30, 80, 20 );
   connect(mycall, SIGNAL(textChanged(const char *)), this, SLOT(slotTextChanged(const char *)) );


/*
   tmpbtngrp = new QButtonGroup( this );
   tmpbtngrp->hide();

   ax25 = new QRadioButton( this );
   ax25->setGeometry( 120, 15, 120, 20 );
   ax25->setText("AX.25-Connect");
   connect(ax25, SIGNAL(clicked()), this, SLOT(slotAX25Clicked()) );
   tmpbtngrp->insert( ax25 );

   tcpip = new QRadioButton( this );
   tcpip->setGeometry( 120, 35, 120, 20 );
   tcpip->setText("TCP/IP-Connect");
   connect(tcpip, SIGNAL(clicked()), this, SLOT(slotTCPIPClicked()) );
   tmpbtngrp->insert( tcpip );
*/


   lscript = new QLabel( this );
   lscript->setGeometry( 10, 65, 200, 20 );
   lscript->setText( "Start-Script" );

   script = new QLineEdit( this );
   script->setGeometry( 10, 85, 220, 20 );
   connect(script, SIGNAL(textChanged(const char *)), this, SLOT(slotTextChanged(const char *)) );

   browse = new QPushButton( this ),
   browse->setGeometry( 240, 85, 50, 25 );
   browse->setText("browse");
   connect( browse, SIGNAL(clicked()), this, SLOT(slotBrowseScript()) );



   lHost = new QLabel( this );
   lHost->setGeometry( 10, 110, 80, 20 );
   lHost->setText( "Host-Call" );

   hostcall = new QLineEdit( this );
   hostcall->setGeometry( 10, 130, 100, 20 );
   connect(hostcall, SIGNAL(textChanged(const char *)), this, SLOT(slotTextChanged(const char *)) );

   lPath = new QLabel( this );
   lPath->setGeometry( 120, 110, 130, 20 );
   lPath->setText( "Path" );

   path = new QLineEdit( this );
   path->setGeometry( 120, 130, 170, 20 );
   connect(path, SIGNAL(textChanged(const char *)), this, SLOT(slotTextChanged(const char *)) );

   lLogincmd = new QLabel( this );
   lLogincmd->setGeometry( 10, 155, 150, 20 );
   lLogincmd->setText( "Login-Cmd" );

   logincmd = new QLineEdit( this );
   logincmd->setGeometry( 10, 175, 150, 20 );
   connect(logincmd, SIGNAL(textChanged(const char *)), this, SLOT(slotTextChanged(const char *)) );

   lPort = new QLabel( this );
   lPort->setGeometry( 170, 155, 120, 20 );
   lPort->setText( "Port" );

   port = new QLineEdit( this );
   port->setGeometry( 170, 175, 120, 20 );
   connect(port, SIGNAL(textChanged(const char *)), this, SLOT(slotTextChanged(const char *)) );


   cbEmptyframe = new QCheckBox( this );
   cbEmptyframe->setGeometry( 10, 200, 250, 20 );
   cbEmptyframe->setText( "send empty frame after connect" );
   connect( cbEmptyframe, SIGNAL(toggled(bool)), this, SLOT(slotCbChanged(bool)) );

   cbPassword = new QCheckBox( this );
   cbPassword->setGeometry( 10, 220, 250, 20 );
   cbPassword->setText( "linux-password" );
   connect( cbPassword, SIGNAL(toggled(bool)), this, SLOT(slotTogglePW(bool)) );

   passwd = new QLineEdit( this );
   passwd->setGeometry( 30, 240, 230, 20 );



/*
   lIp = new QLabel( this );
   lIp->setGeometry( 10, 110, 100, 20 );
   lIp->setText("Host-IP-Address");

   ip = new QLineEdit( this );
   ip->setGeometry( 10, 130, 100, 20 );

   lPortNr = new QLabel( this );
   lPortNr->setGeometry( 10, 155, 80, 20 );
   lPortNr->setText("Port-Number");

   portnr = new QLineEdit( this );
   portnr->setGeometry( 10, 175, 80, 20 );
*/



   KIconLoader *loader = mykapp->getIconLoader();

   QPixmap pixmap;

   // Navigations-Knoepfe fuer die Datenbank
   neu = new QPushButton( this );
   neu->setGeometry( 320, 40, 25, 25 );
   pixmap = loader->loadIcon( "plus.xpm" );
   neu->setPixmap(pixmap);
   connect( neu, SIGNAL(clicked()), this, SLOT(slotNewDS()) );

   weg = new QPushButton( this );
   weg->setGeometry( 350, 40, 25, 25 );
   pixmap = loader->loadIcon( "minus.xpm" );
   weg->setPixmap(pixmap);

   save = new QPushButton( this );
   save->setGeometry( 380, 40, 25, 25 );
   pixmap = loader->loadIcon( "ok.xpm" );
   save->setPixmap(pixmap);
   connect( save, SIGNAL(clicked()), this, SLOT(slotSaveDS()) );


   erster = new QPushButton( this );
   erster->setGeometry( 310, 70, 25, 25 );
   pixmap = loader->loadIcon( "first.xpm" );
   erster->setPixmap(pixmap);
   connect(erster, SIGNAL(clicked()), this, SLOT(slotFirstDS()) );

   vorheriger = new QPushButton( this );
   vorheriger->setGeometry( 340, 70, 25, 25 );
   pixmap = loader->loadIcon( "left.xpm" );
   vorheriger->setPixmap(pixmap);
   connect(vorheriger, SIGNAL(clicked()), this, SLOT(slotPrevDS()) );

   naechster = new QPushButton( this );
   naechster->setGeometry( 370, 70, 25, 25 );
   pixmap = loader->loadIcon( "right.xpm" );
   naechster->setPixmap(pixmap);
   connect(naechster, SIGNAL(clicked()), this, SLOT(slotNextDS()) );

   letzter = new QPushButton( this );
   letzter->setGeometry( 400, 70, 25, 25 );
   pixmap = loader->loadIcon( "last.xpm" );
   letzter->setPixmap(pixmap);
   connect(letzter, SIGNAL(clicked()), this, SLOT(slotLastDS()) );


   ok = new QPushButton( this );
   ok->setGeometry( 340, 110, 65, 25 );
   ok->setText( "&Ok" );
   connect( ok, SIGNAL(clicked()), this, SLOT(slotOkClicked()) );

   abort = new QPushButton( this );
   abort->setGeometry( 340, 140, 65, 25 );
   abort->setText( "&Abort" );
   connect( abort, SIGNAL(clicked()), this, SLOT(reject()) );

   copyStnList();
   showEntry( liste );

   changed = false;
   save->setEnabled( false );


   if (current == NULL)
   {
      erster->setEnabled( false );
      vorheriger->setEnabled( false );
      naechster->setEnabled( false );
      letzter->setEnabled( false );

      hostcall->setEnabled( false );
      path->setEnabled( false );
      mycall->setEnabled( false );
      logincmd->setEnabled( false );
      passwd->setEnabled( false );
      port->setEnabled( false );
      cbEmptyframe->setEnabled( false );
      cbPassword->setEnabled( false );
   }
   else
   {
      if (current->last == NULL)
      {
         erster->setEnabled( false );
         vorheriger->setEnabled( false );
      }

      if (current->next == NULL)
      {
         naechster->setEnabled( false );
         letzter->setEnabled( false );
      }
   }
}


DlgConnSet::~DlgConnSet()
{
   s_stnlist *tmp;

   while (liste != NULL)
   {
      tmp = liste;
      liste = liste->next;
      if (tmp->hostcall != NULL)
         free(tmp->hostcall);
      if (tmp->path != NULL)
         free(tmp->path);
      if (tmp->mycall != NULL)
         free(tmp->mycall);
      if (tmp->port != NULL)
         free(tmp->port);
      if (tmp->login_cmd != NULL)
         free(tmp->login_cmd);
      if (tmp->pw != NULL)
         free(tmp->pw);
      if (tmp->script != NULL)
         free(tmp->script);
/*      if (tmp->ipaddress != NULL)
         free(tmp->ipaddress);*/
      free(tmp);
   }


   delete hostcall;
   delete path;
   delete mycall;
   delete port;
   delete lPort;
   delete logincmd;
   delete passwd;
   delete cbEmptyframe;
   delete cbPassword;
   delete ok;
   delete abort;
   delete neu;
   delete weg;
   delete erster;
   delete letzter;
   delete naechster;
   delete vorheriger;
   delete save;
   delete lHost;
   delete lPath;
   delete lMycall;
   delete lLogincmd;
   delete lscript;
   delete script;
/*   delete ax25;
   delete tcpip;
   delete tmpbtngrp;
   delete lIp;
   delete lPortNr;
   delete ip;
   delete portnr;*/
}


void DlgConnSet::slotTogglePW( bool active )
{
   passwd->setEnabled(active);
   changed = true;
   save->setEnabled( true );
}


void DlgConnSet::copyStnList()
{
   s_stnlist *tmp, *orig, *last;

   orig = stnlist;
   last = NULL;
   liste = NULL;
   while (orig != NULL)
   {
      // Neuer Eintrag in die lokale Kopie der Liste
      if (liste == NULL)
      {
         // Erster Eintrag
         liste = (s_stnlist *)malloc(sizeof(s_stnlist));
         tmp = liste;
      }
      else
      {
         tmp = liste;
         while (tmp->next != NULL) tmp = tmp->next;

         tmp->next = (s_stnlist *)malloc(sizeof(s_stnlist));
         tmp = tmp->next;
      }

      tmp->next = NULL;
      tmp->last = last;
      if (orig->path == NULL)
         tmp->path = NULL;
      else
         tmp->path = (char *) strdup(orig->path);

      if (orig->hostcall == NULL)
         tmp->hostcall = NULL;
      else
         tmp->hostcall = (char *) strdup(orig->hostcall);

      if (orig->mycall == NULL)
         tmp->mycall = NULL;
      else
         tmp->mycall = (char *) strdup(orig->mycall);

      if (orig->port == NULL)
         tmp->port = NULL;
      else
         tmp->port = (char *) strdup(orig->port);

      if (orig->login_cmd == NULL)
         tmp->login_cmd = NULL;
      else
         tmp->login_cmd = (char *) strdup(orig->login_cmd);

      tmp->emptyframe = orig->emptyframe;
      tmp->linuxpw = orig->linuxpw;

      if (orig->pw == NULL)
         tmp->pw = NULL;
      else
         tmp->pw = (char *) strdup(orig->pw);

      if (orig->script == NULL)
         tmp->script = NULL;
      else
         tmp->script = (char *) strdup(orig->script);

/*      if (orig->ipaddress == NULL)
         tmp->ipaddress = NULL;
      else
         tmp->ipaddress = (char *) strdup(orig->ipaddress);

      tmp->axtcp = orig->axtcp;
      tmp->portnr = orig->portnr;
*/
      last = orig;
      orig = orig->next;
   }
}


void DlgConnSet::showEntry( s_stnlist *entry )
{
   if (entry == NULL)
   {
      // Der Eintrag ist nicht vorhanden
      weg->setEnabled( false );
      save->setEnabled( false );
      current = NULL;
      return;
   }

   weg->setEnabled( true );
   save->setEnabled( false );


   if (entry->hostcall == NULL)
      hostcall->setText( "" );
   else
      hostcall->setText( entry->hostcall );

   if (entry->path == NULL)
      path->setText( "" );
   else
      path->setText( entry->path );

   if (entry->mycall == NULL)
      mycall->setText( "" );
   else
      mycall->setText( entry->mycall );

   if (entry->port == NULL)
      port->setText( "" );
   else
      port->setText( entry->port );

   if (entry->login_cmd == NULL)
      logincmd->setText( "" );
   else
      logincmd->setText( entry->login_cmd );

   if (entry->pw == NULL)
      passwd->setText( "" );
   else
      passwd->setText( entry->pw );

   if (entry->script == NULL)
      script->setText( "" );
   else
      script->setText( entry->script );

/*   if (entry->ipaddress == NULL)
      ip->setText("");
   else
      ip->setText( entry->ipaddress );

   switch (entry->axtcp)
   {
      case 1: // AX.25
              ax25->setChecked( true );
              slotAX25Clicked();
              break;
      case 2: // TCP/IP
              tcpip->setChecked( true );
              slotTCPIPClicked();
              break;
   }
*/
   cbEmptyframe->setChecked( entry->emptyframe );
   cbPassword->setChecked( entry->linuxpw );
   passwd->setEnabled( entry->linuxpw );

   current = entry;
   changed = false;
   save->setEnabled( false );
}


void DlgConnSet::slotTextChanged( const char * )
{
   changed = true;
   save->setEnabled( true );
}


void DlgConnSet::slotCbChanged( bool )
{
   changed = true;
   save->setEnabled( true );
}


void DlgConnSet::slotNewDS()
{
   int i;
   s_stnlist *tmp;


   if (changed)
   {
      i = KMsgBox::yesNoCancel( NULL,
                                klocale->translate("Save Data?"),
                                klocale->translate("The current entry has been changed. Save it?"),
                                0,
                                klocale->translate("&Yes"),
                                klocale->translate("&No"),
                                klocale->translate("&Cancel"));
      switch (i)
      {
         case 1: slotSaveDS(); break;
         case 3: return;
      }
   }

   // Standard-Werte
   hostcall->setText( "" );
   path->setText( "" );
   mycall->setText( "" );
   port->setText( "" );
   logincmd->setText( "" );
   passwd->setText( "" );
   cbEmptyframe->setChecked( false );
   cbPassword->setChecked( false );

   save->setEnabled( false );
   changed = false;

   // An diese Stelle einen neuen Datensatz einfuegen.
   tmp = (s_stnlist *)malloc(sizeof(s_stnlist));
   if (current == NULL)
   {
      tmp->last = NULL;
      tmp->next = NULL;
      liste = tmp;

      hostcall->setEnabled( true );
      path->setEnabled( true );
      mycall->setEnabled( true );
      logincmd->setEnabled( true );
      passwd->setEnabled( true );
      port->setEnabled( true );
      cbEmptyframe->setEnabled( true );
      cbPassword->setEnabled( true );
   }
   else
   {
      naechster->setEnabled( true );
      letzter->setEnabled( true );

      if (current->last != NULL)
      {
        current->last->next = tmp;
        tmp->last = current->last;
      }
      else
      {
         tmp->last = NULL;
         liste = tmp;
      }
      tmp->next = current;
      current->last = tmp;
   }

   current = tmp;

   tmp->hostcall = NULL;
   tmp->path = NULL;
   tmp->mycall = NULL;
   tmp->port = NULL;
   tmp->login_cmd = NULL;
   tmp->emptyframe = false;
   tmp->linuxpw = false;
   tmp->pw = NULL;
   tmp->script = NULL;
/*   tmp->axtcp = 1;
   tmp->ipaddress = NULL;
   tmp->portnr = 0;

   vorheriger->setEnabled( true );
   erster->setEnabled( true );

   naechster->setEnabled( true );
   letzter->setEnabled( true );*/

   hostcall->setFocus();
}


void DlgConnSet::slotSaveDS()
{
   if (current->hostcall != NULL)
      free(current->hostcall);
   current->hostcall = (char *) strdup(hostcall->text());

   if (current->path != NULL)
      free(current->path);
   current->path = (char *) strdup(path->text());

   if (current->mycall != NULL)
      free(current->mycall);
   current->mycall = (char *) strdup(mycall->text());

   if (current->port != NULL)
      free(current->port);
   current->port = (char *) strdup(port->text());

   if (current->login_cmd != NULL)
      free(current->login_cmd);
   current->login_cmd = (char *) strdup(logincmd->text());

   if (current->pw != NULL)
      free(current->pw);
   current->pw = (char *) strdup(passwd->text());

   if (current->script != NULL)
      free(current->script);
   current->script = (char *) strdup(script->text());

/*   if (current->ipaddress != NULL)
      free(current->ipaddress);
   current->ipaddress = (char *) strdup(ip->text());

   current->portnr = atoi( portnr->text() );

   if (ax25->isChecked())
      current->axtcp = 1;
   if (tcpip->isChecked())
      current->axtcp = 2;
printf("current->axtcp: %i\n", current->axtcp);
*/
   current->emptyframe = cbEmptyframe->isChecked();
   current->linuxpw = cbPassword->isChecked();


   save->setEnabled( false );
   changed = false;
}


void DlgConnSet::slotNextDS()
{
   int i;


   if (current->next == NULL) return;

   if (changed)
   {
      i = KMsgBox::yesNoCancel( NULL,
                                klocale->translate("Save Data?"),
                                klocale->translate("The current entry has been changed. Save it?"),
                                0,
                                klocale->translate("&Yes"),
                                klocale->translate("&No"),
                                klocale->translate("&Cancel"));
      switch (i)
      {
         case 1: slotSaveDS(); break;
         case 3: return;
      }
   }

   current = current->next;
   showEntry( current );

   if (current->next == NULL)
   {
      letzter->setEnabled( false );
      naechster->setEnabled( false );
   }
   else
   {
      letzter->setEnabled( true );
      naechster->setEnabled( true );
   }

   erster->setEnabled( true );
   vorheriger->setEnabled( true );
}


void DlgConnSet::slotLastDS()
{
}


void DlgConnSet::slotPrevDS()
{
   int i;


   if (current->last == NULL) return;

   if (changed)
   {
      i = KMsgBox::yesNoCancel( NULL,
                                klocale->translate("Save Data?"),
                                klocale->translate("The current entry has been changed. Save it?"),
                                0,
                                klocale->translate("&Yes"),
                                klocale->translate("&No"),
                                klocale->translate("&Cancel"));
      switch (i)
      {
         case 1: slotSaveDS(); break;
         case 3: return;
      }
   }

   current = current->last;
   showEntry( current );

   if (current->last == NULL)
   {
      erster->setEnabled( false );
      vorheriger->setEnabled( false );
   }
   else
   {
      erster->setEnabled( true );
      vorheriger->setEnabled( true );
   }

   letzter->setEnabled( true );
   naechster->setEnabled( true );
}


void DlgConnSet::slotFirstDS()
{
}


void DlgConnSet::gimmeStnListe()
{
   s_stnlist *tmp;

   while (stnlist != NULL)
   {
      tmp = stnlist;
      stnlist = stnlist->next;
      if (tmp->hostcall != NULL)
         free(tmp->hostcall);
      if (tmp->path != NULL)
         free(tmp->path);
      if (tmp->mycall != NULL)
         free(tmp->mycall);
      if (tmp->port != NULL)
         free(tmp->port);
      if (tmp->login_cmd != NULL)
         free(tmp->login_cmd);
      if (tmp->pw != NULL)
         free(tmp->pw);
      if (tmp->script != NULL)
         free(tmp->script);
/*      if (tmp->ipaddress != NULL)
         free(tmp->ipaddress);*/
      free(tmp);
   }

   stnlist = liste;
   liste = NULL;
}


void DlgConnSet::slotOkClicked()
{
   int i;


   if (changed)
   {
      i = KMsgBox::yesNoCancel( NULL,
                                klocale->translate("Save Data?"),
                                klocale->translate("The current entry has been changed. Save it?"),
                                0,
                                klocale->translate("&Yes"),
                                klocale->translate("&No"),
                                klocale->translate("&Cancel"));
      switch (i)
      {
         case 1: slotSaveDS(); break;
         case 3: return;
      }
   }

   accept();
}


void DlgConnSet::slotBrowseScript()
{
   char tmp[2000];


   strcpy(tmp, config->maindir);
   QString f = QFileDialog::getOpenFileName(tmp);

   // Cancel
   if (f.isEmpty()) return;

   strcpy(tmp, (const char *)f);

   if (!file_exist(tmp))
   {
      KMsgBox::message(NULL, klocale->translate("File not found"),
                             klocale->translate("Cannot open specified file."));
      return;
   }

   script->setText(tmp);

   changed = true;
   save->setEnabled( true );
}


/*void DlgConnSet::slotAX25Clicked()
{
   // TCP/IP-Einstellungen verstecken, AX.25-Einstellungen zeigen
   hostcall->show();
   path->show();
   logincmd->show();
   passwd->show();
   port->show();
   cbEmptyframe->show();
   cbPassword->show();
   lHost->show();
   lPath->show();
   lLogincmd->show();
   lPort->show();

   lIp->hide();
   lPortNr->hide();
   ip->hide();
   portnr->hide();

   changed = true;
   save->setEnabled( true );
}


void DlgConnSet::slotTCPIPClicked()
{
   // AX.25-Einstellungen verstecken, TCP/IP-Einstellungen zeigen
   lIp->show();
   lPortNr->show();
   ip->show();
   portnr->show();

   hostcall->hide();
   path->hide();
   logincmd->hide();
   passwd->hide();
   port->hide();
   cbEmptyframe->hide();
   cbPassword->hide();
   lHost->hide();
   lPath->hide();
   lLogincmd->hide();
   lPort->hide();

   changed = true;
   save->setEnabled( true );
}
*/


////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////


