/*
 *  ConvKT - a LinKT convers vitalizer
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef CONVCHAN_H
#define CONVCHAN_H

#include "output.h"
#include "vorschreib.h"
#include "userlist.h"
#include "global.h"

#include <qobject.h>
#include <qmultilinedit.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qsplitter.h>


typedef struct _s_userlist
{
   struct _s_userlist *next;
   char *call;
   char *host;
   char *pers;
   bool away;
   char *awaytext;
} s_userlist;


class ConversChannel : public QWidget
{
   Q_OBJECT;
public:
   ConversChannel( QWidget *parent, int ch );
   ~ConversChannel();

   void ConversChannel::resizeEvent(QResizeEvent *e);

   void textGot( char *str );
   void perstextSet( char *call, char *text );
   void awaySet( char *call, char *host, char *line );
   void awayTextSet( char *call, char *host, char *text, char *str );
   void awayClear( char *call, char *host, char *line );
   void clearUserList();
   void setSize();

/////////////////////////////////////////////////////////////////

   OutputWidget *output;
   myVorschreib *input;
   UserListe *userliste;
//   QListBox *userliste;
   QSplitter *splitter;
   QSplitter *splitter2;
   QPushButton *btn;

   int getChanNr();
   int getLabelIndex();
   void setLabelIndex( int index );

   void setNew( bool neu );

   void userListEntry( const char *str, const int type=TYPE_PP );
   void addUserList( char *call, char *host, char *pers, bool away );
   void delUserList( char *call, char *host );
   s_userlist * getUserList();

public slots:
   void slotBtnClicked();
   void returnPressedGot();

private:
   int channr;
   int labelindex;

   bool colorline;
   bool neu;

   s_userlist *userlist;
};


#endif

