/*
 *  ConvKT - a LinKT convers vitalizer
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "convchan.h"
#include "convchan.moc"

#include "main.h"
#include "toolbox.h"
#include "global.h"

#include <ctype.h>

extern TopLevel *toplevel;

#define BUTTON_WIDTH 60
#define BUTTON_HEIGHT 25


ConversChannel::ConversChannel( QWidget *parent, int ch ) : QWidget( parent )
{
   QFont fOut( config->output_font, config->output_size );
   QFont fVor( config->vorschr_font, config->vorschr_size );
   QFont fUsr( config->userlist_font, config->userlist_size );
   char tmp[100];


   channr = ch;
   userlist = NULL;
   colorline = false;
   neu = false;

   int outheight = (config->outputsize * height()) / 100;


   splitter2 = new QSplitter( this );
   splitter2->setOrientation( QSplitter::Vertical );
   splitter2->setGeometry( 0, 0, width(), height() );

   splitter = new QSplitter( splitter2 );

   output = new OutputWidget( splitter );
   output->setFont( fOut );
   output->setBackgroundColor( colors[COLOR_WHITE] );

   userliste = new UserListe( splitter );
   userliste->setFont( fUsr );
//   userliste->setFont(f);
//   splitter->setResizeMode(userliste, QSplitter::KeepSize);

   output->setGeometry( 0, 0, splitter->width()*0.9, output->height() );
   userliste->setGeometry( splitter->width()*0.9, 0, splitter->width()*0.1, userliste->height() );
//   userliste->setFixedSize( splitter->width()*0.1, userliste->height() );

   input = new myVorschreib( splitter2 );
   input->setGeometry( 0, outheight, width(), height()-outheight );
   input->setFont( fVor );
//   input->setFixedSize( width(), height()-outheight );
//   splitter2->setResizeMode(userliste, QSplitter::KeepSize);
   connect( input, SIGNAL(returnPressed()), this, SLOT(returnPressedGot()) );
   connect( input, SIGNAL(signalPageUp()), output, SLOT(slotPageUp()) );
   connect( input, SIGNAL(signalPageDown()), output, SLOT(slotPageDown()) );
   connect( input, SIGNAL(signalFunctionKey(int)), toplevel, SLOT(slotFunctionKey(int)) );


   sprintf(tmp, "#%i", channr);
   btn = new QPushButton( tmp, toplevel->buttonbar );
   toplevel->buttonbar->newButton( btn );
   connect( btn, SIGNAL(clicked()), this, SLOT(slotBtnClicked()) );
}


ConversChannel::~ConversChannel()
{
   toplevel->buttonbar->deleteButton( btn );
   delete output;
   delete input;
   delete btn;
   delete userliste;
   delete splitter;
   delete splitter2;
}


void ConversChannel::resizeEvent(QResizeEvent *e)
{
   QWidget::resizeEvent(e);

   splitter2->setGeometry( 0, 0, width(), height() );
}


int ConversChannel::getLabelIndex()
{
   return labelindex;
}


void ConversChannel::setLabelIndex( int index )
{
   labelindex = index;
}


void ConversChannel::slotBtnClicked()
{
   show();

   input->setFocus();
   toplevel->chooseChannel( this );
}


void ConversChannel::setNew( bool neu )
{
   if (toplevel->isVisible(this)) return;
   if (this->neu == neu) return;

   QFont f(btn->font());

   if (neu)
   {
      f.setBold( true );
      f.setPointSize( config->sizeNew );
   }
   else
   {
      f.setBold( false );
      f.setPointSize(  config->sizeOld );
   }
   btn->setFont(f);
   this->neu = neu;
}


int ConversChannel::getChanNr()
{
   return channr;
}


void ConversChannel::returnPressedGot()
{
   char text[500],zeichen;
   int len,src,dest;
   int line, col;


   input->cursorPosition(&line, &col);
   strcpy(text,input->textLine(line));

   KillSpacesRight(text);
   len = strlen(text);

   text[len] = '\0';

   // ^A bis ^Z in ASCII(0) bis ASCII(25) umwandeln
   src = 0;
   dest = 0;
   while (text[src] != '\0')
   {
      if (text[src] == '^')
      {
         src++;
         if (text[src] == '\0')
            text[dest] = text[src];
         else
         {
            zeichen = toupper(text[src]);
            if (zeichen >= 'A' && zeichen <= 'Z')
            {
               text[dest] = zeichen-'A'+1;
            }
            else
            {
               if (text[src] == '^')
                  text[dest] = '^';
            }
         }
      }
      else text[dest] = text[src];
      src++;
      dest++;
   }

   text[dest] = '\0';

   if (config->localEcho)
   {
      output->writeText( text, colors[config->colors->tx], STYLE_NORMAL );
      output->newLine();
   }

   text[dest] = '\r';
   text[dest+1] = '\0';

   toplevel->sendString( channr, text );
}


//   void ConversChannel::userListEntry( const char *str, const int type )
//
// Diese Funktion bekommt jeden Eintrag einer /W * - Liste geliefert.
// Sie wertet die Zeilen aus und packt die Rufzeichen etc in die
// Kanalliste
void ConversChannel::userListEntry( const char *str, const int type )
{
   char call[50], host[50], pers[200], *pos;
   int len;
   bool away=false;


   switch (type)
   {
      case TYPE_PP:
           // Minimale Laenge: 44 Bytes
           if (strlen(str) < 44) return;
           // Folgende Bytes muessen SPACES sein
           if (str[9] != ' ' || str[19] != ' ' || str[37] != ' ') return;
           // Rufzeichen
           memcpy(call, str, 8);
           call[8] = '\0';
           KillSpacesRight(call);
           // Host
           memcpy(host, str+10, 9);
           host[9] = '\0';
           KillSpacesRight(host);
           // Perstext
           len = strlen(str)-45;
           if (len < 1)
              len = 0;
           else
              memcpy(pers, str+45, len);
           pers[len] = '\0';
           break;
      case TYPE_TNN:
           // Minimale Laenge: 34 Bytes
           if (strlen(str) < 34) return;
           // Folgende Bytes muessen SPACES sein
           if (str[7] != ' ' || str[27] != ' ') return;
           // Rufzeichen
           memcpy(call, str, 6);
           call[6] = '\0';
           KillSpacesRight(call);
           // Host
           memcpy(host, str+8, 6);
           host[6] = '\0';
           KillSpacesRight(host);
           // Perstext
           len = strlen(str)-35;
           if (len < 1)
              len = 0;
           else
              memcpy(pers, str+35, len);
           pers[len] = '\0';
           break;
   }

   if ((pos = strstr(pers, "(AWAY)")) != NULL)
   {
      *pos = '\0';
      away = true;
   }

   addUserList( call, host, pers, away );
}


void ConversChannel::addUserList( char *call, char *host, char *pers, bool away )
{
   s_userlist *tmp;
   char str[100];


   if (userlist == NULL)
   {
      // Erster Eintrag
      userlist = (s_userlist *)malloc(sizeof(s_userlist));
      tmp = userlist;
   }
   else
   {
      tmp = userlist;
      while (tmp->next != NULL) tmp = tmp->next;

      tmp->next = (s_userlist *)malloc(sizeof(s_userlist));
      tmp = tmp->next;
   }

   tmp->next = NULL;
   tmp->call = (char *) strdup(call);
   tmp->host = (char *) strdup(host);
   tmp->pers = (char *) strdup(pers);
   tmp->away = away;
   tmp->awaytext = NULL;

   if (away)
      sprintf(str, "%s (A)", tmp->call);
   else
      strcpy(str, tmp->call);

   userliste->insertItem( tmp->call, tmp->host, away );
}


void ConversChannel::delUserList( char *call, char *host )
{
   s_userlist *tmp=userlist, *last=NULL;
   bool fertig=false;

   while (tmp != NULL && !fertig)
   {
      if (!strcmp(tmp->call, call))
         if (!strcmp(tmp->host, host))
         {
            // Dieser Eintrag soll geloescht werden
            if (last == NULL)
               userlist = tmp->next;
            else
               last->next = tmp->next;
            free(tmp->call);
            free(tmp->host);
            free(tmp->pers);
            free(tmp);
            fertig = true;
         }
      last = tmp;
      tmp = tmp->next;
   }

   userliste->clearFromList( call, host );
}


void ConversChannel::clearUserList()
{
   s_userlist *tmp=userlist, *tmp2;

   while (tmp != NULL)
   {
      tmp2 = tmp;
      tmp = tmp->next;

      free(tmp2->call);
      free(tmp2->host);
      free(tmp2->pers);
      free(tmp2);
   }

   userlist = NULL;

   userliste->clearList();
}


s_userlist * ConversChannel::getUserList()
{
   return userlist;
}


void ConversChannel::textGot( char *str )
{
   char tmp[500];
   char *tmpptr;
   s_conf_colorlines *clines;
   bool ready=false;

   // Gucken, ob die Zeile farbig gemacht werden soll
   if ((tmpptr = strstr(str, ">: ")) != NULL)
   {
      strcpy( tmp, tmpptr+3 );

      clines = config->clines;
      while (clines != NULL && !ready)
      {
         if (!strncmp(tmp, clines->str, strlen(clines->str)))
         {
            output->writeText( str, colors[config->colors->rx], STYLE_ITALIC );
            colorline = true;
            ready = true;
         }
         clines = clines->next;
      }
      if (!ready)
      {
         output->writeText( str, colors[config->colors->rx], STYLE_NORMAL );
         colorline = false;
      }
   }
   else
   {
      if (colorline)
         output->writeText( str, colors[config->colors->rx], STYLE_ITALIC );
      else
         output->writeText( str, colors[config->colors->rx], STYLE_NORMAL );
   }
   output->newLine();
   setNew(true);
}


void ConversChannel::perstextSet( char *call, char *text )
{
   s_userlist *tmp;

   tmp = userlist;
   while (tmp != NULL)
   {
      if (!strcmp(call, tmp->call))
      {
         if (tmp->pers != NULL)
            free(tmp->pers);
         tmp->pers = (char *) strdup(text);
         return;
      }
      tmp = tmp->next;
   }
}


void ConversChannel::awaySet( char *call, char *host, char *line )
{
   s_userlist *tmp;
   bool out=false;


   tmp = userlist;
   while (tmp != NULL)
   {
      if (!strcmp(call, tmp->call))
         if (!strcmp(host, tmp->host))
         {
            tmp->away = true;
            if (!out)
            {
               toplevel->outText( this, line, colors[config->colors->system], true );
               out = true;
            }

            userliste->setAway( call, host );
         }
      tmp = tmp->next;
   }
}


void ConversChannel::awayTextSet( char *call, char *host, char *text, char *str )
{
   s_userlist *tmp;
   bool found=false;

   tmp = userlist;
   while (tmp != NULL && !found)
   {
      if (!strcmp(call, tmp->call))
         if (!strcmp(host, tmp->host))
            if (tmp->away)
            {
               toplevel->outText( this, str, colors[config->colors->system], true );
               if (tmp->awaytext != NULL)
                  free(tmp->awaytext);
               tmp->awaytext = (char *) strdup(text);
               found = true;
            }
      tmp = tmp->next;
   }
}


void ConversChannel::awayClear( char *call, char *host, char *line )
{
   s_userlist *tmp;
   bool out=false;


   tmp = userlist;
   while (tmp != NULL)
   {
      if (!strcmp(call, tmp->call))
         if (!strcmp(host, tmp->host))
         {
            tmp->away = false;
            if (!out)
            {
               toplevel->outText( this, line, colors[config->colors->system], true );
               out = true;
            }

            userliste->clearAway( call, host );
         }
      tmp = tmp->next;
   }
}


void ConversChannel::setSize()
{
   QFont f( config->userlist_font, config->userlist_size );
   QFontMetrics fm(f);

   // Die Userliste und das Inputfeld wird beim Resizen nicht veraendert
   userliste->resize( 12*fm.width("m"), userliste->height() );
   splitter->setResizeMode( userliste, QSplitter::KeepSize );
   splitter2->setResizeMode( input, QSplitter::KeepSize );
}


