/*
 *  ConvKT - a LinKT convers vitalizer
 *  Copyright (C) 1997-1999 Jochen Sarrazin, DG6VJ. All rights reserved.
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "buttonbar.h"
#include "buttonbar.moc"


#define BBAR_BTNWIDTH 70
#define BBAR_BTNHEIGHT 25


ButtonBar::ButtonBar( QWidget *parent ) : QWidget( parent )
{
   buttons = new QList<QPushButton>();
   buttons->setAutoDelete( false );
}


ButtonBar::~ButtonBar()
{
   delete buttons;
}


void ButtonBar::newButton( QPushButton *btn )
{
   buttons->append( btn );

   // Positionieren und anzeigen
   btn->setGeometry( (BBAR_BTNWIDTH+2)*(buttons->count()-1), 0, BBAR_BTNWIDTH, BBAR_BTNHEIGHT );
   btn->setAutoDefault( false );

   btn->show();
}


void ButtonBar::deleteButton( QPushButton *btn )
{
   buttons->remove( btn );
}


void ButtonBar::redrawButtons()
{
   QPushButton *tmp;
   int i=0;

   if ((tmp = buttons->first()) == NULL) return;

   do
   {
      tmp->setGeometry( (BBAR_BTNWIDTH+2)*i, 0, BBAR_BTNWIDTH, BBAR_BTNHEIGHT );
      i++;
   }
   while ((tmp = buttons->next()) != NULL);
}



